/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.equinox.ds.instance;

import java.io.IOException;
import java.util.Collections;
import java.util.Dictionary;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.eclipse.equinox.ds.Activator;
import org.eclipse.equinox.ds.Log;
import org.eclipse.equinox.ds.instance.BuildDispose;
import org.eclipse.equinox.ds.instance.RegisterComponentService;
import org.eclipse.equinox.ds.model.ComponentDescription;
import org.eclipse.equinox.ds.model.ComponentDescriptionProp;
import org.eclipse.equinox.ds.resolver.Reference;
import org.eclipse.equinox.ds.service.ComponentFactoryImpl;
import org.eclipse.equinox.ds.service.ComponentInstanceImpl;
import org.eclipse.equinox.ds.workqueue.WorkQueue;
import org.osgi.framework.BundleContext;
import org.osgi.framework.InvalidSyntaxException;
import org.osgi.framework.ServiceReference;
import org.osgi.framework.ServiceRegistration;
import org.osgi.service.cm.Configuration;
import org.osgi.service.cm.ConfigurationAdmin;
import org.osgi.service.cm.ConfigurationEvent;
import org.osgi.service.cm.ConfigurationListener;
import org.osgi.service.component.ComponentException;

public class InstanceProcess
implements ConfigurationListener {
    private static final boolean DEBUG = false;
    private Activator main;
    public BuildDispose buildDispose;
    protected WorkQueue workQueue;
    private ServiceRegistration configListener;
    static /* synthetic */ Class class$0;
    static /* synthetic */ Class class$1;

    public InstanceProcess(Activator main) {
        this.main = main;
        this.workQueue = main.workQueue;
        this.buildDispose = new BuildDispose(main);
        BundleContext bundleContext = main.context;
        Class<?> clazz = class$0;
        if (clazz == null) {
            try {
                clazz = class$0 = Class.forName("org.osgi.service.cm.ConfigurationListener");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        this.configListener = bundleContext.registerService(clazz.getName(), (Object)this, null);
    }

    public void dispose() {
        if (this.configListener != null) {
            this.main.context.ungetService(this.configListener.getReference());
        }
        this.buildDispose.dispose();
        this.buildDispose = null;
        this.main = null;
        this.workQueue = null;
    }

    public void registerComponentConfigs(List componentDescriptionProps) {
        String factoryPid = null;
        Iterator it = componentDescriptionProps.iterator();
        while (it.hasNext()) {
            ComponentDescriptionProp cdp = (ComponentDescriptionProp)it.next();
            ComponentDescription cd = cdp.getComponentDescription();
            if (cdp.isComponentFactory()) {
                ConfigurationAdmin configurationAdmin = (ConfigurationAdmin)this.main.resolver.configAdminTracker.getService();
                if (configurationAdmin != null) {
                    try {
                        Configuration config = configurationAdmin.getConfiguration(cd.getName());
                        if (config != null) {
                            factoryPid = config.getFactoryPid();
                        }
                    }
                    catch (IOException e) {
                        Log.log(1, "[SCR] Error attempting to create componentFactory. ", e);
                    }
                }
                if (factoryPid != null) {
                    throw new ComponentException("ManagedServiceFactory and ConfigurationFactory are incompatible");
                }
                BundleContext bundleContext = cd.getBundleContext();
                Class<?> clazz = class$1;
                if (clazz == null) {
                    try {
                        clazz = Class.forName("org.osgi.service.component.ComponentFactory");
                    }
                    catch (ClassNotFoundException classNotFoundException) {
                        throw new NoClassDefFoundError(classNotFoundException.getMessage());
                    }
                }
                cdp.setServiceRegistration(bundleContext.registerService(clazz.getName(), (Object)new ComponentFactoryImpl(cdp, this.main), (Dictionary)cdp.getProperties()));
                continue;
            }
            if (cd.isImmediate() || cd.getFactory() != null) {
                try {
                    this.buildDispose.buildComponentConfigInstance(null, cdp);
                }
                catch (ComponentException e) {
                    Log.log(1, "[SCR] Error attempting to build Component.", e);
                }
            }
            if (cd.getService() == null) continue;
            RegisterComponentService.registerService(this, cdp);
        }
    }

    public void disposeComponentConfigs(List componentDescriptionProps) {
        Iterator it = componentDescriptionProps.iterator();
        while (it.hasNext()) {
            ComponentDescriptionProp cdp = (ComponentDescriptionProp)it.next();
            this.buildDispose.disposeComponentConfig(cdp);
        }
    }

    public void dynamicBind(List references) {
        Iterator it = references.iterator();
        while (it.hasNext()) {
            Reference reference = (Reference)it.next();
            List instances = reference.getComponentDescriptionProp().getInstances();
            Iterator it2 = instances.iterator();
            while (it2.hasNext()) {
                ComponentInstanceImpl compInstance = (ComponentInstanceImpl)it2.next();
                this.buildDispose.bindReference(reference, compInstance);
            }
        }
    }

    public void dynamicUnBind(Map unbindJobs) {
        Iterator itr = unbindJobs.entrySet().iterator();
        while (itr.hasNext()) {
            Map.Entry unbindJob = itr.next();
            Reference reference = (Reference)unbindJob.getKey();
            ComponentDescriptionProp cdp = reference.getComponentDescriptionProp();
            ServiceReference serviceReference = (ServiceReference)unbindJob.getValue();
            List instances = cdp.getInstances();
            Iterator it = instances.iterator();
            while (it.hasNext()) {
                ComponentInstanceImpl compInstance = (ComponentInstanceImpl)it.next();
                Object instance = compInstance.getInstance();
                if (instance == null) continue;
                try {
                    this.buildDispose.unbindDynamicReference(reference, compInstance, serviceReference);
                }
                catch (Exception ex) {
                    ex.printStackTrace();
                }
            }
            reference.removeServiceReference(serviceReference);
        }
    }

    public void configurationEvent(ConfigurationEvent event) {
        Configuration[] config = null;
        String pid = event.getPid();
        String fpid = event.getFactoryPid();
        ComponentDescription cd = fpid != null ? (ComponentDescription)this.main.resolver.enabledCDsByName.get(fpid) : (ComponentDescription)this.main.resolver.enabledCDsByName.get(pid);
        if (cd == null) {
            return;
        }
        switch (event.getType()) {
            case 1: {
                String filter = String.valueOf(fpid != null ? "(&" : "") + "(" + "service.pid" + "=" + pid + ")" + (fpid != null ? "(service.factoryPid=" + fpid + "))" : "");
                ConfigurationAdmin cm = (ConfigurationAdmin)this.main.resolver.configAdminTracker.getService();
                try {
                    config = cm.listConfigurations(filter);
                }
                catch (IOException e) {
                    Log.log(1, "[SCR] Error attempting to list CM Configurations ", e);
                }
                catch (InvalidSyntaxException e) {
                    Log.log(1, "[SCR] Error attempting to list CM Configurations ", e);
                }
                if (fpid == null) {
                    this.main.resolver.disableComponents(Collections.singletonList(cd));
                    this.workQueue.enqueueWork(this.main, 1, Collections.singletonList(cd));
                    break;
                }
                ComponentDescriptionProp cdp = cd.getComponentDescriptionPropByPID(pid);
                if (cdp == null && cd.getComponentDescriptionProps().size() == 1 && ((ComponentDescriptionProp)cd.getComponentDescriptionProps().get(0)).getProperties().get("service.pid") == null) {
                    cdp = (ComponentDescriptionProp)cd.getComponentDescriptionProps().get(0);
                }
                if (cdp != null) {
                    cd.removeComponentDescriptionProp(cdp);
                    this.main.resolver.disposeComponentConfigs(Collections.singletonList(cdp));
                }
                this.main.resolver.map(cd, config[0].getProperties());
                this.workQueue.enqueueWork(this.main, 1, Collections.EMPTY_LIST);
                break;
            }
            case 2: {
                if (fpid == null) {
                    this.main.resolver.disableComponents(Collections.singletonList(cd));
                    this.workQueue.enqueueWork(this.main, 1, Collections.singletonList(cd));
                    break;
                }
                ComponentDescriptionProp cdp = cd.getComponentDescriptionPropByPID(pid);
                if (cd.getComponentDescriptionProps().size() == 1) {
                    this.main.resolver.disableComponents(Collections.singletonList(cd));
                    this.workQueue.enqueueWork(this.main, 1, Collections.singletonList(cd));
                    break;
                }
                cd.removeComponentDescriptionProp(cdp);
                this.disposeComponentConfigs(Collections.singletonList(cdp));
                this.main.resolver.satisfiedCDPs.remove(cdp);
                this.main.resolver.enabledCDPs.remove(cdp);
            }
        }
    }
}

