/*
 * Decompiled with CFR 0.152.
 */
package org.jquantlib.math.distributions;

import org.jquantlib.math.distributions.Derivative;

public class NormalDistribution
implements Derivative {
    protected double average;
    protected double sigma;
    private double normalizationFactor;
    private double denominator;
    private double denormalizationFactor;

    public NormalDistribution() {
        this(0.0, 1.0);
    }

    public NormalDistribution(double average, double sigma) {
        if (sigma <= 0.0) {
            throw new IllegalArgumentException("sigma must be greater than 0.0 (" + sigma + " not allowed)");
        }
        this.average = average;
        this.sigma = sigma;
        this.normalizationFactor = 0.3989422804014327 / sigma;
        this.denormalizationFactor = sigma * sigma;
        this.denominator = 2.0 * this.denormalizationFactor;
    }

    @Override
    public double evaluate(double x) {
        double exponent = -0.5 * x * x;
        if (exponent <= -690.0) {
            return 0.0;
        }
        return 0.3989422804014327 * Math.exp(exponent);
    }

    @Override
    public double derivative(double x) {
        return this.evaluate(x) * (this.average - x) / this.denormalizationFactor;
    }
}

