/*
 * Decompiled with CFR 0.152.
 */
package org.osgi.framework;

import java.security.AccessController;
import java.security.PrivilegedAction;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import javax.security.auth.x500.X500Principal;
import org.apache.felix.framework.FilterImpl;
import org.osgi.framework.Bundle;
import org.osgi.framework.BundleReference;
import org.osgi.framework.Filter;
import org.osgi.framework.InvalidSyntaxException;

/*
 * This class specifies class file version 48.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class FrameworkUtil {
    private FrameworkUtil() {
    }

    public static Filter createFilter(String filter) throws InvalidSyntaxException {
        return new FilterImpl(filter);
    }

    public static boolean matchDistinguishedNameChain(String matchPattern, List<String> dnChain) {
        return DNChainMatching.match(matchPattern, dnChain);
    }

    public static Bundle getBundle(final Class<?> classFromBundle) {
        Object cl = AccessController.doPrivileged(new PrivilegedAction<Object>(){

            @Override
            public Object run() {
                return classFromBundle.getClassLoader();
            }
        });
        if (cl instanceof BundleReference) {
            return ((BundleReference)cl).getBundle();
        }
        return null;
    }

    /*
     * This class specifies class file version 48.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static final class DNChainMatching {
        private static final String MINUS_WILDCARD = "-";
        private static final String STAR_WILDCARD = "*";

        private DNChainMatching() {
        }

        private static boolean rdnmatch(List<?> rdn, List<?> rdnPattern) {
            if (rdn.size() != rdnPattern.size()) {
                return false;
            }
            for (int i = 0; i < rdn.size(); ++i) {
                int patNameEnd;
                String rdnNameValue = (String)rdn.get(i);
                String patNameValue = (String)rdnPattern.get(i);
                int rdnNameEnd = rdnNameValue.indexOf(61);
                if (rdnNameEnd != (patNameEnd = patNameValue.indexOf(61)) || !rdnNameValue.regionMatches(0, patNameValue, 0, rdnNameEnd)) {
                    return false;
                }
                String patValue = patNameValue.substring(patNameEnd);
                String rdnValue = rdnNameValue.substring(rdnNameEnd);
                if (rdnValue.equals(patValue) || patValue.equals("=*") || patValue.equals("=#16012a")) continue;
                return false;
            }
            return true;
        }

        private static boolean dnmatch(List<?> dn, List<?> dnPattern) {
            int dnStart = 0;
            int patStart = 0;
            int patLen = dnPattern.size();
            if (patLen == 0) {
                return false;
            }
            if (dnPattern.get(0).equals(STAR_WILDCARD)) {
                patStart = 1;
                --patLen;
            }
            if (dn.size() < patLen) {
                return false;
            }
            if (dn.size() > patLen) {
                if (!dnPattern.get(0).equals(STAR_WILDCARD)) {
                    return false;
                }
                dnStart = dn.size() - patLen;
            }
            for (int i = 0; i < patLen; ++i) {
                if (DNChainMatching.rdnmatch((List)dn.get(i + dnStart), (List)dnPattern.get(i + patStart))) continue;
                return false;
            }
            return true;
        }

        /*
         * Enabled aggressive block sorting
         */
        private static List<Object> parseDNchainPattern(String dnChain) {
            if (dnChain == null) {
                throw new IllegalArgumentException("The DN chain must not be null.");
            }
            ArrayList<Object> parsed = new ArrayList<Object>();
            int startIndex = 0;
            startIndex = DNChainMatching.skipSpaces(dnChain, startIndex);
            while (true) {
                int endIndex;
                if (startIndex >= dnChain.length()) break;
                boolean inQuote = false;
                block6: for (endIndex = startIndex; endIndex < dnChain.length(); ++endIndex) {
                    char c = dnChain.charAt(endIndex);
                    switch (c) {
                        case '\"': {
                            inQuote = !inQuote;
                            break;
                        }
                        case '\\': {
                            ++endIndex;
                            break;
                        }
                        case ';': {
                            if (!inQuote) break block6;
                        }
                    }
                }
                if (endIndex > dnChain.length()) {
                    throw new IllegalArgumentException("unterminated escape");
                }
                parsed.add(dnChain.substring(startIndex, endIndex));
                startIndex = endIndex + 1;
                startIndex = DNChainMatching.skipSpaces(dnChain, startIndex);
            }
            for (int i = 0; i < parsed.size(); ++i) {
                String dn = (String)parsed.get(i);
                if (dn.equals(STAR_WILDCARD) || dn.equals(MINUS_WILDCARD)) continue;
                ArrayList<Object> rdns = new ArrayList<Object>();
                if (dn.charAt(0) == '*') {
                    if (dn.charAt(1) != ',') {
                        throw new IllegalArgumentException("invalid wildcard prefix");
                    }
                    rdns.add(STAR_WILDCARD);
                    dn = new X500Principal(dn.substring(2)).getName("CANONICAL");
                } else {
                    dn = new X500Principal(dn).getName("CANONICAL");
                }
                DNChainMatching.parseDN(dn, rdns);
                parsed.set(i, rdns);
            }
            if (parsed.size() == 0) {
                throw new IllegalArgumentException("empty DN chain");
            }
            return parsed;
        }

        private static List<Object> parseDNchain(List<String> chain) {
            if (chain == null) {
                throw new IllegalArgumentException("DN chain must not be null.");
            }
            ArrayList<Object> result = new ArrayList<Object>(chain.size());
            for (String dn : chain) {
                dn = new X500Principal(dn).getName("CANONICAL");
                ArrayList<Object> rdns = new ArrayList<Object>();
                DNChainMatching.parseDN(dn, rdns);
                result.add(rdns);
            }
            if (result.size() == 0) {
                throw new IllegalArgumentException("empty DN chain");
            }
            return result;
        }

        private static int skipSpaces(String dnChain, int startIndex) {
            while (startIndex < dnChain.length() && dnChain.charAt(startIndex) == ' ') {
                ++startIndex;
            }
            return startIndex;
        }

        private static void parseDN(String dn, List<Object> rdn) {
            int startIndex = 0;
            char c = '\u0000';
            ArrayList<String> nameValues = new ArrayList<String>();
            while (startIndex < dn.length()) {
                int endIndex;
                for (endIndex = startIndex; endIndex < dn.length() && (c = dn.charAt(endIndex)) != ',' && c != '+'; ++endIndex) {
                    if (c != '\\') continue;
                    ++endIndex;
                }
                if (endIndex > dn.length()) {
                    throw new IllegalArgumentException(new StringBuffer().append("unterminated escape ").append(dn).toString());
                }
                nameValues.add(dn.substring(startIndex, endIndex));
                if (c != '+') {
                    rdn.add(nameValues);
                    nameValues = endIndex != dn.length() ? new ArrayList() : null;
                }
                startIndex = endIndex + 1;
            }
            if (nameValues != null) {
                throw new IllegalArgumentException(new StringBuffer().append("improperly terminated DN ").append(dn).toString());
            }
        }

        private static int skipWildCards(List<Object> dnChainPattern, int dnChainPatternIndex) {
            int i;
            for (i = dnChainPatternIndex; i < dnChainPattern.size(); ++i) {
                Object dnPattern = dnChainPattern.get(i);
                if (dnPattern instanceof String) {
                    if (dnPattern.equals(STAR_WILDCARD) || dnPattern.equals(MINUS_WILDCARD)) continue;
                    throw new IllegalArgumentException("expected wildcard in DN pattern");
                }
                if (dnPattern instanceof List) break;
                throw new IllegalArgumentException("expected String or List in DN Pattern");
            }
            return i;
        }

        private static boolean dnChainMatch(List<Object> dnChain, int dnChainIndex, List<Object> dnChainPattern, int dnChainPatternIndex) throws IllegalArgumentException {
            if (dnChainIndex >= dnChain.size()) {
                return false;
            }
            if (dnChainPatternIndex >= dnChainPattern.size()) {
                return false;
            }
            Object dnPattern = dnChainPattern.get(dnChainPatternIndex);
            if (dnPattern instanceof String) {
                if (!dnPattern.equals(STAR_WILDCARD) && !dnPattern.equals(MINUS_WILDCARD)) {
                    throw new IllegalArgumentException("expected wildcard in DN pattern");
                }
                dnChainPatternIndex = dnPattern.equals(MINUS_WILDCARD) ? DNChainMatching.skipWildCards(dnChainPattern, dnChainPatternIndex) : ++dnChainPatternIndex;
                if (dnChainPatternIndex >= dnChainPattern.size()) {
                    return dnPattern.equals(MINUS_WILDCARD) ? true : dnChain.size() - 1 == dnChainIndex;
                }
                if (dnPattern.equals(STAR_WILDCARD)) {
                    return DNChainMatching.dnChainMatch(dnChain, dnChainIndex, dnChainPattern, dnChainPatternIndex) || DNChainMatching.dnChainMatch(dnChain, dnChainIndex + 1, dnChainPattern, dnChainPatternIndex);
                }
                for (int i = dnChainIndex; i < dnChain.size(); ++i) {
                    if (!DNChainMatching.dnChainMatch(dnChain, i, dnChainPattern, dnChainPatternIndex)) continue;
                    return true;
                }
            } else {
                if (dnPattern instanceof List) {
                    do {
                        if (!DNChainMatching.dnmatch((List)dnChain.get(dnChainIndex), (List)dnPattern)) {
                            return false;
                        }
                        if (++dnChainIndex >= dnChain.size() && ++dnChainPatternIndex >= dnChainPattern.size()) {
                            return true;
                        }
                        if (dnChainIndex >= dnChain.size()) {
                            return (dnChainPatternIndex = DNChainMatching.skipWildCards(dnChainPattern, dnChainPatternIndex)) >= dnChainPattern.size();
                        }
                        if (dnChainPatternIndex >= dnChainPattern.size()) {
                            return false;
                        }
                        dnPattern = dnChainPattern.get(dnChainPatternIndex);
                        if (!(dnPattern instanceof String)) continue;
                        if (!dnPattern.equals(STAR_WILDCARD) && !dnPattern.equals(MINUS_WILDCARD)) {
                            throw new IllegalArgumentException("expected wildcard in DN pattern");
                        }
                        return DNChainMatching.dnChainMatch(dnChain, dnChainIndex, dnChainPattern, dnChainPatternIndex);
                    } while (dnPattern instanceof List);
                    throw new IllegalArgumentException("expected String or List in DN Pattern");
                }
                throw new IllegalArgumentException("expected String or List in DN Pattern");
            }
            return false;
        }

        static boolean match(String pattern, List<String> dnChain) {
            List<Object> parsedDNPattern;
            List<Object> parsedDNChain;
            try {
                parsedDNChain = DNChainMatching.parseDNchain(dnChain);
            }
            catch (RuntimeException e) {
                IllegalArgumentException iae = new IllegalArgumentException(new StringBuffer().append("Invalid DN chain: ").append(DNChainMatching.toString(dnChain)).toString());
                iae.initCause(e);
                throw iae;
            }
            try {
                parsedDNPattern = DNChainMatching.parseDNchainPattern(pattern);
            }
            catch (RuntimeException e) {
                IllegalArgumentException iae = new IllegalArgumentException(new StringBuffer().append("Invalid match pattern: ").append(pattern).toString());
                iae.initCause(e);
                throw iae;
            }
            return DNChainMatching.dnChainMatch(parsedDNChain, 0, parsedDNPattern, 0);
        }

        private static String toString(List<?> dnChain) {
            if (dnChain == null) {
                return null;
            }
            StringBuffer sb = new StringBuffer();
            Iterator<?> iChain = dnChain.iterator();
            while (iChain.hasNext()) {
                sb.append(iChain.next());
                if (!iChain.hasNext()) continue;
                sb.append("; ");
            }
            return sb.toString();
        }
    }
}

