/*
 * $Header: /cvs/xierpa/aQute.lib/src/aQute/lib/xmlservlet/XMLBaseServlet.java,v 1.1 2007-01-03 17:27:44 pkriens Exp $
 * 
 * Copyright (c) The OSGi Alliance (2005). All Rights Reserved.
 * 
 * Implementation of certain elements of the OSGi Specification may be subject
 * to third party intellectual property rights, including without limitation,
 * patent rights (such a third party may or may not be a member of the OSGi
 * Alliance). The OSGi Alliance is not responsible and shall not be held
 * responsible in any manner for identifying or failing to identify any or all
 * such third party intellectual property rights.
 * 
 * This document and the information contained herein are provided on an "AS IS"
 * basis and THE OSGI ALLIANCE DISCLAIMS ALL WARRANTIES, EXPRESS OR IMPLIED,
 * INCLUDING BUT NOT LIMITED TO ANY WARRANTY THAT THE USE OF THE INFORMATION
 * HEREIN WILL NOT INFRINGE ANY RIGHTS AND ANY IMPLIED WARRANTIES OF
 * MERCHANTABILITY OR FITNESS FOR A PARTICULAR PURPOSE. IN NO EVENT WILL THE
 * OSGI ALLIANCE BE LIABLE FOR ANY LOSS OF PROFITS, LOSS OF BUSINESS, LOSS OF
 * USE OF DATA, INTERRUPTION OF BUSINESS, OR FOR DIRECT, INDIRECT, SPECIAL OR
 * EXEMPLARY, INCIDENTIAL, PUNITIVE OR CONSEQUENTIAL DAMAGES OF ANY KIND IN
 * CONNECTION WITH THIS DOCUMENT OR THE INFORMATION CONTAINED HEREIN, EVEN IF
 * ADVISED OF THE POSSIBILITY OF SUCH LOSS OR DAMAGE.
 * 
 * All Company, brand and product names may be trademarks that are the sole
 * property of their respective owners. All rights reserved.
 */

package aQute.lib.xmlservlet;

import java.io.*;
import java.net.URL;
import java.util.Date;

import javax.servlet.http.*;
import javax.xml.transform.*;
import javax.xml.transform.stream.*;

import org.osgi.service.http.HttpContext;

import aQute.lib.tag.Tag;

/**
 * This is a base class for servlets that generate XML. The output can be shown
 * as XML or as HTML after XSLT processing.
 * 
 * @version $Revision: 1.1 $
 */
public abstract class XMLBaseServlet extends HttpServlet implements
		URIResolver, HttpContext {

	/**
	 * 
	 * @param rq
	 * @param rsp
	 * @throws IOException
	 * @see javax.servlet.http.HttpServlet#doGet(javax.servlet.http.HttpServletRequest,
	 *      javax.servlet.http.HttpServletResponse)
	 */
	public void doGet(HttpServletRequest rq, HttpServletResponse rsp)
			throws IOException {
		boolean xml = rq.getParameter("_xml") != null;
		PrintStream	pw = new PrintStream( rsp.getOutputStream() );
		
		ByteArrayOutputStream bout = new ByteArrayOutputStream();
		PrintWriter tmp = new PrintWriter(new OutputStreamWriter(bout, "utf-8"));

		try {
			rsp.setContentType(xml ? "text/xml" : "text/html");

			Tag tag = new Tag("result");
			tag.addAttribute("start", new Date());
			String template = doXML(tag, rq, rsp);
			tag.addAttribute("end", new Date());

			tmp.println("<?xml version='1.0'?>");
			tmp.println("<?xml-stylesheet type='text/xsl' title='Compact' "
					+ " href='" + template + ".xsl'?>");

			tag.print(0, tmp);
			tmp.flush();

			if (!xml) {
				// TODO use templates and cache these, this
				// is horribly inefficient.
				ByteArrayInputStream bin = new ByteArrayInputStream(bout
						.toByteArray());
				Source data = new StreamSource(bin);
				URL url = getClass().getResource("www/" + template + ".xsl");
				Source style = new StreamSource(url.openStream());
				Result output = new StreamResult(rsp.getOutputStream());

				// create Transformer and perform the tranfomation
				TransformerFactory fact = TransformerFactory.newInstance();
				fact.setURIResolver(this);
				Transformer xslt = fact.newTransformer(style);
				xslt.transform(data, output);
			} else {
				pw.write(bout.toByteArray());
				pw.flush();
			}
		}
		catch (Throwable e) {
			pw.println("Could not handle request: ");
			e.printStackTrace(pw);
			rsp.setContentType("text/plain");
			pw.flush();
		}

	}

	abstract protected String doXML(Tag result, HttpServletRequest rq,
			HttpServletResponse rsp) throws Exception;

	public boolean handleSecurity(HttpServletRequest request,
			HttpServletResponse response) throws IOException {
		return true;
	}

	public URL getResource(String name) {
		return getClass().getResource(name);
	}

	public String getMimeType(String name) {
		return null;
	}

	public Source resolve(String href, String base) throws TransformerException {
		try {
			URL url = getClass().getResource("www/" + href);
			if (url == null)
				return null;
			return new StreamSource(url.openStream());
		}
		catch (Exception e) {
			throw new TransformerException(e); // SILLY!
		}
	}
}
