package aQute.lib.aim;
import java.io.*;
import java.util.*;

public class Buddy {
	AIM		aim;
	String	name;
	Date	since;
	Date	idle;
	boolean	online;
	int		evil;

	public Buddy(AIM aim, String name) {
		this.name = name;
		this.aim = aim;
	}

	public void tell(String msg) throws IOException {
		aim.send(name, msg);
	}

	public AIM getAIM() {
		return aim;
	}

	/**
	 * Returns the evil.
	 * 
	 * @return int
	 */
	public int getEvil() {
		return evil;
	}

	/**
	 * Returns the idle.
	 * 
	 * @return Date
	 */
	public Date getIdle() {
		return idle;
	}

	/**
	 * Returns the name.
	 * 
	 * @return String
	 */
	public String getName() {
		return name;
	}

	/**
	 * Returns the online.
	 * 
	 * @return boolean
	 */
	public boolean isOnline() {
		return online;
	}

	/**
	 * Returns the since.
	 * 
	 * @return Date
	 */
	public Date getSince() {
		return since;
	}

	/**
	 * Sets the evil.
	 * 
	 * @param evil
	 *            The evil to set
	 */
	public void setEvil(int evil) {
		this.evil = evil;
	}

	/**
	 * Sets the idle.
	 * 
	 * @param idle
	 *            The idle to set
	 */
	public void setIdle(Date idle) {
		this.idle = idle;
	}

	/**
	 * Sets the online.
	 * 
	 * @param online
	 *            The online to set
	 */
	public void setOnline(boolean online) {
		this.online = online;
	}

	/**
	 * Sets the since.
	 * 
	 * @param since
	 *            The since to set
	 */
	public void setSince(Date since) {
		this.since = since;
	}

	protected void imIn(boolean auto, String msg) {
		aim.log("Rx " + this + " msg: " + msg);
	}

	//public String toString() {
	//	return name;
	//}

	public void removed() {
	}

}