package aQute.test;

import junit.framework.TestCase;
import aQute.base64.Base64;

public class Base64Test extends TestCase {

	public void testEncode() {
		assertEquals(new String("Man"), new String(Base64.decodeBase64("TWFu")));
		assertEquals("Aladdin:open sesame", new String(Base64
				.decodeBase64("QWxhZGRpbjpvcGVuIHNlc2FtZQ==")));
		assertEquals("sure.", new String(Base64.decodeBase64("c3VyZS4=")));
		assertEquals("sure", new String(Base64.decodeBase64("c3VyZQ==")));
		assertEquals("sur", new String(Base64.decodeBase64("c3Vy")));
		assertEquals("su", new String(Base64.decodeBase64("c3U=")));

	}

	public void testBase64() {

		// BA==
		assertEncode(new byte[] { 1 });
		// AA==
		assertEncode(new byte[] { 0 });

		assertEncode(new byte[] { 1, 2 });
		assertEncode(new byte[] { 1, -3, -9 });
		assertEncode(new byte[] { 1, 2, 3 });
		assertEncode(new byte[] { 1, 2, 3, 4 });
		assertEncode(new byte[] { 1, 2, 3, 4, 5 });
		assertEncode(new byte[] { 1, 2, 3, 4, 5, 6 });
		assertEncode(new byte[] { 1, 2, 3, 4, 5, 6, 7 });
		for (int i = 0; i < 256; i++) {
			assertEncode(new byte[] { (byte) i });
			byte d[] = new byte[i % 23];
			for (int j = 0; j < d.length; j++) {
				d[j] = (byte) (0xFF & (i ^ j));
			}
			assertEncode(d);
		}

	}

	void assertEncode(byte data[]) {
		Base64 b1 = new Base64(data);
		String expected = Base64V.byteArrayToBase64(data);
		System.out.println(expected + "-" + b1);
		assertEquals(expected, b1.toString());
	}

	void assertDecode(String s) {
		Base64 b1 = new Base64(s);
		byte[] expected = Base64V.base64ToByteArray(s);
		System.out.println(expected + "-" + b1);
		assertEquals(expected, b1.toData());
	}
}
