/** BEGIN COPYRIGHT BLOCK
 * This Program is free software; you can redistribute it and/or modify it under
 * the terms of the GNU General Public License as published by the Free Software
 * Foundation; version 2 of the License.
 *
 * This Program is distributed in the hope that it will be useful, but WITHOUT
 * ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or FITNESS
 * FOR A PARTICULAR PURPOSE. See the GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License along with
 * this Program; if not, write to the Free Software Foundation, Inc., 59 Temple
 * Place, Suite 330, Boston, MA 02111-1307 USA.
 *
 * Copyright (C) 2005 Red Hat, Inc.
 * All rights reserved.
 * END COPYRIGHT BLOCK **/

#include "coolkey-api.h"
#include "rhCoolKey.h"

static rhCoolKey *coolkey = NULL;
static const char * coolkeyDbusName = NULL;

int notify( CoolKeyListener *listener,
        unsigned long keyType, const char *keyID, unsigned long keyState,
        unsigned long data, const char *strData
    )
{
   CoolKeyDispatch clientListener = listener->GetClientListener();

   /* notify our instance of rhCoolKey */

   coolkey->RhNotifyKeyStateChange(keyType,keyID,keyState,data,strData);

   if(clientListener) {
       (clientListener )((CoolKeyListener *) listener->GetClient(),keyType, keyID, keyState,
       data, strData);
   }
   return S_OK;
}

void coolkey_destroy() {
    if(coolkey != NULL) {
        coolkey->ShutDownInstance();
        delete coolkey;
        coolkey = NULL;
    }
}

void coolkey_init(const char *db_dir,CoolKeyNotifyCallback cb,void* notifyClient,const char* dbusUniqueName) {

    coolkeyDbusName = dbusUniqueName;
    if(coolkey == NULL) {
        coolkey = new rhCoolKey(db_dir);

        CoolKeyListener *listener = new CoolKeyListener();
        listener->SetListener((CoolKeyDispatch) cb,(CoolKeyDispatch) notify);
        listener->SetClient(notifyClient);
        coolkey->RegisterCoolKeyListener(listener);
    }
}

/* get a block of data about a token in a structure format */
tokenInfo *coolkey_get_token_info(int keyType,const char *keyID) {

    if(coolkey == NULL) {
        return NULL;
    }
    tokenInfo   *tInfo = (tokenInfo *) malloc(sizeof(tokenInfo)); 

    if(tInfo == NULL) {
       exit(1);
    }
    
    coolkey->GetCoolKeyATR(keyType, keyID, &tInfo->atr); 

    coolkey->GetCoolKeyIssuerInfo(keyType, keyID, &tInfo->issuerInfo);

    coolkey->GetCoolKeyIssuer(keyType, keyID, &tInfo->issuer);

    coolkey->GetCoolKeyIssuedTo(keyType, keyID, &tInfo->issuedTo);

    coolkey->GetCoolKeyStatus(keyType, keyID, &tInfo->status);

    return tInfo;
}

void coolkey_free_token_info(tokenInfo *tInfo) {
    if(tInfo) {
        if(tInfo->atr) {
           PL_strfree(tInfo->atr);
           tInfo->atr = NULL;
        }

        if(tInfo->issuerInfo) {
           PL_strfree(tInfo->issuerInfo);
           tInfo->issuerInfo = NULL;
        }
        
        if(tInfo->issuer) {
           PL_strfree(tInfo->issuer);
           tInfo->issuer = NULL;
        }

        if(tInfo->issuedTo) {
           PL_strfree(tInfo->issuedTo);
           tInfo->issuedTo = NULL;
        }

        free(tInfo);
    }
}
