/*
 * Decompiled with CFR 0.152.
 */
package org.mozilla.jss.pkcs11;

import java.math.BigInteger;
import java.security.InvalidKeyException;
import java.security.NoSuchAlgorithmException;
import java.security.NoSuchProviderException;
import java.security.Principal;
import java.security.PublicKey;
import java.security.SignatureException;
import java.security.cert.CertificateEncodingException;
import java.security.cert.CertificateException;
import java.security.cert.CertificateExpiredException;
import java.security.cert.CertificateNotYetValidException;
import java.security.cert.X509Certificate;
import java.util.Arrays;
import java.util.Date;
import java.util.Set;
import org.mozilla.jss.crypto.CryptoToken;
import org.mozilla.jss.crypto.InternalCertificate;
import org.mozilla.jss.crypto.TokenCertificate;
import org.mozilla.jss.netscape.security.x509.X509CertImpl;
import org.mozilla.jss.pkcs11.CertProxy;
import org.mozilla.jss.pkcs11.TokenProxy;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PK11Cert
extends X509Certificate
implements InternalCertificate,
TokenCertificate,
AutoCloseable {
    public static Logger logger = LoggerFactory.getLogger(PK11Cert.class);
    public static final int VALID_PEER = 1;
    public static final int TRUSTED_PEER = 2;
    public static final int SEND_WARN = 4;
    public static final int VALID_CA = 8;
    public static final int TRUSTED_CA = 16;
    public static final int NS_TRUSTED_CA = 32;
    public static final int USER = 64;
    public static final int TRUSTED_CLIENT_CA = 128;
    public static final int INVISIBLE_CA = 256;
    public static final int GOVT_APPROVED_CA = 512;
    public static final int SSL = 0;
    public static final int EMAIL = 1;
    public static final int OBJECT_SIGNING = 2;
    private X509CertImpl x509 = null;
    protected CertProxy certProxy;
    protected TokenProxy tokenProxy;
    protected String nickname;

    public static boolean isTrustFlagEnabled(int flag, int flags) {
        return (flag & flags) > 0;
    }

    public static String encodeTrustFlags(int flags) {
        StringBuffer sb = new StringBuffer();
        if (PK11Cert.isTrustFlagEnabled(8, flags) && !PK11Cert.isTrustFlagEnabled(16, flags) && !PK11Cert.isTrustFlagEnabled(128, flags)) {
            sb.append("c");
        }
        if (PK11Cert.isTrustFlagEnabled(1, flags) && !PK11Cert.isTrustFlagEnabled(2, flags)) {
            sb.append("p");
        }
        if (PK11Cert.isTrustFlagEnabled(16, flags)) {
            sb.append("C");
        }
        if (PK11Cert.isTrustFlagEnabled(128, flags)) {
            sb.append("T");
        }
        if (PK11Cert.isTrustFlagEnabled(2, flags)) {
            sb.append("P");
        }
        if (PK11Cert.isTrustFlagEnabled(64, flags)) {
            sb.append("u");
        }
        if (PK11Cert.isTrustFlagEnabled(4, flags)) {
            sb.append("w");
        }
        if (PK11Cert.isTrustFlagEnabled(256, flags)) {
            sb.append("I");
        }
        if (PK11Cert.isTrustFlagEnabled(512, flags)) {
            sb.append("G");
        }
        return sb.toString();
    }

    public static int decodeTrustFlags(String flags) throws Exception {
        int value = 0;
        block11: for (char c : flags.toCharArray()) {
            switch (c) {
                case 'p': {
                    value |= 1;
                    continue block11;
                }
                case 'P': {
                    value = value | 2 | 1;
                    continue block11;
                }
                case 'w': {
                    value |= 4;
                    continue block11;
                }
                case 'c': {
                    value |= 8;
                    continue block11;
                }
                case 'T': {
                    value = value | 0x80 | 8;
                    continue block11;
                }
                case 'C': {
                    value = value | 0x10 | 8;
                    continue block11;
                }
                case 'u': {
                    value |= 0x40;
                    continue block11;
                }
                case 'i': {
                    value |= 0x100;
                    continue block11;
                }
                case 'g': {
                    value |= 0x200;
                    continue block11;
                }
                default: {
                    throw new Exception("Invalid trust flag: " + c);
                }
            }
        }
        return value;
    }

    @Override
    public native byte[] getEncoded() throws CertificateEncodingException;

    @Override
    public String getNickname() {
        return this.nickname;
    }

    @Override
    public int hashCode() {
        try {
            return Arrays.hashCode(this.getEncoded());
        }
        catch (CertificateEncodingException cee) {
            throw new RuntimeException(cee.getMessage(), cee);
        }
    }

    @Override
    public boolean equals(Object other) {
        if (other == null || !(other instanceof PK11Cert)) {
            return false;
        }
        PK11Cert p_other = (PK11Cert)other;
        try {
            return Arrays.equals(this.getEncoded(), p_other.getEncoded());
        }
        catch (CertificateEncodingException cee) {
            throw new RuntimeException(cee.getMessage(), cee);
        }
    }

    @Override
    public Principal getSubjectDN() {
        return new StringPrincipal(this.getSubjectDNString());
    }

    @Override
    public Principal getIssuerDN() {
        return new StringPrincipal(this.getIssuerDNString());
    }

    @Override
    public BigInteger getSerialNumber() {
        return new BigInteger(this.getSerialNumberByteArray());
    }

    protected native byte[] getSerialNumberByteArray();

    protected native String getSubjectDNString();

    protected native String getIssuerDNString();

    @Override
    public native PublicKey getPublicKey();

    @Override
    public native int getVersion();

    @Override
    public int getBasicConstraints() {
        try {
            if (this.x509 == null) {
                this.x509 = new X509CertImpl(this.getEncoded());
            }
            return this.x509.getBasicConstraints();
        }
        catch (Exception e) {
            throw new RuntimeException(e.getMessage(), e);
        }
    }

    @Override
    public boolean[] getKeyUsage() {
        try {
            if (this.x509 == null) {
                this.x509 = new X509CertImpl(this.getEncoded());
            }
            return this.x509.getKeyUsage();
        }
        catch (Exception e) {
            throw new RuntimeException(e.getMessage(), e);
        }
    }

    @Override
    public boolean[] getSubjectUniqueID() {
        try {
            if (this.x509 == null) {
                this.x509 = new X509CertImpl(this.getEncoded());
            }
            return this.x509.getSubjectUniqueID();
        }
        catch (Exception e) {
            throw new RuntimeException(e.getMessage(), e);
        }
    }

    @Override
    public boolean[] getIssuerUniqueID() {
        try {
            if (this.x509 == null) {
                this.x509 = new X509CertImpl(this.getEncoded());
            }
            return this.x509.getIssuerUniqueID();
        }
        catch (Exception e) {
            throw new RuntimeException(e.getMessage(), e);
        }
    }

    @Override
    public byte[] getSigAlgParams() {
        try {
            if (this.x509 == null) {
                this.x509 = new X509CertImpl(this.getEncoded());
            }
            return this.x509.getSigAlgParams();
        }
        catch (Exception e) {
            throw new RuntimeException(e.getMessage(), e);
        }
    }

    @Override
    public String getSigAlgName() {
        try {
            if (this.x509 == null) {
                this.x509 = new X509CertImpl(this.getEncoded());
            }
            return this.x509.getSigAlgName();
        }
        catch (Exception e) {
            throw new RuntimeException(e.getMessage(), e);
        }
    }

    @Override
    public String getSigAlgOID() {
        try {
            if (this.x509 == null) {
                this.x509 = new X509CertImpl(this.getEncoded());
            }
            return this.x509.getSigAlgOID();
        }
        catch (Exception e) {
            throw new RuntimeException(e.getMessage(), e);
        }
    }

    @Override
    public byte[] getSignature() {
        try {
            if (this.x509 == null) {
                this.x509 = new X509CertImpl(this.getEncoded());
            }
            return this.x509.getSignature();
        }
        catch (Exception e) {
            throw new RuntimeException(e.getMessage(), e);
        }
    }

    @Override
    public byte[] getTBSCertificate() throws CertificateEncodingException {
        try {
            if (this.x509 == null) {
                this.x509 = new X509CertImpl(this.getEncoded());
            }
            return this.x509.getTBSCertificate();
        }
        catch (CertificateEncodingException cee) {
            throw cee;
        }
        catch (Exception e) {
            throw new RuntimeException(e.getMessage(), e);
        }
    }

    @Override
    public Date getNotAfter() {
        try {
            if (this.x509 == null) {
                this.x509 = new X509CertImpl(this.getEncoded());
            }
            return this.x509.getNotAfter();
        }
        catch (Exception e) {
            throw new RuntimeException(e.getMessage(), e);
        }
    }

    @Override
    public Date getNotBefore() {
        try {
            if (this.x509 == null) {
                this.x509 = new X509CertImpl(this.getEncoded());
            }
            return this.x509.getNotBefore();
        }
        catch (Exception e) {
            throw new RuntimeException(e.getMessage(), e);
        }
    }

    @Override
    public void checkValidity() throws CertificateExpiredException, CertificateNotYetValidException {
        try {
            if (this.x509 == null) {
                this.x509 = new X509CertImpl(this.getEncoded());
            }
            this.x509.checkValidity();
        }
        catch (CertificateExpiredException cee) {
            throw cee;
        }
        catch (CertificateNotYetValidException cnyve) {
            throw cnyve;
        }
        catch (Exception e) {
            throw new RuntimeException(e.getMessage(), e);
        }
    }

    @Override
    public void checkValidity(Date date) throws CertificateExpiredException, CertificateNotYetValidException {
        try {
            if (this.x509 == null) {
                this.x509 = new X509CertImpl(this.getEncoded());
            }
            this.x509.checkValidity(date);
        }
        catch (CertificateExpiredException cee) {
            throw cee;
        }
        catch (CertificateNotYetValidException cnyve) {
            throw cnyve;
        }
        catch (Exception e) {
            throw new RuntimeException(e.getMessage(), e);
        }
    }

    @Override
    public String toString() {
        try {
            if (this.x509 == null) {
                this.x509 = new X509CertImpl(this.getEncoded());
            }
            return this.x509.toString();
        }
        catch (Exception e) {
            throw new RuntimeException(e.getMessage(), e);
        }
    }

    @Override
    public void verify(PublicKey key) throws CertificateException, NoSuchAlgorithmException, InvalidKeyException, NoSuchProviderException, SignatureException {
        try {
            if (this.x509 == null) {
                this.x509 = new X509CertImpl(this.getEncoded());
            }
            this.x509.verify(key);
        }
        catch (NoSuchAlgorithmException nsae) {
            throw nsae;
        }
        catch (InvalidKeyException ike) {
            throw ike;
        }
        catch (NoSuchProviderException nspe) {
            throw nspe;
        }
        catch (SignatureException se) {
            throw se;
        }
        catch (CertificateException ce) {
            throw ce;
        }
        catch (Exception e) {
            throw new RuntimeException(e.getMessage(), e);
        }
    }

    @Override
    public void verify(PublicKey key, String sigProvider) throws CertificateException, NoSuchAlgorithmException, InvalidKeyException, NoSuchProviderException, SignatureException {
        try {
            if (this.x509 == null) {
                this.x509 = new X509CertImpl(this.getEncoded());
            }
            this.x509.verify(key, sigProvider);
        }
        catch (NoSuchAlgorithmException nsae) {
            throw nsae;
        }
        catch (InvalidKeyException ike) {
            throw ike;
        }
        catch (NoSuchProviderException nspe) {
            throw nspe;
        }
        catch (SignatureException se) {
            throw se;
        }
        catch (CertificateException ce) {
            throw ce;
        }
        catch (Exception e) {
            throw new RuntimeException(e.getMessage(), e);
        }
    }

    @Override
    public byte[] getExtensionValue(String oid) {
        try {
            if (this.x509 == null) {
                this.x509 = new X509CertImpl(this.getEncoded());
            }
            return this.x509.getExtensionValue(oid);
        }
        catch (Exception e) {
            throw new RuntimeException(e.getMessage(), e);
        }
    }

    @Override
    public Set<String> getCriticalExtensionOIDs() {
        try {
            if (this.x509 == null) {
                this.x509 = new X509CertImpl(this.getEncoded());
            }
            return this.x509.getCriticalExtensionOIDs();
        }
        catch (Exception e) {
            throw new RuntimeException(e.getMessage(), e);
        }
    }

    @Override
    public Set<String> getNonCriticalExtensionOIDs() {
        try {
            if (this.x509 == null) {
                this.x509 = new X509CertImpl(this.getEncoded());
            }
            return this.x509.getNonCriticalExtensionOIDs();
        }
        catch (Exception e) {
            throw new RuntimeException(e.getMessage(), e);
        }
    }

    @Override
    public boolean hasUnsupportedCriticalExtension() {
        try {
            if (this.x509 == null) {
                this.x509 = new X509CertImpl(this.getEncoded());
            }
            return this.x509.hasUnsupportedCriticalExtension();
        }
        catch (Exception e) {
            throw new RuntimeException(e.getMessage(), e);
        }
    }

    public void finalize() throws Throwable {
        this.close();
    }

    @Override
    public void close() throws Exception {
        if (this.certProxy != null) {
            try {
                this.certProxy.close();
            }
            finally {
                this.certProxy = null;
            }
        }
        if (this.tokenProxy != null) {
            try {
                this.tokenProxy.close();
            }
            finally {
                this.tokenProxy = null;
            }
        }
    }

    @Override
    public native byte[] getUniqueID();

    @Override
    public native CryptoToken getOwningToken();

    protected native void setTrust(int var1, int var2);

    protected native int getTrust(int var1);

    @Override
    public void setSSLTrust(int trust) {
        this.setTrust(0, trust);
    }

    @Override
    public void setEmailTrust(int trust) {
        this.setTrust(1, trust);
    }

    @Override
    public void setObjectSigningTrust(int trust) {
        this.setTrust(2, trust);
    }

    @Override
    public int getSSLTrust() {
        return this.getTrust(0);
    }

    @Override
    public int getEmailTrust() {
        return this.getTrust(1);
    }

    @Override
    public int getObjectSigningTrust() {
        return this.getTrust(2);
    }

    public String getTrustFlags() {
        StringBuilder sb = new StringBuilder();
        sb.append(PK11Cert.encodeTrustFlags(this.getSSLTrust()));
        sb.append(",");
        sb.append(PK11Cert.encodeTrustFlags(this.getEmailTrust()));
        sb.append(",");
        sb.append(PK11Cert.encodeTrustFlags(this.getObjectSigningTrust()));
        return sb.toString();
    }

    public void setTrustFlags(String trustFlags) throws Exception {
        String[] flags = trustFlags.split(",", -1);
        if (flags.length < 3) {
            throw new Exception("Invalid trust flags: " + trustFlags);
        }
        this.setSSLTrust(PK11Cert.decodeTrustFlags(flags[0]));
        this.setEmailTrust(PK11Cert.decodeTrustFlags(flags[1]));
        this.setObjectSigningTrust(PK11Cert.decodeTrustFlags(flags[2]));
    }

    PK11Cert(byte[] certPtr, byte[] slotPtr, String nickname) {
        assert (certPtr != null);
        assert (slotPtr != null);
        this.certProxy = new CertProxy(certPtr);
        this.tokenProxy = new TokenProxy(slotPtr);
        this.nickname = nickname;
    }

    protected static class StringPrincipal
    implements Principal {
        protected String str;

        public StringPrincipal(String str) {
            this.str = str;
        }

        @Override
        public boolean equals(Object other) {
            if (!(other instanceof StringPrincipal)) {
                return false;
            }
            return this.getName().equals(((StringPrincipal)other).getName());
        }

        @Override
        public String getName() {
            return this.str;
        }

        @Override
        public int hashCode() {
            return this.str.hashCode();
        }

        @Override
        public String toString() {
            return this.str;
        }
    }
}

