/* SPDX-License-Identifier: GPL-2.0 */
/*
 * Virtual platform for Alibaba Dragonball Sandbox.
 *
 * Copyright (C) 2020 Alibaba Cloud. or its affiliates. All Rights Reserved.
 */
#ifndef _X86_DRAGONBALL_H
#define _X86_DRAGONBALL_H

#ifdef CONFIG_X86_DRAGONBALL

#define DB_BOOT_PARAM_SIGNATURE	0xdbdbb007700bbdbd
#define DB_BOOT_PARAM_MAX_SIZE	0x10000

/* Keep it compatible with struct db_mpc_common */
struct db_param_common {
	u8 type;
	u8 reserved;
	u16 length;
} __packed;

struct db_boot_param {
	u64 signature;
	u32 length;
	u32 mp_table_length;
	u64 mp_table_addr;
	u32 __reserved02[26];
	struct db_param_common entries[0];
} __packed;

struct db_mpc_common {
	u8 type;
	u8 reserved;
	u16 length;
} __packed;

#ifdef CONFIG_NUMA
#define	DRAGONBALL_MP_NUMA_CPU		0x1
#define	DRAGONBALL_MP_NUMA_MEM		0x2

struct db_mpc_numa_cpu {
	u8 type;
	u8 node;
	u16 length;
	u32 apic_id;
};

struct db_mpc_numa_mem {
	u8 type;
	u8 node;
	u16 length;
	u32 reserved2;
	u64 start;
	u64 size;
};

extern int dragonball_numa_init(void);
#endif	// CONFIG_NUMA

extern void dragonball_init(void);
#else
static inline void dragonball_init(void) {}
#endif
#endif //_X86_DRAGONBALL_H
