// SPDX-License-Identifier: GPL-2.0
/*
 * Virtual platform for Alibaba Dragonball Sandbox.
 *
 * Copyright (C) 2020 Alibaba Cloud. or its affiliates. All Rights Reserved.
 */
#include <linux/init.h>
#include <linux/string.h>
#include <linux/memblock.h>
#include <linux/printk.h>
#include <linux/nodemask.h>

#include <asm/cmdline.h>
#include <asm/dragonball.h>
#include <asm/x86_init.h>
#include <asm/setup.h>
#include <asm/mpspec.h>
#include <asm/mpspec_def.h>

#include <dragonball/dragonball.h>

#define DRAGONBALL_MPC_VENDOR           "ALICLOUD"
#define DRAGONBALL_MPC_PRODUCT_ID       "DRAGONBALL10"

void __init dragonball_init(void)
{
	u64 data = boot_params.hdr.hardware_subarch_data;
	struct db_boot_param *param = (void *)__va(data);

	if (data == 0 || data & 0x7 || data > MAXMEM || data + DB_BOOT_PARAM_MAX_SIZE > MAXMEM)
		return;

	if (param->signature != DB_BOOT_PARAM_SIGNATURE ||
		param->length != sizeof(*param) ||
		param->length > DB_BOOT_PARAM_MAX_SIZE) {
		return;
	}

	enable_dragonball_platform();
	if (!is_dragonball_platform())
		return;

	enable_dragonball_feature(DB_FEAT_VSOCKSRV);
	enable_dragonball_feature(DB_FEAT_DEVMGR);
	enable_dragonball_feature(DB_FEAT_PVDMA);
	enable_dragonball_feature(DB_FEAT_NUMA);
	enable_dragonball_feature(DB_FEAT_VEBPF);
	#ifdef CONFIG_DRAGONBALL_PVPANIC
	enable_dragonball_feature(DB_FEAT_PVPANIC);
	#endif
	#ifdef CONFIG_DRAGONBALL_PVDUMP
	enable_dragonball_feature(DB_FEAT_PVDUMP);
	#endif
	#ifdef CONFIG_DRAGONBALL_QNC
	enable_dragonball_feature(DB_FEAT_QNC);
	#endif

	/* Ensure that the kernel does not reallocate this physical memory. */
	memblock_reserve(data, param->length);

	if (param->mp_table_addr != 0 && param->mp_table_length != 0) {
		mp_table_base_addr = param->mp_table_addr;
		mp_table_length = param->mp_table_length;
	}

	// TODO: get rid of i8042
	x86_platform.legacy.i8042 = X86_LEGACY_I8042_EXPECTED_PRESENT;
	x86_platform.legacy.no_vga = 1;
	x86_platform.legacy.rtc = 0;
	x86_platform.legacy.reserve_bios_regions = 0;
	x86_platform.legacy.warm_reset = 1;
	x86_platform.legacy.devices.pnpbios = 0;
}
