/* SPDX-License-Identifier: GPL-2.0 */
/*
 * Copyright (C) 2021 Alibaba Cloud. or its affiliates. All Rights Reserved.
 *
 * This program is free software; you can redistribute it and/or modify it
 * under the terms of the GNU General Public License as published by the Free
 * Software Foundation; either version 2 of the License, or (at your option)
 * any later version.
 */

#ifndef _DRAGONBALL_DEFS_H
#define _DRAGONBALL_DEFS_H

/* Definitations for values */
/* Dragonball platform driver version */
#define DB_PLATFORM_DRIVER_VER			0x1

/* Command `update` for msi message */
#define DB_DEVICE_MSI_CMD_UPDATE		0x1

/* Definitations for driver status */
/* Driver reset */
#define DB_PLATFORM_DRIVER_RESET		0x0

/* Driver acknowledge */
#define DB_PLATFORM_DRIVER_ACK			0x01

/* Driver and device's feature negotiation is complete */
#define DB_PLATFORM_FEAT_OK			0x02

/* Driver is set up ready to serve the device */
#define DB_PLATFORM_DRIVER_OK			0x04

/* Something wrong in guest, and given up on the device */
#define DB_PLATFORM_DRIVER_FAIL			0x20

/* Definitations for offset */
/* Magic value("DBPF") offset (R) */
#define DB_PLATFORM_MAGIC_OFF			0x0

/* Device version offset (R) */
#define DB_DEVICE_VER_OFF			0x4

/* Driver version offset (W) */
#define DB_DRIVER_VER_OFF			0x8

/* Device features offset (R) */
#define DB_DEVICE_FEAT_OFF			0x10

/* Device features selection offset (W) */
#define DB_DEVICE_FEAT_SEL_OFF			0x14

/* Driver features offset (W) */
#define DB_DRIVER_FEAT_OFF			0x18

/* Driver features selection offset (W) */
#define DB_DRIVER_FEAT_SEL_OFF			0x1c

/* Device status offset (RW)*/
#define DB_DEVICE_STATUS_OFF			0x20

/* Driver now feature offset (W) */
#define DB_DRIVER_NOW_FEAT_OFF		0x24

/* Device feature config space offset low 32bit (R) */
#define DB_DEVICE_NOW_FEAT_CFG_SPACE_LO_OFF	0x28

/* Device feature config space offset high 32bit (R) */
#define DB_DEVICE_NOW_FEAT_CFG_SPACE_HI_OFF	0x2c

/* Device msi interrupt number (R) */
#define DB_DEVICE_MSI_NR_OFF			0x30

/* Device msi command (W)  */
#define DB_DEVICE_MSI_CMD_OFF			0x34

/* Device msi command args (W) */
#define DB_DEVICE_MSI_ARG_OFF			0x38

/* Device msi address low 32bit (W) */
#define DB_DEVICE_MSI_ADDR_LO_OFF		0x40

/* Device msi address high 32bit (W) */
#define DB_DEVICE_MSI_ADDR_HI_OFF		0x44

/* Device msi data (W) */
#define DB_DEVICE_MSI_DATA_OFF			0x48

/* Mmio space for features (RW) */
#define DB_FEATURE_SPACE_OFF			0x100

#endif /* _DRAGONBALL_DEFS_H */
