/* SPDX-License-Identifier: GPL-2.0 */
/*
 * Copyright (C) 2021 Alibaba Cloud. or its affiliates. All Rights Reserved.
 *
 * This program is free software; you can redistribute it and/or modify it
 * under the terms of the GNU General Public License as published by the Free
 * Software Foundation; either version 2 of the License, or (at your option)
 * any later version.
 */

#ifndef _DRAGONBALL_PLATFORM_FEATURE_DEFS_H
#define _DRAGONBALL_PLATFORM_FEATURE_DEFS_H

#include "dragonball_defs.h"

/* Dragonball platform feature's offset */
#define DB_FEAT_CONF_OFF			(DB_FEATURE_SPACE_OFF + 0x0)

/* Feature version offset (R)*/
#define DB_FEAT_VER_OFF				0x0

/* Feature driver version offset (W) */
#define DB_FEAT_DRIVER_VER_OFF			0x4

/* Feature's capability offset (R) */
#define DB_FEAT_CAP_OFF			0x8

/* Feature's driver capability offset (W) */
#define DB_FEAT_DRIVER_CAP_OFF			0xc

/* Feature status offset (RW) */
#define DB_FEAT_STATUS_OFF			0x10

/* Feature's mmio base low 32bit offset (R) */
#define DB_FEAT_MMIO_BASE_LO_OFF		0x20

/* Feature's mmio base high 32bit offset (R) */
#define DB_FEAT_MMIO_BASE_HI_OFF		0x24

/* Feature's mmio size low 32 bit offset (R) */
#define DB_FEAT_MMIO_SIZE_LO_OFF		0x28

/* Feature's mmio size high 32 bit offset (R) */
#define DB_FEAT_MMIO_SIZE_HI_OFF		0x2c

/* Feature's msi irq number (R) */
#define DB_FEAT_MSI_NR_OFF			0x30

/* Feature's msi irq base (W) */
#define DB_FEAT_MSI_BASE_OFF			0x34

/* Feature's private io offset (R) */
#define DB_FEAT_PRIVATE_OFF			0x50

#endif
