/* SPDX-License-Identifier: GPL-2.0 */
/*
 * db_vsock_srv.h  Virtual Sockets Server for Dragonball
 * Copyright (C) 2019 Alibaba, Inc
 *
 * This program is free software; you can redistribute it and/or modify it
 * under the terms of the GNU General Public License as published by the Free
 * Software Foundation; either version 2 of the License, or (at your option)
 * any later version.
 */

#ifndef _DB_VSOCK_SRV_H
#define _DB_VSOCK_SRV_H

#include <linux/workqueue.h>
#include <linux/net.h>

/* Vsock port to listen for incoming connections. */
#define DB_SERVER_PORT			0xDB
#define DB_RECVBUF_SIZE			0x400
#define DB_INIT_TIMEOUT			10

/*
 * Vsock service handler to handle new incoming connections.
 *
 * Return:
 * 0: on success and the callback takes ownership of the sock.
 * !0: on failure and the callback should keep the sock as is.
 */
typedef int (*db_vsock_svc_handler_t) (struct socket *sock);

extern int register_db_vsock_service(const char cmd,
				     db_vsock_svc_handler_t handler);
extern int unregister_db_vsock_service(const char cmd);

extern struct socket *db_create_vsock_listener(unsigned int port);
extern int db_vsock_sendmsg(struct socket *sock, char *buf, size_t len);
extern int db_vsock_recvmsg(struct socket *sock, char *buf, size_t len,
			    int flags);

#endif /* _DB_VSOCK_SRV_H */
