// SPDX-License-Identifier: GPL-2.0
/*
 * Copyright (C) 2020-2022 Alibaba Corporation. All rights reserved.
 * Author: Zelin Deng <zelin.deng@linux.alibaba.com>
 * Author: Guanjun <guanjun@linux.alibaba.com>
 * Author: Jiayu Ni <jiayu.ni@linux.alibaba.com>
 */

#include <string.h>
#include <stdlib.h>
#include <stdio.h>

#include "ycc_uio.h"
#include "utils.h"
#include "aead.h"

struct aead_test {
	const char *name;
	const char *key;
	const char *iv;
	const char *ass;
	const char *ptext;
	const char *ctext;
	unsigned int key_len;
	unsigned int ass_len;
	unsigned int p_len;
	unsigned int c_len;
};

static const struct aead_test aead = {
	.name = "at",
	.key = "\xfe\xff\xe9\x92\x86\x65\x73\x1c"
	       "\x6d\x6a\x8f\x94\x67\x30\x83\x08"
	       "\xfe\xff\xe9\x92\x86\x65\x73\x1c",
	.key_len = 24,
	.iv = "\xca\xfe\xba\xbe\xfa\xce\xdb\xad"
	      "\xde\xca\xf8\x88",
	.ptext = "\xd9\x31\x32\x25\xf8\x84\x06\xe5"
		 "\xa5\x59\x09\xc5\xaf\xf5\x26\x9a"
		 "\x86\xa7\xa9\x53\x15\x34\xf7\xda"
		 "\x2e\x4c\x30\x3d\x8a\x31\x8a\x72"
		 "\x1c\x3c\x0c\x95\x95\x68\x09\x53"
		 "\x2f\xcf\x0e\x24\x49\xa6\xb5\x25"
		 "\xb1\x6a\xed\xf5\xaa\x0d\xe6\x57"
		 "\xba\x63\x7b\x39",
	.p_len = 60,
	.ass = "\xfe\xed\xfa\xce\xde\xad\xbe\xef"
		 "\xfe\xed\xfa\xce\xde\xad\xbe\xef"
		 "\xab\xad\xda\xd2",
	.ass_len = 20,
	.ctext = "\x39\x80\xca\x0b\x3c\x00\xe8\x41"
		 "\xeb\x06\xfa\xc4\x87\x2a\x27\x57"
		 "\x85\x9e\x1c\xea\xa6\xef\xd9\x84"
		 "\x62\x85\x93\xb4\x0c\xa1\xe1\x9c"
		 "\x7d\x77\x3d\x00\xc1\x44\xc5\x25"
		 "\xac\x61\x9d\x18\xc8\x4a\x3f\x47"
		 "\x18\xe2\x44\x8b\x2f\xe3\x24\xd9"
		 "\xcc\xda\x27\x10"
		 "\x25\x19\x49\x8e\x80\xf1\x47\x8f"
		 "\x37\xba\x55\xbd\x6d\x27\x61\x8c",
	.c_len = 76,

};

static bool inited;

/*
 * Destructor: It is must if driver initialize successfully.
 */
static void __attribute__((destructor)) drv_exit(void)
{
	if (inited)
		ycc_drv_exit();
}

int main(int argc, char *argv[])
{
	struct aead_ctx *cipher;
	struct aead_req *req;
	unsigned char iv[100];
	unsigned char src[100];
	unsigned char dst[100];
	int ret;

	ret = ycc_drv_init(1);
	if (ret < 0)
		return ret;

	inited = true;
	ret = -1;
	cipher = aead_alloc_ctx("gcm(aes)", 0);
	if (!cipher)
		goto out;

	req = aead_alloc_req(cipher);
	if (!req)
		goto free_ctx;

	ret = aead_setkey(cipher, aead.key, aead.key_len);
	if (ret < 0)
		goto free_req;

	ret = aead_setauthsize(cipher, aead.c_len - aead.p_len);
	if (ret < 0)
		goto free_req;

	memcpy(src, aead.ass, aead.ass_len);
	memcpy(src + aead.ass_len, aead.ptext, aead.p_len);
	hex_dump("Dump aead src:", src, aead.ass_len + aead.p_len);

	memcpy(iv, aead.iv, sizeof(aead.iv) - 1);
	aead_set_req_ad(req, aead.ass_len);
	aead_set_req(req, src, dst, aead.p_len, iv);

	ret = aead_encrypt(req);
	hex_dump("Dump aead encrypt dst:", dst, aead.c_len);

	memcpy(src, aead.ass, aead.ass_len);
	memcpy(src + aead.ass_len, aead.ctext, aead.c_len);
	hex_dump("Dump aead src:", src, aead.ass_len + aead.c_len);

	memcpy(iv, aead.iv, sizeof(aead.iv) - 1);
	aead_set_req(req, src, dst, aead.c_len, iv);

	ret = aead_decrypt(req);
	hex_dump("Dump aead decrypt dst:", dst, aead.p_len);

free_req:
	aead_free_req(req);
free_ctx:
	aead_free_ctx(cipher);
out:
	return ret;
}
