/*
Pulp 3 API

Fetch, Upload, Organize, and Distribute Software Packages

API version: v3
Contact: pulp-list@redhat.com
*/

// Code generated by OpenAPI Generator (https://openapi-generator.tech); DO NOT EDIT.

package pulpclient

import (
	"bytes"
	"context"
	"io"
	"net/http"
	"net/url"
	"strings"
	"reflect"
)


// ContentReleaseArchitecturesAPIService ContentReleaseArchitecturesAPI service
type ContentReleaseArchitecturesAPIService service

type ContentReleaseArchitecturesAPIContentDebReleaseArchitecturesCreateRequest struct {
	ctx context.Context
	ApiService *ContentReleaseArchitecturesAPIService
	debReleaseArchitecture *DebReleaseArchitecture
}

func (r ContentReleaseArchitecturesAPIContentDebReleaseArchitecturesCreateRequest) DebReleaseArchitecture(debReleaseArchitecture DebReleaseArchitecture) ContentReleaseArchitecturesAPIContentDebReleaseArchitecturesCreateRequest {
	r.debReleaseArchitecture = &debReleaseArchitecture
	return r
}

func (r ContentReleaseArchitecturesAPIContentDebReleaseArchitecturesCreateRequest) Execute() (*DebReleaseArchitectureResponse, *http.Response, error) {
	return r.ApiService.ContentDebReleaseArchitecturesCreateExecute(r)
}

/*
ContentDebReleaseArchitecturesCreate Create a release architecture

A ReleaseArchitecture represents a single dpkg architecture string.

Associated artifacts: None; contains only metadata.

Every ReleaseArchitecture is always associated with exactly one Release. This indicates that
the release/distribution in question supports this architecture.

 @param ctx context.Context - for authentication, logging, cancellation, deadlines, tracing, etc. Passed from http.Request or context.Background().
 @return ContentReleaseArchitecturesAPIContentDebReleaseArchitecturesCreateRequest
*/
func (a *ContentReleaseArchitecturesAPIService) ContentDebReleaseArchitecturesCreate(ctx context.Context) ContentReleaseArchitecturesAPIContentDebReleaseArchitecturesCreateRequest {
	return ContentReleaseArchitecturesAPIContentDebReleaseArchitecturesCreateRequest{
		ApiService: a,
		ctx: ctx,
	}
}

// Execute executes the request
//  @return DebReleaseArchitectureResponse
func (a *ContentReleaseArchitecturesAPIService) ContentDebReleaseArchitecturesCreateExecute(r ContentReleaseArchitecturesAPIContentDebReleaseArchitecturesCreateRequest) (*DebReleaseArchitectureResponse, *http.Response, error) {
	var (
		localVarHTTPMethod   = http.MethodPost
		localVarPostBody     interface{}
		formFiles            []formFile
		localVarReturnValue  *DebReleaseArchitectureResponse
	)

	localBasePath, err := a.client.cfg.ServerURLWithContext(r.ctx, "ContentReleaseArchitecturesAPIService.ContentDebReleaseArchitecturesCreate")
	if err != nil {
		return localVarReturnValue, nil, &GenericOpenAPIError{error: err.Error()}
	}

	localVarPath := localBasePath + "/pulp/api/v3/content/deb/release_architectures/"

	localVarHeaderParams := make(map[string]string)
	localVarQueryParams := url.Values{}
	localVarFormParams := url.Values{}
	if r.debReleaseArchitecture == nil {
		return localVarReturnValue, nil, reportError("debReleaseArchitecture is required and must be specified")
	}

	// to determine the Content-Type header
	localVarHTTPContentTypes := []string{"application/json", "application/x-www-form-urlencoded", "multipart/form-data"}

	// set Content-Type header
	localVarHTTPContentType := selectHeaderContentType(localVarHTTPContentTypes)
	if localVarHTTPContentType != "" {
		localVarHeaderParams["Content-Type"] = localVarHTTPContentType
	}

	// to determine the Accept header
	localVarHTTPHeaderAccepts := []string{"application/json"}

	// set Accept header
	localVarHTTPHeaderAccept := selectHeaderAccept(localVarHTTPHeaderAccepts)
	if localVarHTTPHeaderAccept != "" {
		localVarHeaderParams["Accept"] = localVarHTTPHeaderAccept
	}
	// body params
	localVarPostBody = r.debReleaseArchitecture
	req, err := a.client.prepareRequest(r.ctx, localVarPath, localVarHTTPMethod, localVarPostBody, localVarHeaderParams, localVarQueryParams, localVarFormParams, formFiles)
	if err != nil {
		return localVarReturnValue, nil, err
	}

	localVarHTTPResponse, err := a.client.callAPI(req)
	if err != nil || localVarHTTPResponse == nil {
		return localVarReturnValue, localVarHTTPResponse, err
	}

	localVarBody, err := io.ReadAll(localVarHTTPResponse.Body)
	localVarHTTPResponse.Body.Close()
	localVarHTTPResponse.Body = io.NopCloser(bytes.NewBuffer(localVarBody))
	if err != nil {
		return localVarReturnValue, localVarHTTPResponse, err
	}

	if localVarHTTPResponse.StatusCode >= 300 {
		newErr := &GenericOpenAPIError{
			body:  localVarBody,
			error: localVarHTTPResponse.Status,
		}
		return localVarReturnValue, localVarHTTPResponse, newErr
	}

	err = a.client.decode(&localVarReturnValue, localVarBody, localVarHTTPResponse.Header.Get("Content-Type"))
	if err != nil {
		newErr := &GenericOpenAPIError{
			body:  localVarBody,
			error: err.Error(),
		}
		return localVarReturnValue, localVarHTTPResponse, newErr
	}

	return localVarReturnValue, localVarHTTPResponse, nil
}

type ContentReleaseArchitecturesAPIContentDebReleaseArchitecturesListRequest struct {
	ctx context.Context
	ApiService *ContentReleaseArchitecturesAPIService
	architecture *string
	codename *string
	distribution *string
	limit *int32
	offset *int32
	ordering *[]string
	pulpHrefIn *[]string
	pulpIdIn *[]string
	repositoryVersion *string
	repositoryVersionAdded *string
	repositoryVersionRemoved *string
	suite *string
	fields *[]string
	excludeFields *[]string
}

// Filter results where architecture matches value
func (r ContentReleaseArchitecturesAPIContentDebReleaseArchitecturesListRequest) Architecture(architecture string) ContentReleaseArchitecturesAPIContentDebReleaseArchitecturesListRequest {
	r.architecture = &architecture
	return r
}

// Filter results where codename matches value
func (r ContentReleaseArchitecturesAPIContentDebReleaseArchitecturesListRequest) Codename(codename string) ContentReleaseArchitecturesAPIContentDebReleaseArchitecturesListRequest {
	r.codename = &codename
	return r
}

// Filter results where distribution matches value
func (r ContentReleaseArchitecturesAPIContentDebReleaseArchitecturesListRequest) Distribution(distribution string) ContentReleaseArchitecturesAPIContentDebReleaseArchitecturesListRequest {
	r.distribution = &distribution
	return r
}

// Number of results to return per page.
func (r ContentReleaseArchitecturesAPIContentDebReleaseArchitecturesListRequest) Limit(limit int32) ContentReleaseArchitecturesAPIContentDebReleaseArchitecturesListRequest {
	r.limit = &limit
	return r
}

// The initial index from which to return the results.
func (r ContentReleaseArchitecturesAPIContentDebReleaseArchitecturesListRequest) Offset(offset int32) ContentReleaseArchitecturesAPIContentDebReleaseArchitecturesListRequest {
	r.offset = &offset
	return r
}

// Ordering  * &#x60;pulp_id&#x60; - Pulp id * &#x60;-pulp_id&#x60; - Pulp id (descending) * &#x60;pulp_created&#x60; - Pulp created * &#x60;-pulp_created&#x60; - Pulp created (descending) * &#x60;pulp_last_updated&#x60; - Pulp last updated * &#x60;-pulp_last_updated&#x60; - Pulp last updated (descending) * &#x60;pulp_type&#x60; - Pulp type * &#x60;-pulp_type&#x60; - Pulp type (descending) * &#x60;upstream_id&#x60; - Upstream id * &#x60;-upstream_id&#x60; - Upstream id (descending) * &#x60;timestamp_of_interest&#x60; - Timestamp of interest * &#x60;-timestamp_of_interest&#x60; - Timestamp of interest (descending) * &#x60;architecture&#x60; - Architecture * &#x60;-architecture&#x60; - Architecture (descending) * &#x60;distribution&#x60; - Distribution * &#x60;-distribution&#x60; - Distribution (descending) * &#x60;codename&#x60; - Codename * &#x60;-codename&#x60; - Codename (descending) * &#x60;suite&#x60; - Suite * &#x60;-suite&#x60; - Suite (descending) * &#x60;pk&#x60; - Pk * &#x60;-pk&#x60; - Pk (descending)
func (r ContentReleaseArchitecturesAPIContentDebReleaseArchitecturesListRequest) Ordering(ordering []string) ContentReleaseArchitecturesAPIContentDebReleaseArchitecturesListRequest {
	r.ordering = &ordering
	return r
}

// Multiple values may be separated by commas.
func (r ContentReleaseArchitecturesAPIContentDebReleaseArchitecturesListRequest) PulpHrefIn(pulpHrefIn []string) ContentReleaseArchitecturesAPIContentDebReleaseArchitecturesListRequest {
	r.pulpHrefIn = &pulpHrefIn
	return r
}

// Multiple values may be separated by commas.
func (r ContentReleaseArchitecturesAPIContentDebReleaseArchitecturesListRequest) PulpIdIn(pulpIdIn []string) ContentReleaseArchitecturesAPIContentDebReleaseArchitecturesListRequest {
	r.pulpIdIn = &pulpIdIn
	return r
}

// Repository Version referenced by HREF
func (r ContentReleaseArchitecturesAPIContentDebReleaseArchitecturesListRequest) RepositoryVersion(repositoryVersion string) ContentReleaseArchitecturesAPIContentDebReleaseArchitecturesListRequest {
	r.repositoryVersion = &repositoryVersion
	return r
}

// Repository Version referenced by HREF
func (r ContentReleaseArchitecturesAPIContentDebReleaseArchitecturesListRequest) RepositoryVersionAdded(repositoryVersionAdded string) ContentReleaseArchitecturesAPIContentDebReleaseArchitecturesListRequest {
	r.repositoryVersionAdded = &repositoryVersionAdded
	return r
}

// Repository Version referenced by HREF
func (r ContentReleaseArchitecturesAPIContentDebReleaseArchitecturesListRequest) RepositoryVersionRemoved(repositoryVersionRemoved string) ContentReleaseArchitecturesAPIContentDebReleaseArchitecturesListRequest {
	r.repositoryVersionRemoved = &repositoryVersionRemoved
	return r
}

// Filter results where suite matches value
func (r ContentReleaseArchitecturesAPIContentDebReleaseArchitecturesListRequest) Suite(suite string) ContentReleaseArchitecturesAPIContentDebReleaseArchitecturesListRequest {
	r.suite = &suite
	return r
}

// A list of fields to include in the response.
func (r ContentReleaseArchitecturesAPIContentDebReleaseArchitecturesListRequest) Fields(fields []string) ContentReleaseArchitecturesAPIContentDebReleaseArchitecturesListRequest {
	r.fields = &fields
	return r
}

// A list of fields to exclude from the response.
func (r ContentReleaseArchitecturesAPIContentDebReleaseArchitecturesListRequest) ExcludeFields(excludeFields []string) ContentReleaseArchitecturesAPIContentDebReleaseArchitecturesListRequest {
	r.excludeFields = &excludeFields
	return r
}

func (r ContentReleaseArchitecturesAPIContentDebReleaseArchitecturesListRequest) Execute() (*PaginateddebReleaseArchitectureResponseList, *http.Response, error) {
	return r.ApiService.ContentDebReleaseArchitecturesListExecute(r)
}

/*
ContentDebReleaseArchitecturesList List release architectures

A ReleaseArchitecture represents a single dpkg architecture string.

Associated artifacts: None; contains only metadata.

Every ReleaseArchitecture is always associated with exactly one Release. This indicates that
the release/distribution in question supports this architecture.

 @param ctx context.Context - for authentication, logging, cancellation, deadlines, tracing, etc. Passed from http.Request or context.Background().
 @return ContentReleaseArchitecturesAPIContentDebReleaseArchitecturesListRequest
*/
func (a *ContentReleaseArchitecturesAPIService) ContentDebReleaseArchitecturesList(ctx context.Context) ContentReleaseArchitecturesAPIContentDebReleaseArchitecturesListRequest {
	return ContentReleaseArchitecturesAPIContentDebReleaseArchitecturesListRequest{
		ApiService: a,
		ctx: ctx,
	}
}

// Execute executes the request
//  @return PaginateddebReleaseArchitectureResponseList
func (a *ContentReleaseArchitecturesAPIService) ContentDebReleaseArchitecturesListExecute(r ContentReleaseArchitecturesAPIContentDebReleaseArchitecturesListRequest) (*PaginateddebReleaseArchitectureResponseList, *http.Response, error) {
	var (
		localVarHTTPMethod   = http.MethodGet
		localVarPostBody     interface{}
		formFiles            []formFile
		localVarReturnValue  *PaginateddebReleaseArchitectureResponseList
	)

	localBasePath, err := a.client.cfg.ServerURLWithContext(r.ctx, "ContentReleaseArchitecturesAPIService.ContentDebReleaseArchitecturesList")
	if err != nil {
		return localVarReturnValue, nil, &GenericOpenAPIError{error: err.Error()}
	}

	localVarPath := localBasePath + "/pulp/api/v3/content/deb/release_architectures/"

	localVarHeaderParams := make(map[string]string)
	localVarQueryParams := url.Values{}
	localVarFormParams := url.Values{}

	if r.architecture != nil {
		parameterAddToHeaderOrQuery(localVarQueryParams, "architecture", r.architecture, "")
	}
	if r.codename != nil {
		parameterAddToHeaderOrQuery(localVarQueryParams, "codename", r.codename, "")
	}
	if r.distribution != nil {
		parameterAddToHeaderOrQuery(localVarQueryParams, "distribution", r.distribution, "")
	}
	if r.limit != nil {
		parameterAddToHeaderOrQuery(localVarQueryParams, "limit", r.limit, "")
	}
	if r.offset != nil {
		parameterAddToHeaderOrQuery(localVarQueryParams, "offset", r.offset, "")
	}
	if r.ordering != nil {
		parameterAddToHeaderOrQuery(localVarQueryParams, "ordering", r.ordering, "csv")
	}
	if r.pulpHrefIn != nil {
		parameterAddToHeaderOrQuery(localVarQueryParams, "pulp_href__in", r.pulpHrefIn, "csv")
	}
	if r.pulpIdIn != nil {
		parameterAddToHeaderOrQuery(localVarQueryParams, "pulp_id__in", r.pulpIdIn, "csv")
	}
	if r.repositoryVersion != nil {
		parameterAddToHeaderOrQuery(localVarQueryParams, "repository_version", r.repositoryVersion, "")
	}
	if r.repositoryVersionAdded != nil {
		parameterAddToHeaderOrQuery(localVarQueryParams, "repository_version_added", r.repositoryVersionAdded, "")
	}
	if r.repositoryVersionRemoved != nil {
		parameterAddToHeaderOrQuery(localVarQueryParams, "repository_version_removed", r.repositoryVersionRemoved, "")
	}
	if r.suite != nil {
		parameterAddToHeaderOrQuery(localVarQueryParams, "suite", r.suite, "")
	}
	if r.fields != nil {
		t := *r.fields
		if reflect.TypeOf(t).Kind() == reflect.Slice {
			s := reflect.ValueOf(t)
			for i := 0; i < s.Len(); i++ {
				parameterAddToHeaderOrQuery(localVarQueryParams, "fields", s.Index(i), "multi")
			}
		} else {
			parameterAddToHeaderOrQuery(localVarQueryParams, "fields", t, "multi")
		}
	}
	if r.excludeFields != nil {
		t := *r.excludeFields
		if reflect.TypeOf(t).Kind() == reflect.Slice {
			s := reflect.ValueOf(t)
			for i := 0; i < s.Len(); i++ {
				parameterAddToHeaderOrQuery(localVarQueryParams, "exclude_fields", s.Index(i), "multi")
			}
		} else {
			parameterAddToHeaderOrQuery(localVarQueryParams, "exclude_fields", t, "multi")
		}
	}
	// to determine the Content-Type header
	localVarHTTPContentTypes := []string{}

	// set Content-Type header
	localVarHTTPContentType := selectHeaderContentType(localVarHTTPContentTypes)
	if localVarHTTPContentType != "" {
		localVarHeaderParams["Content-Type"] = localVarHTTPContentType
	}

	// to determine the Accept header
	localVarHTTPHeaderAccepts := []string{"application/json"}

	// set Accept header
	localVarHTTPHeaderAccept := selectHeaderAccept(localVarHTTPHeaderAccepts)
	if localVarHTTPHeaderAccept != "" {
		localVarHeaderParams["Accept"] = localVarHTTPHeaderAccept
	}
	req, err := a.client.prepareRequest(r.ctx, localVarPath, localVarHTTPMethod, localVarPostBody, localVarHeaderParams, localVarQueryParams, localVarFormParams, formFiles)
	if err != nil {
		return localVarReturnValue, nil, err
	}

	localVarHTTPResponse, err := a.client.callAPI(req)
	if err != nil || localVarHTTPResponse == nil {
		return localVarReturnValue, localVarHTTPResponse, err
	}

	localVarBody, err := io.ReadAll(localVarHTTPResponse.Body)
	localVarHTTPResponse.Body.Close()
	localVarHTTPResponse.Body = io.NopCloser(bytes.NewBuffer(localVarBody))
	if err != nil {
		return localVarReturnValue, localVarHTTPResponse, err
	}

	if localVarHTTPResponse.StatusCode >= 300 {
		newErr := &GenericOpenAPIError{
			body:  localVarBody,
			error: localVarHTTPResponse.Status,
		}
		return localVarReturnValue, localVarHTTPResponse, newErr
	}

	err = a.client.decode(&localVarReturnValue, localVarBody, localVarHTTPResponse.Header.Get("Content-Type"))
	if err != nil {
		newErr := &GenericOpenAPIError{
			body:  localVarBody,
			error: err.Error(),
		}
		return localVarReturnValue, localVarHTTPResponse, newErr
	}

	return localVarReturnValue, localVarHTTPResponse, nil
}

type ContentReleaseArchitecturesAPIContentDebReleaseArchitecturesReadRequest struct {
	ctx context.Context
	ApiService *ContentReleaseArchitecturesAPIService
	debReleaseArchitectureHref string
	fields *[]string
	excludeFields *[]string
}

// A list of fields to include in the response.
func (r ContentReleaseArchitecturesAPIContentDebReleaseArchitecturesReadRequest) Fields(fields []string) ContentReleaseArchitecturesAPIContentDebReleaseArchitecturesReadRequest {
	r.fields = &fields
	return r
}

// A list of fields to exclude from the response.
func (r ContentReleaseArchitecturesAPIContentDebReleaseArchitecturesReadRequest) ExcludeFields(excludeFields []string) ContentReleaseArchitecturesAPIContentDebReleaseArchitecturesReadRequest {
	r.excludeFields = &excludeFields
	return r
}

func (r ContentReleaseArchitecturesAPIContentDebReleaseArchitecturesReadRequest) Execute() (*DebReleaseArchitectureResponse, *http.Response, error) {
	return r.ApiService.ContentDebReleaseArchitecturesReadExecute(r)
}

/*
ContentDebReleaseArchitecturesRead Inspect a release architecture

A ReleaseArchitecture represents a single dpkg architecture string.

Associated artifacts: None; contains only metadata.

Every ReleaseArchitecture is always associated with exactly one Release. This indicates that
the release/distribution in question supports this architecture.

 @param ctx context.Context - for authentication, logging, cancellation, deadlines, tracing, etc. Passed from http.Request or context.Background().
 @param debReleaseArchitectureHref
 @return ContentReleaseArchitecturesAPIContentDebReleaseArchitecturesReadRequest
*/
func (a *ContentReleaseArchitecturesAPIService) ContentDebReleaseArchitecturesRead(ctx context.Context, debReleaseArchitectureHref string) ContentReleaseArchitecturesAPIContentDebReleaseArchitecturesReadRequest {
	return ContentReleaseArchitecturesAPIContentDebReleaseArchitecturesReadRequest{
		ApiService: a,
		ctx: ctx,
		debReleaseArchitectureHref: debReleaseArchitectureHref,
	}
}

// Execute executes the request
//  @return DebReleaseArchitectureResponse
func (a *ContentReleaseArchitecturesAPIService) ContentDebReleaseArchitecturesReadExecute(r ContentReleaseArchitecturesAPIContentDebReleaseArchitecturesReadRequest) (*DebReleaseArchitectureResponse, *http.Response, error) {
	var (
		localVarHTTPMethod   = http.MethodGet
		localVarPostBody     interface{}
		formFiles            []formFile
		localVarReturnValue  *DebReleaseArchitectureResponse
	)

	localBasePath, err := a.client.cfg.ServerURLWithContext(r.ctx, "ContentReleaseArchitecturesAPIService.ContentDebReleaseArchitecturesRead")
	if err != nil {
		return localVarReturnValue, nil, &GenericOpenAPIError{error: err.Error()}
	}

	localVarPath := localBasePath + "{deb_release_architecture_href}"
	localVarPath = strings.Replace(localVarPath, "{"+"deb_release_architecture_href"+"}", parameterValueToString(r.debReleaseArchitectureHref, "debReleaseArchitectureHref"), -1)  // NOTE: paths aren't escaped because Pulp uses hrefs as path parameters

	localVarHeaderParams := make(map[string]string)
	localVarQueryParams := url.Values{}
	localVarFormParams := url.Values{}

	if r.fields != nil {
		t := *r.fields
		if reflect.TypeOf(t).Kind() == reflect.Slice {
			s := reflect.ValueOf(t)
			for i := 0; i < s.Len(); i++ {
				parameterAddToHeaderOrQuery(localVarQueryParams, "fields", s.Index(i), "multi")
			}
		} else {
			parameterAddToHeaderOrQuery(localVarQueryParams, "fields", t, "multi")
		}
	}
	if r.excludeFields != nil {
		t := *r.excludeFields
		if reflect.TypeOf(t).Kind() == reflect.Slice {
			s := reflect.ValueOf(t)
			for i := 0; i < s.Len(); i++ {
				parameterAddToHeaderOrQuery(localVarQueryParams, "exclude_fields", s.Index(i), "multi")
			}
		} else {
			parameterAddToHeaderOrQuery(localVarQueryParams, "exclude_fields", t, "multi")
		}
	}
	// to determine the Content-Type header
	localVarHTTPContentTypes := []string{}

	// set Content-Type header
	localVarHTTPContentType := selectHeaderContentType(localVarHTTPContentTypes)
	if localVarHTTPContentType != "" {
		localVarHeaderParams["Content-Type"] = localVarHTTPContentType
	}

	// to determine the Accept header
	localVarHTTPHeaderAccepts := []string{"application/json"}

	// set Accept header
	localVarHTTPHeaderAccept := selectHeaderAccept(localVarHTTPHeaderAccepts)
	if localVarHTTPHeaderAccept != "" {
		localVarHeaderParams["Accept"] = localVarHTTPHeaderAccept
	}
	req, err := a.client.prepareRequest(r.ctx, localVarPath, localVarHTTPMethod, localVarPostBody, localVarHeaderParams, localVarQueryParams, localVarFormParams, formFiles)
	if err != nil {
		return localVarReturnValue, nil, err
	}

	localVarHTTPResponse, err := a.client.callAPI(req)
	if err != nil || localVarHTTPResponse == nil {
		return localVarReturnValue, localVarHTTPResponse, err
	}

	localVarBody, err := io.ReadAll(localVarHTTPResponse.Body)
	localVarHTTPResponse.Body.Close()
	localVarHTTPResponse.Body = io.NopCloser(bytes.NewBuffer(localVarBody))
	if err != nil {
		return localVarReturnValue, localVarHTTPResponse, err
	}

	if localVarHTTPResponse.StatusCode >= 300 {
		newErr := &GenericOpenAPIError{
			body:  localVarBody,
			error: localVarHTTPResponse.Status,
		}
		return localVarReturnValue, localVarHTTPResponse, newErr
	}

	err = a.client.decode(&localVarReturnValue, localVarBody, localVarHTTPResponse.Header.Get("Content-Type"))
	if err != nil {
		newErr := &GenericOpenAPIError{
			body:  localVarBody,
			error: err.Error(),
		}
		return localVarReturnValue, localVarHTTPResponse, newErr
	}

	return localVarReturnValue, localVarHTTPResponse, nil
}
