"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
async function isFocused(page, selector, options = {}) {
    try {
        await page.waitForSelector(selector, options);
        /* istanbul ignore next */
        const isFocused = await page.$eval(selector, (el) => el === document.activeElement);
        return { pass: isFocused, reason: 1 /* NotFocused */ };
    }
    catch (e) {
        return { pass: false, reason: 0 /* NotFound */ };
    }
}
const toHaveFocus = async function (page, selector, options = {}) {
    const result = await isFocused(page, selector, options);
    return {
        pass: result.pass,
        message: () => {
            const not = this.isNot ? " not" : "";
            const hint = this.utils.matcherHint("toHaveFocus", undefined, undefined, {
                isNot: this.isNot,
                promise: this.promise,
            });
            const message = result.reason === 0 /* NotFound */
                ? `Expected: element to${not} have focus\n` +
                    "Received: element was not found"
                : `Expected: element to${not} have focus`;
            return hint + "\n\n" + message;
        },
    };
};
exports.default = toHaveFocus;
