/*
 * Decompiled with CFR 0.152.
 */
package org.dogtagpki.acme.server;

import java.net.URI;
import javax.ws.rs.POST;
import javax.ws.rs.Path;
import javax.ws.rs.PathParam;
import javax.ws.rs.Produces;
import javax.ws.rs.core.Context;
import javax.ws.rs.core.Response;
import javax.ws.rs.core.UriInfo;
import org.dogtagpki.acme.ACMEAccount;
import org.dogtagpki.acme.ACMEHeader;
import org.dogtagpki.acme.ACMENonce;
import org.dogtagpki.acme.JWS;
import org.dogtagpki.acme.server.ACMEEngine;
import org.dogtagpki.acme.server.ACMEManagedService;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Path(value="acct/{id}")
@ACMEManagedService
public class ACMEAccountService {
    public static Logger logger = LoggerFactory.getLogger(ACMEAccountService.class);
    @Context
    UriInfo uriInfo;

    @POST
    @Produces(value={"application/json"})
    public Response updateAccount(@PathParam(value="id") String accountID, JWS jws) throws Exception {
        String[] newContact;
        logger.info("Updating account " + accountID);
        String protectedHeader = new String(jws.getProtectedHeaderAsBytes(), "UTF-8");
        logger.info("Header: " + protectedHeader);
        ACMEHeader header = ACMEHeader.fromJSON((String)protectedHeader);
        ACMEEngine engine = ACMEEngine.getInstance();
        engine.validateNonce(header.getNonce());
        URI kid = header.getKid();
        String kidPath = kid.getPath();
        String jwsAccountID = kidPath.substring(kidPath.lastIndexOf(47) + 1);
        if (!accountID.equals(jwsAccountID)) {
            throw new Exception("Invalid KID: " + kid);
        }
        ACMEAccount account = engine.getAccount(accountID);
        String status = account.getStatus();
        logger.info("Status: " + status);
        String[] contact = account.getContact();
        logger.info("Contact:");
        if (contact != null) {
            for (String c : contact) {
                logger.info("- " + c);
            }
        }
        engine.validateJWS(jws, header.getAlg(), account.getJWK());
        String payload = new String(jws.getPayloadAsBytes(), "UTF-8");
        logger.info("Payload: " + payload);
        ACMEAccount update = ACMEAccount.fromJSON((String)payload);
        String newStatus = update.getStatus();
        if (newStatus != null) {
            logger.info("New status: " + newStatus);
            account.setStatus(newStatus);
        }
        if ((newContact = update.getContact()) != null) {
            logger.info("New contact:");
            for (String c : newContact) {
                logger.info("- " + c);
            }
            account.setContact(newContact);
        }
        engine.updateAccount(account);
        URI ordersURL = this.uriInfo.getBaseUriBuilder().path("acct").path(accountID).path("orders").build(new Object[0]);
        account.setOrders(ordersURL);
        Response.ResponseBuilder builder = Response.ok((Object)account);
        ACMENonce nonce = engine.createNonce();
        builder.header("Replay-Nonce", (Object)nonce.getID());
        URI directoryURL = this.uriInfo.getBaseUriBuilder().path("directory").build(new Object[0]);
        builder.link(directoryURL, "index");
        builder.entity((Object)account);
        return builder.build();
    }
}

