/*
 * Decompiled with CFR 0.152.
 */
package com.netscape.cmstools.selftests;

import com.netscape.certsrv.selftests.SelfTestClient;
import com.netscape.certsrv.selftests.SelfTestData;
import com.netscape.cmstools.cli.MainCLI;
import com.netscape.cmstools.selftests.SelfTestCLI;
import java.io.FileWriter;
import java.io.PrintWriter;
import org.apache.commons.cli.CommandLine;
import org.apache.commons.cli.Option;
import org.dogtagpki.cli.CLI;
import org.dogtagpki.cli.CommandCLI;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SelfTestShowCLI
extends CommandCLI {
    public static Logger logger = LoggerFactory.getLogger(SelfTestShowCLI.class);
    public SelfTestCLI selfTestCLI;

    public SelfTestShowCLI(SelfTestCLI selfTestCLI) {
        super("show", "Show selftest", (CLI)selfTestCLI);
        this.selfTestCLI = selfTestCLI;
    }

    public void printHelp() {
        formatter.printHelp(this.getFullName() + " <SelfTest ID> [OPTIONS...]", this.options);
    }

    public void createOptions() {
        Option option = new Option(null, "output", true, "Output file to store selfTest properties.");
        option.setArgName("file");
        this.options.addOption(option);
    }

    public void execute(CommandLine cmd) throws Exception {
        String[] cmdArgs = cmd.getArgs();
        if (cmdArgs.length != 1) {
            throw new Exception("No SelfTest ID specified.");
        }
        String selfTestID = cmdArgs[0];
        String output = cmd.getOptionValue("output");
        MainCLI mainCLI = (MainCLI)this.getRoot();
        mainCLI.init();
        SelfTestClient selfTestClient = this.selfTestCLI.getSelfTestClient();
        SelfTestData selfTestInfo = selfTestClient.getSelfTest(selfTestID);
        if (output == null) {
            MainCLI.printMessage("SelfTest \"" + selfTestID + "\"");
            SelfTestCLI.printSelfTestData(selfTestInfo);
        } else {
            try (PrintWriter out = new PrintWriter(new FileWriter(output));){
                out.println(selfTestInfo);
            }
            MainCLI.printMessage("Stored selfTest \"" + selfTestID + "\" into " + output);
        }
    }
}

