/*
 * Decompiled with CFR 0.152.
 */
package com.netscape.cmscore.cert;

import com.netscape.ca.CRLIssuingPoint;
import com.netscape.cmscore.cert.PrettyPrintResources;
import java.text.DateFormat;
import java.util.Iterator;
import java.util.Locale;
import java.util.ResourceBundle;
import java.util.Set;
import java.util.TimeZone;
import org.mozilla.jss.netscape.security.util.CrlPrettyPrint;
import org.mozilla.jss.netscape.security.util.ExtPrettyPrint;
import org.mozilla.jss.netscape.security.util.PrettyPrintFormat;
import org.mozilla.jss.netscape.security.x509.CRLExtensions;
import org.mozilla.jss.netscape.security.x509.Extension;
import org.mozilla.jss.netscape.security.x509.RevokedCertificate;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CrlCachePrettyPrint
extends CrlPrettyPrint {
    public static Logger logger = LoggerFactory.getLogger(CrlCachePrettyPrint.class);
    private static final String CUSTOM_LOCALE = "Custom";
    private CRLIssuingPoint mIP = null;
    private PrettyPrintFormat pp = null;

    public CrlCachePrettyPrint(CRLIssuingPoint ip) {
        super(null);
        this.mIP = ip;
        this.pp = new PrettyPrintFormat(":");
    }

    public String toString(Locale clientLocale) {
        return this.toString(clientLocale, 0L, 0L, 0L);
    }

    public String toString(Locale clientLocale, long crlSize, long pageStart, long pageSize) {
        ResourceBundle resource = ResourceBundle.getBundle(PrettyPrintResources.class.getName());
        DateFormat dateFormater = DateFormat.getDateTimeInstance(0, 0, clientLocale);
        String tz = " ";
        String tzid = " ";
        StringBuffer sb = new StringBuffer();
        try {
            sb.append(this.pp.indent(4) + resource.getString("tokenCRL") + "\n");
            sb.append(this.pp.indent(8) + resource.getString("tokenData") + "\n");
            String signingAlgorithm = this.mIP.getLastSigningAlgorithm();
            if (signingAlgorithm != null) {
                sb.append(this.pp.indent(12) + resource.getString("tokenSignatureAlgorithm") + signingAlgorithm + "\n");
            }
            sb.append(this.pp.indent(12) + resource.getString("tokenIssuer") + this.mIP.getCertificateAuthority().getCRLX500Name().toString() + "\n");
            String thisUpdate = dateFormater.format(this.mIP.getLastUpdate());
            if (TimeZone.getDefault() != null) {
                tz = TimeZone.getDefault().getDisplayName(TimeZone.getDefault().inDaylightTime(this.mIP.getLastUpdate()), 0, clientLocale);
                tzid = TimeZone.getDefault().getID();
            }
            if (tz.equals(tzid) || tzid.equals(CUSTOM_LOCALE)) {
                sb.append(this.pp.indent(12) + resource.getString("tokenThisUpdate") + thisUpdate + "\n");
            } else {
                sb.append(this.pp.indent(12) + resource.getString("tokenThisUpdate") + thisUpdate + " " + tzid + "\n");
            }
            if (this.mIP.getNextUpdate() != null) {
                String nextUpdate = dateFormater.format(this.mIP.getNextUpdate());
                if (TimeZone.getDefault() != null) {
                    tz = TimeZone.getDefault().getDisplayName(TimeZone.getDefault().inDaylightTime(this.mIP.getNextUpdate()), 0, clientLocale);
                }
                if (tz.equals(tzid) || tzid.equals(CUSTOM_LOCALE)) {
                    sb.append(this.pp.indent(12) + resource.getString("tokenNextUpdate") + nextUpdate + "\n");
                } else {
                    sb.append(this.pp.indent(12) + resource.getString("tokenNextUpdate") + nextUpdate + " " + tzid + "\n");
                }
            }
            if (crlSize > 0L && pageStart == 0L && pageSize == 0L) {
                sb.append(this.pp.indent(12) + resource.getString("revokedCerts") + crlSize + "\n");
            } else if (crlSize == 0L && pageStart == 0L && pageSize == 0L || crlSize > 0L && pageStart > 0L && pageSize > 0L) {
                sb.append(this.pp.indent(12) + resource.getString("revokedCerts"));
                long upperLimit = crlSize;
                if (crlSize > 0L && pageStart > 0L && pageSize > 0L) {
                    upperLimit = pageStart + pageSize - 1L > crlSize ? crlSize : pageStart + pageSize - 1L;
                    sb.append(pageStart + "-" + upperLimit + " of " + crlSize);
                } else {
                    pageStart = 1L;
                    sb.append("" + crlSize);
                }
                sb.append("\n");
                Set<RevokedCertificate> revokedCerts = this.mIP.getRevokedCertificates((int)(pageStart - 1L), (int)upperLimit);
                if (revokedCerts != null) {
                    Iterator<RevokedCertificate> i = revokedCerts.iterator();
                    for (long l = 1L; i.hasNext() && (crlSize == 0L || upperLimit - pageStart + 1L >= l); ++l) {
                        RevokedCertificate revokedCert = i.next();
                        if (crlSize != 0L && upperLimit - pageStart + 1L < l) continue;
                        sb.append(this.pp.indent(16) + resource.getString("tokenSerial") + "0x" + revokedCert.getSerialNumber().toString(16).toUpperCase() + "\n");
                        String revocationDate = dateFormater.format(revokedCert.getRevocationDate());
                        if (TimeZone.getDefault() != null) {
                            tz = TimeZone.getDefault().getDisplayName(TimeZone.getDefault().inDaylightTime(revokedCert.getRevocationDate()), 0, clientLocale);
                        }
                        if (tz.equals(tzid) || tzid.equals(CUSTOM_LOCALE)) {
                            sb.append(this.pp.indent(16) + resource.getString("revocationDate") + revocationDate + "\n");
                        } else {
                            sb.append(this.pp.indent(16) + resource.getString("revocationDate") + revocationDate + " " + tzid + "\n");
                        }
                        if (!revokedCert.hasExtensions()) continue;
                        sb.append(this.pp.indent(16) + resource.getString("tokenExtensions") + "\n");
                        CRLExtensions crlExtensions = revokedCert.getExtensions();
                        if (crlExtensions == null) continue;
                        for (int k = 0; k < crlExtensions.size(); ++k) {
                            Extension ext = (Extension)crlExtensions.elementAt(k);
                            ExtPrettyPrint extpp = new ExtPrettyPrint(ext, 20);
                            sb.append(extpp.toString());
                        }
                    }
                } else if (this.mIP.isCRLCacheEnabled() && this.mIP.isCRLCacheEmpty()) {
                    sb.append("\n" + this.pp.indent(16) + resource.getString("cacheIsEmpty") + "\n\n");
                } else {
                    sb.append("\n" + this.pp.indent(16) + resource.getString("cacheNotAvailable") + "\n\n");
                }
            }
        }
        catch (Exception e) {
            sb.append("\n\n" + this.pp.indent(4) + resource.getString("decodingError") + "\n\n");
            logger.warn("Exception: " + e.getMessage(), (Throwable)e);
        }
        return sb.toString();
    }
}

