/*
 * Decompiled with CFR 0.152.
 */
package org.dogtagpki.cli;

import com.netscape.certsrv.client.ClientConfig;
import com.netscape.certsrv.client.PKIClient;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import org.apache.commons.cli.CommandLineParser;
import org.apache.commons.cli.DefaultParser;
import org.apache.commons.cli.HelpFormatter;
import org.apache.commons.cli.Options;
import org.apache.commons.lang3.StringUtils;
import org.dogtagpki.cli.CLIException;
import org.dogtagpki.cli.CLIModule;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CLI {
    public static Logger logger = LoggerFactory.getLogger(CLI.class);
    public static boolean verbose;
    public static CommandLineParser parser;
    public static HelpFormatter formatter;
    public String name;
    public String description;
    public CLI parent;
    public Options options = new Options();
    public Map<String, CLIModule> modules = new LinkedHashMap<String, CLIModule>();
    public PKIClient client;

    public CLI(String name, String description) {
        this(name, description, null);
    }

    public CLI(String name, String description, CLI parent) {
        this.name = name;
        this.description = description;
        this.parent = parent;
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public String getFullName() {
        return this.parent == null ? this.name : this.parent.getFullName() + "-" + this.name;
    }

    public String getFullModuleName(String moduleName) {
        return this.getFullName() + "-" + moduleName;
    }

    public String getDescription() {
        return this.description;
    }

    public void setDescription(String description) {
        this.description = description;
    }

    public CLI getParent() {
        return this.parent;
    }

    public CLI getRoot() {
        if (this.parent != null) {
            return this.parent.getRoot();
        }
        return this;
    }

    public boolean isDeprecated() {
        return this.getClass().getAnnotation(Deprecated.class) != null;
    }

    public Collection<CLIModule> getModules() {
        return this.modules.values();
    }

    public CLIModule getModule(String name) {
        return this.modules.get(name);
    }

    public void addModule(CLI cli) {
        CLIModule module = new CLIModule(this, cli);
        this.modules.put(cli.getName(), module);
    }

    public void addModule(String name, String className) {
        CLIModule module = new CLIModule(this, className);
        this.modules.put(name, module);
    }

    public CLIModule removeModule(String name) {
        return this.modules.remove(name);
    }

    public List<CLIModule> findModules(String command) throws Exception {
        ArrayList<CLIModule> results = new ArrayList<CLIModule>();
        String[] names = command.split("-");
        CLI current = this;
        int i = 0;
        while (i < names.length) {
            int j;
            Object moduleName = null;
            CLIModule module = null;
            for (j = i; j < names.length && (module = current.getModule((String)(moduleName = moduleName == null ? names[j] : (String)moduleName + "-" + names[j]))) == null; ++j) {
            }
            if (module == null) {
                throw new Exception("Invalid module \"" + (String)moduleName + "\".");
            }
            results.add(module);
            current = module.getCLI();
            i = j + 1;
        }
        return results;
    }

    public CLIModule findModule(String command) throws Exception {
        List<CLIModule> modules = this.findModules(command);
        return modules.get(modules.size() - 1);
    }

    public String getManPage() {
        return null;
    }

    public ClientConfig getConfig() throws Exception {
        if (this.parent != null) {
            return this.parent.getConfig();
        }
        return null;
    }

    public PKIClient getClient() throws Exception {
        if (this.parent != null) {
            return this.parent.getClient();
        }
        return null;
    }

    public Object getClient(String name) throws Exception {
        if (this.parent != null) {
            return this.parent.getClient(name);
        }
        return null;
    }

    public void printHelp() throws Exception {
        int leftPadding = 1;
        int rightPadding = 35;
        System.out.println("Commands:");
        for (CLIModule module : this.modules.values()) {
            CLI cli = module.getCLI();
            if (cli.isDeprecated()) continue;
            String label = cli.getFullName();
            int padding = rightPadding - leftPadding - label.length();
            if (padding < 1) {
                padding = 1;
            }
            System.out.print(StringUtils.repeat((String)" ", (int)leftPadding));
            System.out.print(label);
            System.out.print(StringUtils.repeat((String)" ", (int)padding));
            System.out.println(cli.getDescription());
        }
        boolean first = true;
        for (CLIModule module : this.modules.values()) {
            String label;
            int padding;
            CLI cli = module.getCLI();
            if (!cli.isDeprecated()) continue;
            if (first) {
                System.out.println();
                System.out.println("Deprecated:");
                first = false;
            }
            if ((padding = rightPadding - leftPadding - (label = cli.getFullName()).length()) < 1) {
                padding = 1;
            }
            System.out.print(StringUtils.repeat((String)" ", (int)leftPadding));
            System.out.print(label);
            System.out.print(StringUtils.repeat((String)" ", (int)padding));
            System.out.println(cli.getDescription());
        }
    }

    public void execute(String[] args) throws Exception {
        String[] moduleArgs;
        if (args.length == 0 || args[0].equals("--help")) {
            this.printHelp();
            return;
        }
        String command = args[0];
        String moduleName = null;
        String subCommand = null;
        CLI module = null;
        int position = 0;
        while (true) {
            int i;
            if ((i = command.indexOf(45, position)) >= 0) {
                moduleName = command.substring(0, i);
                subCommand = command.substring(i + 1);
            } else {
                moduleName = command;
                subCommand = null;
            }
            CLIModule m = this.getModule(moduleName);
            if (m != null) {
                CLI c = m.getCLI();
                if (subCommand == null) {
                    module = c;
                    break;
                }
                if (!c.getModules().isEmpty()) {
                    module = c;
                    break;
                }
            }
            if (i < 0) break;
            position = i + 1;
        }
        if (module == null) {
            throw new Exception("Invalid module \"" + this.getFullModuleName(moduleName) + "\".");
        }
        logger.info("Module: " + moduleName);
        if (subCommand != null) {
            moduleArgs = new String[args.length];
            moduleArgs[0] = subCommand;
            System.arraycopy(args, 1, moduleArgs, 1, args.length - 1);
        } else {
            moduleArgs = new String[args.length - 1];
            System.arraycopy(args, 1, moduleArgs, 0, args.length - 1);
        }
        module.options.addOption("v", "verbose", false, "Run in verbose mode.");
        module.options.addOption(null, "debug", false, "Run in debug mode.");
        module.options.addOption(null, "help", false, "Show help message.");
        module.execute(moduleArgs);
    }

    public void runExternal(List<String> command) throws CLIException, IOException, InterruptedException {
        String[] array = command.toArray(new String[command.size()]);
        this.runExternal(array);
    }

    public void runExternal(String[] command) throws CLIException, IOException, InterruptedException {
        Runtime rt;
        Process p;
        int rc;
        if (logger.isDebugEnabled()) {
            StringBuilder sb = new StringBuilder("Command:");
            for (String c : command) {
                boolean quote = c.contains(" ");
                sb.append(' ');
                if (quote) {
                    sb.append('\"');
                }
                sb.append(c);
                if (!quote) continue;
                sb.append('\"');
            }
            logger.debug(sb.toString());
        }
        if ((rc = (p = (rt = Runtime.getRuntime()).exec(command)).waitFor()) != 0) {
            throw new CLIException("Command failed. RC: " + rc, rc);
        }
    }

    static {
        parser = new DefaultParser();
        formatter = new HelpFormatter();
    }
}

