/*
 * Decompiled with CFR 0.152.
 */
package com.netscape.cmscore.dbs;

import com.netscape.certsrv.base.EBaseException;
import com.netscape.certsrv.base.MetaInfo;
import com.netscape.certsrv.dbs.DBAttrMapper;
import com.netscape.certsrv.dbs.IDBObj;
import com.netscape.cmscore.apps.CMS;
import java.util.Enumeration;
import java.util.StringTokenizer;
import java.util.Vector;
import netscape.ldap.LDAPAttribute;
import netscape.ldap.LDAPAttributeSet;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MetaInfoMapper
extends DBAttrMapper {
    public static Logger logger = LoggerFactory.getLogger(MetaInfoMapper.class);
    public static final String SEP = ":";
    private String mLdapName = null;
    private Vector<String> v = new Vector();

    public MetaInfoMapper(String ldapName) {
        this.mLdapName = ldapName;
        this.v.addElement(this.mLdapName);
    }

    @Override
    public Enumeration<String> getSupportedLDAPAttributeNames() {
        return this.v.elements();
    }

    @Override
    public void mapObjectToLDAPAttributeSet(IDBObj parent, String name, Object obj, LDAPAttributeSet attrs) throws EBaseException {
        if (obj == null) {
            throw new EBaseException(CMS.getUserMessage("CMS_DBS_SERIALIZE_FAILED", name));
        }
        MetaInfo info = (MetaInfo)obj;
        Enumeration e = info.getElements();
        if (!e.hasMoreElements()) {
            return;
        }
        logger.debug("MetaInfoMapper: Mapping " + name + " to " + this.mLdapName);
        LDAPAttribute attr = new LDAPAttribute(this.mLdapName);
        while (e.hasMoreElements()) {
            String s = null;
            String attrName = (String)e.nextElement();
            String value = (String)info.get(attrName);
            s = attrName + SEP + value;
            attr.addValue(s);
        }
        attrs.add(attr);
    }

    @Override
    public void mapLDAPAttributeSetToObject(LDAPAttributeSet attrs, String name, IDBObj parent) throws EBaseException {
        LDAPAttribute attr = attrs.getAttribute(this.mLdapName);
        if (attr == null) {
            return;
        }
        Enumeration values = attr.getStringValues();
        MetaInfo info = new MetaInfo();
        while (values.hasMoreElements()) {
            String s = (String)values.nextElement();
            StringTokenizer st = new StringTokenizer(s, SEP);
            info.set(st.nextToken(), (Object)st.nextToken());
        }
        parent.set(name, info);
    }

    @Override
    public String mapSearchFilter(String name, String op, String value) throws EBaseException {
        return this.mLdapName + op + value;
    }
}

