/*
 * Decompiled with CFR 0.152.
 */
package com.unboundid.util;

import com.unboundid.ldap.sdk.DN;
import com.unboundid.ldap.sdk.LDAPException;
import com.unboundid.ldap.sdk.ResultCode;
import com.unboundid.util.Base64;
import com.unboundid.util.Debug;
import com.unboundid.util.NotNull;
import com.unboundid.util.Nullable;
import com.unboundid.util.StaticUtils;
import com.unboundid.util.ThreadSafety;
import com.unboundid.util.ThreadSafetyLevel;
import com.unboundid.util.UtilityMessages;
import java.io.BufferedReader;
import java.io.Closeable;
import java.io.File;
import java.io.FileReader;
import java.io.IOException;
import java.text.ParseException;
import java.util.concurrent.atomic.AtomicLong;

@ThreadSafety(level=ThreadSafetyLevel.COMPLETELY_THREADSAFE)
public final class DNFileReader
implements Closeable {
    @NotNull
    private final AtomicLong lineNumberCounter;
    @NotNull
    private final BufferedReader reader;
    @NotNull
    private final File dnFile;

    public DNFileReader(@NotNull String path) throws IOException {
        this(new File(path));
    }

    public DNFileReader(@NotNull File dnFile) throws IOException {
        this.dnFile = dnFile;
        this.reader = new BufferedReader(new FileReader(dnFile));
        this.lineNumberCounter = new AtomicLong(0L);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Nullable
    public DN readDN() throws IOException, LDAPException {
        long lineNumber;
        String line;
        String trimmedLine;
        do {
            DNFileReader dNFileReader = this;
            synchronized (dNFileReader) {
                line = this.reader.readLine();
                lineNumber = this.lineNumberCounter.incrementAndGet();
            }
            if (line != null) continue;
            return null;
        } while ((trimmedLine = line.trim()).isEmpty() || trimmedLine.startsWith("#"));
        String dnString = trimmedLine;
        if (trimmedLine.charAt(2) == ':') {
            String lowerLine = StaticUtils.toLowerCase(trimmedLine);
            if (lowerLine.startsWith("dn::")) {
                String base64String = line.substring(4).trim();
                try {
                    dnString = Base64.decodeToString(base64String);
                }
                catch (ParseException pe) {
                    Debug.debugException(pe);
                    throw new LDAPException(ResultCode.DECODING_ERROR, UtilityMessages.ERR_DN_FILE_READER_CANNOT_BASE64_DECODE.get(base64String, lineNumber, this.dnFile.getAbsolutePath(), pe.getMessage()), pe);
                }
            } else if (lowerLine.startsWith("dn:")) {
                dnString = line.substring(3).trim();
            }
        }
        try {
            return new DN(dnString);
        }
        catch (LDAPException le) {
            Debug.debugException(le);
            throw new LDAPException(ResultCode.INVALID_DN_SYNTAX, UtilityMessages.ERR_DN_FILE_READER_CANNOT_PARSE_DN.get(dnString, lineNumber, this.dnFile.getAbsolutePath(), le.getMessage()), le);
        }
    }

    @Override
    public void close() throws IOException {
        this.reader.close();
    }
}

