/* dhparam.c: initial DH parameters for stunnel */
#include "prototypes.h"
#ifndef OPENSSL_NO_DH
#define DN_new DH_new
DH *get_dh2048(void) {
    static unsigned char dhp_2048[] = {
        0xf0, 0x8d, 0xc9, 0x4c, 0x3c, 0x1a, 0x12, 0x40, 0xcb, 0x37, 0xe9, 0xac,
        0x46, 0x67, 0xbb, 0xf1, 0x6b, 0x8c, 0xb2, 0xff, 0x79, 0xeb, 0xd2, 0x0c,
        0xe7, 0x29, 0x9d, 0xd8, 0x66, 0x57, 0x63, 0x13, 0x38, 0xfd, 0x95, 0xdd,
        0x7e, 0x8a, 0xc3, 0xe2, 0xd1, 0x41, 0x6d, 0x13, 0xae, 0x80, 0x1d, 0x65,
        0xd0, 0xd3, 0x09, 0x66, 0xe7, 0x81, 0x80, 0x52, 0xb6, 0x2a, 0x2e, 0x98,
        0xa8, 0x15, 0xbf, 0x43, 0x2e, 0x4f, 0xf3, 0x10, 0x9e, 0x9c, 0xd9, 0x2d,
        0xfa, 0xfd, 0xcc, 0x29, 0xe0, 0x48, 0x91, 0xe4, 0x6e, 0xc0, 0x18, 0x14,
        0x8a, 0x6b, 0xf0, 0x11, 0xfb, 0x20, 0x4e, 0xc1, 0x01, 0x49, 0xf0, 0x9e,
        0xd7, 0x1c, 0xfd, 0x95, 0xa5, 0x17, 0x70, 0xac, 0x57, 0x75, 0x96, 0xaa,
        0x2e, 0xfa, 0xba, 0x38, 0x52, 0xca, 0x68, 0x43, 0xf4, 0xcc, 0x70, 0xcb,
        0x84, 0x4c, 0xf6, 0xe8, 0x33, 0xfe, 0x4f, 0x09, 0x07, 0x6a, 0x8f, 0xf5,
        0xc4, 0x52, 0x28, 0x18, 0xde, 0xe0, 0x89, 0x3b, 0x15, 0x06, 0xcf, 0x35,
        0x74, 0xb5, 0x28, 0x6c, 0xf6, 0xed, 0x31, 0xf7, 0x06, 0x81, 0xc5, 0xcf,
        0x2a, 0x19, 0x44, 0x3f, 0xcc, 0x80, 0x35, 0xb0, 0xc2, 0xe4, 0x27, 0x2a,
        0x87, 0xee, 0x66, 0xeb, 0xab, 0x3b, 0xe0, 0xaa, 0x1f, 0xb0, 0xe4, 0xb6,
        0xdd, 0x33, 0xfc, 0x31, 0x4d, 0x53, 0xfd, 0xd1, 0xff, 0x1b, 0x25, 0xbf,
        0x4e, 0x94, 0x58, 0xab, 0xa8, 0x56, 0x2a, 0x7a, 0x53, 0x57, 0x13, 0x09,
        0xc5, 0x63, 0x24, 0x88, 0xb0, 0xe0, 0x5c, 0xb3, 0x28, 0xd4, 0x69, 0x02,
        0x91, 0x20, 0x66, 0x8d, 0x5a, 0xb5, 0xb1, 0x86, 0x79, 0xa7, 0x52, 0x92,
        0x89, 0xc0, 0x03, 0x22, 0xe1, 0x7b, 0x4e, 0xac, 0x4a, 0xdc, 0x06, 0xf6,
        0xa6, 0x9f, 0xe3, 0xbf, 0x73, 0x3f, 0x86, 0x8c, 0x8a, 0x5d, 0xc0, 0x5d,
        0x11, 0x55, 0x6c, 0x77
    };
    static unsigned char dhg_2048[] = {
        0x02
    };
    DH *dh = DH_new();
    BIGNUM *p, *g;

    if (dh == NULL)
        return NULL;
    p = BN_bin2bn(dhp_2048, sizeof(dhp_2048), NULL);
    g = BN_bin2bn(dhg_2048, sizeof(dhg_2048), NULL);
    if (p == NULL || g == NULL
            || !DH_set0_pqg(dh, p, NULL, g)) {
        DH_free(dh);
        BN_free(p);
        BN_free(g);
        return NULL;
    }
    return dh;
}
#endif /* OPENSSL_NO_DH */
/* built for stunnel 5.71 */
