/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.tenant;

import com.alibaba.rcm.Constraint;
import com.alibaba.tenant.JGroupConstraint;
import com.alibaba.tenant.NativeDispatcher;
import com.alibaba.tenant.TenantGlobals;
import com.alibaba.tenant.TenantResourceContainer;
import com.alibaba.tenant.TenantResourceType;
import java.io.File;
import java.io.IOException;
import java.nio.file.FileVisitOption;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.security.AccessController;
import java.util.ArrayList;
import sun.security.action.GetPropertyAction;

class JGroup {
    private static NativeDispatcher nd = new NativeDispatcher();
    static final String ROOT_GROUP_PATH;
    static final String JDK_GROUP_PATH;
    static final String JVM_GROUP_PATH;
    static final int DEFAULT_WEIGHT = 1024;
    static final int DEFAULT_MAXCPU = 100;
    private static JGroup rootGroup;
    private static JGroup jdkGroup;
    private static JGroup jvmGroup;
    private String groupPath;
    private JGroup parentGroup;
    private TenantResourceContainer resourceContainer;
    private static boolean debugJGroup;
    private static final String DEBUG_JGROUP_PROP = "com.alibaba.tenant.debugJGroup";
    private static final String PROP_ROOT_GROUP = "com.alibaba.tenant.jgroup.rootGroup";
    private static final String PROP_JDK_GROUP = "com.alibaba.tenant.jgroup.jdkGroup";
    private static final String DEFAULT_JDK_GROUP_NAME = "ajdk_multi_tenant";
    private static final String DEFAULT_ROOT_GROUP_PATH = "/";

    static JGroup jvmGroup() {
        return jvmGroup;
    }

    static JGroup jdkGroup() {
        return jdkGroup;
    }

    static JGroup rootGroup() {
        return rootGroup;
    }

    JGroup(TenantResourceContainer tenantResourceContainer) {
        if (tenantResourceContainer == null) {
            throw new IllegalArgumentException("Must provide a non-null TenantContainer to start with");
        }
        this.resourceContainer = tenantResourceContainer;
        assert (this.resourceContainer.getTenant() != null);
        this.init(this.resourceContainer, this.getTenantGroupPath(this.resourceContainer));
    }

    private JGroup(TenantResourceContainer tenantResourceContainer, String string) {
        this.init(tenantResourceContainer, string);
    }

    private void init(TenantResourceContainer tenantResourceContainer, String string) {
        this.groupPath = string;
        if (tenantResourceContainer == null) {
            this.parentGroup = null;
            if (JVM_GROUP_PATH.equals(string)) {
                this.parentGroup = JGroup.jdkGroup();
                this.initSystemGroup(this);
            } else if (JDK_GROUP_PATH.equals(string)) {
                this.parentGroup = JGroup.rootGroup();
            } else if (!ROOT_GROUP_PATH.equals(string)) {
                System.err.println("Should not call this with path=" + string);
            }
        } else {
            this.parentGroup = tenantResourceContainer.getParent() == null ? JGroup.jvmGroup() : tenantResourceContainer.getParent().getJGroup();
            this.initUserGroup(this, tenantResourceContainer.getConstraints());
        }
    }

    private String getTenantGroupPath(TenantResourceContainer tenantResourceContainer) {
        TenantResourceContainer tenantResourceContainer2 = tenantResourceContainer.getParent();
        return (tenantResourceContainer2 == null ? JVM_GROUP_PATH : tenantResourceContainer2.getJGroup().groupPath) + File.separator + "t" + tenantResourceContainer.getTenant().getTenantId();
    }

    private String groupPath() {
        return this.groupPath;
    }

    JGroup parent() {
        return this.parentGroup;
    }

    void destory() {
        Path path3 = JGroup.configPathOf(this.parent(), "tasks");
        try {
            Files.walk(Paths.get(JGroup.rootPathOf("cpu"), this.groupPath()), FileVisitOption.FOLLOW_LINKS).filter(path -> path.endsWith("tasks")).forEach(path2 -> {
                try {
                    for (String string : Files.readAllLines(path2)) {
                        Files.write(path3, string.getBytes(), new OpenOption[0]);
                        JGroup.debug("destroyCgroup: move " + string + " from " + path2 + " to " + path3);
                    }
                }
                catch (IOException iOException) {
                    iOException.printStackTrace();
                }
            });
            Files.walk(Paths.get(JGroup.rootPathOf("cpu"), this.groupPath()), FileVisitOption.FOLLOW_LINKS).map(Path::toFile).filter(File::isDirectory).forEach(File::delete);
        }
        catch (IOException iOException) {
            iOException.printStackTrace();
        }
    }

    private void initUserGroup(JGroup jGroup, Iterable<Constraint> iterable) {
        try {
            this.initCgroupCommon(jGroup);
            if (iterable != null) {
                for (Constraint constraint : iterable) {
                    TenantResourceType tenantResourceType;
                    if (!(constraint.getResourceType() instanceof TenantResourceType) || !(tenantResourceType = (TenantResourceType)constraint.getResourceType()).isJGroupResource()) continue;
                    ((JGroupConstraint)constraint).sync(jGroup);
                }
            }
        }
        catch (RuntimeException runtimeException) {
            throw runtimeException;
        }
        catch (Throwable throwable) {
            throw new RuntimeException(throwable);
        }
    }

    private void initSystemGroup(JGroup jGroup) {
        try {
            this.initCgroupCommon(jGroup);
        }
        catch (Throwable throwable) {
            throwable.printStackTrace();
            System.exit(127);
        }
    }

    private void initCgroupCommon(JGroup jGroup) {
        if (jGroup == null || jGroup.groupPath() == null || jGroup.groupPath().isEmpty()) {
            throw new IllegalArgumentException("Bad argument to createCGroup()");
        }
        if (nd.createCgroup(jGroup.groupPath()) == 0) {
            if (NativeDispatcher.IS_CPUSET_ENABLED) {
                this.copyValueFromParentGroup(jGroup, "cpuset.cpus");
                this.copyValueFromParentGroup(jGroup, "cpuset.mems");
            }
        } else {
            throw new RuntimeException("Failed to create cgroup at " + jGroup.groupPath());
        }
        JGroup.debug("Created group with standard controllers");
    }

    private void copyValueFromParentGroup(JGroup jGroup, String string) {
        String string2 = this.getValue(jGroup.parent(), string);
        this.setValue(jGroup, string, string2);
        JGroup.debug("Set group " + jGroup.groupPath() + "'s config " + string + " with parent group's value: " + string2);
    }

    private String getValue(JGroup jGroup, String string) {
        if (jGroup == null || jGroup.groupPath() == null || jGroup.groupPath().isEmpty() || string == null || string.isEmpty() || !string.contains(".")) {
            return null;
        }
        String string2 = string.split("\\.")[0];
        Path path = Paths.get(JGroup.rootPathOf(string2), jGroup.groupPath(), string);
        if (Files.exists(path, new LinkOption[0])) {
            try {
                String string3 = new String(Files.readAllBytes(path)).trim();
                JGroup.debug(string + "=" + string3);
                return string3;
            }
            catch (IOException iOException) {
                throw new RuntimeException(iOException);
            }
        }
        JGroup.debug("getValue: config path " + path + " does not exist");
        return null;
    }

    private void setValue(JGroup jGroup, String string, String string2) {
        if (jGroup == null || jGroup.groupPath() == null || jGroup.groupPath().isEmpty() || string == null || string.isEmpty() || string2 == null || string2.isEmpty() || !string.contains(".")) {
            throw new IllegalArgumentException("Cannot set " + jGroup.groupPath() + File.separator + string + "=" + string2);
        }
        String string3 = string.split("\\.")[0];
        Path path = Paths.get(JGroup.rootPathOf(string3), jGroup.groupPath(), string);
        if (Files.exists(path, new LinkOption[0])) {
            try {
                JGroup.debug("Set value: " + path + "=" + string2);
                Files.write(path, string2.getBytes(), new OpenOption[0]);
            }
            catch (IOException iOException) {
                throw new RuntimeException("Failed to set " + jGroup.groupPath() + File.separator + string + " = " + string2, iOException);
            }
        } else {
            JGroup.debug("setValue: config path " + path + " does not exist");
        }
    }

    static String rootPathOf(String string) {
        switch (string) {
            case "cpu": {
                return NativeDispatcher.CG_MP_CPU;
            }
            case "cpuset": {
                return NativeDispatcher.CG_MP_CPUSET;
            }
            case "cpuacct": {
                return NativeDispatcher.CG_MP_CPUACCT;
            }
        }
        throw new IllegalArgumentException("Unsupported controller : " + string);
    }

    private static void debug(String ... stringArray) {
        if (debugJGroup) {
            System.out.print("[JGroupDispatcher] ");
            for (String string : stringArray) {
                System.out.print(string);
                System.out.print(" ");
            }
            System.out.println();
        }
    }

    void attach() {
        if (nd.moveToCgroup(this.groupPath()) != 0) {
            throw new IllegalStateException("Cannot attach to group " + this);
        }
        JGroup.debug("Attached to cgroup: " + this.groupPath());
    }

    void detach() {
        JGroup.jvmGroup().attach();
    }

    long getCpuTime() {
        try {
            return Long.parseLong(this.getValue(this, "cpuacct.usage"));
        }
        catch (Exception exception) {
            System.err.println("Exception from JGroup.getCpuTime()");
            exception.printStackTrace();
            return -1L;
        }
    }

    synchronized void setValue(String string, String string2) {
        this.setValue(this, string, string2);
    }

    synchronized String getValue(String string) {
        return this.getValue(this, string);
    }

    private static void initializeJGroupClass() {
        try {
            rootGroup = new JGroup(null, ROOT_GROUP_PATH);
            jdkGroup = new JGroup(null, JDK_GROUP_PATH);
            jvmGroup = new JGroup(null, JVM_GROUP_PATH);
            JGroup.checkRootGroupPath();
            JGroup.jvmGroup().attach();
        }
        catch (Throwable throwable) {
            System.err.println("Failed to initialize JGroup");
            throwable.printStackTrace();
            System.exit(128);
        }
    }

    private static void checkRootGroupPath() {
        ArrayList<String> arrayList = new ArrayList<String>(4);
        if (TenantGlobals.isCpuThrottlingEnabled()) {
            arrayList.add("cpu");
            arrayList.add("cpuset");
        }
        if (TenantGlobals.isCpuAccountingEnabled()) {
            arrayList.add("cpuacct");
        }
        for (String string : arrayList) {
            String string2 = JGroup.rootPathOf(string);
            if (string2 != null && Files.exists(Paths.get(string2, ROOT_GROUP_PATH), new LinkOption[0])) continue;
            throw new IllegalArgumentException("Bad ROOT group path: " + string2 + File.separator + ROOT_GROUP_PATH);
        }
    }

    private static Path configPathOf(JGroup jGroup, String string) {
        String string2 = null;
        try {
            string2 = JGroup.rootPathOf(string.split("\\.")[0]);
        }
        catch (IllegalArgumentException illegalArgumentException) {
            string2 = JGroup.rootPathOf("cpu");
        }
        return Paths.get(string2, jGroup.groupPath(), string);
    }

    private static void destroyJGroupClass() {
        jvmGroup.destory();
        jvmGroup = null;
    }

    static {
        String string = System.getProperty(PROP_ROOT_GROUP);
        ROOT_GROUP_PATH = string == null ? DEFAULT_ROOT_GROUP_PATH : string;
        string = System.getProperty(PROP_JDK_GROUP);
        JDK_GROUP_PATH = string == null ? ROOT_GROUP_PATH + File.separator + DEFAULT_JDK_GROUP_NAME : ROOT_GROUP_PATH + File.separator + string;
        JVM_GROUP_PATH = JDK_GROUP_PATH + File.separator + nd.getProcessId();
        debugJGroup = Boolean.parseBoolean(AccessController.doPrivileged(new GetPropertyAction(DEBUG_JGROUP_PROP)));
    }
}

