#if !defined(ROSE_ENUMS_H)
#define ROSE_ENUMS_H

enum VariantT {
    V_SgName = 489,
    V_SgSymbolTable = 629,
    V_SgPragma = 573,
    V_SgModifierNodes = 483,
    V_SgConstVolatileModifier = 310,
    V_SgStorageModifier = 620,
    V_SgAccessModifier = 1,
    V_SgFunctionModifier = 391,
    V_SgUPC_AccessModifier = 708,
    V_SgLinkageModifier = 457,
    V_SgSpecialFunctionModifier = 613,
    V_SgTypeModifier = 682,
    V_SgElaboratedTypeModifier = 343,
    V_SgBaseClassModifier = 266,
    V_SgDeclarationModifier = 320,
    V_SgOpenclAccessModeModifier = 557,
    V_SgModifier = 482,
    V_Sg_File_Info = 793,
    V_SgSourceFile = 606,
    V_SgBinaryComposite = 269,
    V_SgUnknownFile = 714,
    V_SgFile = 373,
    V_SgFileList = 374,
    V_SgDirectory = 335,
    V_SgDirectoryList = 336,
    V_SgProject = 578,
    V_SgOptions = 559,
    V_SgUnparse_Info = 716,
    V_SgFuncDecl_attr = 386,
    V_SgClassDecl_attr = 285,
    V_SgTypedefSeq = 705,
    V_SgFunctionParameterTypeList = 394,
    V_SgTemplateParameter = 653,
    V_SgTemplateArgument = 630,
    V_SgTemplateParameterList = 655,
    V_SgTemplateArgumentList = 631,
    V_SgBitAttribute = 272,
    V_SgAttribute = 261,
    V_SgExpBaseClass = 265,
    V_SgBaseClass = 264,
    V_SgUndirectedGraphEdge = 712,
    V_SgDirectedGraphEdge = 333,
    V_SgGraphNode = 406,
    V_SgGraphEdge = 404,
    V_SgStringKeyedBidirectionalGraph = 622,
    V_SgIntKeyedBidirectionalGraph = 428,
    V_SgBidirectionalGraph = 268,
    V_SgIncidenceDirectedGraph = 421,
    V_SgIncidenceUndirectedGraph = 422,
    V_SgGraph = 403,
    V_SgGraphNodeList = 407,
    V_SgGraphEdgeList = 405,
    V_SgQualifiedName = 582,
    V_SgNameGroup = 490,
    V_SgDimensionObject = 331,
    V_SgDataStatementGroup = 315,
    V_SgDataStatementObject = 316,
    V_SgDataStatementValue = 317,
    V_SgFormatItem = 380,
    V_SgFormatItemList = 381,
    V_SgTypeTable = 400,
    V_SgJavaImportStatementList = 802,
    V_SgJavaClassDeclarationList = 803,
    V_SgSupport = 626,
    V_SgTypeUnknown = 695,
    V_SgTypeChar = 667,
    V_SgTypeSignedChar = 689,
    V_SgTypeUnsignedChar = 697,
    V_SgTypeShort = 687,
    V_SgTypeSignedShort = 693,
    V_SgTypeUnsignedShort = 701,
    V_SgTypeInt = 678,
    V_SgTypeSignedInt = 690,
    V_SgTypeUnsignedInt = 698,
    V_SgTypeLong = 679,
    V_SgTypeSignedLong = 691,
    V_SgTypeUnsignedLong = 699,
    V_SgTypeVoid = 702,
    V_SgTypeGlobalVoid = 675,
    V_SgTypeWchar = 703,
    V_SgTypeFloat = 674,
    V_SgTypeDouble = 672,
    V_SgTypeLongLong = 681,
    V_SgTypeSignedLongLong = 692,
    V_SgTypeUnsignedLongLong = 700,
    V_SgTypeLongDouble = 680,
    V_SgTypeString = 694,
    V_SgTypeBool = 666,
    V_SgTypeMatrix = 683,
    V_SgTypeTuple = 684,
    V_SgTypeNullptr = 685,
    V_SgTypeComplex = 668,
    V_SgTypeImaginary = 677,
    V_SgTypeDefault = 669,
    V_SgPointerMemberType = 570,
    V_SgReferenceType = 588,
    V_SgRvalueReferenceType = 595,
    V_SgDeclType = 322,
    V_SgTypeOfType = 686,
    V_SgTypeCAFTeam = 794,
    V_SgTypeUnsigned128bitInteger = 696,
    V_SgTypeSigned128bitInteger = 688,
    V_SgTypeLabel = 671,
    V_SgJavaParameterizedType = 611,
    V_SgJavaQualifiedType = 810,
    V_SgJavaWildcardType = 612,
    V_SgJavaUnionType = 812,
    V_SgJavaParameterType = 813,
    V_SgTemplateType = 657,
    V_SgEnumType = 361,
    V_SgTypedefType = 707,
    V_SgModifierType = 484,
    V_SgPartialFunctionModifierType = 562,
    V_SgArrayType = 11,
    V_SgTypeEllipse = 673,
    V_SgTypeCrayPointer = 798,
    V_SgPartialFunctionType = 563,
    V_SgMemberFunctionType = 474,
    V_SgFunctionType = 397,
    V_SgPointerType = 571,
    V_SgClassType = 290,
    V_SgNamedType = 491,
    V_SgQualifiedNameType = 583,
    V_SgType = 665,
    V_SgForStatement = 379,
    V_SgForInitStatement = 378,
    V_SgCatchStatementSeq = 283,
    V_SgFunctionParameterList = 392,
    V_SgCtorInitializerList = 314,
    V_SgBasicBlock = 267,
    V_SgGlobal = 401,
    V_SgIfStmt = 414,
    V_SgWhileStmt = 789,
    V_SgDoWhileStmt = 339,
    V_SgSwitchStatement = 627,
    V_SgCatchOptionStmt = 282,
    V_SgFunctionParameterScope = 390,
    V_SgVariableDefinition = 780,
    V_SgStmtDeclarationStatement = 616,
    V_SgEnumDeclaration = 358,
    V_SgAsmStmt = 238,
    V_SgFunctionTypeTable = 399,
    V_SgExprStatement = 370,
    V_SgLabelStatement = 444,
    V_SgCaseOptionStmt = 280,
    V_SgTryStmt = 663,
    V_SgDefaultOptionStmt = 323,
    V_SgBreakStmt = 278,
    V_SgContinueStmt = 313,
    V_SgReturnStmt = 591,
    V_SgGotoStatement = 402,
    V_SgSpawnStmt = 607,
    V_SgTemplateTypedefDeclaration = 641,
    V_SgTemplateInstantiationTypedefDeclaration = 652,
    V_SgTypedefDeclaration = 704,
    V_SgNullStatement = 508,
    V_SgVariantStatement = 783,
    V_SgPragmaDeclaration = 574,
    V_SgTemplateClassDeclaration = 633,
    V_SgTemplateMemberFunctionDeclaration = 638,
    V_SgTemplateFunctionDeclaration = 635,
    V_SgTemplateVariableDeclaration = 643,
    V_SgTemplateDeclaration = 632,
    V_SgVariableDeclaration = 779,
    V_SgTemplateInstantiationDecl = 647,
    V_SgTemplateInstantiationDefn = 648,
    V_SgTemplateInstantiationFunctionDecl = 650,
    V_SgTemplateInstantiationMemberFunctionDecl = 651,
    V_SgWithStatement = 786,
    V_SgPythonGlobalStmt = 580,
    V_SgPythonPrintStmt = 581,
    V_SgPassStatement = 564,
    V_SgAssertStmt = 253,
    V_SgExecStatement = 366,
    V_SgProgramHeaderStatement = 577,
    V_SgProcedureHeaderStatement = 576,
    V_SgEntryStatement = 357,
    V_SgFortranNonblockedDo = 385,
    V_SgInterfaceStatement = 434,
    V_SgParameterStatement = 561,
    V_SgCommonBlock = 297,
    V_SgModuleStatement = 485,
    V_SgUseStatement = 767,
    V_SgStopOrPauseStatement = 619,
    V_SgPrintStatement = 575,
    V_SgReadStatement = 585,
    V_SgWriteStatement = 790,
    V_SgOpenStatement = 558,
    V_SgCloseStatement = 294,
    V_SgInquireStatement = 427,
    V_SgFlushStatement = 376,
    V_SgBackspaceStatement = 263,
    V_SgRewindStatement = 592,
    V_SgEndfileStatement = 355,
    V_SgWaitStatement = 784,
    V_SgCAFWithTeamStatement = 795,
    V_SgFormatStatement = 382,
    V_SgFortranDo = 383,
    V_SgForAllStatement = 377,
    V_SgIOStatement = 411,
    V_SgMatlabForStatement = 470,
    V_SgUpcNotifyStatement = 764,
    V_SgUpcWaitStatement = 766,
    V_SgUpcBarrierStatement = 757,
    V_SgUpcFenceStatement = 760,
    V_SgUpcForAllStatement = 761,
    V_SgOmpParallelStatement = 520,
    V_SgOmpSingleStatement = 523,
    V_SgOmpTaskStatement = 524,
    V_SgOmpForStatement = 517,
    V_SgOmpDoStatement = 515,
    V_SgOmpSectionsStatement = 522,
    V_SgOmpTargetStatement = 528,
    V_SgOmpTargetDataStatement = 529,
    V_SgOmpSimdStatement = 530,
    V_SgOmpClauseBodyStatement = 513,
    V_SgOmpAtomicStatement = 510,
    V_SgOmpMasterStatement = 518,
    V_SgOmpSectionStatement = 521,
    V_SgOmpOrderedStatement = 519,
    V_SgOmpWorkshareStatement = 527,
    V_SgOmpCriticalStatement = 512,
    V_SgOmpBodyStatement = 514,
    V_SgJavaThrowStatement = 608,
    V_SgJavaForEachStatement = 609,
    V_SgJavaSynchronizedStatement = 610,
    V_SgJavaLabelStatement = 445,
    V_SgJavaImportStatement = 799,
    V_SgJavaPackageDeclaration = 800,
    V_SgJavaPackageStatement = 801,
    V_SgAsyncStmt = 814,
    V_SgFinishStmt = 815,
    V_SgAtStmt = 816,
    V_SgBlockDataStatement = 276,
    V_SgImplicitStatement = 418,
    V_SgStatementFunctionStatement = 618,
    V_SgWhereStatement = 788,
    V_SgNullifyStatement = 509,
    V_SgEquivalenceStatement = 364,
    V_SgDerivedTypeStatement = 327,
    V_SgAttributeSpecificationStatement = 262,
    V_SgAllocateStatement = 7,
    V_SgDeallocateStatement = 319,
    V_SgContainsStatement = 312,
    V_SgSequenceStatement = 600,
    V_SgElseWhereStatement = 352,
    V_SgArithmeticIfStatement = 10,
    V_SgAssignStatement = 256,
    V_SgComputedGotoStatement = 306,
    V_SgAssignedGotoStatement = 257,
    V_SgNamelistStatement = 492,
    V_SgImportStatement = 420,
    V_SgAssociateStatement = 258,
    V_SgFortranIncludeLine = 384,
    V_SgNamespaceDeclarationStatement = 494,
    V_SgNamespaceAliasDeclarationStatement = 493,
    V_SgNamespaceDefinitionStatement = 495,
    V_SgUsingDeclarationStatement = 770,
    V_SgUsingDirectiveStatement = 771,
    V_SgTemplateInstantiationDirectiveStatement = 649,
    V_SgStaticAssertionDeclaration = 615,
    V_SgTemplateClassDefinition = 645,
    V_SgTemplateFunctionDefinition = 646,
    V_SgClassDeclaration = 286,
    V_SgClassDefinition = 287,
    V_SgFunctionDefinition = 389,
    V_SgScopeStatement = 599,
    V_SgMemberFunctionDeclaration = 471,
    V_SgFunctionDeclaration = 388,
    V_SgIncludeDirectiveStatement = 423,
    V_SgDefineDirectiveStatement = 325,
    V_SgUndefDirectiveStatement = 711,
    V_SgIfdefDirectiveStatement = 415,
    V_SgIfndefDirectiveStatement = 416,
    V_SgIfDirectiveStatement = 413,
    V_SgDeadIfDirectiveStatement = 318,
    V_SgElseDirectiveStatement = 351,
    V_SgElseifDirectiveStatement = 353,
    V_SgEndifDirectiveStatement = 356,
    V_SgLineDirectiveStatement = 455,
    V_SgWarningDirectiveStatement = 785,
    V_SgErrorDirectiveStatement = 365,
    V_SgEmptyDirectiveStatement = 354,
    V_SgIncludeNextDirectiveStatement = 424,
    V_SgIdentDirectiveStatement = 412,
    V_SgLinemarkerDirectiveStatement = 456,
    V_SgC_PreprocessorDirectiveStatement = 279,
    V_SgClinkageStartStatement = 293,
    V_SgClinkageEndStatement = 292,
    V_SgClinkageDeclarationStatement = 291,
    V_SgOmpFlushStatement = 516,
    V_SgOmpBarrierStatement = 511,
    V_SgOmpTaskwaitStatement = 525,
    V_SgOmpThreadprivateStatement = 526,
    V_SgMicrosoftAttributeDeclaration = 476,
    V_SgDeclarationStatement = 321,
    V_SgStatement = 614,
    V_SgVarRefExp = 778,
    V_SgCompoundLiteralExp = 305,
    V_SgLabelRefExp = 443,
    V_SgClassNameRefExp = 288,
    V_SgFunctionRefExp = 395,
    V_SgMemberFunctionRefExp = 472,
    V_SgTemplateFunctionRefExp = 636,
    V_SgTemplateMemberFunctionRefExp = 639,
    V_SgSizeOfOp = 603,
    V_SgAlignOfOp = 604,
    V_SgNoexceptOp = 502,
    V_SgJavaInstanceOfOp = 605,
    V_SgJavaMarkerAnnotation = 806,
    V_SgJavaSingleMemberAnnotation = 807,
    V_SgJavaNormalAnnotation = 808,
    V_SgJavaAnnotation = 805,
    V_SgJavaTypeExpression = 809,
    V_SgTypeExpression = 670,
    V_SgLambdaExp = 450,
    V_SgUpcLocalsizeofExpression = 762,
    V_SgUpcBlocksizeofExpression = 758,
    V_SgUpcElemsizeofExpression = 759,
    V_SgVarArgStartOp = 777,
    V_SgVarArgStartOneOperandOp = 776,
    V_SgVarArgOp = 775,
    V_SgVarArgEndOp = 774,
    V_SgVarArgCopyOp = 773,
    V_SgTypeIdOp = 676,
    V_SgConditionalExp = 308,
    V_SgNewExp = 500,
    V_SgDeleteExp = 326,
    V_SgThisExp = 658,
    V_SgSuperExp = 660,
    V_SgClassExp = 811,
    V_SgRefExp = 587,
    V_SgAggregateInitializer = 5,
    V_SgCompoundInitializer = 304,
    V_SgConstructorInitializer = 311,
    V_SgAssignInitializer = 254,
    V_SgExpressionRoot = 372,
    V_SgMinusOp = 479,
    V_SgUnaryAddOp = 709,
    V_SgNotOp = 504,
    V_SgPointerDerefExp = 569,
    V_SgAddressOfOp = 4,
    V_SgMinusMinusOp = 478,
    V_SgPlusPlusOp = 566,
    V_SgBitComplementOp = 273,
    V_SgRealPartOp = 586,
    V_SgImagPartOp = 417,
    V_SgConjugateOp = 309,
    V_SgCastExp = 281,
    V_SgThrowOp = 661,
    V_SgArrowExp = 12,
    V_SgDotExp = 340,
    V_SgDotStarOp = 341,
    V_SgArrowStarOp = 13,
    V_SgEqualityOp = 363,
    V_SgLessThanOp = 454,
    V_SgGreaterThanOp = 409,
    V_SgNotEqualOp = 503,
    V_SgLessOrEqualOp = 453,
    V_SgGreaterOrEqualOp = 408,
    V_SgAddOp = 3,
    V_SgSubtractOp = 625,
    V_SgMultiplyOp = 488,
    V_SgDivideOp = 338,
    V_SgIntegerDivideOp = 430,
    V_SgModOp = 481,
    V_SgAndOp = 9,
    V_SgOrOp = 560,
    V_SgBitXorOp = 275,
    V_SgBitAndOp = 271,
    V_SgBitOrOp = 274,
    V_SgCommaOpExp = 296,
    V_SgLshiftOp = 466,
    V_SgRshiftOp = 594,
    V_SgJavaUnsignedRshiftOp = 597,
    V_SgPntrArrRefExp = 567,
    V_SgScopeOp = 598,
    V_SgAssignOp = 255,
    V_SgPlusAssignOp = 565,
    V_SgMinusAssignOp = 477,
    V_SgAndAssignOp = 8,
    V_SgIorAssignOp = 439,
    V_SgMultAssignOp = 487,
    V_SgDivAssignOp = 337,
    V_SgModAssignOp = 480,
    V_SgXorAssignOp = 791,
    V_SgLshiftAssignOp = 465,
    V_SgRshiftAssignOp = 593,
    V_SgJavaUnsignedRshiftAssignOp = 596,
    V_SgIntegerDivideAssignOp = 431,
    V_SgExponentiationAssignOp = 368,
    V_SgConcatenationOp = 307,
    V_SgNaryComparisonOp = 499,
    V_SgNaryBooleanOp = 498,
    V_SgBoolValExp = 277,
    V_SgStringVal = 623,
    V_SgShortVal = 602,
    V_SgCharVal = 284,
    V_SgUnsignedCharVal = 717,
    V_SgWcharVal = 787,
    V_SgUnsignedShortVal = 721,
    V_SgIntVal = 429,
    V_SgEnumVal = 362,
    V_SgUnsignedIntVal = 718,
    V_SgLongIntVal = 463,
    V_SgLongLongIntVal = 464,
    V_SgUnsignedLongLongIntVal = 719,
    V_SgUnsignedLongVal = 720,
    V_SgFloatVal = 375,
    V_SgDoubleVal = 342,
    V_SgLongDoubleVal = 462,
    V_SgNullptrValExp = 507,
    V_SgFunctionParameterRefExp = 393,
    V_SgTemplateParameterVal = 654,
    V_SgUpcThreads = 765,
    V_SgUpcMythread = 763,
    V_SgComplexVal = 300,
    V_SgNullExpression = 506,
    V_SgVariantExpression = 782,
    V_SgStatementExpression = 617,
    V_SgAsmOp = 209,
    V_SgCudaKernelExecConfig = 441,
    V_SgCudaKernelCallExp = 442,
    V_SgLambdaRefExp = 451,
    V_SgTupleExp = 664,
    V_SgListExp = 459,
    V_SgDictionaryExp = 330,
    V_SgKeyDatumPair = 440,
    V_SgComprehension = 301,
    V_SgListComprehension = 458,
    V_SgSetComprehension = 601,
    V_SgDictionaryComprehension = 329,
    V_SgMembershipOp = 475,
    V_SgNonMembershipOp = 505,
    V_SgIsOp = 437,
    V_SgIsNotOp = 438,
    V_SgStringConversion = 621,
    V_SgYieldExpression = 792,
    V_SgHereExp = 817,
    V_SgSubscriptExpression = 624,
    V_SgColonShapeExp = 295,
    V_SgAsteriskShapeExp = 259,
    V_SgIOItemExpression = 410,
    V_SgImpliedDo = 419,
    V_SgExponentiationOp = 367,
    V_SgUnknownArrayOrFunctionReference = 713,
    V_SgActualArgumentExpression = 2,
    V_SgUserDefinedBinaryOp = 768,
    V_SgPointerAssignOp = 568,
    V_SgCAFCoExpression = 796,
    V_SgDesignatedInitializer = 328,
    V_SgMatrixExp = 468,
    V_SgRangeExp = 584,
    V_SgMagicColonExp = 467,
    V_SgElementwiseMultiplyOp = 348,
    V_SgPowerOp = 572,
    V_SgElementwisePowerOp = 349,
    V_SgElementwiseDivideOp = 346,
    V_SgLeftDivideOp = 452,
    V_SgElementwiseLeftDivideOp = 347,
    V_SgElementwiseAddOp = 345,
    V_SgElementwiseSubtractOp = 350,
    V_SgMatrixTransposeOp = 469,
    V_SgElementwiseOp = 344,
    V_SgInitializer = 426,
    V_SgUserDefinedUnaryOp = 769,
    V_SgPseudoDestructorRefExp = 579,
    V_SgUnaryOp = 710,
    V_SgCompoundAssignOp = 303,
    V_SgBinaryOp = 270,
    V_SgNaryOp = 497,
    V_SgValueExp = 772,
    V_SgExprListExp = 369,
    V_SgFunctionCallExp = 387,
    V_SgCallExpression = 797,
    V_SgTypeTraitBuiltinOperator = 659,
    V_SgExpression = 371,
    V_SgTemplateVariableSymbol = 644,
    V_SgVariableSymbol = 781,
    V_SgFunctionTypeSymbol = 398,
    V_SgTemplateClassSymbol = 634,
    V_SgClassSymbol = 289,
    V_SgTemplateSymbol = 656,
    V_SgEnumSymbol = 360,
    V_SgEnumFieldSymbol = 359,
    V_SgTemplateTypedefSymbol = 642,
    V_SgTypedefSymbol = 706,
    V_SgTemplateFunctionSymbol = 637,
    V_SgTemplateMemberFunctionSymbol = 640,
    V_SgLabelSymbol = 446,
    V_SgJavaLabelSymbol = 447,
    V_SgDefaultSymbol = 324,
    V_SgNamespaceSymbol = 496,
    V_SgIntrinsicSymbol = 436,
    V_SgModuleSymbol = 486,
    V_SgInterfaceSymbol = 435,
    V_SgCommonSymbol = 299,
    V_SgRenameSymbol = 590,
    V_SgMemberFunctionSymbol = 473,
    V_SgFunctionSymbol = 396,
    V_SgAsmBinaryAddressSymbol = 251,
    V_SgAsmBinaryDataSymbol = 252,
    V_SgAliasSymbol = 6,
    V_SgSymbol = 628,
    V_SgAsmArmInstruction = 14,
    V_SgAsmArmv8Instruction = 250,
    V_SgAsmX86Instruction = 249,
    V_SgAsmPowerpcInstruction = 227,
    V_SgAsmMipsInstruction = 195,
    V_SgAsmM68kInstruction = 192,
    V_SgAsmInstruction = 177,
    V_SgAsmOperandList = 210,
    V_SgAsmBinaryAdd = 16,
    V_SgAsmBinarySubtract = 27,
    V_SgAsmBinaryMultiply = 25,
    V_SgAsmBinaryDivide = 20,
    V_SgAsmBinaryMod = 24,
    V_SgAsmBinaryAddPreupdate = 18,
    V_SgAsmBinarySubtractPreupdate = 29,
    V_SgAsmBinaryAddPostupdate = 17,
    V_SgAsmBinarySubtractPostupdate = 28,
    V_SgAsmBinaryLsl = 22,
    V_SgAsmBinaryLsr = 23,
    V_SgAsmBinaryAsr = 19,
    V_SgAsmBinaryRor = 26,
    V_SgAsmBinaryExpression = 21,
    V_SgAsmUnaryPlus = 245,
    V_SgAsmUnaryMinus = 244,
    V_SgAsmUnaryRrx = 246,
    V_SgAsmUnaryArmSpecialRegisterList = 242,
    V_SgAsmUnaryExpression = 243,
    V_SgAsmDirectRegisterExpression = 42,
    V_SgAsmIndirectRegisterExpression = 176,
    V_SgAsmRegisterReferenceExpression = 231,
    V_SgAsmRegisterNames = 230,
    V_SgAsmIntegerValueExpression = 178,
    V_SgAsmFloatValueExpression = 160,
    V_SgAsmConstantExpression = 37,
    V_SgAsmValueExpression = 247,
    V_SgAsmMemoryReferenceExpression = 194,
    V_SgAsmControlFlagsExpression = 36,
    V_SgAsmCommonSubExpression = 35,
    V_SgAsmRiscOperation = 232,
    V_SgAsmExprListExp = 156,
    V_SgAsmExpression = 157,
    V_SgAsmIntegerType = 179,
    V_SgAsmFloatType = 159,
    V_SgAsmScalarType = 233,
    V_SgAsmVectorType = 248,
    V_SgAsmType = 241,
    V_SgAsmFunction = 161,
    V_SgAsmBlock = 30,
    V_SgAsmStaticData = 237,
    V_SgAsmSynthesizedDataStructureDeclaration = 40,
    V_SgAsmSynthesizedFieldDeclaration = 158,
    V_SgAsmSynthesizedDeclaration = 41,
    V_SgAsmStatement = 236,
    V_SgAsmInterpretationList = 181,
    V_SgAsmInterpretation = 180,
    V_SgAsmElfFileHeader = 124,
    V_SgAsmElfSectionTable = 132,
    V_SgAsmElfSectionTableEntry = 133,
    V_SgAsmElfSegmentTable = 134,
    V_SgAsmElfSegmentTableEntryList = 136,
    V_SgAsmElfSegmentTableEntry = 135,
    V_SgAsmElfSymbolSection = 141,
    V_SgAsmElfSymbolList = 140,
    V_SgAsmElfSymbol = 139,
    V_SgAsmElfSymverSection = 154,
    V_SgAsmElfSymverEntry = 147,
    V_SgAsmElfSymverEntryList = 148,
    V_SgAsmElfSymverDefinedSection = 146,
    V_SgAsmElfSymverDefinedEntryList = 145,
    V_SgAsmElfSymverDefinedEntry = 144,
    V_SgAsmElfSymverDefinedAuxList = 143,
    V_SgAsmElfSymverDefinedAux = 142,
    V_SgAsmElfSymverNeededSection = 153,
    V_SgAsmElfSymverNeededEntryList = 152,
    V_SgAsmElfSymverNeededEntry = 151,
    V_SgAsmElfSymverNeededAuxList = 150,
    V_SgAsmElfSymverNeededAux = 149,
    V_SgAsmElfRelocSection = 130,
    V_SgAsmElfRelocEntryList = 129,
    V_SgAsmElfRelocEntry = 128,
    V_SgAsmElfDynamicSection = 118,
    V_SgAsmElfDynamicEntryList = 117,
    V_SgAsmElfDynamicEntry = 116,
    V_SgAsmElfStringSection = 137,
    V_SgAsmElfStrtab = 138,
    V_SgAsmElfNoteSection = 127,
    V_SgAsmElfNoteEntryList = 126,
    V_SgAsmElfNoteEntry = 125,
    V_SgAsmElfEHFrameSection = 123,
    V_SgAsmElfEHFrameEntryCIList = 120,
    V_SgAsmElfEHFrameEntryCI = 119,
    V_SgAsmElfEHFrameEntryFDList = 122,
    V_SgAsmElfEHFrameEntryFD = 121,
    V_SgAsmElfSection = 131,
    V_SgAsmDOSFileHeader = 39,
    V_SgAsmDOSExtendedHeader = 38,
    V_SgAsmPEFileHeader = 215,
    V_SgAsmPERVASizePairList = 222,
    V_SgAsmPERVASizePair = 221,
    V_SgAsmPEImportItem = 218,
    V_SgAsmPEImportItemList = 219,
    V_SgAsmPEImportDirectory = 216,
    V_SgAsmPEImportDirectoryList = 217,
    V_SgAsmPEImportSection = 220,
    V_SgAsmPEExportSection = 214,
    V_SgAsmPEExportDirectory = 211,
    V_SgAsmPEExportEntryList = 213,
    V_SgAsmPEExportEntry = 212,
    V_SgAsmPEStringSection = 226,
    V_SgAsmPESectionTable = 224,
    V_SgAsmPESectionTableEntry = 225,
    V_SgAsmPESection = 223,
    V_SgAsmCoffSymbolTable = 34,
    V_SgAsmCoffSymbolList = 33,
    V_SgAsmCoffSymbol = 32,
    V_SgAsmCoffStrtab = 31,
    V_SgAsmNEFileHeader = 198,
    V_SgAsmNEEntryTable = 197,
    V_SgAsmNEEntryPoint = 196,
    V_SgAsmNESectionTable = 205,
    V_SgAsmNESectionTableEntry = 206,
    V_SgAsmNERelocTable = 203,
    V_SgAsmNERelocEntry = 202,
    V_SgAsmNENameTable = 200,
    V_SgAsmNEModuleTable = 199,
    V_SgAsmNEStringTable = 207,
    V_SgAsmNESection = 204,
    V_SgAsmLEFileHeader = 184,
    V_SgAsmLEEntryTable = 183,
    V_SgAsmLEEntryPoint = 182,
    V_SgAsmLESectionTable = 190,
    V_SgAsmLESectionTableEntry = 191,
    V_SgAsmLERelocTable = 188,
    V_SgAsmLENameTable = 185,
    V_SgAsmLEPageTable = 186,
    V_SgAsmLEPageTableEntry = 187,
    V_SgAsmLESection = 189,
    V_SgAsmDwarfArrayType = 44,
    V_SgAsmDwarfClassType = 48,
    V_SgAsmDwarfEntryPoint = 59,
    V_SgAsmDwarfEnumerationType = 60,
    V_SgAsmDwarfFormalParameter = 63,
    V_SgAsmDwarfImportedDeclaration = 67,
    V_SgAsmDwarfLabel = 74,
    V_SgAsmDwarfLexicalBlock = 75,
    V_SgAsmDwarfMember = 80,
    V_SgAsmDwarfPointerType = 88,
    V_SgAsmDwarfReferenceType = 90,
    V_SgAsmDwarfCompilationUnit = 51,
    V_SgAsmDwarfStringType = 94,
    V_SgAsmDwarfStructureType = 95,
    V_SgAsmDwarfSubroutineType = 98,
    V_SgAsmDwarfTypedef = 103,
    V_SgAsmDwarfUnionType = 104,
    V_SgAsmDwarfUnspecifiedParameters = 106,
    V_SgAsmDwarfVariant = 112,
    V_SgAsmDwarfCommonBlock = 49,
    V_SgAsmDwarfCommonInclusion = 50,
    V_SgAsmDwarfInheritance = 71,
    V_SgAsmDwarfInlinedSubroutine = 72,
    V_SgAsmDwarfModule = 81,
    V_SgAsmDwarfPtrToMemberType = 89,
    V_SgAsmDwarfSetType = 92,
    V_SgAsmDwarfSubrangeType = 97,
    V_SgAsmDwarfWithStmt = 115,
    V_SgAsmDwarfAccessDeclaration = 43,
    V_SgAsmDwarfBaseType = 45,
    V_SgAsmDwarfCatchBlock = 46,
    V_SgAsmDwarfConstType = 54,
    V_SgAsmDwarfConstant = 55,
    V_SgAsmDwarfEnumerator = 61,
    V_SgAsmDwarfFileType = 62,
    V_SgAsmDwarfFriend = 65,
    V_SgAsmDwarfNamelist = 83,
    V_SgAsmDwarfNamelistItem = 84,
    V_SgAsmDwarfPackedType = 86,
    V_SgAsmDwarfSubprogram = 96,
    V_SgAsmDwarfTemplateTypeParameter = 99,
    V_SgAsmDwarfTemplateValueParameter = 100,
    V_SgAsmDwarfThrownType = 101,
    V_SgAsmDwarfTryBlock = 102,
    V_SgAsmDwarfVariantPart = 113,
    V_SgAsmDwarfVariable = 111,
    V_SgAsmDwarfVolatileType = 114,
    V_SgAsmDwarfDwarfProcedure = 58,
    V_SgAsmDwarfRestrictType = 91,
    V_SgAsmDwarfInterfaceType = 73,
    V_SgAsmDwarfNamespace = 85,
    V_SgAsmDwarfImportedModule = 68,
    V_SgAsmDwarfUnspecifiedType = 107,
    V_SgAsmDwarfPartialUnit = 87,
    V_SgAsmDwarfImportedUnit = 69,
    V_SgAsmDwarfMutableType = 82,
    V_SgAsmDwarfCondition = 53,
    V_SgAsmDwarfSharedType = 93,
    V_SgAsmDwarfFormatLabel = 64,
    V_SgAsmDwarfFunctionTemplate = 66,
    V_SgAsmDwarfClassTemplate = 47,
    V_SgAsmDwarfUpcSharedType = 109,
    V_SgAsmDwarfUpcStrictType = 110,
    V_SgAsmDwarfUpcRelaxedType = 108,
    V_SgAsmDwarfUnknownConstruct = 105,
    V_SgAsmDwarfConstruct = 56,
    V_SgAsmDwarfMacroList = 79,
    V_SgAsmDwarfMacro = 78,
    V_SgAsmDwarfLine = 76,
    V_SgAsmDwarfLineList = 77,
    V_SgAsmDwarfConstructList = 57,
    V_SgAsmDwarfCompilationUnitList = 52,
    V_SgAsmDwarfInformation = 70,
    V_SgAsmStringStorage = 240,
    V_SgAsmBasicString = 15,
    V_SgAsmStoredString = 239,
    V_SgAsmGenericString = 172,
    V_SgAsmGenericHeaderList = 169,
    V_SgAsmGenericHeader = 168,
    V_SgAsmGenericSymbolList = 175,
    V_SgAsmGenericSymbol = 174,
    V_SgAsmGenericStrtab = 173,
    V_SgAsmGenericSectionList = 171,
    V_SgAsmGenericSection = 170,
    V_SgAsmGenericDLLList = 164,
    V_SgAsmGenericDLL = 163,
    V_SgAsmGenericFormat = 167,
    V_SgAsmGenericFileList = 166,
    V_SgAsmGenericFile = 165,
    V_SgAsmExecutableFileFormat = 155,
    V_SgAsmNode = 208,
    V_SgCommonBlockObject = 298,
    V_SgInitializedName = 425,
    V_SgLambdaCapture = 448,
    V_SgLambdaCaptureList = 449,
    V_SgJavaMemberValuePair = 804,
    V_SgOmpOrderedClause = 545,
    V_SgOmpNowaitClause = 543,
    V_SgOmpBeginClause = 532,
    V_SgOmpEndClause = 537,
    V_SgOmpUntiedClause = 550,
    V_SgOmpDefaultClause = 536,
    V_SgOmpCollapseClause = 533,
    V_SgOmpIfClause = 540,
    V_SgOmpNumThreadsClause = 544,
    V_SgOmpDeviceClause = 541,
    V_SgOmpSafelenClause = 553,
    V_SgOmpExpressionClause = 538,
    V_SgOmpCopyprivateClause = 535,
    V_SgOmpPrivateClause = 546,
    V_SgOmpFirstprivateClause = 539,
    V_SgOmpSharedClause = 549,
    V_SgOmpCopyinClause = 534,
    V_SgOmpLastprivateClause = 542,
    V_SgOmpReductionClause = 547,
    V_SgOmpMapClause = 552,
    V_SgOmpLinearClause = 554,
    V_SgOmpUniformClause = 555,
    V_SgOmpAlignedClause = 556,
    V_SgOmpVariablesClause = 551,
    V_SgOmpScheduleClause = 548,
    V_SgOmpClause = 531,
    V_SgRenamePair = 589,
    V_SgInterfaceBody = 432,
    V_SgHeaderFileBody = 433,
    V_SgUntypedUnaryOperator = 724,
    V_SgUntypedBinaryOperator = 725,
    V_SgUntypedValueExpression = 726,
    V_SgUntypedArrayReferenceExpression = 727,
    V_SgUntypedOtherExpression = 728,
    V_SgUntypedFunctionCallOrArrayReferenceExpression = 729,
    V_SgUntypedReferenceExpression = 743,
    V_SgUntypedExpression = 723,
    V_SgUntypedImplicitDeclaration = 738,
    V_SgUntypedVariableDeclaration = 739,
    V_SgUntypedProgramHeaderDeclaration = 740,
    V_SgUntypedSubroutineDeclaration = 742,
    V_SgUntypedFunctionDeclaration = 741,
    V_SgUntypedModuleDeclaration = 752,
    V_SgUntypedDeclarationStatement = 736,
    V_SgUntypedAssignmentStatement = 732,
    V_SgUntypedFunctionCallStatement = 733,
    V_SgUntypedBlockStatement = 734,
    V_SgUntypedNamedStatement = 731,
    V_SgUntypedOtherStatement = 735,
    V_SgUntypedFunctionScope = 749,
    V_SgUntypedModuleScope = 750,
    V_SgUntypedGlobalScope = 751,
    V_SgUntypedScope = 748,
    V_SgUntypedStatement = 730,
    V_SgUntypedArrayType = 745,
    V_SgUntypedType = 744,
    V_SgUntypedAttribute = 746,
    V_SgUntypedInitializedName = 737,
    V_SgUntypedFile = 747,
    V_SgUntypedStatementList = 753,
    V_SgUntypedDeclarationStatementList = 754,
    V_SgUntypedFunctionDeclarationList = 755,
    V_SgUntypedInitializedNameList = 756,
    V_SgUntypedNode = 722,
    V_SgLocatedNodeSupport = 461,
    V_SgToken = 662,
    V_SgLocatedNode = 460,
    V_SgAterm = 260,
    V_SgNode = 501,
    V_SgNumVariants = 819,
    V_SgAsmPEImportLookupTable = 900,
    V_SgAsmPEImportHNTEntry = 901,
    V_SgAsmx86RegisterReferenceExpression = 902,
    V_SgAsmTypeWord = 903,
    V_SgAsmType80bitFloat = 904,
    V_SgAsmFile = 905,
    V_SgAsmTypeDoubleQuadWord = 906,
    V_SgAsmByteValueExpression = 907,
    V_SgAsmTypeSingleFloat = 908,
    V_SgAsmPowerpcRegisterReferenceExpression = 909,
    V_SgAsmSingleFloatValueExpression = 910,
    V_SgUpcLocalsizeof = 911,
    V_SgAsmDoubleWordValueExpression = 912,
    V_SgAsmTypeQuadWord = 913,
    V_SgAsmFunctionDeclaration = 914,
    V_SgAsmType128bitFloat = 915,
    V_SgAsmTypeDoubleFloat = 916,
    V_SgAsmPEImportILTEntry = 917,
    V_SgAsmDeclaration = 918,
    V_SgUpcElemsizeof = 919,
    V_SgAsmTypeDoubleWord = 920,
    V_SgAsmTypeByte = 921,
    V_SgAsmArmRegisterReferenceExpression = 922,
    V_SgAsmPEImportHNTEntryList = 923,
    V_SgAsmVectorValueExpression = 924,
    V_SgAsmQuadWordValueExpression = 925,
    V_SgAsmWordValueExpression = 926,
    V_SgAsmTypeVector = 927,
    V_SgAsmx86Instruction = 928,
    V_SgBinaryFile = 929,
    V_SgAsmDoubleFloatValueExpression = 930,
    V_SgUpcBlocksizeof = 931,
    V_SgAsmFieldDeclaration = 932,
    V_SgAsmDataStructureDeclaration = 933,
    V_SgAsmPEImportILTEntryList = 934,
    V_SgAsmAmdgpuVegaInstruction = 935,
};

enum X86SegmentRegister { // These must match numbering in object code
  x86_segreg_es,
  x86_segreg_cs,
  x86_segreg_ss,
  x86_segreg_ds,
  x86_segreg_fs,
  x86_segreg_gs,
  x86_segreg_none = 16 /* For unspecified segment overrides */
};

enum X86GeneralPurposeRegister { // These must match numbering in object code
  x86_gpr_ax,
  x86_gpr_cx,
  x86_gpr_dx,
  x86_gpr_bx,
  x86_gpr_sp,
  x86_gpr_bp,
  x86_gpr_si,
  x86_gpr_di, // Not including r8..r15
  x86_gpr_r8,
  x86_gpr_r9,
  x86_gpr_r10,
  x86_gpr_r11,
  x86_gpr_r12,
  x86_gpr_r13,
  x86_gpr_r14,
  x86_gpr_r15,
};

enum X86RegisterClass {
  x86_regclass_unknown,
  x86_regclass_gpr, // Numbers are X86GeneralPurposeRegister (ax,cx,dx,bx,sp,bp,si,di,r8..r15)
  x86_regclass_segment, // Numbers are X86SegmentRegister (es,cs,ss,ds,fs,gs)
  x86_regclass_cr, // Numbers are cr0..cr15
  x86_regclass_dr, // Numbers are dr0..dr15
  x86_regclass_st, // Numbers are st0..st7
  x86_regclass_mm, // Numbers are mm0..mm7
  x86_regclass_kmask, // Numbers are k0..k7 on x86_64
  x86_regclass_xmm, // Numbers are xmm0..xmm15 on x86, xmm0..xmm31 on x86_64
  x86_regclass_ymm, // Numbers are ymm0..ymm31 on x86_64
  x86_regclass_zmm, // Numbers are zmm0..zmm31 on x86_64
  x86_regclass_ip, // Only value allowed is 0
  x86_regclass_st_top, // Only value allowed is 0
  x86_regclass_flags // Only value allowed is 0
};

enum X86BranchPrediction {
  x86_branch_prediction_none,
  x86_branch_prediction_taken,
  x86_branch_prediction_not_taken
};

enum X86RepeatPrefix {
    x86_repeat_none,            /**< No repeat prefix */
    x86_repeat_repne,           /**< Repeat not equal prefix 0xf2 */
    x86_repeat_repe             /**< Repeat equal prefix 0xf3 */
};

enum X86PositionInRegister {
  x86_regpos_unknown, /*!< unknown (error or unitialized value) */
  x86_regpos_low_byte, /*!< 1st byte of register (bits 0-7), only for GPRs */
  x86_regpos_high_byte, /*!< 2nd byte of register (bits 8-15), only for ax,bx,cx,dx */
  x86_regpos_word, /*!< 16 bit part of register, only for GPRs, CR0, CR8? */
  x86_regpos_dword, /*!< lower 32 bit part of register, only for GPRs */
  x86_regpos_qword, /*!< lower 64 bit part of register, only for GPRs */
  x86_regpos_all /*!< the full register is used (default value), only value allowed for segregs and st */
};

enum X86InstructionSize {
  x86_insnsize_none,
  x86_insnsize_16,
  x86_insnsize_32,
  x86_insnsize_64
};

enum X86Flag { // These match the bit positions in rFLAGS
  x86_flag_cf = 0,
  x86_flag_1 = 1,
  x86_flag_pf = 2,
  x86_flag_3 = 3,
  x86_flag_af = 4,
  x86_flag_5 = 5,
  x86_flag_zf = 6,
  x86_flag_sf = 7,
  x86_flag_tf = 8,
  x86_flag_if = 9,
  x86_flag_df = 10,
  x86_flag_of = 11,
  x86_flag_iopl0 = 12,
  x86_flag_iopl1 = 13,
  x86_flag_nt = 14,
  x86_flag_15 = 15,
  x86_flag_rf = 16,
  x86_flag_vm = 17,
  x86_flag_ac = 18,
  x86_flag_vif = 19,
  x86_flag_vip = 20,
  x86_flag_id = 21
};


enum X86InstructionKind {
    x86_unknown_instruction     = 0x0000,
    x86_aaa                     = 0x0001, // x86-InstructionSetReference-AM.pdf, page 3-28
    x86_aad                     = 0x0002, // x86-InstructionSetReference-AM.pdf, page 3-30
    x86_aam                     = 0x0003, // x86-InstructionSetReference-AM.pdf, page 3-32
    x86_aas                     = 0x0004, // x86-InstructionSetReference-AM.pdf, page 3-34
    x86_adc                     = 0x0005, // x86-InstructionSetReference-AM.pdf, page 3-37
    x86_add                     = 0x0006, // x86-InstructionSetReference-AM.pdf, page 3-40
    x86_addpd                   = 0x0007, // x86-InstructionSetReference-AM.pdf, page 3-43
    x86_addps                   = 0x0008, // x86-InstructionSetReference-AM.pdf, page 3-46
    x86_addsd                   = 0x0009, // x86-InstructionSetReference-AM.pdf, page 3-49
    x86_addss                   = 0x000a, // x86-InstructionSetReference-AM.pdf, page 3-52
    x86_addsubpd                = 0x000b, // x86-InstructionSetReference-AM.pdf, page 3-56
    x86_addsubps                = 0x000c, // x86-InstructionSetReference-AM.pdf, page 3-60
    x86_and                     = 0x000d, // x86-InstructionSetReference-AM.pdf, page 3-63
    x86_andnpd                  = 0x000e, // x86-InstructionSetReference-AM.pdf, page 3-69
    x86_andnps                  = 0x000f, // x86-InstructionSetReference-AM.pdf, page 3-71
    x86_andpd                   = 0x0010, // x86-InstructionSetReference-AM.pdf, page 3-65
    x86_andps                   = 0x0011, // x86-InstructionSetReference-AM.pdf, page 3-67
    x86_arpl                    = 0x0012, // x86-InstructionSetReference-AM.pdf, page 3-73
    x86_blendpd                 = 0x0013, // x86-InstructionSetReference-AM.pdf, page 3-75
    x86_blendps                 = 0x0014, // x86-InstructionSetReference-AM.pdf, page 3-78
    x86_blendvpd                = 0x0015, // x86-InstructionSetReference-AM.pdf, page 3-81
    x86_blendvps                = 0x0016, // x86-InstructionSetReference-AM.pdf, page 3-84
    x86_bound                   = 0x0017, // x86-InstructionSetReference-AM.pdf, page 3-87
    x86_bsf                     = 0x0018, // x86-InstructionSetReference-AM.pdf, page 3-89
    x86_bsr                     = 0x0019, // x86-InstructionSetReference-AM.pdf, page 3-91
    x86_bswap                   = 0x001a, // x86-InstructionSetReference-AM.pdf, page 3-93
    x86_bt                      = 0x001b, // x86-InstructionSetReference-AM.pdf, page 3-96
    x86_btc                     = 0x001c, // x86-InstructionSetReference-AM.pdf, page 3-99
    x86_btr                     = 0x001d, // x86-InstructionSetReference-AM.pdf, page 3-102
    x86_bts                     = 0x001e, // x86-InstructionSetReference-AM.pdf, page 3-105
    x86_call                    = 0x001f, // x86-InstructionSetReference-AM.pdf, page 3-105
    x86_cbw                     = 0x0020, // x86-InstructionSetReference-AM.pdf, page 3-123
    x86_cdq                     = 0x0021, // x86-InstructionSetReference-AM.pdf, page 3-283
    x86_cdqe                    = 0x0022, // x86-InstructionSetReference-AM.pdf, page 3-124
    x86_clc                     = 0x0023, // x86-InstructionSetReference-AM.pdf, page 3-125
    x86_cld                     = 0x0024, // x86-InstructionSetReference-AM.pdf, page 3-126
    x86_clflush                 = 0x0025, // x86-InstructionSetReference-AM.pdf, page 3-128
    x86_clgi                    = 0x0026, // ExtraInstructions.txt, page 1
    x86_cli                     = 0x0027, // x86-InstructionSetReference-AM.pdf, page 3-131
    x86_clts                    = 0x0028, // x86-InstructionSetReference-AM.pdf, page 3-133
    x86_cmc                     = 0x0029, // x86-InstructionSetReference-AM.pdf, page 3-134
    x86_cmova                   = 0x002a, // x86-InstructionSetReference-AM.pdf, page 3-136
    x86_cmovae                  = 0x002b, // x86-InstructionSetReference-AM.pdf, page 3-136
    x86_cmovb                   = 0x002c, // x86-InstructionSetReference-AM.pdf, page 3-135
    x86_cmovbe                  = 0x002d, // x86-InstructionSetReference-AM.pdf, page 3-135
    x86_cmove                   = 0x002e, // x86-InstructionSetReference-AM.pdf, page 3-141
    x86_cmovg                   = 0x002f, // x86-InstructionSetReference-AM.pdf, page 3-136
    x86_cmovge                  = 0x0030, // x86-InstructionSetReference-AM.pdf, page 3-136
    x86_cmovl                   = 0x0031, // x86-InstructionSetReference-AM.pdf, page 3-136
    x86_cmovle                  = 0x0032, // x86-InstructionSetReference-AM.pdf, page 3-136
    x86_cmovne                  = 0x0033, // x86-InstructionSetReference-AM.pdf, page 3-137
    x86_cmovno                  = 0x0034, // x86-InstructionSetReference-AM.pdf, page 3-136
    x86_cmovns                  = 0x0035, // x86-InstructionSetReference-AM.pdf, page 3-137
    x86_cmovo                   = 0x0036, // x86-InstructionSetReference-AM.pdf, page 3-137
    x86_cmovpe                  = 0x0037, // x86-InstructionSetReference-AM.pdf, page 3-137
    x86_cmovpo                  = 0x0038, // x86-InstructionSetReference-AM.pdf, page 3-137
    x86_cmovs                   = 0x0039, // x86-InstructionSetReference-AM.pdf, page 3-137
    x86_cmp                     = 0x003a, // x86-InstructionSetReference-AM.pdf, page 3-144
    x86_cmppd                   = 0x003b, // x86-InstructionSetReference-AM.pdf, page 3-149
    x86_cmpps                   = 0x003c, // x86-InstructionSetReference-AM.pdf, page 3-154
    x86_cmpsb                   = 0x003d, // x86-InstructionSetReference-AM.pdf, page 3-155
    x86_cmpsd                   = 0x003e, // x86-InstructionSetReference-AM.pdf, page 3-164
    x86_cmpsq                   = 0x003f, // x86-InstructionSetReference-AM.pdf, page 3-160
    x86_cmpss                   = 0x0040, // x86-InstructionSetReference-AM.pdf, page 3-168
    x86_cmpsw                   = 0x0041, // x86-InstructionSetReference-AM.pdf, page 3-155
    x86_cmpxchg                 = 0x0042, // x86-InstructionSetReference-AM.pdf, page 3-171

    x86_cmpxchg16b              = 0x0043, // x86-InstructionSetReference-AM.pdf, page 3-174
    x86_cmpxchg8b               = 0x0044, // x86-InstructionSetReference-AM.pdf, page 3-171
    x86_comisd                  = 0x0045, // x86-InstructionSetReference-AM.pdf, page 3-177
    x86_comiss                  = 0x0046, // x86-InstructionSetReference-AM.pdf, page 3-180
    x86_cpuid                   = 0x0047, // x86-InstructionSetReference-AM.pdf, page 3-214
    x86_cqo                     = 0x0048, // x86-InstructionSetReference-AM.pdf, page 3-285
    x86_crc32                   = 0x0049, // x86-InstructionSetReference-AM.pdf, page 3-218
    x86_cvtdq2pd                = 0x004a, // x86-InstructionSetReference-AM.pdf, page 3-220
    x86_cvtdq2ps                = 0x004b, // x86-InstructionSetReference-AM.pdf, page 3-223
    x86_cvtpd2dq                = 0x004c, // x86-InstructionSetReference-AM.pdf, page 3-226
    x86_cvtpd2pi                = 0x004d, // x86-InstructionSetReference-AM.pdf, page 3-229
    x86_cvtpd2ps                = 0x004e, // x86-InstructionSetReference-AM.pdf, page 3-232
    x86_cvtpi2pd                = 0x004f, // x86-InstructionSetReference-AM.pdf, page 3-235
    x86_cvtpi2ps                = 0x0050, // x86-InstructionSetReference-AM.pdf, page 3-238
    x86_cvtps2dq                = 0x0051, // x86-InstructionSetReference-AM.pdf, page 3-241
    x86_cvtps2pd                = 0x0052, // x86-InstructionSetReference-AM.pdf, page 3-244
    x86_cvtps2pi                = 0x0053, // x86-InstructionSetReference-AM.pdf, page 3-247
    x86_cvtsd2si                = 0x0054, // x86-InstructionSetReference-AM.pdf, page 3-250
    x86_cvtsd2ss                = 0x0055, // x86-InstructionSetReference-AM.pdf, page 3-253
    x86_cvtsi2sd                = 0x0056, // x86-InstructionSetReference-AM.pdf, page 3-256
    x86_cvtsi2ss                = 0x0057, // x86-InstructionSetReference-AM.pdf, page 3-259
    x86_cvtss2sd                = 0x0058, // x86-InstructionSetReference-AM.pdf, page 3-262
    x86_cvtss2si                = 0x0059, // x86-InstructionSetReference-AM.pdf, page 3-265
    x86_cvttpd2dq               = 0x005a, // x86-InstructionSetReference-AM.pdf, page 3-268
    x86_cvttpd2pi               = 0x005b, // x86-InstructionSetReference-AM.pdf, page 3-271
    x86_cvttps2dq               = 0x005c, // x86-InstructionSetReference-AM.pdf, page 3-274
    x86_cvttps2pi               = 0x005d, // x86-InstructionSetReference-AM.pdf, page 3-277
    x86_cvttsd2si               = 0x005e, // x86-InstructionSetReference-AM.pdf, page 3-280
    x86_cvttss2si               = 0x005f, // x86-InstructionSetReference-AM.pdf, page 3-283
    x86_cwd                     = 0x0060, // x86-InstructionSetReference-AM.pdf, page 3-283
    x86_cwde                    = 0x0061, // x86-InstructionSetReference-AM.pdf, page 3-123
    x86_daa                     = 0x0062, // x86-InstructionSetReference-AM.pdf, page 3-287
    x86_das                     = 0x0063, // x86-InstructionSetReference-AM.pdf, page 3-289
    x86_dec                     = 0x0064, // x86-InstructionSetReference-AM.pdf, page 3-292
    x86_div                     = 0x0065, // x86-InstructionSetReference-AM.pdf, page 3-296
    x86_divpd                   = 0x0066, // x86-InstructionSetReference-AM.pdf, page 3-299
    x86_divps                   = 0x0067, // x86-InstructionSetReference-AM.pdf, page 3-302
    x86_divsd                   = 0x0068, // x86-InstructionSetReference-AM.pdf, page 3-305
    x86_divss                   = 0x0069, // x86-InstructionSetReference-AM.pdf, page 3-308
    x86_dppd                    = 0x006a, // x86-InstructionSetReference-AM.pdf, page 3-311
    x86_dpps                    = 0x006b, // x86-InstructionSetReference-AM.pdf, page 3-315
    x86_emms                    = 0x006c, // x86-InstructionSetReference-AM.pdf, page 3-317
    x86_enter                   = 0x006d, // x86-InstructionSetReference-AM.pdf, page 3-321
    x86_extractps               = 0x006e, // x86-InstructionSetReference-AM.pdf, page 3-324
    x86_extrq                   = 0x006f, // ExtraInstructions.txt, page 5
    x86_f2xm1                   = 0x0070, // x86-InstructionSetReference-AM.pdf, page 3-326
    x86_fabs                    = 0x0071, // x86-InstructionSetReference-AM.pdf, page 3-328
    x86_fadd                    = 0x0072, // x86-InstructionSetReference-AM.pdf, page 3-328
    x86_faddp                   = 0x0073, // x86-InstructionSetReference-AM.pdf, page 3-328
    x86_farcall                 = 0x0074, // x86-InstructionSetReference-AM.pdf, page 3-123
    x86_farjmp                  = 0x0075, // x86-InstructionSetReference-AM.pdf, page 3-559
    x86_fbld                    = 0x0076, // x86-InstructionSetReference-AM.pdf, page 3-334
    x86_fbstp                   = 0x0077, // x86-InstructionSetReference-AM.pdf, page 3-337
    x86_fchs                    = 0x0078, // x86-InstructionSetReference-AM.pdf, page 3-339
    x86_fcmovb                  = 0x0079, // x86-InstructionSetReference-AM.pdf, page 3-341
    x86_fcmovbe                 = 0x007a, // x86-InstructionSetReference-AM.pdf, page 3-341
    x86_fcmove                  = 0x007b, // x86-InstructionSetReference-AM.pdf, page 3-341
    x86_fcmovnb                 = 0x007c, // x86-InstructionSetReference-AM.pdf, page 3-341
    x86_fcmovnbe                = 0x007d, // x86-InstructionSetReference-AM.pdf, page 3-341
    x86_fcmovne                 = 0x007e, // x86-InstructionSetReference-AM.pdf, page 3-341
    x86_fcmovnu                 = 0x007f, // x86-InstructionSetReference-AM.pdf, page 3-343
    x86_fcmovu                  = 0x0080, // x86-InstructionSetReference-AM.pdf, page 3-341
    x86_fcom                    = 0x0081, // x86-InstructionSetReference-AM.pdf, page 3-343
    x86_fcomi                   = 0x0082, // x86-InstructionSetReference-AM.pdf, page 3-347
    x86_fcomip                  = 0x0083, // x86-InstructionSetReference-AM.pdf, page 3-347
    x86_fcomp                   = 0x0084, // x86-InstructionSetReference-AM.pdf, page 3-343
    x86_fcompp                  = 0x0085, // x86-InstructionSetReference-AM.pdf, page 3-347
    x86_fcos                    = 0x0086, // x86-InstructionSetReference-AM.pdf, page 3-352
    x86_fdecstp                 = 0x0087, // x86-InstructionSetReference-AM.pdf, page 3-354
    x86_fdiv                    = 0x0088, // x86-InstructionSetReference-AM.pdf, page 3-354
    x86_fdivp                   = 0x0089, // x86-InstructionSetReference-AM.pdf, page 3-354
    x86_fdivr                   = 0x008a, // x86-InstructionSetReference-AM.pdf, page 3-358
    x86_fdivrp                  = 0x008b, // x86-InstructionSetReference-AM.pdf, page 3-358
    x86_femms                   = 0x008c, // ExtraInstructions.txt, page 5
    x86_ffree                   = 0x008d, // x86-InstructionSetReference-AM.pdf, page 3-363
    x86_fiadd                   = 0x008e, // x86-InstructionSetReference-AM.pdf, page 3-332
    x86_ficom                   = 0x008f, // x86-InstructionSetReference-AM.pdf, page 3-363
    x86_ficomp                  = 0x0090, // x86-InstructionSetReference-AM.pdf, page 3-366
    x86_fidiv                   = 0x0091, // x86-InstructionSetReference-AM.pdf, page 3-358
    x86_fidivr                  = 0x0092, // x86-InstructionSetReference-AM.pdf, page 3-362
    x86_fild                    = 0x0093, // x86-InstructionSetReference-AM.pdf, page 3-368
    x86_fimul                   = 0x0094, // x86-InstructionSetReference-AM.pdf, page 3-393
    x86_fincstp                 = 0x0095, // x86-InstructionSetReference-AM.pdf, page 3-370
    x86_fist                    = 0x0096, // x86-InstructionSetReference-AM.pdf, page 3-372
    x86_fistp                   = 0x0097, // x86-InstructionSetReference-AM.pdf, page 3-376
    x86_fisttp                  = 0x0098, // x86-InstructionSetReference-AM.pdf, page 3-379
    x86_fisub                   = 0x0099, // x86-InstructionSetReference-AM.pdf, page 3-440
    x86_fisubr                  = 0x009a, // x86-InstructionSetReference-AM.pdf, page 3-444
    x86_fld                     = 0x009b, // x86-InstructionSetReference-AM.pdf, page 3-382
    x86_fld1                    = 0x009c, // x86-InstructionSetReference-AM.pdf, page 3-382
    x86_fldcw                   = 0x009d, // x86-InstructionSetReference-AM.pdf, page 3-386
    x86_fldenv                  = 0x009e, // x86-InstructionSetReference-AM.pdf, page 3-389
    x86_fldl2e                  = 0x009f, // x86-InstructionSetReference-AM.pdf, page 3-382
    x86_fldl2t                  = 0x00a0, // x86-InstructionSetReference-AM.pdf, page 3-382
    x86_fldlg2                  = 0x00a1, // x86-InstructionSetReference-AM.pdf, page 3-382
    x86_fldln2                  = 0x00a2, // x86-InstructionSetReference-AM.pdf, page 3-382
    x86_fldpi                   = 0x00a3, // x86-InstructionSetReference-AM.pdf, page 3-382
    x86_fldz                    = 0x00a4, // x86-InstructionSetReference-AM.pdf, page 3-384
    x86_fmul                    = 0x00a5, // x86-InstructionSetReference-AM.pdf, page 3-389
    x86_fmulp                   = 0x00a6, // x86-InstructionSetReference-AM.pdf, page 3-389
    x86_fnclex                  = 0x00a7, // x86-InstructionSetReference-AM.pdf, page 3-341
    x86_fninit                  = 0x00a8, // x86-InstructionSetReference-AM.pdf, page 3-372
    x86_fnop                    = 0x00a9, // x86-InstructionSetReference-AM.pdf, page 3-394
    x86_fnsave                  = 0x00aa, // x86-InstructionSetReference-AM.pdf, page 3-415
    x86_fnstcw                  = 0x00ab, // x86-InstructionSetReference-AM.pdf, page 3-430
    x86_fnstenv                 = 0x00ac, // x86-InstructionSetReference-AM.pdf, page 3-433
    x86_fnstsw                  = 0x00ad, // x86-InstructionSetReference-AM.pdf, page 3-436
    x86_fpatan                  = 0x00ae, // x86-InstructionSetReference-AM.pdf, page 3-397
    x86_fprem                   = 0x00af, // x86-InstructionSetReference-AM.pdf, page 3-400
    x86_fprem1                  = 0x00b0, // x86-InstructionSetReference-AM.pdf, page 3-403
    x86_fptan                   = 0x00b1, // x86-InstructionSetReference-AM.pdf, page 3-406
    x86_frndint                 = 0x00b2, // x86-InstructionSetReference-AM.pdf, page 3-408
    x86_frstor                  = 0x00b3, // x86-InstructionSetReference-AM.pdf, page 3-411
    x86_fscale                  = 0x00b4, // x86-InstructionSetReference-AM.pdf, page 3-417
    x86_fsin                    = 0x00b5, // x86-InstructionSetReference-AM.pdf, page 3-419
    x86_fsincos                 = 0x00b6, // x86-InstructionSetReference-AM.pdf, page 3-422
    x86_fsqrt                   = 0x00b7, // x86-InstructionSetReference-AM.pdf, page 3-424
    x86_fst                     = 0x00b8, // x86-InstructionSetReference-AM.pdf, page 3-424
    x86_fstp                    = 0x00b9, // x86-InstructionSetReference-AM.pdf, page 3-427
    x86_fsub                    = 0x00ba, // x86-InstructionSetReference-AM.pdf, page 3-436
    x86_fsubp                   = 0x00bb, // x86-InstructionSetReference-AM.pdf, page 3-436
    x86_fsubr                   = 0x00bc, // x86-InstructionSetReference-AM.pdf, page 3-440
    x86_fsubrp                  = 0x00bd, // x86-InstructionSetReference-AM.pdf, page 3-440
    x86_ftst                    = 0x00be, // x86-InstructionSetReference-AM.pdf, page 3-446
    x86_fucom                   = 0x00bf, // x86-InstructionSetReference-AM.pdf, page 3-446
    x86_fucomi                  = 0x00c0, // x86-InstructionSetReference-AM.pdf, page 3-347
    x86_fucomip                 = 0x00c1, // x86-InstructionSetReference-AM.pdf, page 3-350
    x86_fucomp                  = 0x00c2, // x86-InstructionSetReference-AM.pdf, page 3-446
    x86_fucompp                 = 0x00c3, // x86-InstructionSetReference-AM.pdf, page 3-449
    x86_fwait                   = 0x00c4, // x86-InstructionSetReference-NZ.pdf, page 4-499
    x86_fxam                    = 0x00c5, // x86-InstructionSetReference-AM.pdf, page 3-451
    x86_fxch                    = 0x00c6, // x86-InstructionSetReference-AM.pdf, page 3-453
    x86_fxrstor                 = 0x00c7, // x86-InstructionSetReference-AM.pdf, page 3-456
    x86_fxsave                  = 0x00c8, // x86-InstructionSetReference-AM.pdf, page 3-467
    x86_fxtract                 = 0x00c9, // x86-InstructionSetReference-AM.pdf, page 3-469
    x86_fyl2x                   = 0x00ca, // x86-InstructionSetReference-AM.pdf, page 3-471
    x86_fyl2xp1                 = 0x00cb, // x86-InstructionSetReference-AM.pdf, page 3-473
    x86_getsec                  = 0x00cc, // ExtraInstructions.txt, page 5
    x86_haddpd                  = 0x00cd, // x86-InstructionSetReference-AM.pdf, page 3-477
    x86_haddps                  = 0x00ce, // x86-InstructionSetReference-AM.pdf, page 3-481
    x86_hlt                     = 0x00cf, // x86-InstructionSetReference-AM.pdf, page 3-483
    x86_hsubpd                  = 0x00d0, // x86-InstructionSetReference-AM.pdf, page 3-487
    x86_hsubps                  = 0x00d1, // x86-InstructionSetReference-AM.pdf, page 3-491
    x86_idiv                    = 0x00d2, // x86-InstructionSetReference-AM.pdf, page 3-495
    x86_imul                    = 0x00d3, // x86-InstructionSetReference-AM.pdf, page 3-500
    x86_in                      = 0x00d4, // x86-InstructionSetReference-AM.pdf, page 3-502
    x86_inc                     = 0x00d5, // x86-InstructionSetReference-AM.pdf, page 3-505
    x86_insb                    = 0x00d6, // x86-InstructionSetReference-AM.pdf, page 3-505
    x86_insd                    = 0x00d7, // x86-InstructionSetReference-AM.pdf, page 3-509
    x86_insertps                = 0x00d8, // x86-InstructionSetReference-AM.pdf, page 3-512
    x86_insertq                 = 0x00d9, // ExtraInstructions.txt, page 5
    x86_insw                    = 0x00da, // x86-InstructionSetReference-AM.pdf, page 3-505
    x86_int                     = 0x00db, // x86-InstructionSetReference-AM.pdf, page 3-512
    x86_int1                    = 0x00dc, // ExtraInstructions.txt, page 6
    x86_int3                    = 0x00dd, // x86-InstructionSetReference-AM.pdf, page 3-512
    x86_into                    = 0x00de, // x86-InstructionSetReference-AM.pdf, page 3-527
    x86_invd                    = 0x00df, // x86-InstructionSetReference-AM.pdf, page 3-529
    x86_invept                  = 0x00e0, // x86-InstructionSetReference-NZ.pdf, page 5-7
    x86_invlpg                  = 0x00e1, // x86-InstructionSetReference-AM.pdf, page 3-531
    x86_invlpga                 = 0x00e2, // ExtraInstructions.txt, page 2
    x86_invvpid                 = 0x00e3, // x86-InstructionSetReference-NZ.pdf, page 5-11
    x86_iret                    = 0x00e4, // x86-InstructionSetReference-AM.pdf, page 3-542
    x86_ja                      = 0x00e5, // x86-InstructionSetReference-AM.pdf, page 3-544
    x86_jae                     = 0x00e6, // x86-InstructionSetReference-AM.pdf, page 3-544
    x86_jb                      = 0x00e7, // x86-InstructionSetReference-AM.pdf, page 3-544
    x86_jbe                     = 0x00e8, // x86-InstructionSetReference-AM.pdf, page 3-544
    x86_jcxz                    = 0x00e9, // x86-InstructionSetReference-AM.pdf, page 3-542
    x86_je                      = 0x00ea, // x86-InstructionSetReference-AM.pdf, page 3-549
    x86_jecxz                   = 0x00eb, // x86-InstructionSetReference-AM.pdf, page 3-542
    x86_jg                      = 0x00ec, // x86-InstructionSetReference-AM.pdf, page 3-545
    x86_jge                     = 0x00ed, // x86-InstructionSetReference-AM.pdf, page 3-545
    x86_jl                      = 0x00ee, // x86-InstructionSetReference-AM.pdf, page 3-545
    x86_jle                     = 0x00ef, // x86-InstructionSetReference-AM.pdf, page 3-544
    x86_jmp                     = 0x00f0, // x86-InstructionSetReference-AM.pdf, page 3-549
    x86_jmpe                    = 0x00f1, // ExtraInstructions.txt, page 5
    x86_jne                     = 0x00f2, // x86-InstructionSetReference-AM.pdf, page 3-545
    x86_jno                     = 0x00f3, // x86-InstructionSetReference-AM.pdf, page 3-545
    x86_jns                     = 0x00f4, // x86-InstructionSetReference-AM.pdf, page 3-545
    x86_jo                      = 0x00f5, // x86-InstructionSetReference-AM.pdf, page 3-545
    x86_jpe                     = 0x00f6, // x86-InstructionSetReference-AM.pdf, page 3-545
    x86_jpo                     = 0x00f7, // x86-InstructionSetReference-AM.pdf, page 3-545
    x86_jrcxz                   = 0x00f8, // x86-InstructionSetReference-AM.pdf, page 3-542
    x86_js                      = 0x00f9, // x86-InstructionSetReference-AM.pdf, page 3-546
    x86_lahf                    = 0x00fa, // x86-InstructionSetReference-AM.pdf, page 3-561
    x86_lar                     = 0x00fb, // x86-InstructionSetReference-AM.pdf, page 3-565
    x86_lddqu                   = 0x00fc, // x86-InstructionSetReference-AM.pdf, page 3-568
    x86_ldmxcsr                 = 0x00fd, // x86-InstructionSetReference-AM.pdf, page 3-570
    x86_lds                     = 0x00fe, // x86-InstructionSetReference-AM.pdf, page 3-570
    x86_lea                     = 0x00ff, // x86-InstructionSetReference-AM.pdf, page 3-579
    x86_leave                   = 0x0100, // x86-InstructionSetReference-AM.pdf, page 3-581
    x86_les                     = 0x0101, // x86-InstructionSetReference-AM.pdf, page 3-570
    x86_lfence                  = 0x0102, // x86-InstructionSetReference-AM.pdf, page 3-582
    x86_lfs                     = 0x0103, // x86-InstructionSetReference-AM.pdf, page 3-570
    x86_lgdt                    = 0x0104, // x86-InstructionSetReference-AM.pdf, page 3-582
    x86_lgs                     = 0x0105, // x86-InstructionSetReference-AM.pdf, page 3-576
    x86_lidt                    = 0x0106, // x86-InstructionSetReference-AM.pdf, page 3-585
    x86_lldt                    = 0x0107, // x86-InstructionSetReference-AM.pdf, page 3-588
    x86_lmsw                    = 0x0108, // x86-InstructionSetReference-AM.pdf, page 3-590
    x86_lock                    = 0x0109, // x86-InstructionSetReference-AM.pdf, page 3-592
    x86_lodsb                   = 0x010a, // x86-InstructionSetReference-AM.pdf, page 3-592
    x86_lodsd                   = 0x010b, // x86-InstructionSetReference-AM.pdf, page 3-592
    x86_lodsq                   = 0x010c, // x86-InstructionSetReference-AM.pdf, page 3-596
    x86_lodsw                   = 0x010d, // x86-InstructionSetReference-AM.pdf, page 3-592
    x86_loop                    = 0x010e, // x86-InstructionSetReference-AM.pdf, page 3-596
    x86_loopnz                  = 0x010f, // x86-InstructionSetReference-AM.pdf, page 3-599
    x86_loopz                   = 0x0110, // x86-InstructionSetReference-AM.pdf, page 3-596
    x86_lsl                     = 0x0111, // x86-InstructionSetReference-AM.pdf, page 3-603
    x86_lss                     = 0x0112, // x86-InstructionSetReference-AM.pdf, page 3-570
    x86_ltr                     = 0x0113, // x86-InstructionSetReference-AM.pdf, page 3-606
    x86_lzcnt                   = 0x0114, // ExtraInstructions.txt, page 4
    x86_maskmovq                = 0x0115, // x86-InstructionSetReference-AM.pdf, page 3-612
    x86_maxpd                   = 0x0116, // x86-InstructionSetReference-AM.pdf, page 3-615
    x86_maxps                   = 0x0117, // x86-InstructionSetReference-AM.pdf, page 3-618
    x86_maxsd                   = 0x0118, // x86-InstructionSetReference-AM.pdf, page 3-621
    x86_maxss                   = 0x0119, // x86-InstructionSetReference-AM.pdf, page 3-624
    x86_mfence                  = 0x011a, // x86-InstructionSetReference-AM.pdf, page 3-625
    x86_minpd                   = 0x011b, // x86-InstructionSetReference-AM.pdf, page 3-628
    x86_minps                   = 0x011c, // x86-InstructionSetReference-AM.pdf, page 3-631
    x86_minsd                   = 0x011d, // x86-InstructionSetReference-AM.pdf, page 3-634
    x86_minss                   = 0x011e, // x86-InstructionSetReference-AM.pdf, page 3-637
    x86_monitor                 = 0x011f, // x86-InstructionSetReference-AM.pdf, page 3-640
    x86_mov                     = 0x0120, // ExtraInstructions.txt, page 6
    x86_movapd                  = 0x0121, // x86-InstructionSetReference-AM.pdf, page 3-654
    x86_movaps                  = 0x0122, // x86-InstructionSetReference-AM.pdf, page 3-657
    x86_movbe                   = 0x0123, // x86-InstructionSetReference-AM.pdf, page 3-660
    x86_movd                    = 0x0124, // x86-InstructionSetReference-AM.pdf, page 3-660
    x86_movddup                 = 0x0125, // x86-InstructionSetReference-AM.pdf, page 3-667
    x86_movdq2q                 = 0x0126, // x86-InstructionSetReference-AM.pdf, page 3-674
    x86_movdqa                  = 0x0127, // x86-InstructionSetReference-AM.pdf, page 3-669
    x86_movdqu                  = 0x0128, // x86-InstructionSetReference-AM.pdf, page 3-672
    x86_movhlps                 = 0x0129, // x86-InstructionSetReference-AM.pdf, page 3-676
    x86_movhpd                  = 0x012a, // x86-InstructionSetReference-AM.pdf, page 3-679
    x86_movhps                  = 0x012b, // x86-InstructionSetReference-AM.pdf, page 3-682
    x86_movlhps                 = 0x012c, // x86-InstructionSetReference-AM.pdf, page 3-684
    x86_movlpd                  = 0x012d, // x86-InstructionSetReference-AM.pdf, page 3-686
    x86_movlps                  = 0x012e, // x86-InstructionSetReference-AM.pdf, page 3-689
    x86_movmskpd                = 0x012f, // x86-InstructionSetReference-AM.pdf, page 3-691
    x86_movmskps                = 0x0130, // x86-InstructionSetReference-AM.pdf, page 3-693
    x86_movntdq                 = 0x0131, // x86-InstructionSetReference-AM.pdf, page 3-699
    x86_movntdqa                = 0x0132, // x86-InstructionSetReference-AM.pdf, page 3-696
    x86_movnti                  = 0x0133, // x86-InstructionSetReference-AM.pdf, page 3-701
    x86_movntpd                 = 0x0134, // x86-InstructionSetReference-AM.pdf, page 3-704
    x86_movntps                 = 0x0135, // x86-InstructionSetReference-AM.pdf, page 3-707
    x86_movntq                  = 0x0136, // x86-InstructionSetReference-AM.pdf, page 3-710
    x86_movntsd                 = 0x0137, // ExtraInstructions.txt, page 4
    x86_movntss                 = 0x0138, // ExtraInstructions.txt, page 5
    x86_movq                    = 0x0139, // x86-InstructionSetReference-AM.pdf, page 3-713
    x86_movq2dq                 = 0x013a, // x86-InstructionSetReference-AM.pdf, page 3-715
    x86_movsb                   = 0x013b, // x86-InstructionSetReference-AM.pdf, page 3-715
    x86_movsd                   = 0x013c, // x86-InstructionSetReference-AM.pdf, page 3-715
    x86_movsd_sse               = 0x013d, // x86-InstructionSetReference-AM.pdf, page 3-723
    x86_movshdup                = 0x013e, // x86-InstructionSetReference-AM.pdf, page 3-726
    x86_movsldup                = 0x013f, // x86-InstructionSetReference-AM.pdf, page 3-729
    x86_movsq                   = 0x0140, // x86-InstructionSetReference-AM.pdf, page 3-720
    x86_movss                   = 0x0141, // x86-InstructionSetReference-AM.pdf, page 3-732
    x86_movsw                   = 0x0142, // x86-InstructionSetReference-AM.pdf, page 3-715
    x86_movsx                   = 0x0143, // ExtraInstructions.txt, page 5
    x86_movsxd                  = 0x0144, // x86-InstructionSetReference-AM.pdf, page 3-734
    x86_movupd                  = 0x0145, // x86-InstructionSetReference-AM.pdf, page 3-737
    x86_movups                  = 0x0146, // x86-InstructionSetReference-AM.pdf, page 3-740
    x86_movzx                   = 0x0147, // x86-InstructionSetReference-AM.pdf, page 3-742
    x86_mpsadbw                 = 0x0148, // x86-InstructionSetReference-AM.pdf, page 3-746
    x86_mul                     = 0x0149, // x86-InstructionSetReference-AM.pdf, page 3-749
    x86_mulpd                   = 0x014a, // x86-InstructionSetReference-AM.pdf, page 3-752
    x86_mulps                   = 0x014b, // x86-InstructionSetReference-AM.pdf, page 3-755
    x86_mulsd                   = 0x014c, // x86-InstructionSetReference-AM.pdf, page 3-758
    x86_mulss                   = 0x014d, // x86-InstructionSetReference-AM.pdf, page 3-761
    x86_mwait                   = 0x014e, // x86-InstructionSetReference-AM.pdf, page 3-765
    x86_neg                     = 0x014f, // x86-InstructionSetReference-NZ.pdf, page 4-5
    x86_nop                     = 0x0150, // ExtraInstructions.txt, page 5
    x86_not                     = 0x0151, // x86-InstructionSetReference-NZ.pdf, page 4-9
    x86_or                      = 0x0152, // x86-InstructionSetReference-NZ.pdf, page 4-12
    x86_orpd                    = 0x0153, // x86-InstructionSetReference-NZ.pdf, page 4-14
    x86_orps                    = 0x0154, // x86-InstructionSetReference-NZ.pdf, page 4-16
    x86_out                     = 0x0155, // x86-InstructionSetReference-NZ.pdf, page 4-18
    x86_outs                    = 0x0156, // x86-InstructionSetReference-NZ.pdf, page 4-18
    x86_outsb                   = 0x0157, // x86-InstructionSetReference-NZ.pdf, page 4-18
    x86_outsd                   = 0x0158, // x86-InstructionSetReference-NZ.pdf, page 4-23
    x86_outsw                   = 0x0159, // x86-InstructionSetReference-NZ.pdf, page 4-18
    x86_pabsb                   = 0x015a, // x86-InstructionSetReference-NZ.pdf, page 4-23
    x86_pabsd                   = 0x015b, // x86-InstructionSetReference-NZ.pdf, page 4-27
    x86_pabsw                   = 0x015c, // x86-InstructionSetReference-NZ.pdf, page 4-23
    x86_packssdw                = 0x015d, // x86-InstructionSetReference-NZ.pdf, page 4-32
    x86_packsswb                = 0x015e, // x86-InstructionSetReference-NZ.pdf, page 4-27
    x86_packusdw                = 0x015f, // x86-InstructionSetReference-NZ.pdf, page 4-35
    x86_packuswb                = 0x0160, // x86-InstructionSetReference-NZ.pdf, page 4-39
    x86_paddb                   = 0x0161, // x86-InstructionSetReference-NZ.pdf, page 4-39
    x86_paddd                   = 0x0162, // x86-InstructionSetReference-NZ.pdf, page 4-43
    x86_paddq                   = 0x0163, // x86-InstructionSetReference-NZ.pdf, page 4-46
    x86_paddsb                  = 0x0164, // x86-InstructionSetReference-NZ.pdf, page 4-46
    x86_paddsw                  = 0x0165, // x86-InstructionSetReference-NZ.pdf, page 4-50
    x86_paddusb                 = 0x0166, // x86-InstructionSetReference-NZ.pdf, page 4-50
    x86_paddusw                 = 0x0167, // x86-InstructionSetReference-NZ.pdf, page 4-54
    x86_paddw                   = 0x0168, // x86-InstructionSetReference-NZ.pdf, page 4-39
    x86_palignr                 = 0x0169, // x86-InstructionSetReference-NZ.pdf, page 4-57
    x86_pand                    = 0x016a, // x86-InstructionSetReference-NZ.pdf, page 4-60
    x86_pandn                   = 0x016b, // x86-InstructionSetReference-NZ.pdf, page 4-63
    x86_pause                   = 0x016c, // x86-InstructionSetReference-NZ.pdf, page 4-64
    x86_pavgb                   = 0x016d, // x86-InstructionSetReference-NZ.pdf, page 4-64
    x86_pavgusb                 = 0x016e, // ExtraInstructions.txt, page 3
    x86_pavgw                   = 0x016f, // x86-InstructionSetReference-NZ.pdf, page 4-68
    x86_pblendvb                = 0x0170, // x86-InstructionSetReference-NZ.pdf, page 4-72
    x86_pblendw                 = 0x0171, // x86-InstructionSetReference-NZ.pdf, page 4-75
    x86_pcmpeqb                 = 0x0172, // x86-InstructionSetReference-NZ.pdf, page 4-75
    x86_pcmpeqd                 = 0x0173, // x86-InstructionSetReference-NZ.pdf, page 4-79
    x86_pcmpeqq                 = 0x0174, // x86-InstructionSetReference-NZ.pdf, page 4-81
    x86_pcmpeqw                 = 0x0175, // x86-InstructionSetReference-NZ.pdf, page 4-75
    x86_pcmpestri               = 0x0176, // x86-InstructionSetReference-NZ.pdf, page 4-84
    x86_pcmpestrm               = 0x0177, // x86-InstructionSetReference-NZ.pdf, page 4-87
    x86_pcmpgtb                 = 0x0178, // x86-InstructionSetReference-NZ.pdf, page 4-93
    x86_pcmpgtd                 = 0x0179, // x86-InstructionSetReference-NZ.pdf, page 4-98
    x86_pcmpgtq                 = 0x017a, // x86-InstructionSetReference-NZ.pdf, page 4-100
    x86_pcmpgtw                 = 0x017b, // x86-InstructionSetReference-NZ.pdf, page 4-93
    x86_pcmpistri               = 0x017c, // x86-InstructionSetReference-NZ.pdf, page 4-90
    x86_pcmpistrm               = 0x017d, // x86-InstructionSetReference-NZ.pdf, page 4-93
    x86_pextrb                  = 0x017e, // x86-InstructionSetReference-NZ.pdf, page 4-100
    x86_pextrd                  = 0x017f, // x86-InstructionSetReference-NZ.pdf, page 4-100
    x86_pextrq                  = 0x0180, // x86-InstructionSetReference-NZ.pdf, page 4-103
    x86_pextrw                  = 0x0181, // x86-InstructionSetReference-NZ.pdf, page 4-107
    x86_pf2id                   = 0x0182, // ExtraInstructions.txt, page 2
    x86_pf2iw                   = 0x0183, // ExtraInstructions.txt, page 2
    x86_pfacc                   = 0x0184, // ExtraInstructions.txt, page 2
    x86_pfadd                   = 0x0185, // ExtraInstructions.txt, page 2
    x86_pfcmpeq                 = 0x0186, // ExtraInstructions.txt, page 2
    x86_pfcmpge                 = 0x0187, // ExtraInstructions.txt, page 2
    x86_pfcmpgt                 = 0x0188, // ExtraInstructions.txt, page 2
    x86_pfmax                   = 0x0189, // ExtraInstructions.txt, page 2
    x86_pfmin                   = 0x018a, // ExtraInstructions.txt, page 2
    x86_pfmul                   = 0x018b, // ExtraInstructions.txt, page 2
    x86_pfnacc                  = 0x018c, // ExtraInstructions.txt, page 2
    x86_pfpnacc                 = 0x018d, // ExtraInstructions.txt, page 2
    x86_pfrcp                   = 0x018e, // ExtraInstructions.txt, page 2
    x86_pfrcpit1                = 0x018f, // ExtraInstructions.txt, page 2
    x86_pfrcpit2                = 0x0190, // ExtraInstructions.txt, page 2
    x86_pfrsqit1                = 0x0191, // ExtraInstructions.txt, page 2
    x86_pfrsqrt                 = 0x0192, // ExtraInstructions.txt, page 2
    x86_pfsub                   = 0x0193, // ExtraInstructions.txt, page 2
    x86_pfsubr                  = 0x0194, // ExtraInstructions.txt, page 2
    x86_phaddd                  = 0x0195, // x86-InstructionSetReference-NZ.pdf, page 4-110
    x86_phaddsw                 = 0x0196, // x86-InstructionSetReference-NZ.pdf, page 4-113
    x86_phaddw                  = 0x0197, // x86-InstructionSetReference-NZ.pdf, page 4-107
    x86_phminposuw              = 0x0198, // x86-InstructionSetReference-NZ.pdf, page 4-116
    x86_phsubd                  = 0x0199, // x86-InstructionSetReference-NZ.pdf, page 4-119
    x86_phsubsw                 = 0x019a, // x86-InstructionSetReference-NZ.pdf, page 4-122
    x86_phsubw                  = 0x019b, // x86-InstructionSetReference-NZ.pdf, page 4-116
    x86_pi2fd                   = 0x019c, // ExtraInstructions.txt, page 2
    x86_pi2fw                   = 0x019d, // ExtraInstructions.txt, page 2
    x86_pinsrb                  = 0x019e, // x86-InstructionSetReference-NZ.pdf, page 4-122
    x86_pinsrd                  = 0x019f, // x86-InstructionSetReference-NZ.pdf, page 4-122
    x86_pinsrq                  = 0x01a0, // x86-InstructionSetReference-NZ.pdf, page 4-125
    x86_pinsrw                  = 0x01a1, // x86-InstructionSetReference-NZ.pdf, page 4-128
    x86_pmaddubsw               = 0x01a2, // x86-InstructionSetReference-NZ.pdf, page 4-131
    x86_pmaddwd                 = 0x01a3, // x86-InstructionSetReference-NZ.pdf, page 4-135
    x86_pmaxsb                  = 0x01a4, // x86-InstructionSetReference-NZ.pdf, page 4-138
    x86_pmaxsd                  = 0x01a5, // x86-InstructionSetReference-NZ.pdf, page 4-141
    x86_pmaxsw                  = 0x01a6, // x86-InstructionSetReference-NZ.pdf, page 4-144
    x86_pmaxub                  = 0x01a7, // x86-InstructionSetReference-NZ.pdf, page 4-147
    x86_pmaxud                  = 0x01a8, // x86-InstructionSetReference-NZ.pdf, page 4-150
    x86_pmaxuw                  = 0x01a9, // x86-InstructionSetReference-NZ.pdf, page 4-153
    x86_pminsb                  = 0x01aa, // x86-InstructionSetReference-NZ.pdf, page 4-156
    x86_pminsd                  = 0x01ab, // x86-InstructionSetReference-NZ.pdf, page 4-159
    x86_pminsw                  = 0x01ac, // x86-InstructionSetReference-NZ.pdf, page 4-162
    x86_pminub                  = 0x01ad, // x86-InstructionSetReference-NZ.pdf, page 4-165
    x86_pminud                  = 0x01ae, // x86-InstructionSetReference-NZ.pdf, page 4-168
    x86_pminuw                  = 0x01af, // x86-InstructionSetReference-NZ.pdf, page 4-171
    x86_pmovmskb                = 0x01b0, // x86-InstructionSetReference-NZ.pdf, page 4-174
    x86_pmovsxbd                = 0x01b1, // x86-InstructionSetReference-NZ.pdf, page 4-174
    x86_pmovsxbq                = 0x01b2, // x86-InstructionSetReference-NZ.pdf, page 4-174
    x86_pmovsxbw                = 0x01b3, // x86-InstructionSetReference-NZ.pdf, page 4-174
    x86_pmovsxdq                = 0x01b4, // x86-InstructionSetReference-NZ.pdf, page 4-178
    x86_pmovsxwd                = 0x01b5, // x86-InstructionSetReference-NZ.pdf, page 4-174
    x86_pmovsxwq                = 0x01b6, // x86-InstructionSetReference-NZ.pdf, page 4-174
    x86_pmovzxbd                = 0x01b7, // x86-InstructionSetReference-NZ.pdf, page 4-178
    x86_pmovzxbq                = 0x01b8, // x86-InstructionSetReference-NZ.pdf, page 4-178
    x86_pmovzxbw                = 0x01b9, // x86-InstructionSetReference-NZ.pdf, page 4-178
    x86_pmovzxdq                = 0x01ba, // x86-InstructionSetReference-NZ.pdf, page 4-182
    x86_pmovzxwd                = 0x01bb, // x86-InstructionSetReference-NZ.pdf, page 4-178
    x86_pmovzxwq                = 0x01bc, // x86-InstructionSetReference-NZ.pdf, page 4-178
    x86_pmuldq                  = 0x01bd, // x86-InstructionSetReference-NZ.pdf, page 4-184
    x86_pmulhrsw                = 0x01be, // x86-InstructionSetReference-NZ.pdf, page 4-187
    x86_pmulhrw                 = 0x01bf, // ExtraInstructions.txt, page 2
    x86_pmulhuw                 = 0x01c0, // x86-InstructionSetReference-NZ.pdf, page 4-191
    x86_pmulhw                  = 0x01c1, // x86-InstructionSetReference-NZ.pdf, page 4-194
    x86_pmulld                  = 0x01c2, // x86-InstructionSetReference-NZ.pdf, page 4-196
    x86_pmullw                  = 0x01c3, // x86-InstructionSetReference-NZ.pdf, page 4-200
    x86_pmuludq                 = 0x01c4, // x86-InstructionSetReference-NZ.pdf, page 4-203
    x86_pop                     = 0x01c5, // x86-InstructionSetReference-NZ.pdf, page 4-210
    x86_popa                    = 0x01c6, // x86-InstructionSetReference-NZ.pdf, page 4-210
    x86_popad                   = 0x01c7, // x86-InstructionSetReference-NZ.pdf, page 4-212
    x86_popcnt                  = 0x01c8, // x86-InstructionSetReference-NZ.pdf, page 4-214
    x86_popf                    = 0x01c9, // x86-InstructionSetReference-NZ.pdf, page 4-214
    x86_popfd                   = 0x01ca, // x86-InstructionSetReference-NZ.pdf, page 4-214
    x86_popfq                   = 0x01cb, // x86-InstructionSetReference-NZ.pdf, page 4-218
    x86_por                     = 0x01cc, // x86-InstructionSetReference-NZ.pdf, page 4-221
    x86_prefetch                = 0x01cd, // ExtraInstructions.txt, page 5
    x86_prefetchnta             = 0x01ce, // x86-InstructionSetReference-NZ.pdf, page 4-223
    x86_prefetcht0              = 0x01cf, // x86-InstructionSetReference-NZ.pdf, page 4-221
    x86_prefetcht1              = 0x01d0, // x86-InstructionSetReference-NZ.pdf, page 4-221
    x86_prefetcht2              = 0x01d1, // x86-InstructionSetReference-NZ.pdf, page 4-221
    x86_prefetchw               = 0x01d2, // ExtraInstructions.txt, page 5
    x86_psadbw                  = 0x01d3, // x86-InstructionSetReference-NZ.pdf, page 4-227
    x86_pshufb                  = 0x01d4, // x86-InstructionSetReference-NZ.pdf, page 4-231
    x86_pshufd                  = 0x01d5, // x86-InstructionSetReference-NZ.pdf, page 4-234
    x86_pshufhw                 = 0x01d6, // x86-InstructionSetReference-NZ.pdf, page 4-237
    x86_pshuflw                 = 0x01d7, // x86-InstructionSetReference-NZ.pdf, page 4-240
    x86_pshufw                  = 0x01d8, // x86-InstructionSetReference-NZ.pdf, page 4-242
    x86_psignb                  = 0x01d9, // x86-InstructionSetReference-NZ.pdf, page 4-242
    x86_psignd                  = 0x01da, // x86-InstructionSetReference-NZ.pdf, page 4-247
    x86_psignw                  = 0x01db, // x86-InstructionSetReference-NZ.pdf, page 4-242
    x86_pslld                   = 0x01dc, // x86-InstructionSetReference-NZ.pdf, page 4-249
    x86_pslldq                  = 0x01dd, // x86-InstructionSetReference-NZ.pdf, page 4-249
    x86_psllq                   = 0x01de, // x86-InstructionSetReference-NZ.pdf, page 4-254
    x86_psllw                   = 0x01df, // x86-InstructionSetReference-NZ.pdf, page 4-249
    x86_psrad                   = 0x01e0, // x86-InstructionSetReference-NZ.pdf, page 4-259
    x86_psraq                   = 0x01e1, // ExtraInstructions.txt, page 5
    x86_psraw                   = 0x01e2, // x86-InstructionSetReference-NZ.pdf, page 4-254
    x86_psrld                   = 0x01e3, // x86-InstructionSetReference-NZ.pdf, page 4-261
    x86_psrldq                  = 0x01e4, // x86-InstructionSetReference-NZ.pdf, page 4-261
    x86_psrlq                   = 0x01e5, // x86-InstructionSetReference-NZ.pdf, page 4-266
    x86_psrlw                   = 0x01e6, // x86-InstructionSetReference-NZ.pdf, page 4-261
    x86_psubb                   = 0x01e7, // x86-InstructionSetReference-NZ.pdf, page 4-266
    x86_psubd                   = 0x01e8, // x86-InstructionSetReference-NZ.pdf, page 4-270
    x86_psubq                   = 0x01e9, // x86-InstructionSetReference-NZ.pdf, page 4-273
    x86_psubsb                  = 0x01ea, // x86-InstructionSetReference-NZ.pdf, page 4-273
    x86_psubsw                  = 0x01eb, // x86-InstructionSetReference-NZ.pdf, page 4-277
    x86_psubusb                 = 0x01ec, // x86-InstructionSetReference-NZ.pdf, page 4-277
    x86_psubusw                 = 0x01ed, // x86-InstructionSetReference-NZ.pdf, page 4-281
    x86_psubw                   = 0x01ee, // x86-InstructionSetReference-NZ.pdf, page 4-266
    x86_pswapd                  = 0x01ef, // ExtraInstructions.txt, page 2
    x86_ptest                   = 0x01f0, // x86-InstructionSetReference-NZ.pdf, page 4-284
    x86_punpckhbw               = 0x01f1, // x86-InstructionSetReference-NZ.pdf, page 4-284
    x86_punpckhdq               = 0x01f2, // x86-InstructionSetReference-NZ.pdf, page 4-284
    x86_punpckhqdq              = 0x01f3, // x86-InstructionSetReference-NZ.pdf, page 4-290
    x86_punpckhwd               = 0x01f4, // x86-InstructionSetReference-NZ.pdf, page 4-284
    x86_punpcklbw               = 0x01f5, // x86-InstructionSetReference-NZ.pdf, page 4-290
    x86_punpckldq               = 0x01f6, // x86-InstructionSetReference-NZ.pdf, page 4-290
    x86_punpcklqdq              = 0x01f7, // x86-InstructionSetReference-NZ.pdf, page 4-295
    x86_punpcklwd               = 0x01f8, // x86-InstructionSetReference-NZ.pdf, page 4-290
    x86_push                    = 0x01f9, // x86-InstructionSetReference-NZ.pdf, page 4-300
    x86_pusha                   = 0x01fa, // x86-InstructionSetReference-NZ.pdf, page 4-300
    x86_pushad                  = 0x01fb, // x86-InstructionSetReference-NZ.pdf, page 4-303
    x86_pushf                   = 0x01fc, // x86-InstructionSetReference-NZ.pdf, page 4-303
    x86_pushfd                  = 0x01fd, // x86-InstructionSetReference-NZ.pdf, page 4-303
    x86_pushfq                  = 0x01fe, // x86-InstructionSetReference-NZ.pdf, page 4-306
    x86_pxor                    = 0x01ff, // x86-InstructionSetReference-NZ.pdf, page 4-309
    x86_rcl                     = 0x0200, // x86-InstructionSetReference-NZ.pdf, page 4-309
    x86_rcpps                   = 0x0201, // x86-InstructionSetReference-NZ.pdf, page 4-319
    x86_rcpss                   = 0x0202, // x86-InstructionSetReference-NZ.pdf, page 4-322
    x86_rcr                     = 0x0203, // x86-InstructionSetReference-NZ.pdf, page 4-310
    x86_rdmsr                   = 0x0204, // x86-InstructionSetReference-NZ.pdf, page 4-324
    x86_rdpmc                   = 0x0205, // x86-InstructionSetReference-NZ.pdf, page 4-329
    x86_rdtsc                   = 0x0206, // x86-InstructionSetReference-NZ.pdf, page 4-331
    x86_rdtscp                  = 0x0207, // x86-InstructionSetReference-NZ.pdf, page 4-333
    x86_rep_insb                = 0x0208, // x86-InstructionSetReference-NZ.pdf, page 4-333
    x86_rep_insd                = 0x0209, // x86-InstructionSetReference-NZ.pdf, page 4-333
    x86_rep_insw                = 0x020a, // x86-InstructionSetReference-NZ.pdf, page 4-333
    x86_rep_lodsb               = 0x020b, // x86-InstructionSetReference-NZ.pdf, page 4-333
    x86_rep_lodsd               = 0x020c, // x86-InstructionSetReference-NZ.pdf, page 4-334
    x86_rep_lodsq               = 0x020d, // x86-InstructionSetReference-NZ.pdf, page 4-334
    x86_rep_lodsw               = 0x020e, // x86-InstructionSetReference-NZ.pdf, page 4-334
    x86_rep_movsb               = 0x020f, // x86-InstructionSetReference-NZ.pdf, page 4-333
    x86_rep_movsd               = 0x0210, // x86-InstructionSetReference-NZ.pdf, page 4-333
    x86_rep_movsq               = 0x0211, // x86-InstructionSetReference-NZ.pdf, page 4-333
    x86_rep_movsw               = 0x0212, // x86-InstructionSetReference-NZ.pdf, page 4-333
    x86_rep_outsb               = 0x0213, // x86-InstructionSetReference-NZ.pdf, page 4-333
    x86_rep_outsd               = 0x0214, // x86-InstructionSetReference-NZ.pdf, page 4-333
    x86_rep_outsw               = 0x0215, // x86-InstructionSetReference-NZ.pdf, page 4-333
    x86_rep_stosb               = 0x0216, // x86-InstructionSetReference-NZ.pdf, page 4-334
    x86_rep_stosd               = 0x0217, // x86-InstructionSetReference-NZ.pdf, page 4-334
    x86_rep_stosq               = 0x0218, // x86-InstructionSetReference-NZ.pdf, page 4-334
    x86_rep_stosw               = 0x0219, // x86-InstructionSetReference-NZ.pdf, page 4-334
    x86_repe_cmpsb              = 0x021a, // x86-InstructionSetReference-NZ.pdf, page 4-334
    x86_repe_cmpsd              = 0x021b, // x86-InstructionSetReference-NZ.pdf, page 4-334
    x86_repe_cmpsq              = 0x021c, // x86-InstructionSetReference-NZ.pdf, page 4-334
    x86_repe_cmpsw              = 0x021d, // x86-InstructionSetReference-NZ.pdf, page 4-334
    x86_repe_scasb              = 0x021e, // x86-InstructionSetReference-NZ.pdf, page 4-334
    x86_repe_scasd              = 0x021f, // x86-InstructionSetReference-NZ.pdf, page 4-334
    x86_repe_scasq              = 0x0220, // x86-InstructionSetReference-NZ.pdf, page 4-334
    x86_repe_scasw              = 0x0221, // x86-InstructionSetReference-NZ.pdf, page 4-334
    x86_repne_cmpsb             = 0x0222, // x86-InstructionSetReference-NZ.pdf, page 4-335
    x86_repne_cmpsd             = 0x0223, // x86-InstructionSetReference-NZ.pdf, page 4-335
    x86_repne_cmpsq             = 0x0224, // x86-InstructionSetReference-NZ.pdf, page 4-335
    x86_repne_cmpsw             = 0x0225, // x86-InstructionSetReference-NZ.pdf, page 4-335
    x86_repne_scasb             = 0x0226, // x86-InstructionSetReference-NZ.pdf, page 4-335
    x86_repne_scasd             = 0x0227, // x86-InstructionSetReference-NZ.pdf, page 4-335
    x86_repne_scasq             = 0x0228, // x86-InstructionSetReference-NZ.pdf, page 4-338
    x86_repne_scasw             = 0x0229, // x86-InstructionSetReference-NZ.pdf, page 4-335
    x86_ret                     = 0x022a, // x86-InstructionSetReference-NZ.pdf, page 4-338
    x86_retf                    = 0x022b, // x86-InstructionSetReference-NZ.pdf, page 4-350
    x86_rol                     = 0x022c, // x86-InstructionSetReference-NZ.pdf, page 4-311
    x86_ror                     = 0x022d, // x86-InstructionSetReference-NZ.pdf, page 4-316
    x86_roundpd                 = 0x022e, // x86-InstructionSetReference-NZ.pdf, page 4-354
    x86_roundps                 = 0x022f, // x86-InstructionSetReference-NZ.pdf, page 4-357
    x86_roundsd                 = 0x0230, // x86-InstructionSetReference-NZ.pdf, page 4-360
    x86_roundss                 = 0x0231, // x86-InstructionSetReference-NZ.pdf, page 4-363
    x86_rsm                     = 0x0232, // x86-InstructionSetReference-NZ.pdf, page 4-365
    x86_rsqrtps                 = 0x0233, // x86-InstructionSetReference-NZ.pdf, page 4-368
    x86_rsqrtss                 = 0x0234, // x86-InstructionSetReference-NZ.pdf, page 4-371
    x86_sahf                    = 0x0235, // x86-InstructionSetReference-NZ.pdf, page 4-373
    x86_salc                    = 0x0236, // ExtraInstructions.txt, page 5
    x86_sar                     = 0x0237, // x86-InstructionSetReference-NZ.pdf, page 4-374
    x86_sbb                     = 0x0238, // x86-InstructionSetReference-NZ.pdf, page 4-384
    x86_scasb                   = 0x0239, // x86-InstructionSetReference-NZ.pdf, page 4-384
    x86_scasd                   = 0x023a, // x86-InstructionSetReference-NZ.pdf, page 4-384
    x86_scasq                   = 0x023b, // x86-InstructionSetReference-NZ.pdf, page 4-389
    x86_scasw                   = 0x023c, // x86-InstructionSetReference-NZ.pdf, page 4-384
    x86_seta                    = 0x023d, // x86-InstructionSetReference-NZ.pdf, page 4-390
    x86_setae                   = 0x023e, // x86-InstructionSetReference-NZ.pdf, page 4-390
    x86_setb                    = 0x023f, // x86-InstructionSetReference-NZ.pdf, page 4-390
    x86_setbe                   = 0x0240, // x86-InstructionSetReference-NZ.pdf, page 4-390
    x86_sete                    = 0x0241, // x86-InstructionSetReference-NZ.pdf, page 4-394
    x86_setg                    = 0x0242, // x86-InstructionSetReference-NZ.pdf, page 4-390
    x86_setge                   = 0x0243, // x86-InstructionSetReference-NZ.pdf, page 4-390
    x86_setl                    = 0x0244, // x86-InstructionSetReference-NZ.pdf, page 4-390
    x86_setle                   = 0x0245, // x86-InstructionSetReference-NZ.pdf, page 4-390
    x86_setne                   = 0x0246, // x86-InstructionSetReference-NZ.pdf, page 4-391
    x86_setno                   = 0x0247, // x86-InstructionSetReference-NZ.pdf, page 4-390
    x86_setns                   = 0x0248, // ExtraInstructions.txt, page 5
    x86_seto                    = 0x0249, // x86-InstructionSetReference-NZ.pdf, page 4-391
    x86_setpe                   = 0x024a, // x86-InstructionSetReference-NZ.pdf, page 4-391
    x86_setpo                   = 0x024b, // x86-InstructionSetReference-NZ.pdf, page 4-391
    x86_sets                    = 0x024c, // x86-InstructionSetReference-NZ.pdf, page 4-391
    x86_sfence                  = 0x024d, // x86-InstructionSetReference-NZ.pdf, page 4-395
    x86_sgdt                    = 0x024e, // x86-InstructionSetReference-NZ.pdf, page 4-398
    x86_shl                     = 0x024f, // x86-InstructionSetReference-NZ.pdf, page 4-375
    x86_shld                    = 0x0250, // x86-InstructionSetReference-NZ.pdf, page 4-401
    x86_shr                     = 0x0251, // x86-InstructionSetReference-NZ.pdf, page 4-380
    x86_shrd                    = 0x0252, // x86-InstructionSetReference-NZ.pdf, page 4-404
    x86_shufpd                  = 0x0253, // x86-InstructionSetReference-NZ.pdf, page 4-407
    x86_shufps                  = 0x0254, // x86-InstructionSetReference-NZ.pdf, page 4-410
    x86_sidt                    = 0x0255, // x86-InstructionSetReference-NZ.pdf, page 4-413
    x86_skinit                  = 0x0256, // ExtraInstructions.txt, page 1
    x86_sldt                    = 0x0257, // x86-InstructionSetReference-NZ.pdf, page 4-415
    x86_smsw                    = 0x0258, // x86-InstructionSetReference-NZ.pdf, page 4-418
    x86_sqrtpd                  = 0x0259, // x86-InstructionSetReference-NZ.pdf, page 4-421
    x86_sqrtps                  = 0x025a, // x86-InstructionSetReference-NZ.pdf, page 4-424
    x86_sqrtsd                  = 0x025b, // x86-InstructionSetReference-NZ.pdf, page 4-427
    x86_sqrtss                  = 0x025c, // x86-InstructionSetReference-NZ.pdf, page 4-430
    x86_stc                     = 0x025d, // x86-InstructionSetReference-NZ.pdf, page 4-431
    x86_std                     = 0x025e, // x86-InstructionSetReference-NZ.pdf, page 4-432
    x86_stgi                    = 0x025f, // ExtraInstructions.txt, page 1
    x86_sti                     = 0x0260, // x86-InstructionSetReference-NZ.pdf, page 4-435
    x86_stmxcsr                 = 0x0261, // x86-InstructionSetReference-NZ.pdf, page 4-437
    x86_stos                    = 0x0262, // x86-InstructionSetReference-NZ.pdf, page 4-437
    x86_stosb                   = 0x0263, // x86-InstructionSetReference-NZ.pdf, page 4-437
    x86_stosd                   = 0x0264, // x86-InstructionSetReference-NZ.pdf, page 4-437
    x86_stosq                   = 0x0265, // x86-InstructionSetReference-NZ.pdf, page 4-441
    x86_stosw                   = 0x0266, // x86-InstructionSetReference-NZ.pdf, page 4-437
    x86_str                     = 0x0267, // x86-InstructionSetReference-NZ.pdf, page 4-443
    x86_sub                     = 0x0268, // x86-InstructionSetReference-NZ.pdf, page 4-446
    x86_subpd                   = 0x0269, // x86-InstructionSetReference-NZ.pdf, page 4-449
    x86_subps                   = 0x026a, // x86-InstructionSetReference-NZ.pdf, page 4-452
    x86_subsd                   = 0x026b, // x86-InstructionSetReference-NZ.pdf, page 4-455
    x86_subss                   = 0x026c, // x86-InstructionSetReference-NZ.pdf, page 4-458
    x86_swapgs                  = 0x026d, // x86-InstructionSetReference-NZ.pdf, page 4-460
    x86_syscall                 = 0x026e, // x86-InstructionSetReference-NZ.pdf, page 4-462
    x86_sysenter                = 0x026f, // x86-InstructionSetReference-NZ.pdf, page 4-466
    x86_sysexit                 = 0x0270, // x86-InstructionSetReference-NZ.pdf, page 4-470
    x86_sysret                  = 0x0271, // x86-InstructionSetReference-NZ.pdf, page 4-472
    x86_test                    = 0x0272, // x86-InstructionSetReference-NZ.pdf, page 4-475
    x86_ucomisd                 = 0x0273, // x86-InstructionSetReference-NZ.pdf, page 4-478
    x86_ucomiss                 = 0x0274, // x86-InstructionSetReference-NZ.pdf, page 4-481
    x86_ud2                     = 0x0275, // x86-InstructionSetReference-NZ.pdf, page 4-482
    x86_unpckhpd                = 0x0276, // x86-InstructionSetReference-NZ.pdf, page 4-485
    x86_unpckhps                = 0x0277, // x86-InstructionSetReference-NZ.pdf, page 4-488
    x86_unpcklpd                = 0x0278, // x86-InstructionSetReference-NZ.pdf, page 4-491
    x86_unpcklps                = 0x0279, // x86-InstructionSetReference-NZ.pdf, page 4-494
    x86_verr                    = 0x027a, // x86-InstructionSetReference-NZ.pdf, page 4-494
    x86_verw                    = 0x027b, // x86-InstructionSetReference-NZ.pdf, page 4-497
    x86_vmcall                  = 0x027c, // x86-InstructionSetReference-NZ.pdf, page 5-13
    x86_vmclear                 = 0x027d, // x86-InstructionSetReference-NZ.pdf, page 5-16
    x86_vmlaunch                = 0x027e, // x86-InstructionSetReference-NZ.pdf, page 5-16
    x86_vmload                  = 0x027f, // ExtraInstructions.txt, page 1
    x86_vmmcall                 = 0x0280, // ExtraInstructions.txt, page 1
    x86_vmoff                   = 0x0281, // ExtraInstructions.txt, page 1
    x86_vmptrld                 = 0x0282, // x86-InstructionSetReference-NZ.pdf, page 5-22
    x86_vmptrst                 = 0x0283, // x86-InstructionSetReference-NZ.pdf, page 5-24
    x86_vmread                  = 0x0284, // x86-InstructionSetReference-NZ.pdf, page 5-27
    x86_vmresume                = 0x0285, // x86-InstructionSetReference-NZ.pdf, page 5-19
    x86_vmrun                   = 0x0286, // ExtraInstructions.txt, page 1
    x86_vmsave                  = 0x0287, // ExtraInstructions.txt, page 1
    x86_vmwrite                 = 0x0288, // x86-InstructionSetReference-NZ.pdf, page 5-29
    x86_vmxoff                  = 0x0289, // x86-InstructionSetReference-NZ.pdf, page 5-31
    x86_vmxon                   = 0x028a, // x86-InstructionSetReference-NZ.pdf, page 5-37
    x86_wait                    = 0x028b, // x86-InstructionSetReference-NZ.pdf, page 4-497
    x86_wbinvd                  = 0x028c, // x86-InstructionSetReference-NZ.pdf, page 4-501
    x86_wrmsr                   = 0x028d, // x86-InstructionSetReference-NZ.pdf, page 4-503
    x86_xadd                    = 0x028e, // x86-InstructionSetReference-NZ.pdf, page 4-506
    x86_xchg                    = 0x028f, // x86-InstructionSetReference-NZ.pdf, page 4-509
    x86_xgetbv                  = 0x0290, // x86-InstructionSetReference-NZ.pdf, page 4-511
    x86_xlatb                   = 0x0291, // x86-InstructionSetReference-NZ.pdf, page 4-513
    x86_xor                     = 0x0292, // x86-InstructionSetReference-NZ.pdf, page 4-516
    x86_xorpd                   = 0x0293, // x86-InstructionSetReference-NZ.pdf, page 4-518
    x86_xorps                   = 0x0294, // x86-InstructionSetReference-NZ.pdf, page 4-520
    x86_xrstor                  = 0x0295, // x86-InstructionSetReference-NZ.pdf, page 4-525
    x86_xsave                   = 0x0296, // x86-InstructionSetReference-NZ.pdf, page 4-529
    x86_xsetbv                  = 0x0297, // x86-InstructionSetReference-NZ.pdf, page 5-4
    x86_last_instruction        = 0x0298
};

namespace ByteOrder {
    enum Endianness {
        ORDER_UNSPECIFIED = 0, /**< Endianness is unspecified and unknown. */
                ORDER_LSB, /**< Least significant byte first, i.e., little-endian. */
                ORDER_MSB       /**< Most significant byte first, i.e., big-endian. */
    };
}

#endif
