import React from 'react';
import { LinkTarget } from '@grafana/data';
import { IconName } from '../../types';
/** @internal */
export interface MenuItem {
    /** Label of the menu item */
    label: string;
    /** Target of the menu item (i.e. new window)  */
    target?: LinkTarget;
    /** Icon of the menu item */
    icon?: IconName;
    /** Url of the menu item */
    url?: string;
    /** Handler for the click behaviour */
    onClick?: (event?: React.SyntheticEvent<HTMLElement>) => void;
    /** Handler for the click behaviour */
    group?: string;
    /** Active */
    active?: boolean;
}
/** @internal */
export interface MenuItemsGroup {
    /** Label for the menu items group */
    label?: string;
    /** Items of the group */
    items: MenuItem[];
}
/** @internal */
export interface MenuProps extends React.HTMLAttributes<HTMLDivElement> {
    /** React element rendered at the top of the menu */
    header?: React.ReactNode;
    /** Array of menu items */
    items?: MenuItemsGroup[];
    /** Callback performed when menu is closed */
    onClose?: () => void;
}
/** @internal */
export declare const Menu: React.ForwardRefExoticComponent<MenuProps & React.RefAttributes<HTMLDivElement>>;
