"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.searchTestDataSetupTask = exports.setDashboardAcl = exports.addToTeam = exports.getTeam = exports.getUser = void 0;
const tslib_1 = require("tslib");
const axios_1 = tslib_1.__importDefault(require("axios"));
const task_1 = require("./task");
const client = axios_1.default.create({
    baseURL: 'http://localhost:3000/api',
    auth: {
        username: 'admin',
        password: 'admin2',
    },
});
function getUser(user) {
    return tslib_1.__awaiter(this, void 0, void 0, function* () {
        console.log('Creating user ' + user.name);
        const search = yield client.get('/users/search', {
            params: { query: user.login },
        });
        if (search.data.totalCount === 1) {
            user.id = search.data.users[0].id;
            return user;
        }
        const rsp = yield client.post('/admin/users', user);
        user.id = rsp.data.id;
        return user;
    });
}
exports.getUser = getUser;
function getTeam(team) {
    return tslib_1.__awaiter(this, void 0, void 0, function* () {
        // delete if exists
        const teams = yield client.get('/teams/search');
        for (const existing of teams.data.teams) {
            if (existing.name === team.name) {
                console.log('Team exists, deleting');
                yield client.delete('/teams/' + existing.id);
            }
        }
        console.log('Creating team ' + team.name);
        const teamRsp = yield client.post(`/teams`, team);
        team.id = teamRsp.data.teamId;
        return team;
    });
}
exports.getTeam = getTeam;
function addToTeam(team, user) {
    return tslib_1.__awaiter(this, void 0, void 0, function* () {
        console.log(`Adding user ${user.name} to team ${team.name}`);
        yield client.post(`/teams/${team.id}/members`, { userId: user.id });
    });
}
exports.addToTeam = addToTeam;
function setDashboardAcl(dashboardId, aclList) {
    return tslib_1.__awaiter(this, void 0, void 0, function* () {
        console.log('Setting Dashboard ACL ' + dashboardId);
        yield client.post(`/dashboards/id/${dashboardId}/permissions`, { items: aclList });
    });
}
exports.setDashboardAcl = setDashboardAcl;
const searchTestDataSetupRunner = ({ count }) => tslib_1.__awaiter(void 0, void 0, void 0, function* () {
    const user1 = yield getUser({
        name: 'searchTestUser1',
        email: 'searchTestUser@team.com',
        login: 'searchTestUser1',
        password: '12345',
    });
    const team1 = yield getTeam({ name: 'searchTestTeam1', email: 'searchtestdata@team.com' });
    addToTeam(team1, user1);
    // create or update folder
    const folder = {
        uid: 'search-test-data',
        title: 'Search test data folder',
        version: 1,
    };
    try {
        yield client.delete(`/folders/${folder.uid}`);
    }
    catch (err) { }
    console.log('Creating folder');
    const rsp = yield client.post(`/folders`, folder);
    folder.id = rsp.data.id;
    folder.url = rsp.data.url;
    yield setDashboardAcl(folder.id, []);
    console.log('Creating dashboards');
    const dashboards = [];
    for (let i = 0; i < count; i++) {
        const dashboard = {
            uid: 'search-test-dash-' + i.toString().padStart(5, '0'),
            title: 'Search test dash ' + i.toString().padStart(5, '0'),
        };
        const rsp = yield client.post(`/dashboards/db`, {
            dashboard: dashboard,
            folderId: folder.id,
            overwrite: true,
        });
        dashboard.id = rsp.data.id;
        dashboard.url = rsp.data.url;
        console.log('Created dashboard ' + dashboard.title);
        dashboards.push(dashboard);
        yield setDashboardAcl(dashboard.id, [{ userId: 0, teamId: team1.id, permission: 4 }]);
    }
});
exports.searchTestDataSetupTask = new task_1.Task('Search test data setup', searchTestDataSetupRunner);
//# sourceMappingURL=searchTestDataSetup.js.map