import React from 'react';
import { PopoverContent, TooltipPlacement } from './types';
export interface TooltipProps {
    theme?: 'info' | 'error' | 'info-alt';
    show?: boolean;
    placement?: TooltipPlacement;
    content: PopoverContent;
    children: JSX.Element;
    /**
     * Set to true if you want the tooltip to stay long enough so the user can move mouse over content to select text or click a link
     */
    interactive?: boolean;
}
export declare const Tooltip: React.MemoExoticComponent<({ children, theme, interactive, show, placement, content }: TooltipProps) => JSX.Element>;
