/*
 * Decompiled with CFR 0.152.
 */
package org.mozilla.jss;

import java.io.InputStream;
import java.security.MessageDigest;
import java.security.Provider;
import java.util.Arrays;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.mozilla.jss.CryptoManager;
import org.mozilla.jss.JSSLoader;
import org.mozilla.jss.NotInitializedException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class JSSProvider
extends Provider {
    private static final Logger logger = LoggerFactory.getLogger(JSSProvider.class);
    public static boolean ENABLE_JSSENGINE = true;
    private static final long serialVersionUID = 1L;
    private static final String JSS_VERSION = CryptoManager.getJSSVersion();
    private static final List<String> DEPRECATED_ALGORITHMS = Arrays.asList("SHA$|SHAwith|SHA1|SHA-1|SHA_1", "MD(2|4|5)");
    private static JSSLoader loader = new JSSLoader();
    private static CryptoManager cm;

    public JSSProvider() {
        this(CryptoManager.isInitialized());
    }

    public JSSProvider(boolean initialize) {
        super("Mozilla-JSS", JSS_VERSION, "Provides Signature, Message Digesting, and RNG");
        if (initialize) {
            this.initializeProvider();
        }
    }

    public JSSProvider(String config_path) throws Exception {
        this(false);
        this.configure(config_path);
    }

    public JSSProvider(InputStream config) throws Exception {
        this(false);
        cm = JSSLoader.init(config);
        this.initializeProvider();
    }

    @Override
    public Provider configure(String arg) {
        try {
            cm = JSSLoader.init(arg);
        }
        catch (NullPointerException npe) {
            throw npe;
        }
        catch (Exception e) {
            throw new RuntimeException(e.getMessage(), e);
        }
        this.initializeProvider();
        return this;
    }

    public CryptoManager getCryptoManager() {
        if (cm == null) {
            try {
                cm = CryptoManager.getInstance();
            }
            catch (NotInitializedException notInitializedException) {
                // empty catch block
            }
        }
        return cm;
    }

    @Override
    public Provider.Service getService(String type, String algorithm) {
        if (JSSProvider.isAlgorithmDeprecated(algorithm)) {
            StackTraceElement[] stackTrace = Thread.currentThread().getStackTrace();
            int i = 0;
            for (i = 0; i < stackTrace.length; ++i) {
                if (!stackTrace[i].getClassName().contains(MessageDigest.class.getCanonicalName())) continue;
                int lineNumber = stackTrace[i + 1].getLineNumber();
                String methodName = stackTrace[i + 1].getMethodName();
                String className = stackTrace[i + 1].getClassName();
                logger.debug("The {} algorithm used in {}::{}:{} is deprecated. Use a more secure algorithm.", new Object[]{algorithm, className, methodName, lineNumber});
                break;
            }
        }
        return super.getService(type, algorithm);
    }

    public static boolean isAlgorithmDeprecated(String algorithm) {
        for (String alg : DEPRECATED_ALGORITHMS) {
            Matcher m = Pattern.compile(alg).matcher(algorithm.toUpperCase());
            if (!m.find()) continue;
            return true;
        }
        return false;
    }

    public static List<String> getDeprecatedAlgortihms() {
        return DEPRECATED_ALGORITHMS;
    }

    protected void initializeProvider() {
        this.put("Signature.MD5/RSA", "org.mozilla.jss.provider.java.security.JSSSignatureSpi$MD5RSA");
        this.put("Alg.Alias.Signature.MD5withRSA", "MD5/RSA");
        this.put("Signature.MD2/RSA", "org.mozilla.jss.provider.java.security.JSSSignatureSpi$MD2RSA");
        this.put("Signature.SHA-256/RSA", "org.mozilla.jss.provider.java.security.JSSSignatureSpi$SHA256RSA");
        this.put("Alg.Alias.Signature.SHA256/RSA", "SHA-256/RSA");
        this.put("Alg.Alias.Signature.SHA256withRSA", "SHA-256/RSA");
        this.put("Signature.RSASSA-PSS", "org.mozilla.jss.provider.java.security.JSSSignatureSpi$RSAPSSSignature");
        this.put("Alg.Alias.Signature.1.2.840.113549.1.1.10", "RSASSA-PSS");
        this.put("Alg.Alias.Signature.OID.1.2.840.113549.1.1.10", "RSASSA-PSS");
        this.put("Signature.SHA-256/RSA/PSS", "org.mozilla.jss.provider.java.security.JSSSignatureSpi$SHA256RSAPSS");
        this.put("Alg.Alias.Signature.SHA256withRSA/PSS", "SHA-256/RSA/PSS");
        this.put("Signature.SHA-384/RSA/PSS", "org.mozilla.jss.provider.java.security.JSSSignatureSpi$SHA384RSAPSS");
        this.put("Alg.Alias.Signature.SHA384withRSA/PSS", "SHA-384/RSA/PSS");
        this.put("Signature.SHA-512/RSA/PSS", "org.mozilla.jss.provider.java.security.JSSSignatureSpi$SHA512RSAPSS");
        this.put("Alg.Alias.Signature.SHA512withRSA/PSS", "SHA-512/RSA/PSS");
        this.put("Signature.SHA-384/RSA", "org.mozilla.jss.provider.java.security.JSSSignatureSpi$SHA384RSA");
        this.put("Alg.Alias.Signature.SHA384/RSA", "SHA-384/RSA");
        this.put("Alg.Alias.Signature.SHA384withRSA", "SHA-384/RSA");
        this.put("Signature.SHA-512/RSA", "org.mozilla.jss.provider.java.security.JSSSignatureSpi$SHA512RSA");
        this.put("Alg.Alias.Signature.SHA512/RSA", "SHA-512/RSA");
        this.put("Alg.Alias.Signature.SHA512withRSA", "SHA-512/RSA");
        this.put("Signature.SHA256withEC", "org.mozilla.jss.provider.java.security.JSSSignatureSpi$SHA256EC");
        this.put("Alg.Alias.Signature.SHA256/EC", "SHA256withEC");
        this.put("Alg.Alias.Signature.SHA-256/EC", "SHA256withEC");
        this.put("Alg.Alias.Signature.SHA256withECDSA", "SHA256withEC");
        this.put("Signature.SHA384withEC", "org.mozilla.jss.provider.java.security.JSSSignatureSpi$SHA384EC");
        this.put("Alg.Alias.Signature.SHA384/EC", "SHA384withEC");
        this.put("Alg.Alias.Signature.SHA-384/EC", "SHA384withEC");
        this.put("Alg.Alias.Signature.SHA384withECDSA", "SHA384withEC");
        this.put("Signature.SHA512withEC", "org.mozilla.jss.provider.java.security.JSSSignatureSpi$SHA512EC");
        this.put("Alg.Alias.Signature.SHA512/EC", "SHA512withEC");
        this.put("Alg.Alias.Signature.SHA-512/EC", "SHA512withEC");
        this.put("Alg.Alias.Signature.SHA512withECDSA", "SHA512withEC");
        this.put("MessageDigest.MD2", "org.mozilla.jss.provider.java.security.JSSMessageDigestSpi$MD2");
        this.put("MessageDigest.MD5", "org.mozilla.jss.provider.java.security.JSSMessageDigestSpi$MD5");
        this.put("MessageDigest.SHA-256", "org.mozilla.jss.provider.java.security.JSSMessageDigestSpi$SHA256");
        this.put("MessageDigest.SHA-384", "org.mozilla.jss.provider.java.security.JSSMessageDigestSpi$SHA384");
        this.put("MessageDigest.SHA-512", "org.mozilla.jss.provider.java.security.JSSMessageDigestSpi$SHA512");
        this.put("Alg.Alias.MessageDigest.SHA256", "SHA-256");
        this.put("Alg.Alias.MessageDigest.SHA384", "SHA-384");
        this.put("Alg.Alias.MessageDigest.SHA512", "SHA-512");
        this.put("SecureRandom.pkcs11prng", "org.mozilla.jss.provider.java.security.JSSSecureRandomSpi");
        this.put("KeyPairGenerator.RSA", "org.mozilla.jss.provider.java.security.JSSKeyPairGeneratorSpi$RSA");
        this.put("KeyPairGenerator.DSA", "org.mozilla.jss.provider.java.security.JSSKeyPairGeneratorSpi$DSA");
        this.put("KeyPairGenerator.EC", "org.mozilla.jss.provider.java.security.JSSKeyPairGeneratorSpi$EC");
        this.put("KeyFactory.RSA", "org.mozilla.jss.provider.java.security.KeyFactorySpi1_2");
        this.put("KeyFactory.DSA", "org.mozilla.jss.provider.java.security.KeyFactorySpi1_2");
        this.put("KeyFactory.EC", "org.mozilla.jss.provider.java.security.KeyFactorySpi1_2");
        this.put("KeyStore.PKCS11", "org.mozilla.jss.provider.java.security.JSSKeyStoreSpi");
        this.put("AlgorithmParameters.IvAlgorithmParameters", "org.mozilla.jss.provider.java.security.IvAlgorithmParameters");
        this.put("AlgorithmParameters.RC2AlgorithmParameters", "org.mozilla.jss.provider.java.security.RC2AlgorithmParameters");
        this.put("AlgorithmParameters.RSAPSSAlgorithmParameters", "org.mozilla.jss.provider.java.security.RSAPSSAlgorithmParameters");
        this.put("Cipher.DES", "org.mozilla.jss.provider.javax.crypto.JSSCipherSpi$DES");
        this.put("Cipher.DESede", "org.mozilla.jss.provider.javax.crypto.JSSCipherSpi$DESede");
        this.put("Alg.Alias.Cipher.DES3", "DESede");
        this.put("Cipher.AES", "org.mozilla.jss.provider.javax.crypto.JSSCipherSpi$AES");
        this.put("Cipher.RC4", "org.mozilla.jss.provider.javax.crypto.JSSCipherSpi$RC4");
        this.put("Cipher.RSA", "org.mozilla.jss.provider.javax.crypto.JSSCipherSpi$RSA");
        this.put("Cipher.RC2", "org.mozilla.jss.provider.javax.crypto.JSSCipherSpi$RC2");
        String kg_spi = "org.mozilla.jss.provider.javax.crypto.JSSKeyGeneratorSpi";
        this.put("KeyGenerator.DES", kg_spi + "$DES");
        this.put("KeyGenerator.DESede", kg_spi + "$DESede");
        this.put("Alg.Alias.KeyGenerator.DES3", "DESede");
        this.put("KeyGenerator.AES", kg_spi + "$AES");
        this.put("KeyGenerator.RC4", kg_spi + "$RC4");
        this.put("KeyGenerator.RC2", kg_spi + "$RC2");
        this.put("KeyGenerator.HmacSHA1", kg_spi + "$HmacSHA1");
        this.put("KeyGenerator.PBAHmacSHA1", kg_spi + "$PBAHmacSHA1");
        this.put("KeyGenerator.PBESHA256Hmac", kg_spi + "$PBESHA256Hmac");
        this.put("KeyGenerator.PBESHA384Hmac", kg_spi + "$PBESHA384Hmac");
        this.put("KeyGenerator.PBESHA512Hmac", kg_spi + "$PBESHA512Hmac");
        this.put("KeyGenerator.HmacSHA256", kg_spi + "$HmacSHA256");
        this.put("KeyGenerator.HmacSHA384", kg_spi + "$HmacSHA384");
        this.put("KeyGenerator.HmacSHA512", kg_spi + "$HmacSHA512");
        this.put("KeyGenerator.KbkdfCounter", kg_spi + "$KbkdfCounter");
        this.put("Alg.Alias.KeyGenerator.KBKDF-Counter", "KbkdfCounter");
        this.put("Alg.Alias.KeyGenerator.SP800-108-KDF-Counter", "KbkdfCounter");
        this.put("Alg.Alias.KeyGenerator.SP800-108-Counter", "KbkdfCounter");
        this.put("Alg.Alias.KeyGenerator.CounterKbkdf", "KbkdfCounter");
        this.put("KeyGenerator.KbkdfCounterData", kg_spi + "$KbkdfCounterData");
        this.put("Alg.Alias.KeyGenerator.KBKDF-Counter-Data", "KbkdfCounterData");
        this.put("Alg.Alias.KeyGenerator.SP800-108-KDF-Counter-Data", "KbkdfCounterData");
        this.put("Alg.Alias.KeyGenerator.SP800-108-Counter-Data", "KbkdfCounterData");
        this.put("Alg.Alias.KeyGenerator.CounterKbkdf-Data", "KbkdfCounterData");
        this.put("KeyGenerator.KbkdfFeedback", kg_spi + "$KbkdfFeedback");
        this.put("Alg.Alias.KeyGenerator.KBKDF-Feedback", "KbkdfFeedback");
        this.put("Alg.Alias.KeyGenerator.SP800-108-KDF-Feedback", "KbkdfFeedback");
        this.put("Alg.Alias.KeyGenerator.SP800-108-Feedback", "KbkdfFeedback");
        this.put("Alg.Alias.KeyGenerator.FeedbackKbkdf", "KbkdfFeedback");
        this.put("KeyGenerator.KbkdfFeedbackData", kg_spi + "$KbkdfFeedbackData");
        this.put("Alg.Alias.KeyGenerator.KBKDF-Feedback-Data", "KbkdfFeedbackData");
        this.put("Alg.Alias.KeyGenerator.SP800-108-KDF-Feedback-Data", "KbkdfFeedbackData");
        this.put("Alg.Alias.KeyGenerator.SP800-108-Feedback-Data", "KbkdfFeedbackData");
        this.put("Alg.Alias.KeyGenerator.FeedbackKbkdf-Data", "KbkdfFeedbackData");
        this.put("KeyGenerator.KbkdfDoublePipeline", kg_spi + "$KbkdfDoublePipeline");
        this.put("Alg.Alias.KeyGenerator.KBKDF-DoublePipeline", "KbkdfDoublePipeline");
        this.put("Alg.Alias.KeyGenerator.SP800-108-KDF-DoublePipeline", "KbkdfDoublePipeline");
        this.put("Alg.Alias.KeyGenerator.SP800-108-DoublePipeline", "KbkdfDoublePipeline");
        this.put("Alg.Alias.KeyGenerator.DoublePipelineKbkdf", "KbkdfDoublePipeline");
        this.put("Alg.Alias.KeyGenerator.KbkdfPipeline", "KbkdfDoublePipeline");
        this.put("Alg.Alias.KeyGenerator.KBKDF-Pipeline", "KbkdfDoublePipeline");
        this.put("Alg.Alias.KeyGenerator.SP800-108-KDF-Pipeline", "KbkdfDoublePipeline");
        this.put("Alg.Alias.KeyGenerator.SP800-108-Pipeline", "KbkdfDoublePipeline");
        this.put("Alg.Alias.KeyGenerator.PipelineKbkdf", "KbkdfDoublePipeline");
        this.put("KeyGenerator.KbkdfDoublePipelineData", kg_spi + "$KbkdfDoublePipelineData");
        this.put("Alg.Alias.KeyGenerator.KBKDF-DoublePipeline-Data", "KbkdfDoublePipelineData");
        this.put("Alg.Alias.KeyGenerator.SP800-108-KDF-DoublePipeline-Data", "KbkdfDoublePipelineData");
        this.put("Alg.Alias.KeyGenerator.SP800-108-DoublePipeline-Data", "KbkdfDoublePipelineData");
        this.put("Alg.Alias.KeyGenerator.DoublePipelineKbkdf-Data", "KbkdfDoublePipelineData");
        this.put("Alg.Alias.KeyGenerator.KbkdfPipelineData", "KbkdfDoublePipelineData");
        this.put("Alg.Alias.KeyGenerator.KBKDF-Pipeline-Data", "KbkdfDoublePipelineData");
        this.put("Alg.Alias.KeyGenerator.SP800-108-KDF-Pipeline-Data", "KbkdfDoublePipelineData");
        this.put("Alg.Alias.KeyGenerator.SP800-108-Pipeline-Data", "KbkdfDoublePipelineData");
        this.put("Alg.Alias.KeyGenerator.PipelineKbkdf-Data", "KbkdfDoublePipelineData");
        this.put("SecretKeyFactory.GenericSecret", "org.mozilla.jss.provider.javax.crypto.JSSSecretKeyFactorySpi$GenericSecret");
        this.put("Alg.Alias.SecretKeyFactory.GENERIC_SECRET", "GenericSecret");
        this.put("SecretKeyFactory.DES", "org.mozilla.jss.provider.javax.crypto.JSSSecretKeyFactorySpi$DES");
        this.put("SecretKeyFactory.DESede", "org.mozilla.jss.provider.javax.crypto.JSSSecretKeyFactorySpi$DESede");
        this.put("Alg.Alias.SecretKeyFactory.DES3", "DESede");
        this.put("SecretKeyFactory.AES", "org.mozilla.jss.provider.javax.crypto.JSSSecretKeyFactorySpi$AES");
        this.put("SecretKeyFactory.RC4", "org.mozilla.jss.provider.javax.crypto.JSSSecretKeyFactorySpi$RC4");
        this.put("SecretKeyFactory.RC2", "org.mozilla.jss.provider.javax.crypto.JSSSecretKeyFactorySpi$RC2");
        this.put("SecretKeyFactory.HmacSHA1", "org.mozilla.jss.provider.javax.crypto.JSSSecretKeyFactorySpi$HmacSHA1");
        this.put("SecretKeyFactory.PBAHmacSHA1", "org.mozilla.jss.provider.javax.crypto.JSSSecretKeyFactorySpi$PBAHmacSHA1");
        this.put("SecretKeyFactory.HmacSHA256", "org.mozilla.jss.provider.javax.crypto.JSSSecretKeyFactorySpi$HmacSHA256");
        this.put("SecretKeyFactory.HmacSHA384", "org.mozilla.jss.provider.javax.crypto.JSSSecretKeyFactorySpi$HmacSHA384");
        this.put("SecretKeyFactory.HmacSHA512", "org.mozilla.jss.provider.javax.crypto.JSSSecretKeyFactorySpi$HmacSHA512");
        this.put("SecretKeyFactory.PBEWithMD5AndDES", "org.mozilla.jss.provider.javax.crypto.JSSSecretKeyFactorySpi$PBE_MD5_DES_CBC");
        this.put("SecretKeyFactory.PBEWithSHA1AndDES", "org.mozilla.jss.provider.javax.crypto.JSSSecretKeyFactorySpi$PBE_SHA1_DES_CBC");
        this.put("SecretKeyFactory.PBEWithSHA1AndDESede", "org.mozilla.jss.provider.javax.crypto.JSSSecretKeyFactorySpi$PBE_SHA1_DES3_CBC");
        this.put("Alg.Alias.SecretKeyFactory.PBEWithSHA1AndDES3", "PBEWithSHA1AndDESede");
        this.put("SecretKeyFactory.PBEWithSHA1And128RC4", "org.mozilla.jss.provider.javax.crypto.JSSSecretKeyFactorySpi$PBE_SHA1_RC4_128");
        this.put("Mac.HmacSHA1", "org.mozilla.jss.provider.javax.crypto.JSSMacSpi$HmacSHA1");
        this.put("Alg.Alias.Mac.Hmac-SHA1", "HmacSHA1");
        this.put("Mac.HmacSHA256", "org.mozilla.jss.provider.javax.crypto.JSSMacSpi$HmacSHA256");
        this.put("Alg.Alias.Mac.Hmac-SHA256", "HmacSHA256");
        this.put("Mac.HmacSHA384", "org.mozilla.jss.provider.javax.crypto.JSSMacSpi$HmacSHA384");
        this.put("Alg.Alias.Mac.Hmac-SHA384", "HmacSHA384");
        this.put("Mac.HmacSHA512", "org.mozilla.jss.provider.javax.crypto.JSSMacSpi$HmacSHA512");
        this.put("Mac.CmacAES", "org.mozilla.jss.provider.javax.crypto.JSSMacSpi$CmacAES");
        this.put("Alg.Alias.Mac.Hmac-SHA512", "HmacSHA512");
        this.put("Alg.Alias.Mac.SHA-256-HMAC", "HmacSHA256");
        this.put("Alg.Alias.Mac.SHA-384-HMAC", "HmacSHA384");
        this.put("Alg.Alias.Mac.SHA-512-HMAC", "HmacSHA512");
        this.put("Alg.Alias.Mac.AES-128-CMAC", "CmacAES");
        this.put("Alg.Alias.Mac.AES-192-CMAC", "CmacAES");
        this.put("Alg.Alias.Mac.AES-256-CMAC", "CmacAES");
        this.put("Alg.Alias.Mac.CmacAES128", "CmacAES");
        this.put("Alg.Alias.Mac.CmacAES192", "CmacAES");
        this.put("Alg.Alias.Mac.CmacAES256", "CmacAES");
        this.put("Alg.Alias.Mac.AES_CMAC", "CmacAES");
        this.put("Alg.Alias.Mac.CMAC_AES", "CmacAES");
        this.put("KeyManagerFactory.NssX509", "org.mozilla.jss.provider.javax.crypto.JSSKeyManagerFactory");
        this.put("Alg.Alias.KeyManagerFactory.SunX509", "NssX509");
        this.put("Alg.Alias.KeyManagerFactory.PKIX", "SunX509");
        this.put("TrustManagerFactory.NssX509", "org.mozilla.jss.provider.javax.crypto.JSSTrustManagerFactory");
        this.put("Alg.Alias.TrustManagerFactory.SunX509", "NssX509");
        this.put("Alg.Alias.TrustManagerFactory.PKIX", "NssX509");
        this.put("Alg.Alias.TrustManagerFactory.X509", "NssX509");
        this.put("Alg.Alias.TrustManagerFactory.X.509", "NssX509");
        if (ENABLE_JSSENGINE) {
            this.put("SSLContext.Default", "org.mozilla.jss.provider.javax.net.JSSContextSpi");
            this.put("SSLContext.SSL", "org.mozilla.jss.provider.javax.net.JSSContextSpi");
            this.put("SSLContext.TLS", "org.mozilla.jss.provider.javax.net.JSSContextSpi");
            this.put("SSLContext.TLSv1.1", "org.mozilla.jss.provider.javax.net.JSSContextSpi$TLSv11");
            this.put("SSLContext.TLSv1.2", "org.mozilla.jss.provider.javax.net.JSSContextSpi$TLSv12");
            this.put("SSLContext.TLSv1.3", "org.mozilla.jss.provider.javax.net.JSSContextSpi$TLSv13");
        }
    }

    @Override
    public String toString() {
        return "Mozilla-JSS version: " + JSS_VERSION;
    }
}

