/*
 * Decompiled with CFR 0.152.
 */
package org.mozilla.jss.pkcs11;

import java.math.BigInteger;
import java.security.interfaces.ECPrivateKey;
import java.security.spec.ECParameterSpec;
import org.mozilla.jss.crypto.PrivateKey;
import org.mozilla.jss.pkcs11.PK11ECPublicKey;
import org.mozilla.jss.pkcs11.PK11PrivKey;
import org.mozilla.jss.pkcs11.PK11PubKey;

public class PK11ECPrivateKey
extends PK11PrivKey
implements ECPrivateKey {
    private static final long serialVersionUID = 1L;

    private PK11ECPrivateKey() {
        super(null);
    }

    protected PK11ECPrivateKey(byte[] pointer) {
        super(pointer);
    }

    @Override
    public PrivateKey.Type getType() {
        return PrivateKey.Type.EC;
    }

    @Override
    public ECParameterSpec getParams() {
        PK11PubKey publicKey = this.getPublicKey();
        if (!(publicKey instanceof PK11ECPublicKey)) {
            throw new RuntimeException("Unknown key type: expected the public key of an EC key to be an PK11ECPublicKey; got: " + publicKey);
        }
        PK11ECPublicKey ecPublicKey = (PK11ECPublicKey)publicKey;
        return ecPublicKey.getParams();
    }

    @Override
    public BigInteger getS() {
        return null;
    }
}

