; NOTE: Assertions have been autogenerated by utils/update_llc_test_checks.py
; RUN: llc -mtriple=aarch64-- -o - %s | FileCheck %s

declare i32 @llvm.fshl.i32(i32, i32, i32)
declare i16 @llvm.fshr.i16(i16, i16, i16)
declare i64 @llvm.fshr.i64(i64, i64, i64)
declare <4 x i32> @llvm.fshl.v4i32(<4 x i32>, <4 x i32>, <4 x i32>)

define i1 @fshl_or_eq_0(i32 %x, i32 %y) {
; CHECK-LABEL: fshl_or_eq_0:
; CHECK:       // %bb.0:
; CHECK-NEXT:    orr w8, w0, w1, lsl #5
; CHECK-NEXT:    cmp w8, #0
; CHECK-NEXT:    cset w0, eq
; CHECK-NEXT:    ret
  %or = or i32 %x, %y
  %f = call i32 @llvm.fshl.i32(i32 %or, i32 %x, i32 5)
  %r = icmp eq i32 %f, 0
  ret i1 %r
}

define i1 @fshl_or_commute_eq_0(i32 %x, i32 %y) {
; CHECK-LABEL: fshl_or_commute_eq_0:
; CHECK:       // %bb.0:
; CHECK-NEXT:    orr w8, w0, w1, lsl #5
; CHECK-NEXT:    cmp w8, #0
; CHECK-NEXT:    cset w0, eq
; CHECK-NEXT:    ret
  %or = or i32 %y, %x
  %f = call i32 @llvm.fshl.i32(i32 %or, i32 %x, i32 5)
  %r = icmp eq i32 %f, 0
  ret i1 %r
}

define <4 x i1> @fshl_or2_eq_0(<4 x i32> %x, <4 x i32> %y) {
; CHECK-LABEL: fshl_or2_eq_0:
; CHECK:       // %bb.0:
; CHECK-NEXT:    ushr v1.4s, v1.4s, #7
; CHECK-NEXT:    orr v0.16b, v1.16b, v0.16b
; CHECK-NEXT:    cmeq v0.4s, v0.4s, #0
; CHECK-NEXT:    xtn v0.4h, v0.4s
; CHECK-NEXT:    ret
  %or = or <4 x i32> %x, %y
  %f = call <4 x i32> @llvm.fshl.v4i32(<4 x i32> %x, <4 x i32> %or, <4 x i32> <i32 25, i32 25, i32 25, i32 25>)
  %r = icmp eq <4 x i32> %f, zeroinitializer
  ret <4 x i1> %r
}

define <4 x i1> @fshl_or2_commute_eq_0(<4 x i32> %x, <4 x i32> %y) {
; CHECK-LABEL: fshl_or2_commute_eq_0:
; CHECK:       // %bb.0:
; CHECK-NEXT:    ushr v1.4s, v1.4s, #7
; CHECK-NEXT:    orr v0.16b, v1.16b, v0.16b
; CHECK-NEXT:    cmeq v0.4s, v0.4s, #0
; CHECK-NEXT:    xtn v0.4h, v0.4s
; CHECK-NEXT:    ret
  %or = or <4 x i32> %y, %x
  %f = call <4 x i32> @llvm.fshl.v4i32(<4 x i32> %x, <4 x i32> %or, <4 x i32> <i32 25, i32 25, i32 25, i32 25>)
  %r = icmp eq <4 x i32> %f, zeroinitializer
  ret <4 x i1> %r
}

define i1 @fshr_or_eq_0(i16 %x, i16 %y) {
; CHECK-LABEL: fshr_or_eq_0:
; CHECK:       // %bb.0:
; CHECK-NEXT:    orr w8, w0, w1, lsl #8
; CHECK-NEXT:    tst w8, #0xffff
; CHECK-NEXT:    cset w0, eq
; CHECK-NEXT:    ret
  %or = or i16 %x, %y
  %f = call i16 @llvm.fshr.i16(i16 %or, i16 %x, i16 8)
  %r = icmp eq i16 %f, 0
  ret i1 %r
}

define i1 @fshr_or_commute_eq_0(i16 %x, i16 %y) {
; CHECK-LABEL: fshr_or_commute_eq_0:
; CHECK:       // %bb.0:
; CHECK-NEXT:    orr w8, w0, w1, lsl #8
; CHECK-NEXT:    tst w8, #0xffff
; CHECK-NEXT:    cset w0, eq
; CHECK-NEXT:    ret
  %or = or i16 %y, %x
  %f = call i16 @llvm.fshr.i16(i16 %or, i16 %x, i16 8)
  %r = icmp eq i16 %f, 0
  ret i1 %r
}

define i1 @fshr_or2_eq_0(i64 %x, i64 %y) {
; CHECK-LABEL: fshr_or2_eq_0:
; CHECK:       // %bb.0:
; CHECK-NEXT:    orr x8, x0, x1, lsr #3
; CHECK-NEXT:    cmp x8, #0
; CHECK-NEXT:    cset w0, eq
; CHECK-NEXT:    ret
  %or = or i64 %x, %y
  %f = call i64 @llvm.fshr.i64(i64 %x, i64 %or, i64 3)
  %r = icmp eq i64 %f, 0
  ret i1 %r
}

define i1 @fshl_or_ne_0(i32 %x, i32 %y) {
; CHECK-LABEL: fshl_or_ne_0:
; CHECK:       // %bb.0:
; CHECK-NEXT:    orr w8, w0, w1, lsl #7
; CHECK-NEXT:    cmp w8, #0
; CHECK-NEXT:    cset w0, ne
; CHECK-NEXT:    ret
  %or = or i32 %x, %y
  %f = call i32 @llvm.fshl.i32(i32 %or, i32 %x, i32 7)
  %r = icmp ne i32 %f, 0
  ret i1 %r
}

define i1 @fshl_or_commute_ne_0(i32 %x, i32 %y) {
; CHECK-LABEL: fshl_or_commute_ne_0:
; CHECK:       // %bb.0:
; CHECK-NEXT:    orr w8, w0, w1, lsl #7
; CHECK-NEXT:    cmp w8, #0
; CHECK-NEXT:    cset w0, ne
; CHECK-NEXT:    ret
  %or = or i32 %y, %x
  %f = call i32 @llvm.fshl.i32(i32 %or, i32 %x, i32 7)
  %r = icmp ne i32 %f, 0
  ret i1 %r
}

define <4 x i1> @fshl_or2_ne_0(<4 x i32> %x, <4 x i32> %y) {
; CHECK-LABEL: fshl_or2_ne_0:
; CHECK:       // %bb.0:
; CHECK-NEXT:    ushr v1.4s, v1.4s, #27
; CHECK-NEXT:    orr v0.16b, v1.16b, v0.16b
; CHECK-NEXT:    cmtst v0.4s, v0.4s, v0.4s
; CHECK-NEXT:    xtn v0.4h, v0.4s
; CHECK-NEXT:    ret
  %or = or <4 x i32> %x, %y
  %f = call <4 x i32> @llvm.fshl.v4i32(<4 x i32> %x, <4 x i32> %or, <4 x i32> <i32 5, i32 5, i32 5, i32 5>)
  %r = icmp ne <4 x i32> %f, zeroinitializer
  ret <4 x i1> %r
}

define <4 x i1> @fshl_or2_commute_ne_0(<4 x i32> %x, <4 x i32> %y) {
; CHECK-LABEL: fshl_or2_commute_ne_0:
; CHECK:       // %bb.0:
; CHECK-NEXT:    ushr v1.4s, v1.4s, #27
; CHECK-NEXT:    orr v0.16b, v1.16b, v0.16b
; CHECK-NEXT:    cmtst v0.4s, v0.4s, v0.4s
; CHECK-NEXT:    xtn v0.4h, v0.4s
; CHECK-NEXT:    ret
  %or = or <4 x i32> %y, %x
  %f = call <4 x i32> @llvm.fshl.v4i32(<4 x i32> %x, <4 x i32> %or, <4 x i32> <i32 5, i32 5, i32 5, i32 5>)
  %r = icmp ne <4 x i32> %f, zeroinitializer
  ret <4 x i1> %r
}

define i1 @fshr_or_ne_0(i64 %x, i64 %y) {
; CHECK-LABEL: fshr_or_ne_0:
; CHECK:       // %bb.0:
; CHECK-NEXT:    orr x8, x0, x1, lsl #63
; CHECK-NEXT:    cmp x8, #0
; CHECK-NEXT:    cset w0, ne
; CHECK-NEXT:    ret
  %or = or i64 %x, %y
  %f = call i64 @llvm.fshr.i64(i64 %or, i64 %x, i64 1)
  %r = icmp ne i64 %f, 0
  ret i1 %r
}

define i1 @fshr_or_commute_ne_0(i64 %x, i64 %y) {
; CHECK-LABEL: fshr_or_commute_ne_0:
; CHECK:       // %bb.0:
; CHECK-NEXT:    orr x8, x0, x1, lsl #63
; CHECK-NEXT:    cmp x8, #0
; CHECK-NEXT:    cset w0, ne
; CHECK-NEXT:    ret
  %or = or i64 %y, %x
  %f = call i64 @llvm.fshr.i64(i64 %or, i64 %x, i64 1)
  %r = icmp ne i64 %f, 0
  ret i1 %r
}

define i1 @fshr_or2_ne_0(i16 %x, i16 %y) {
; CHECK-LABEL: fshr_or2_ne_0:
; CHECK:       // %bb.0:
; CHECK-NEXT:    and w8, w1, #0xfffc
; CHECK-NEXT:    orr w8, w0, w8, lsr #2
; CHECK-NEXT:    tst w8, #0xffff
; CHECK-NEXT:    cset w0, ne
; CHECK-NEXT:    ret
  %or = or i16 %x, %y
  %f = call i16 @llvm.fshr.i16(i16 %x, i16 %or, i16 2)
  %r = icmp ne i16 %f, 0
  ret i1 %r
}

define i1 @fshr_or2_commute_ne_0(i16 %x, i16 %y) {
; CHECK-LABEL: fshr_or2_commute_ne_0:
; CHECK:       // %bb.0:
; CHECK-NEXT:    and w8, w1, #0xfffc
; CHECK-NEXT:    orr w8, w0, w8, lsr #2
; CHECK-NEXT:    tst w8, #0xffff
; CHECK-NEXT:    cset w0, ne
; CHECK-NEXT:    ret
  %or = or i16 %y, %x
  %f = call i16 @llvm.fshr.i16(i16 %x, i16 %or, i16 2)
  %r = icmp ne i16 %f, 0
  ret i1 %r
}

define i1 @fshl_xor_eq_0(i32 %x, i32 %y) {
; CHECK-LABEL: fshl_xor_eq_0:
; CHECK:       // %bb.0:
; CHECK-NEXT:    eor w8, w0, w1
; CHECK-NEXT:    extr w8, w8, w0, #30
; CHECK-NEXT:    cmp w8, #0
; CHECK-NEXT:    cset w0, eq
; CHECK-NEXT:    ret
  %or = xor i32 %x, %y
  %f = call i32 @llvm.fshl.i32(i32 %or, i32 %x, i32 2)
  %r = icmp eq i32 %f, 0
  ret i1 %r
}

define i1 @fshl_or_sgt_0(i32 %x, i32 %y) {
; CHECK-LABEL: fshl_or_sgt_0:
; CHECK:       // %bb.0:
; CHECK-NEXT:    ror w8, w0, #30
; CHECK-NEXT:    orr w8, w8, w1, lsl #2
; CHECK-NEXT:    cmp w8, #0
; CHECK-NEXT:    cset w0, gt
; CHECK-NEXT:    ret
  %or = or i32 %x, %y
  %f = call i32 @llvm.fshl.i32(i32 %or, i32 %x, i32 2)
  %r = icmp sgt i32 %f, 0
  ret i1 %r
}

define i1 @fshl_or_ne_2(i32 %x, i32 %y) {
; CHECK-LABEL: fshl_or_ne_2:
; CHECK:       // %bb.0:
; CHECK-NEXT:    ror w8, w0, #30
; CHECK-NEXT:    orr w8, w8, w1, lsl #2
; CHECK-NEXT:    cmp w8, #2
; CHECK-NEXT:    cset w0, ne
; CHECK-NEXT:    ret
  %or = or i32 %x, %y
  %f = call i32 @llvm.fshl.i32(i32 %or, i32 %x, i32 2)
  %r = icmp ne i32 %f, 2
  ret i1 %r
}
