/**
 * Copyright (c) 2021 OceanBase
 * OceanBase CE is licensed under Mulan PubL v2.
 * You can use this software according to the terms and conditions of the Mulan PubL v2.
 * You may obtain a copy of Mulan PubL v2 at:
 *          http://license.coscl.org.cn/MulanPubL-2.0
 * THIS SOFTWARE IS PROVIDED ON AN "AS IS" BASIS, WITHOUT WARRANTIES OF ANY KIND,
 * EITHER EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED TO NON-INFRINGEMENT,
 * MERCHANTABILITY OR FIT FOR A PARTICULAR PURPOSE.
 * See the Mulan PubL v2 for more details.
 */

#ifdef CTX_ITEM_DEF
CTX_ITEM_DEF(DEFAULT_CTX_ID)
CTX_ITEM_DEF(DO_NOT_USE_ME)
CTX_ITEM_DEF(MEMSTORE_CTX_ID)
CTX_ITEM_DEF(EXECUTE_CTX_ID)
CTX_ITEM_DEF(TRANS_CTX_MGR_ID)
CTX_ITEM_DEF(PLAN_CACHE_CTX_ID)
CTX_ITEM_DEF(WORK_AREA)
CTX_ITEM_DEF(GLIBC)
CTX_ITEM_DEF(CO_STACK)
CTX_ITEM_DEF(LIBEASY)
CTX_ITEM_DEF(LOGGER_CTX_ID)
CTX_ITEM_DEF(KVSTORE_CACHE_ID)
CTX_ITEM_DEF(META_OBJ_CTX_ID)
CTX_ITEM_DEF(TX_CALLBACK_CTX_ID)
CTX_ITEM_DEF(LOB_CTX_ID)
CTX_ITEM_DEF(PS_CACHE_CTX_ID)
CTX_ITEM_DEF(RPC_CTX_ID)
CTX_ITEM_DEF(PKT_NIO)
CTX_ITEM_DEF(TX_DATA_TABLE)
CTX_ITEM_DEF(STORAGE_LONG_TERM_META_CTX_ID)
CTX_ITEM_DEF(MDS_DATA_ID)
CTX_ITEM_DEF(MDS_CTX_ID)
CTX_ITEM_DEF(SCHEMA_SERVICE)
CTX_ITEM_DEF(UNEXPECTED_IN_500)
CTX_ITEM_DEF(MERGE_RESERVE_CTX_ID)
CTX_ITEM_DEF(MERGE_NORMAL_CTX_ID)
CTX_ITEM_DEF(MAX_CTX_ID)
#endif

#ifdef SUB_CTX_ITEM_DEF
SUB_CTX_ITEM_DEF(TEST1)
SUB_CTX_ITEM_DEF(TEST2)
SUB_CTX_ITEM_DEF(THREAD_LOCAL_DECODE_CTX_ID)
SUB_CTX_ITEM_DEF(MAX_SUB_CTX_ID)
#endif

// Label does not need to be defined here, just pass char * directly in alloc,
// It is reserved here to be compatible with the existing code of the upper layer
#ifdef LABEL_ITEM_DEF
LABEL_ITEM_DEF(OB_MOD_DO_NOT_USE_ME, ModDoNotUseMe)
LABEL_ITEM_DEF(OB_TENANT_CTX_ALLOCATOR, TenantCtxAlloca)
LABEL_ITEM_DEF(OB_TENANT_MUTIL_ALLOCATOR, TenantMutilAllo)

//debug
LABEL_ITEM_DEF(OB_FIFO_ALLOC, FifoAlloc)
//end debug

///definemoduleshere
//commonmodules
LABEL_ITEM_DEF(OB_OBJ_FREELISTS, ObjFreelists)
LABEL_ITEM_DEF(OB_COMMON_NETWORK, CommonNetwork)
LABEL_ITEM_DEF(OB_THREAD_BUFFER, ThreadBuffer)
LABEL_ITEM_DEF(OB_KVSTORE_CACHE, KvstoreCache)
LABEL_ITEM_DEF(OB_KVSTORE_CACHE_ITERATOR, KvstorCacheIter)
LABEL_ITEM_DEF(OB_DIAGNOSE_INFO, DiagnoseInfo)
LABEL_ITEM_DEF(OB_SESSION_STAT, SessionStat)
LABEL_ITEM_DEF(OB_TENANT_INFO, TenantInfo)
LABEL_ITEM_DEF(OB_TSI_FACTORY, TsiFactory)
LABEL_ITEM_DEF(OB_COMMON_ARRAY, CommonArray)
LABEL_ITEM_DEF(OB_MYSQL_REQUEST_RECORD, MysqlRequesReco)
LABEL_ITEM_DEF(OB_MYSQL_MULTI_PACKETS, MysqlMultiPacke)
LABEL_ITEM_DEF(OB_SE_ARRAY, SeArray)
LABEL_ITEM_DEF(OB_2D_ARRAY, 2dArray)
LABEL_ITEM_DEF(OB_LIGHTY_QUEUE, LightyQueue)
LABEL_ITEM_DEF(OB_SEQ_QUEUE, SeqQueue)
LABEL_ITEM_DEF(OB_SCANNER, Scanner)
LABEL_ITEM_DEF(OB_NEW_SCANNER, NewScanner)
LABEL_ITEM_DEF(OB_BUFFER, Buffer)
LABEL_ITEM_DEF(OB_LOG_READER, LogReader)
LABEL_ITEM_DEF(OB_REGEX, Regex)
LABEL_ITEM_DEF(OB_HASH_BUCKET, HashBucket)
LABEL_ITEM_DEF(OB_HASH_NODE, HashNode)
LABEL_ITEM_DEF(OB_PAGE_ARENA, PageArena)
LABEL_ITEM_DEF(OB_STRING_BUF, StringBuf)
LABEL_ITEM_DEF(OB_SCHEMA, Schema)
LABEL_ITEM_DEF(OB_SCHEMA_SYS_SCHEMA, SchemaSysSchema)
LABEL_ITEM_DEF(OB_SCHEMA_ROW_KEY, SchemaRowKey)
LABEL_ITEM_DEF(OB_SCHEMA_PRIV_DB_PRIVS, SchePrivDbPrivs)
LABEL_ITEM_DEF(OB_SCHEMA_PRIV_TABLE_PRIVS, SchePrivTablPri)
LABEL_ITEM_DEF(OB_SCHEMA_PRIV_TABLE_PRIV_MAP, SchePriTabPriMa)
LABEL_ITEM_DEF(OB_SCHEMA_PRIV_SYS_PRIVS, SchePrivSysPriv)
LABEL_ITEM_DEF(OB_SCHEMA_PRIV_OBJ_PRIVS, SchePrivObjPriv)
LABEL_ITEM_DEF(OB_SCHEMA_PRIV_OBJ_PRIV_MAP, SchePriObjPriMa)
LABEL_ITEM_DEF(OB_SCHEMA_OPERATOR_SET_WITH_ALLOC, ScheOpeSetWitAl)
LABEL_ITEM_DEF(OB_SCHEMA_TABLE_ID_MAP, ScheTablIdMap)
LABEL_ITEM_DEF(OB_SCHEMA_TABLE_NAME_MAP, ScheTablNameMap)
LABEL_ITEM_DEF(OB_SCHEMA_INDEX_NAME_MAP, ScheIndeNameMap)
LABEL_ITEM_DEF(OB_SCHEMA_FOREIGN_KEY_NAME_MAP, ScheForKeyNamMa)
LABEL_ITEM_DEF(OB_SCHEMA_CONSTRAINT_NAME_MAP, ScheConsNameMap)
LABEL_ITEM_DEF(OB_SCHEMA_DATABASE_NAME_MAP, ScheDataNameMap)
LABEL_ITEM_DEF(OB_SCHEMA_TENANT_INFO_VEC, ScheTenaInfoVec)
LABEL_ITEM_DEF(OB_SCHEMA_USER_INFO_VEC, ScheUserInfoVec)
LABEL_ITEM_DEF(OB_SCHEMA_DB_INFO_VEC, ScheDbInfoVec)
LABEL_ITEM_DEF(OB_SCHEMA_TABLEG_INFO_VEC, ScheTablInfoVec)
LABEL_ITEM_DEF(OB_SCHEMA_TABLE_INFO_VEC, ScheTablInfoVec)
LABEL_ITEM_DEF(OB_SCHEMA_INDEX_INFO_VEC, ScheIndeInfoVec)
LABEL_ITEM_DEF(OB_SCHEMA_AUX_VP_INFO_VEC, ScheAuxVpInfoVe)
LABEL_ITEM_DEF(OB_SCHEMA_AUX_VP_NAME_VEC, ScheAuxVpNameVe)
LABEL_ITEM_DEF(OB_SCHEMA_LOB_META_INFO_VEC, ScheLobMInfoVec)
LABEL_ITEM_DEF(OB_SCHEMA_LOB_PIECE_INFO_VEC, ScheLobPInfoVec)
LABEL_ITEM_DEF(OB_SCHEMA_MLOG_INFO_VEC, ScheMLogInfoVec)
LABEL_ITEM_DEF(OB_SCHEMA_PRIV, SchemaPriv)
LABEL_ITEM_DEF(OB_SCHEMA_ID_VERSIONS, SchemaIdVersion)
LABEL_ITEM_DEF(OB_SCHEMA_CACHE_SYS_CACHE_MAP, ScheCacSysCacMa)
LABEL_ITEM_DEF(OB_SCHEMA_GETTER_GUARD, SchemaGetteGuar)
LABEL_ITEM_DEF(OB_SCHEMA_LABEL_SE_POLICY, ScheLabeSePolic)
LABEL_ITEM_DEF(OB_SCHEMA_LABEL_SE_COMPONENT, ScheLabeSeCompo)
LABEL_ITEM_DEF(OB_SCHEMA_LABEL_SE_LABEL, ScheLabeSeLabel)
LABEL_ITEM_DEF(OB_SCHEMA_LABEL_SE_USER_LEVEL, ScheLabSeUserLe)
LABEL_ITEM_DEF(OB_SCHEMA_MGR, SchemaMgr)
LABEL_ITEM_DEF(OB_SCHEMA_OB_SCHEMA_ARENA, ScheObSchemAren)
LABEL_ITEM_DEF(OB_SCHEMA_SERVICE, SchemaService)
LABEL_ITEM_DEF(OB_SCHEMA_OUTLINE_INFO_VECTOR, ScheOutlInfoVec)
LABEL_ITEM_DEF(OB_SCHEMA_OUTLINE_ID_MAP, ScheOutlIdMap)
LABEL_ITEM_DEF(OB_SCHEMA_OUTLINE_NAME_MAP, ScheOutlNameMap)
LABEL_ITEM_DEF(OB_SCHEMA_OUTLINE_SQL_MAP, ScheOutlSqlMap)
LABEL_ITEM_DEF(OB_SCHEMA_ROUTINE_INFO_VECTOR, ScheRoutInfoVec)
LABEL_ITEM_DEF(OB_SCHEMA_ROUTINE_ID_MAP, ScheRoutIdMap)
LABEL_ITEM_DEF(OB_SCHEMA_ROUTINE_NAME_MAP, ScheRoutNameMap)
LABEL_ITEM_DEF(OB_SCHEMA_PACKAGE_INFO_VECTOR, SchePackInfoVec)
LABEL_ITEM_DEF(OB_SCHEMA_PACKAGE_ID_MAP, SchePackIdMap)
LABEL_ITEM_DEF(OB_SCHEMA_PACKAGE_NAME_MAP, SchePackNameMap)
LABEL_ITEM_DEF(OB_SCHEMA_TRIGGER_INFO_VECTOR, ScheTrigInfoVec)
LABEL_ITEM_DEF(OB_SCHEMA_TRIGGER_ID_MAP, ScheTrigIdMap)
LABEL_ITEM_DEF(OB_SCHEMA_TRIGGER_NAME_MAP, ScheTrigNameMap)
LABEL_ITEM_DEF(OB_SCHEMA_UDT_INFO_VECTOR, ScheUdtInfoVect)
LABEL_ITEM_DEF(OB_SCHEMA_UDT_ID_MAP, ScheUdtIdMap)
LABEL_ITEM_DEF(OB_SCHEMA_UDT_NAME_MAP, ScheUdtNameMap)
LABEL_ITEM_DEF(OB_SCHEMA_SYNONYM, SchemaSynonym)
LABEL_ITEM_DEF(OB_SCHEMA_UDF, SchemaUdf)
LABEL_ITEM_DEF(OB_SCHEMA_SYS_VARIABLE, SchemaSysVariab)
LABEL_ITEM_DEF(OB_SCHEMA_SEQUENCE, SchemaSequence)
LABEL_ITEM_DEF(OB_SCHEMA_KEYSTORE, SchemaKeystore)
LABEL_ITEM_DEF(OB_SCHEMA_TABLESPACE, SchemaTablespac)
LABEL_ITEM_DEF(OB_SCHEMA_SECURITY_AUDIT, SchemaSecurAudi)
LABEL_ITEM_DEF(OB_WAITABLE_POOL, WaitablePool)
LABEL_ITEM_DEF(OB_PLAN_EXECUTE, PlanExecute)
LABEL_ITEM_DEF(OB_MODULE_PAGE_ALLOCATOR, ModulePageAlloc)
LABEL_ITEM_DEF(OB_FIXED_SIZE_BLOCK_ALLOCATOR, FixeSizeBlocAll)
LABEL_ITEM_DEF(OB_RESULT_SET, ResultSet)
LABEL_ITEM_DEF(OB_FIXED_QUEUE, FixedQueue)
LABEL_ITEM_DEF(OB_POOL, Pool)
LABEL_ITEM_DEF(OB_BLOOM_FILTER, BloomFilter)
LABEL_ITEM_DEF(COMPACT_ROW, CompactRow)
LABEL_ITEM_DEF(BUCKET_LOCK, BucketLock)
LABEL_ITEM_DEF(ID_MAP, IdMap)
LABEL_ITEM_DEF(LIB_OBSQL, LibObsql)
LABEL_ITEM_DEF(BLOCK_ALLOC, BlockAlloc)
LABEL_ITEM_DEF(VECTOR, Vector)
LABEL_ITEM_DEF(TEST, Test)
LABEL_ITEM_DEF(OB_OSS, Oss)
LABEL_ITEM_DEF(MYSQL_CLIENT_CACHE, MysqlClientCach)
LABEL_ITEM_DEF(ACK_QUEUE, AckQueue)
LABEL_ITEM_DEF(BALANCE_FILTER, BalanceFilter)
LABEL_ITEM_DEF(JSON_PARSER, JsonParser)
LABEL_ITEM_DEF(OB_HASH_BUCKET_CONF_CONTAINER, HashBuckConfCon)
LABEL_ITEM_DEF(OB_HASH_BUCKET_SQL_COLUMN_MAP, HashBucSqlColMa)
LABEL_ITEM_DEF(OB_HASH_BUCKET_TASK_MAP, HashBuckTaskMap)
LABEL_ITEM_DEF(OB_HASH_NODE_CONF_CONTAINER, HashNodeConfCon)
LABEL_ITEM_DEF(OB_HASH_NODE_SQL_COLUMN_MAP, HashNodSqlColMa)
LABEL_ITEM_DEF(OB_HASH_NODE_NEXT_WAIT_MAP, HashNodNexWaiMa)
LABEL_ITEM_DEF(OB_SQL_STRING, SqlString)
LABEL_ITEM_DEF(OB_INNER_SQL_CONN_POOL, InneSqlConnPool)
LABEL_ITEM_DEF(OB_JSON_PARSER, JsonParser)
LABEL_ITEM_DEF(OB_LINEAR_HASH_MAP, LinearHashMap)
LABEL_ITEM_DEF(OB_AUTOINCREMENT, Autoincrement)
LABEL_ITEM_DEF(OB_CORE_TABLE_PROXY, CoreTableProxy)
LABEL_ITEM_DEF(OB_BIT_SET, BitSet)
LABEL_ITEM_DEF(OB_HASH_BUCKET_GLOBAL_STATUS_MAP, HashBucGloStaMa)
LABEL_ITEM_DEF(OB_HASH_BUCKET_SESSION_STATUS_MAP, HashBucSesStaMa)
LABEL_ITEM_DEF(OB_COMMON_SYS_VAR_FAC, CommSysVarFac)
LABEL_ITEM_DEF(OB_COMMON_SYS_VAR_DEFAULT_VALUE, CommSysVarDefVa)
LABEL_ITEM_DEF(OB_ASYNC_EXTERNAL_SORTER, AsyncExternSort)
LABEL_ITEM_DEF(OB_CORE_LOCAL_STORAGE, CoreLocalStorag)
LABEL_ITEM_DEF(OB_SMALL_OBJ_POOL, SmallObjPool)
LABEL_ITEM_DEF(OB_EXT_MS_QUEUE, ExtMsQueue)
LABEL_ITEM_DEF(OB_EXT_MS_QUEUE_QITEM, ExtMsQueueQitem)
LABEL_ITEM_DEF(OB_PARTITION_TABLE_TASK, PartitTableTask)
LABEL_ITEM_DEF(OB_TEMP_VARIABLES, TempVariables)
LABEL_ITEM_DEF(OB_OBJ_STORE, ObjStore)
LABEL_ITEM_DEF(OB_ARENA_HASH_JOIN, ArenaHashJoin)
LABEL_ITEM_DEF(OB_SCHEDULER, Scheduler)
LABEL_ITEM_DEF(OB_SERVER_LOCALITY_CACHE, ServerLocalCach)
LABEL_ITEM_DEF(OB_SERVER_CID_MAP, ServerCidMap)
LABEL_ITEM_DEF(OB_SERVER_REGION_MAP, ServerRegioMap)
LABEL_ITEM_DEF(OB_SERVER_IDC_MAP, ServerIdcMap)
LABEL_ITEM_DEF(OB_IO_CONTROL, IoControl)
LABEL_ITEM_DEF(OB_COMPRESSOR, Compressor)
LABEL_ITEM_DEF(OB_KVSTORE_CACHE_WASH_STRUCT, KvstCachWashStr)
LABEL_ITEM_DEF(OB_KVSTORE_CACHE_MB, KvstorCacheMb)
LABEL_ITEM_DEF(OB_SERVER_OBJECT_POOL, ServerObjecPool)
LABEL_ITEM_DEF(OB_MACRO_BLOCK_CHECKER, MacroBlockCheck)
LABEL_ITEM_DEF(OB_STREAM_COMPRESSOR, StreamCompresso)
LABEL_ITEM_DEF(OB_NUMBER, Number)
LABEL_ITEM_DEF(OB_SCHEMA_PROFILE, SchemaProfile)

//obproxy
LABEL_ITEM_DEF(OB_PROXY_SESSION, ProxySession)
LABEL_ITEM_DEF(OB_PROXY_DEFAULT_SYS_VARIABLE, ProxDefaSysVari)
LABEL_ITEM_DEF(SHARE_CS_FEEDBACKS, ShareCsFeedback)

//mergeservermodules
LABEL_ITEM_DEF(OB_MS_LOCATION_CACHE, MsLocatioCache)

LABEL_ITEM_DEF(OB_UPS_RESOURCE_POOL_NODE, UpsResouPoolNod)

//oceanbase server modules
LABEL_ITEM_DEF(OMT, Omt)
LABEL_ITEM_DEF(OMT_VIRTUAL_TABLE, OmtVirtualTable)
LABEL_ITEM_DEF(OMT_TENANT, OmtTenant)
LABEL_ITEM_DEF(OB_HASH_BUCKET_TABLE_STATISTICS, HashBuckTablSta)
LABEL_ITEM_DEF(OB_DUTY_TASK, DutyTask)

//chunkservermodules
LABEL_ITEM_DEF(OB_CS_SSTABLE_READER, CsSstableReader)
LABEL_ITEM_DEF(OB_CS_BUILD_INDEX, CsBuildIndex)
LABEL_ITEM_DEF(OB_CS_COMMON, CsCommon)

//sstablemodules
LABEL_ITEM_DEF(OB_SSTABLE, Sstable)
LABEL_ITEM_DEF(OB_SSTABLE_READER, SstableReader)
LABEL_ITEM_DEF(OB_SSTABLE_BLOCK_FILE, SstablBlockFile)
LABEL_ITEM_DEF(OB_MACRO_BLOCK_META, MacroBlockMeta)
LABEL_ITEM_DEF(OB_STORE_ROW_GETTER, StoreRowGetter)
LABEL_ITEM_DEF(OB_STORE_ROW_EXISTER, StoreRowExister)
LABEL_ITEM_DEF(OB_BUILD_INDEX_SCHEDULER, BuildIndexSched)
LABEL_ITEM_DEF(OB_LOB_READER, LobReader)
LABEL_ITEM_DEF(OB_BF_DATA_WRITER, BfDataWriter)
LABEL_ITEM_DEF(OB_ENCODER_ALLOCATOR, EncoderAllocato)
LABEL_ITEM_DEF(OB_SUPER_BLOCK_BUFFER, SuperBlockBuffe)
LABEL_ITEM_DEF(OB_DECODER_CTX, DecoderCtx)
LABEL_ITEM_DEF(OB_MACRO_BLOCK_WRITE_CTX, MacrBlocWritCtx)
LABEL_ITEM_DEF(OB_SSTABLE_MICRO_BLOCK_ALLOCATOR, SstaMicrBlocAll)
LABEL_ITEM_DEF(OB_STORE_ROW_LOCK_CHECKER, StorRowLockChec)

//obmysqlmodules
LABEL_ITEM_DEF(OB_MYSQL_PACKET, MysqlPacket)

//rootservermodules
LABEL_ITEM_DEF(OB_REFERED_MAP, ReferedMap)
LABEL_ITEM_DEF(OB_RS_PARTITION_TABLE_TEMP, RsPartiTableTem)
LABEL_ITEM_DEF(OB_ZONE_TABLE_UPDATER, ZoneTableUpdate)
LABEL_ITEM_DEF(OB_HASH_BUCKET_POOL_UNIT_MAP, HashBucPooUniMa)
LABEL_ITEM_DEF(OB_HASH_BUCKET_CONFIG_POOLS_MAP, HashBucConPooMa)
LABEL_ITEM_DEF(OB_HASH_BUCKET_SERVER_REF_COUNT_MAP, HasBucSerRefCoM)
LABEL_ITEM_DEF(OB_HASH_BUCKET_ID_UNIT_MAP, HashBucIdUnitMa)
LABEL_ITEM_DEF(OB_HASH_BUCKET_ID_CONFIG_MAP, HashBucIdConfMa)
LABEL_ITEM_DEF(OB_HASH_BUCKET_NAME_CONFIG_MAP, HashBucNamConMa)
LABEL_ITEM_DEF(OB_HASH_BUCKET_CONFIG_REF_COUNT_MAP, HasBucConRefCoM)
LABEL_ITEM_DEF(OB_HASH_BUCKET_ID_POOL_MAP, HashBucIdPoolMa)
LABEL_ITEM_DEF(OB_HASH_BUCKET_NAME_POOL_MAP, HashBucNamPooMa)
LABEL_ITEM_DEF(OB_HASH_BUCKET_SERVER_UNITLOAD_MAP, HashBucSerUniMa)
LABEL_ITEM_DEF(OB_HASH_BUCKET_TENANT_POOLS_MAP, HashBucTenPooMa)
LABEL_ITEM_DEF(OB_HASH_BUCKET_SERVER_MIGRATE_UNIT_MAP, HasBucSerMigUnM)
LABEL_ITEM_DEF(OB_RS_UNIT_MANAGER, RsUnitManager)
LABEL_ITEM_DEF(OB_HASH_BUCKET_RENAME_TABLE_MAP, HashBucRenTabMa)
LABEL_ITEM_DEF(OB_ASYNC_RPC_PROXY, AsyncRpcProxy)
LABEL_ITEM_DEF(OB_RS_EVENT_QUEUE, RsEventQueue)
LABEL_ITEM_DEF(OB_HASH_BUCKET_TABLEGROUP_MAP, HashBuckTablMap)
LABEL_ITEM_DEF(OB_HASH_BUCKET_TIME_ZONE_INFO_MAP, HasBucTimZonInM)
LABEL_ITEM_DEF(OB_INNER_LOB_HASH_SET, InnerLobHash)

//sqlmodules
//compile include parse, resolve, optimize, code generate
LABEL_ITEM_DEF(OB_SQL_COMPILE, SqlCompile)
LABEL_ITEM_DEF(OB_SQL_PARSER, SqlParser)
LABEL_ITEM_DEF(OB_SQL_SESSION, SqlSession)
LABEL_ITEM_DEF(OB_SQL_SESSION_WARNING_BUFFER, SqlSessiWarnBuf)
LABEL_ITEM_DEF(OB_SQL_SESSION_QUERY_SQL, SqlSessiQuerSql)
LABEL_ITEM_DEF(OB_SQL_ROW_STORE, SqlRowStore)
LABEL_ITEM_DEF(OB_SQL_CHUNK_ROW_STORE, SqlChunkRowStor)
LABEL_ITEM_DEF(OB_SQL_RES_TYPE, SqlResType)
LABEL_ITEM_DEF(OB_SQL_OPTIMIZER_SELECT_REPLICA, SqlOptimSeleRep)
LABEL_ITEM_DEF(OB_SQL_OPTIMIZER_EQUAL_SETS, SqlOptimEquaSet)
LABEL_ITEM_DEF(OB_SQL_EXECUTOR, SqlExecutor)
LABEL_ITEM_DEF(OB_SQL_EXECUTOR_TASK_INFO, SqlExecuTaskInf)
LABEL_ITEM_DEF(OB_SQL_EXECUTOR_TASK_SPLITER, SqlExecuTaskSpl)
LABEL_ITEM_DEF(OB_SQL_SCAN_PARAM, SqlScanParam)
LABEL_ITEM_DEF(OB_SQL_REQUEST, SqlRequest)
LABEL_ITEM_DEF(OB_SQL_EXPR, SqlExpr)
LABEL_ITEM_DEF(OB_SQL_EXPR_CALC, SqlExprCalc)
LABEL_ITEM_DEF(OB_SQL_EXPR_REPLACE, SqlExprReplace)
LABEL_ITEM_DEF(OB_SQL_AGGR_FUNC, SqlAggrFunc)
LABEL_ITEM_DEF(OB_SQL_AGGR_FUNC_ROW, SqlAggrFuncRow)
LABEL_ITEM_DEF(OB_SQL_AGGR_FUNC_ARR, SqlAggrFuncArr)
LABEL_ITEM_DEF(OB_SQL_AGGR_FUN_GROUP_CONCAT, SqlAggrFunGroCo)
LABEL_ITEM_DEF(OB_SQL_AGGR_CELL_CTX, SqlAggrCellCtx)
LABEL_ITEM_DEF(OB_SQL_INSERT, SqlInsert)
LABEL_ITEM_DEF(OB_SQL_MERGE_JOIN, SqlMergeJoin)
LABEL_ITEM_DEF(OB_SQL_TABLE_LOOKUP, SqlTableLookup)
LABEL_ITEM_DEF(OB_SQL_MERGE_GROUPBY, SqlMergeGroupby)
LABEL_ITEM_DEF(OB_SQL_PHY_PLAN, SqlPhyPlan)
LABEL_ITEM_DEF(OB_SQL_PHY_PL_OBJ, SqlPhyPlObj)
LABEL_ITEM_DEF(OB_SQL_CONNECTION_POOL, SqlConnectPool)
LABEL_ITEM_DEF(OB_SQL_SESSION_SBLOCK, SqlSessionSbloc)
LABEL_ITEM_DEF(OB_SQL_SESSION_VAR_MAP, SqlSessiVarMap)
LABEL_ITEM_DEF(OB_SQL_QUERY_RANGE, SqlQueryRange)
LABEL_ITEM_DEF(OB_SQL_PHY_PLAN_STRING, SqlPhyPlanStrin)
LABEL_ITEM_DEF(OB_SQL_NLJ_CACHE, SqlNljCache)
LABEL_ITEM_DEF(OB_QUERY_RANGE, QueryRange)
LABEL_ITEM_DEF(OB_QUERY_RANGE_CTX, QueryRangeCtx)
LABEL_ITEM_DEF(OB_VARIABLE_SET, VariableSet)
LABEL_ITEM_DEF(OB_SQL_EXEC_CONTEXT, SqlExecContext)
LABEL_ITEM_DEF(OB_SQL_CONTEXT, SqlContext)
LABEL_ITEM_DEF(OB_SQL_CG, SqlCg)
LABEL_ITEM_DEF(OB_SQL_PREPARED_SQL, SqlPrepareSql)
LABEL_ITEM_DEF(OB_SQL_TABLE_LOCATION, SqlTableLocatio)
LABEL_ITEM_DEF(OB_SQL_SORT_ROW, SqlSortRow)
LABEL_ITEM_DEF(OB_SQL_PLAN_MONITOR, SqlPlanMonitor)
LABEL_ITEM_DEF(OB_SQL_WINDOW_FUNC, SqlWindowFunc)
LABEL_ITEM_DEF(OB_SQL_WINDOW_LOCAL, SqlWindowLocal)
LABEL_ITEM_DEF(OB_SQL_WINDOW_ROW_STORE, SqlWindoRowStor)
LABEL_ITEM_DEF(OB_SQL_HASH_SET, SqlHashSet)

LABEL_ITEM_DEF(OB_SQL_CTE_ROW, SqlCteRow)
LABEL_ITEM_DEF(OB_SQL_UDF, SqlUdf)
LABEL_ITEM_DEF(OB_SQL_SEQUENCE, SqlSequence)

LABEL_ITEM_DEF(OB_SQL_DTL, SqlDtl)
LABEL_ITEM_DEF(OB_SQL_PX, SqlPx)
LABEL_ITEM_DEF(OB_SQL_SQC_HANDLER, SqlSqcHandler)
LABEL_ITEM_DEF(OB_SQL_PX_ASYNC_SQC_RPC, SqlPxAsynSqcRpc)

LABEL_ITEM_DEF(OB_SQL_LOAD_DATA, SqlLoadData)

LABEL_ITEM_DEF(OB_PL_TEMP, PlTemp)
LABEL_ITEM_DEF(OB_PL, Pl)

LABEL_ITEM_DEF(OB_HASH_BUCKET_SYS_CONF, HashBuckSysConf)
LABEL_ITEM_DEF(OB_HASH_BUCKET_PLAN_CACHE, HashBuckPlanCac)
LABEL_ITEM_DEF(OB_HASH_BUCKET_PS_CACHE, HashBuckPsCache)
LABEL_ITEM_DEF(OB_HASH_BUCKET_PS_INFO, HashBuckPsInfo)
LABEL_ITEM_DEF(OB_HASH_BUCKET_PS_SESSION_INFO, HashBucPsSessIn)
LABEL_ITEM_DEF(OB_HASH_BUCKET_LC_STAT, HashBuckLCSta)
LABEL_ITEM_DEF(OB_HASH_BUCKET_INTERRUPT_CHECKER, HashBuckInteChe)
LABEL_ITEM_DEF(OB_INTERRUPT_CHECKER_NODE, InterrCheckNode)
LABEL_ITEM_DEF(OB_HASH_BUCKET_TENANT_COMPAT_MODE, HashBucTenComMo)
LABEL_ITEM_DEF(OB_HASH_BUCKET_MASTER_KEY, HashBuckMastKey)
LABEL_ITEM_DEF(OB_HASH_PX_BLOOM_FILTER_KEY, HashPxBlooFilKe)
LABEL_ITEM_DEF(OB_HASH_NODE_GROUP_ROWS, HashNodeGrouRow)
LABEL_ITEM_DEF(OB_HASH_NODE_PLAN_CACHE, HashNodePlanCac)
LABEL_ITEM_DEF(OB_HASH_NODE_PS_CACHE, HashNodePsCache)
LABEL_ITEM_DEF(OB_HASH_NODE_PS_INFO, HashNodePsInfo)
LABEL_ITEM_DEF(OB_HASH_NODE_PS_SESSION_INFO, HashNodPsSessIn)
LABEL_ITEM_DEF(OB_HASH_NODE_LC_STAT, HashNodeLCSta)
LABEL_ITEM_DEF(OB_HASH_NODE_INTERRUPT_CHECKER, HashNodeInteChe)
LABEL_ITEM_DEF(OB_HASH_NODE_TENANT_COMPAT_MODE, HashNodTenComMo)
LABEL_ITEM_DEF(OB_HASH_NODE_MASTER_KEY, HashNodeMastKey)
LABEL_ITEM_DEF(OB_HASH_NODE_PX_BLOOM_FILTER_KEY, HasNodPxBloFilK)
LABEL_ITEM_DEF(OB_SQL_PARAMETERIZATION, SqlParameteriza)
LABEL_ITEM_DEF(OB_SQL_PLAN_CACHE, SqlPlanCache)
LABEL_ITEM_DEF(OB_SQL_PS_CACHE, SqlPsCache)
LABEL_ITEM_DEF(OB_PS_SESSION_INFO_ARRAY, PsSessiInfoArra)
LABEL_ITEM_DEF(OB_CONNECT_BY_PUMP, ConnectByPump)

//mpimodules
LABEL_ITEM_DEF(OB_MPI, Mpi)

//liboblog start
LABEL_ITEM_DEF(OB_LOG_BINLOG_RECORD, LogBinlogRecord)
LABEL_ITEM_DEF(OB_LOG_BINLOG_RECORD_POOL, LogBinloRecoPoo)
LABEL_ITEM_DEF(OB_LOG_FETCHER, LogFetcher)
LABEL_ITEM_DEF(OB_LOG_PART_INFO, LogPartInfo)
LABEL_ITEM_DEF(OB_LOG_PART_TRANS_TASK_SMALL, LogPartTraTasSm)
LABEL_ITEM_DEF(OB_LOG_PART_TRANS_TASK_LARGE, LogPartTraTasLa)
LABEL_ITEM_DEF(OB_LOG_PART_TRANS_TASK_POOL, LSTranTaskPool)
LABEL_ITEM_DEF(OB_LOG_PART_TRANS_TASK_PREALLOC_PAGE, LSTranTasPreaPa)
LABEL_ITEM_DEF(OB_LOG_DATABASE_META_MAP, LogDatabMetaMap)
LABEL_ITEM_DEF(OB_LOG_TABLE_META_MAP, LogTableMetaMap)
LABEL_ITEM_DEF(OB_LOG_META_INFO, LogMetaInfo)
LABEL_ITEM_DEF(OB_LOG_FORMATTER, LogFormatter)
LABEL_ITEM_DEF(OB_LOG_SERVER_PROVIDER, LogServerProvid)
LABEL_ITEM_DEF(OB_LOG_TRANS_CTX, LogTransCtx)
LABEL_ITEM_DEF(OB_LOG_GLOBAL_NORMAL_INDEX_CACHE, LogGlobNorIndCa)
LABEL_ITEM_DEF(OB_LOG_TABLE_ID_CACHE, LogTableIdCache)
LABEL_ITEM_DEF(OB_LOG_TENANT_STAT_INFO, LogTenanStatInf)
LABEL_ITEM_DEF(OB_LOG_TENANT_STAT_MAP, LogTenanStatMap)
LABEL_ITEM_DEF(OB_LOG_TEMP_MEMORY, LogTempMemory)
LABEL_ITEM_DEF(OB_LOG_START_LOG_ID_LOCATOR, LogStarLogIdLoc)
LABEL_ITEM_DEF(OB_LOG_PART_FETCH_CTX, LogPartFetchCtx)
LABEL_ITEM_DEF(OB_LOG_PART_FETCH_CTX_MAP, LogPartFetCtxMa)
LABEL_ITEM_DEF(OB_LOG_PART_FETCH_CTX_POOL, LogPartFetCtxPo)
LABEL_ITEM_DEF(OB_LOG_FETCHER_IDLE_POOL, LogFetchIdlePoo)
LABEL_ITEM_DEF(OB_LOG_FETCHER_DEAD_POOL, LogFetchDeadPoo)
LABEL_ITEM_DEF(OB_LOG_MYSQL_CONNECTOR, LogMysqlConnect)
LABEL_ITEM_DEF(OB_LOG_ALL_SERVER_CACHE, LogAllServeCach)
LABEL_ITEM_DEF(OB_LS_WORKER_THREAD, LogStreaWorkThr)
LABEL_ITEM_DEF(OB_LOG_SVR_STREAM_MAP, LogSvrStreaMap)
LABEL_ITEM_DEF(OB_LOG_SVR_STREAM_POOL, LogSvrStreaPool)
LABEL_ITEM_DEF(OB_LOG_FETCH_STREAM_POOL, LogFetchStrePoo)
LABEL_ITEM_DEF(OB_LOG_TIMER, LogTimer)
LABEL_ITEM_DEF(OB_LOG_PART_PROGRESS_CONTROLLER, LogPartProgrCon)
LABEL_ITEM_DEF(OB_LOG_PART_TRANS_RESOLVER, LogPartTransRes)
LABEL_ITEM_DEF(OB_LOG_FETCH_LOG_ARPC_RES_QUEUE, LogFetcArpcResQ)
LABEL_ITEM_DEF(OB_LOG_FETCH_LOG_ARPC_RESULT, LogFetcArpcRes)
LABEL_ITEM_DEF(OB_LOG_FETCH_LOG_ARPC_REQUEST, LogFetcArpcReq)
LABEL_ITEM_DEF(OB_LOG_FETCH_LOG_SRPC, LogFetchSrpc)
LABEL_ITEM_DEF(OB_LOG_CONFIG, LogConfig)
LABEL_ITEM_DEF(OB_LOG_COMMITTER_CHECKPOINT_QUEUE, LogCommiChecQue)
LABEL_ITEM_DEF(OB_LOG_DML_PARSER, LogDmlParser)
LABEL_ITEM_DEF(OB_LOG_BATCH_SQL_QUERY, LogBatchSqlQuer)
LABEL_ITEM_DEF(OB_LOG_PART_SVR_LIST, LogPartSvrList)
LABEL_ITEM_DEF(OB_LOG_PART_SVR_LIST_BLACK_LIST, LogParSvrLisBlL)
LABEL_ITEM_DEF(OB_LOG_PART_SVR_LIST_HISTORY_LIST, LogParSvrLisHiL)
LABEL_ITEM_DEF(OB_LOG_HBASE_COLUMN_ID_MAP, LogHbasColIdMap)
LABEL_ITEM_DEF(OB_LOG_TABLE_SCHEMA_META_MAP, LogTablSchMetMa)
LABEL_ITEM_DEF(OB_LOG_TENANT_MAP, LogTenantMap)
LABEL_ITEM_DEF(OB_LOG_TENANT_TASK_QUEUE, LogTenanTaskQue)
LABEL_ITEM_DEF(OB_LOG_ALL_SERVER_ARRAY, LogAllServeArra)
//liboblog end

// election
LABEL_ITEM_DEF(OB_ELECTION, Election)
LABEL_ITEM_DEF(OBCG_ELECTION, ElectionGroup)
LABEL_ITEM_DEF(OB_ELECTION_MGR, ElectionMgr)
LABEL_ITEM_DEF(OB_ELECTION_ASYNC_LOG, ElectiAsyncLog)

// memtable
LABEL_ITEM_DEF(OB_CHECKSUM_CHECKER, ChecksumChecker)
LABEL_ITEM_DEF(OB_MEMTABLE_COMPACT_WRITER_BUFFER, MemtCompWritBuf)
LABEL_ITEM_DEF(OB_MEMTABLE_OBJECT, MemtableObject)
LABEL_ITEM_DEF(OB_MEMTABLE_CALLBACK, MemtableCallbac)
LABEL_ITEM_DEF(OB_QUERY_ALLOCATOR, QueryAllocator)

// storage
LABEL_ITEM_DEF(OB_PARTITION, Partition)
LABEL_ITEM_DEF(OB_PARTITION_SPLIT, PartitioSplit)
LABEL_ITEM_DEF(OB_PARTITION_STORAGE, PartitioStorage)
LABEL_ITEM_DEF(OB_PARTITION_SERVICE, PartitioService)
LABEL_ITEM_DEF(OB_MEMSTORE_ALLOCATOR, MemstoreAllocat)
LABEL_ITEM_DEF(OB_MEMSTORE, Memstore)
LABEL_ITEM_DEF(OB_TRANS_SERVICE, TransService)
LABEL_ITEM_DEF(OB_TABLE_SCAN_ITER, TableScanIter)
LABEL_ITEM_DEF(OB_FREEZE, Freeze)
LABEL_ITEM_DEF(OB_CALLBACK_TASK, CallbackTask)
LABEL_ITEM_DEF(OB_VALUE_ROW_ITER, ValueRowIter)
LABEL_ITEM_DEF(OB_COL_MAP, ColMap)
LABEL_ITEM_DEF(OB_PARTITION_SCAN_MERGE, PartitScanMerge)
LABEL_ITEM_DEF(OB_PARTITION_GET_MERGE, PartitGetMerge)
LABEL_ITEM_DEF(OB_SLOG_SCANNER, SlogScanner)
LABEL_ITEM_DEF(OB_SLOG_WRITER, SlogWriter)
LABEL_ITEM_DEF(OB_SYS_TASK_STATUS, SysTaskStatus)
LABEL_ITEM_DEF(OB_SSTABLE_MERGE_INFO, SstablMergeInfo)
LABEL_ITEM_DEF(OB_MACRO_FILE, MacroFile)
LABEL_ITEM_DEF(OB_TMP_FILE_MANAGER, TmpFileManager)
LABEL_ITEM_DEF(OB_TMP_FILE_STORE_MAP, TmpFileStoreMap)
LABEL_ITEM_DEF(OB_TMP_BLOCK_MAP, TmpBlockMap)
LABEL_ITEM_DEF(OB_TMP_BLOCK_MANAGER, TmpBlockManager)
LABEL_ITEM_DEF(OB_TMP_MAP, TmpMap)
LABEL_ITEM_DEF(OB_TMP_PAGE_CACHE, TmpPageCache)
LABEL_ITEM_DEF(OB_SSTABLE_CREATE_INDEX, SstablCreatInde)
LABEL_ITEM_DEF(OB_SSTABLE_LONG_OPS_MONITOR, SstaLongOpsMoni)
LABEL_ITEM_DEF(OB_TABLE_STORE_STAT_MGR, TablStorStatMgr)
LABEL_ITEM_DEF(OB_SSTABLE_CHECKSUM_CALCULATOR, SstablCheckCalc)
LABEL_ITEM_DEF(OB_REPLAY_STATUS, ReplayStatus)
LABEL_ITEM_DEF(OB_TENANT_ID_LIST, TenantIdList)
LABEL_ITEM_DEF(OB_BLOCK_INDEX_INTERMEDIATE, BlockIndexInter)
LABEL_ITEM_DEF(OB_CHECKPOINT, Checkpoint)
LABEL_ITEM_DEF(OB_STORAGE_FILE_BLOCK_REF, StorFileBlocRef)
LABEL_ITEM_DEF(OB_LOB_ACCESS_BUFFER, LobAccessBuf)

//apply_service
LABEL_ITEM_DEF(OB_LOG_APPLY_STATUS, LogApplyStatus)

//replay engine
LABEL_ITEM_DEF(OB_LOG_REPLAY_STATUS, LogReplayStatus)
LABEL_ITEM_DEF(OB_LOG_REPLAY_TASK, LogReplayTask)

//clog
LABEL_ITEM_DEF(OB_CLOG_SW, ClogSw)
LABEL_ITEM_DEF(OB_CLOG_RE, ClogRe)
LABEL_ITEM_DEF(OB_CLOG_GE, ClogGe)
LABEL_ITEM_DEF(OB_LOG_TASK, LogTask)
LABEL_ITEM_DEF(OB_LOG_TASK_BODY, LogTaskBody)
LABEL_ITEM_DEF(OB_SERVER_BLACKLIST, ServerBlacklist)
LABEL_ITEM_DEF(OB_FETCH_LOG_TASK, FetchLogTask)
LABEL_ITEM_DEF(OB_GC_LOG_BUFF, GCLOGBUFF)

LABEL_ITEM_DEF(OB_RPC, Rpc)
LABEL_ITEM_DEF(OB_RPC_STAT, RpcStat)
LABEL_ITEM_DEF(OB_RPC_PROCESSOR, RpcProcessor)
LABEL_ITEM_DEF(OB_RPC_BUFFER, RpcBuffer)

// transaction
LABEL_ITEM_DEF(OB_TRANS_CHECK, TransCheck)
LABEL_ITEM_DEF(OB_TRANS_VIRTUAL_TABLE_PARTITION, TranVirtTablPar)
LABEL_ITEM_DEF(OB_TRANS_VIRTUAL_TABLE_TRANS_STAT, TranVirTabTraSt)
LABEL_ITEM_DEF(OB_TRANS_VIRTUAL_TABLE_PARTITION_STAT, TranVirTabParSt)
LABEL_ITEM_DEF(OB_TRANS_VIRTUAL_TABLE_MEMORY_STAT, TranVirTabMemSt)
LABEL_ITEM_DEF(OB_TRANS_REDO_LOG_ID_ARRAY, TranRedLogIdArr)
LABEL_ITEM_DEF(OB_TRANS_CLOG_BUF, TransClogBuf)
LABEL_ITEM_DEF(OB_TRANS_MUTATOR_BUF, TransMutatoBuf)
LABEL_ITEM_DEF(OB_PARTITION_TRANS_CTX_MGR, PartTranCtxMgr)
LABEL_ITEM_DEF(OB_TRANS_PART_CTX, TransPartCtx)
LABEL_ITEM_DEF(OB_GTS_TASK, GtsTask)
LABEL_ITEM_DEF(OB_GTS_TASK_QUEUE, GtsTaskQueue)
LABEL_ITEM_DEF(OB_TRANS_AUDIT_RECORD, TransAuditRecor)
LABEL_ITEM_DEF(OB_PARTITION_AUDIT_INFO, PartitAuditInfo)
LABEL_ITEM_DEF(OB_DUP_TABLE_PARTITION_INFO, DupTablePartInf)
LABEL_ITEM_DEF(OB_DUP_TABLE_PARTITION_MGR, DupTablePartMgr)
LABEL_ITEM_DEF(OB_DUP_TABLE_LEASE_INFO, DupTableLeasInf)
LABEL_ITEM_DEF(OB_DUP_TABLE_REDO_SYNC_TASK, DupTablRedSynTa)
LABEL_ITEM_DEF(OB_GTI_RPC_PROXY, GtiRpcProxy)
LABEL_ITEM_DEF(OB_GTI_REQUEST_RPC, GtiRequestRpc)
LABEL_ITEM_DEF(OB_GTS_RPC_PROXY, GtsRpcProxy)
LABEL_ITEM_DEF(OB_GTS_REQUEST_RPC, GtsRequestRpc)
LABEL_ITEM_DEF(OB_END_TRANS_CB_TASK, EndTransCbTask)
LABEL_ITEM_DEF(OB_TRANS_CLOG_ENCRYPT_INFO, CLogEncryptInfo)

// rootservice
LABEL_ITEM_DEF(OB_LOCALITY_UTIL, LocalityUtil)

// storage_test
LABEL_ITEM_DEF(OB_RING_BUFFER, RingBuffer)
LABEL_ITEM_DEF(OB_CONCURRENT_HASH_MAP, ConcurHashMap)

//backup and restore
LABEL_ITEM_DEF(RESTORE, Restore)
LABEL_ITEM_DEF(BACKUP, Backup)
LABEL_ITEM_DEF(OB_LOG_ARCHIVE_SCHEDULER, LogArchiveSched)

LABEL_ITEM_DEF(OB_TRACE_LOG, TraceLog)
LABEL_ITEM_DEF(OB_LOG, Log)
LABEL_ITEM_DEF(OB_ASYNC_LOG, AsyncLog)
LABEL_ITEM_DEF(OB_ZLIB, Zlib)

// TABLE API
LABEL_ITEM_DEF(TABLE_PROC, TableProc)
LABEL_ITEM_DEF(TABLE_CLIENT, TableClient)
LABEL_ITEM_DEF(TABLE_BATCH_OPERATION, TableBatchOpera)
LABEL_ITEM_DEF(TABLE_BATCH_OPERATION_RESULT, TablBatcOperRes)

//schema
LABEL_ITEM_DEF(OB_TENANT_SCHEMA_MEM_MGR, TenaScheMemMgr)
LABEL_ITEM_DEF(OB_TENANT_SCHEMA_MGR, TenantSchemMgr)
LABEL_ITEM_DEF(OB_TENANT_SCHEMA_MEM_MGR_FOR_LIBOBLOG, TenSchMemMgrFoL)
LABEL_ITEM_DEF(OB_TENANT_SCHEMA_MGR_FOR_LIBOBLOG, TenaSchMgrForLi)
LABEL_ITEM_DEF(OB_SCHEMA_MGR_CACHE_MAP, ScheMgrCacheMap)
LABEL_ITEM_DEF(OB_REFRESH_FULL_SCHEMA_MAP, RefrFullScheMap)
LABEL_ITEM_DEF(OB_MEM_MGR_MAP, MemMgrMap)
LABEL_ITEM_DEF(OB_MEM_MGR_FOR_LIBOBLOG_MAP, MemMgrForLiboMa)
LABEL_ITEM_DEF(OB_TENANT_SCHEMA_FOR_CACHE_MAP, TenaSchForCacMa)
LABEL_ITEM_DEF(OB_SCHEMA_STATUS_MAP, SchemaStatuMap)
LABEL_ITEM_DEF(OB_TENANT_SPACE_TABLE_ID_SET, TenaSpaTabIdSet)
LABEL_ITEM_DEF(OB_SYS_TABLE_NAME_MAP, SysTableNameMap)
LABEL_ITEM_DEF(OB_SCHEMA_MGR_INFO_ARRAY, ScheMgrInfoArra)
LABEL_ITEM_DEF(OB_GEN_SCHEMA_VERSION_MAP, GenSchemVersMap)
LABEL_ITEM_DEF(OB_SCHEMA_DROP_TENANT_INFO_VEC, ScheDroTenInfVe)
LABEL_ITEM_DEF(OB_TABLE_NAME_WRAPPER_ARRAY, TablNameWrapArr)

// rc
LABEL_ITEM_DEF(OB_ROOT_CONTEXT, RootContext)

// dml
LABEL_ITEM_DEF(OB_DML_CHECK_ROWKEY_DISTINCT_BUCKET, DmlChecRowDisBu)
LABEL_ITEM_DEF(OB_DML_CHECK_ROWKEY_DISTINCT_NODE, DmlChecRowDisNo)

LABEL_ITEM_DEF(OB_MOD_END, ModEnd)
#endif

#ifndef __OB_COMMON_OB_MOD_DEFINE2_H__
#define __OB_COMMON_OB_MOD_DEFINE2_H__
#include <cstdint>

#include "lib/alloc/alloc_assist.h"
#include "lib/utility/ob_template_utils.h"

namespace oceanbase
{
namespace common
{

struct ObLabelItem
{
  ObLabelItem()
    : hold_(0), used_(0), count_(0), alloc_count_(0), free_count_(0)
    {}
  inline void update(int64_t hold, int64_t used)
  {
    if (hold > 0) {
      count_ += 1;
      alloc_count_++;
    } else if (hold < 0) {
      count_ -= 1;
      free_count_++;
    }
    used_ += used;
    hold_ += hold;
  }
  int64_t format_string(char *buf, int64_t len, const char *name) const;
  ObLabelItem &operator +=(const ObLabelItem &item)
  {
    hold_ += item.hold_;
    used_ += item.used_;
    count_ += item.count_;
    alloc_count_ += item.alloc_count_;
    free_count_ += item.free_count_;
    return *this;
  }
  // desc
  bool operator <(const ObLabelItem mi) const { return hold_ > mi.hold_; }
  void reset()
  {
    hold_ = 0;
    used_ = 0;
    count_ = 0;
    alloc_count_ = 0;
    free_count_ = 0;
  }
  int64_t hold_;
  int64_t used_;
  int64_t count_;
  int64_t alloc_count_;
  int64_t free_count_;
};


struct ObCtxIds
{
  enum ObCtxIdEnum
  {
#define CTX_ITEM_DEF(name) name,
#include "lib/allocator/ob_mod_define.h"
#undef CTX_ITEM_DEF
  };
};

class ObCtxInfo
{
public:
  enum { CTX_COUNT_LIMIT = ObCtxIds::MAX_CTX_ID };

  ObCtxInfo()
    : ctx_names_()
  {
#define CTX_ITEM_DEF(id) set_ctx_name(ObCtxIds::id, #id);
#include "lib/allocator/ob_mod_define.h"
#undef CTX_ITEM_DEF
  }
  const char* get_ctx_name(uint64_t ctx_id) const
  {
    const char *name = "INVALID_CTX_NAME";
    return ctx_id < ObCtxIds::MAX_CTX_ID ? ctx_names_[ctx_id] : name;
  }
  bool is_valid_ctx_name(const char *ctx_name, uint64_t& ctx_id) const;

private:
  void set_ctx_name(uint64_t ctx_id, const char *ctx_name)
  {
    if (ctx_id < ObCtxIds::MAX_CTX_ID) {
      ctx_names_[ctx_id] = ctx_name;
    }
  }

private:
  const char *ctx_names_[CTX_COUNT_LIMIT];
};

struct ObSubCtxIds
{
  enum ObSubCtxIdEnum
  {
#define SUB_CTX_ITEM_DEF(name) name,
#include "lib/allocator/ob_mod_define.h"
#undef SUB_CTX_ITEM_DEF
  };
};

struct ObModIds
{
#define LABEL_ITEM_DEF(name, real_name) static constexpr const char name[] = #real_name;
#include "lib/allocator/ob_mod_define.h"
#undef LABEL_ITEM_DEF
};

// for label cnt check
struct InnerModIds
{
  enum InnerModIdEnum
  {
  #define LABEL_ITEM_DEF(name, ...) name,
  #include "lib/allocator/ob_mod_define.h"
  #undef LABEL_ITEM_DEF
  };
  enum { LABEL_COUNT_LIMIT = InnerModIds::OB_MOD_END };
  STATIC_ASSERT(LABEL_COUNT_LIMIT == 453, "forbidden to add new label!!!");
};

#define ObNewModIds ObModIds
}; // end namespace common
}; // end namespace oceanbase

#endif /* __OB_COMMON_OB_MOD_DEFINE2_H__ */
