#ifndef ARCH_LOONGARCH_INSN_H
#define ARCH_LOONGARCH_INSN_H

#define insmask(x) (0xffffffff << (32 - (x)))

#define funccode(ins,x) ((ins) & insmask(x))

enum loongarch_opcodes
{
       INS_JIRL        = 0x4c000000,
       INS_BL          = 0x54000000,
       INS_MOVFR2GRS   = 0x0114b400,
       INS_MOVFR2GRD   = 0x0114b800,
       INS_MOVFRH2GRS  = 0x0114bc00,
       INS_MOVFCSR2GR  = 0x0114c800,
       INS_MOVCF2GR    = 0x0114dc00,
       INS_MOVGR2FCSR  = 0x0114c000,
       INS_MOVFR2CF    = 0x0114d000,
       INS_MOVGR2CF    = 0x0114d800,
       INS_STB         = 0x29000000,
       INS_STH         = 0x29400000,
       INS_STW         = 0x29800000,
       INS_STD         = 0x29c00000,
       INS_STXB        = 0x38100000,
       INS_STXH        = 0x38140000,
       INS_STXW        = 0x38180000,
       INS_STXD        = 0x381c0000,
       INS_STPTRW      = 0x25000000,
       INS_STPTRD      = 0x27000000,
       INS_SCW         = 0x21000000,
       INS_SCD         = 0x23000000,
       INS_FSTS        = 0x2b400000,
       INS_FSTD        = 0x2bc00000,
       INS_FSTXS       = 0x38380000,
       INS_FSTXD       = 0x383c0000,
       INS_LDGT        = 0x38780000,
       INS_LDLE        = 0x387a0000,
       INS_FLDGT       = 0x38740000,
       INS_FLDLE       = 0x38750000,
       INS_STGT        = 0x387c0000,
       INS_STLE        = 0x387e0000,
       INS_FSTGT       = 0x38760000,
       INS_FSTLE       = 0x38770000,
       INS_ARITH_IMM   = 0x02000000,
       INS_ARITH_IMM_2 = 0x10000000,
       INS_ARITH       = 0x00100000,
       INS_DIV_MOD     = 0x00200000,
       INS_SHIFT       = 0x00400000,
       INS_LLW         = 0x20000000,
       INS_LLD         = 0x22000000,
       INS_LDPTRW      = 0x24000000,
       INS_LDPTRD      = 0x26000000,
       INS_LD          = 0x28000000,
       INS_LDBU        = 0x2a000000,
       INS_LDHU        = 0x2a400000,
       INS_LDWU        = 0x2a800000,
       INS_LDXB        = 0x38000000,
       INS_LDXH        = 0x38040000,
       INS_LDXW        = 0x38080000,
       INS_LDXD        = 0x380c0000,
       INS_CLOZ_W      = 0x00001000,
       INS_CLOZ_D      = 0x00002000,
       INS_REVB        = 0x00003000,
       INS_REVH        = 0x00004000,
       INS_BITREVB     = 0x00004800,
       INS_BITREVWD    = 0x00005000,
       INS_EXT         = 0x00005800,
       INS_CPUCFG      = 0x00006c00,
       INS_ALSLW       = 0x00040000,
       INS_ALSLD       = 0x002c0000,
       INS_BYTEPICK    = 0x00080000,
       INS_CRC         = 0x00240000,
       INS_SLLIW       = 0x00408000,
       INS_SLLID       = 0x00410000,
       INS_SRLIW       = 0x00448000,
       INS_SRLID       = 0x00450000,
       INS_SRAIW       = 0x00488000,
       INS_SRAID       = 0x00490000,
       INS_ROTRIW      = 0x004c8000,
       INS_ROTRID      = 0x004d0000,
       INS_BSTR_W      = 0x00600000,
       INS_BSTR_D      = 0x00800000,
       INS_LDDIR       = 0x06400000,
       INS_JUMP        = 0x40000000,
       INS_ST          = 0x29000000,
       INS_RDTIMELW    = 0x00006000,
       INS_RDTIMEHW    = 0x00006400,
       INS_RDTIMED     = 0x00006800,
       INS_FLOAT_ARITH = 0x01000000,
       INS_FLOAT_MUL   = 0x08000000,
       INS_FLDS        = 0x2b000000,
       INS_FLDD        = 0x2b800000,
       INS_FLDXS       = 0x38300000,
       INS_FLDXD       = 0x38340000,
       INS_SIGNED_AM   = 0x38600000,
       INS_UNSIGNED_AM = 0x38700000,
       INS_COND_FLD    = 0x38740000,
       INS_COND_LD     = 0x38780000,
       INS_COND_FST    = 0x38760000,
       INS_COND_ST     = 0x387c0000,
       INS_CACOP       = 0x06000000,
       INS_TLBCLR      = 0x06482000,
       INS_TLBFLUSH    = 0x06482400,
       INS_TLBWR       = 0x06483000,
       INS_TLBFILL     = 0x06483400,
       INS_INVTLB      = 0x06498000,
       INS_IDLE        = 0x06488000,
       INS_PRELD       = 0x2ac00000,
       INS_PRELDX      = 0x382c0000,
       INS_DBAR        = 0x38720000,
       INS_IBAR        = 0x38728000,
       INS_FCMPCONDS   = 0x0c100000,
       INS_FCMPCONDD   = 0x0c200000,
       INS_SYSCALL     = 0x002b0000,
};

enum loongarch_opcode_mask_bit
{
       MASK_JIRL        = 6,
       MASK_BL          = 6,
       MASK_MOVFR2GRS   = 22,
       MASK_MOVFR2GRD   = 22,
       MASK_MOVFRH2GRS  = 22,
       MASK_MOVFCSR2GR  = 22,
       MASK_MOVCF2GR    = 24,
       MASK_MOVGR2FCSR  = 22,
       MASK_MOVFR2CF    = 22,
       MASK_MOVGR2CF    = 22,
       MASK_STB         = 12,
       MASK_STH         = 10,
       MASK_STW         = 10,
       MASK_STD         = 10,
       MASK_STXB        = 17,
       MASK_STXH        = 17,
       MASK_STXW        = 17,
       MASK_STXD        = 17,
       MASK_STPTRW      = 8,
       MASK_STPTRD      = 8,
       MASK_SCW         = 8,
       MASK_SCD         = 8,
       MASK_FSTS        = 10,
       MASK_FSTD        = 10,
       MASK_FSTXS       = 17,
       MASK_FSTXD       = 17,
       MASK_LDGT        = 15,
       MASK_LDLE        = 15,
       MASK_FLDGT       = 16,
       MASK_FLDLE       = 16,
       MASK_STGT        = 15,
       MASK_STLE        = 15,
       MASK_FSTGT       = 16,
       MASK_FSTLE       = 16,
       MASK_ARITH_IMM   = 7,
       MASK_ARITH_IMM_2 = 4,
       MASK_ARITH       = 12,
       MASK_DIV_MOD     = 14,
       MASK_SHIFT       = 10,
       MASK_LLW         = 8,
       MASK_LLD         = 8,
       MASK_LDPTRW      = 8,
       MASK_LDPTRD      = 8,
       MASK_LD          = 8,
       MASK_LDBU        = 10,
       MASK_LDHU        = 10,
       MASK_LDWU        = 10,
       MASK_LDXB        = 17,
       MASK_LDXH        = 17,
       MASK_LDXW        = 17,
       MASK_LDXD        = 17,
       MASK_CLOZ_W      = 20,
       MASK_CLOZ_D      = 20,
       MASK_REVB        = 20,
       MASK_REVH        = 21,
       MASK_BITREVB     = 21,
       MASK_BITREVWD    = 21,
       MASK_EXT         = 21,
       MASK_CPUCFG      = 22,
       MASK_ALSLW       = 14,
       MASK_ALSLD       = 15,
       MASK_BYTEPICK    = 13,
       MASK_CRC         = 14,
       MASK_SLLIW       = 17,
       MASK_SLLID       = 16,
       MASK_SRLIW       = 17,
       MASK_SRLID       = 16,
       MASK_SRAIW       = 17,
       MASK_SRAID       = 16,
       MASK_ROTRIW      = 17,
       MASK_ROTRID      = 16,
       MASK_BSTR_W      = 11,
       MASK_BSTR_D      = 9,
       MASK_LDDIR       = 14,
       MASK_JUMP        = 2,
       MASK_ST          = 8,
       MASK_RDTIMELW    = 22,
       MASK_RDTIMEHW    = 22,
       MASK_RDTIMED     = 22,
       MASK_FLOAT_ARITH = 8,
       MASK_FLOAT_MUL   = 6,
       MASK_FLDS        = 10,
       MASK_FLDD        = 10,
       MASK_FLDXS       = 16,
       MASK_FLDXD       = 16,
       MASK_SIGNED_AM   = 12,
       MASK_UNSIGNED_AM = 15,
       MASK_COND_FLD    = 15,
       MASK_COND_LD     = 14,
       MASK_COND_FST    = 15,
       MASK_COND_ST     = 14,
       MASK_CACOP       = 10,
       MASK_TLBCLR      = 32,
       MASK_TLBFLUSH    = 32,
       MASK_TLBWR       = 32,
       MASK_TLBFILL     = 32,
       MASK_INVTLB      = 17,
       MASK_IDLE        = 17,
       MASK_PRELD       = 11,
       MASK_PRELDX      = 17,
       MASK_DBAR        = 17,
       MASK_IBAR        = 17,
       MASK_FCMPCONDS   = 12,
       MASK_FCMPCONDD   = 12,
       MASK_SYSCALL     = 17,
};

#define is_ins(insval,mask,funccode) (((insval) & (insmask(mask))) == funccode)

#define is_data_process_ins(insval) \
       ((is_ins(insval,MASK_ARITH_IMM,INS_ARITH_IMM))          || \
        (is_ins(insval,MASK_ARITH,INS_ARITH))                  || \
        (is_ins(insval,MASK_SHIFT,INS_SHIFT))                  || \
        (is_ins(insval,MASK_LLW,INS_LLW))                      || \
        (is_ins(insval,MASK_LLD,INS_LLD))                      || \
        (is_ins(insval,MASK_LDPTRW,INS_LDPTRW))                || \
        (is_ins(insval,MASK_LDPTRD,INS_LDPTRD))                || \
        (is_ins(insval,MASK_LD,INS_LD))                        || \
        (is_ins(insval,MASK_LDBU,INS_LDBU))                    || \
        (is_ins(insval,MASK_LDHU,INS_LDHU))                    || \
        (is_ins(insval,MASK_LDWU,INS_LDWU))                    || \
        (is_ins(insval,MASK_LDXB,INS_LDXB))                    || \
        (is_ins(insval,MASK_LDXH,INS_LDXH))                    || \
        (is_ins(insval,MASK_LDXW,INS_LDXW))                    || \
        (is_ins(insval,MASK_LDXD,INS_LDXD))                    || \
        (is_ins(insval,MASK_CLOZ_W,INS_CLOZ_W))                || \
        (is_ins(insval,MASK_CLOZ_D,INS_CLOZ_D))                || \
        (is_ins(insval,MASK_REVB,INS_REVB))                    || \
        (is_ins(insval,MASK_REVH,INS_REVH))                    || \
        (is_ins(insval,MASK_BITREVB,INS_BITREVB))              || \
        (is_ins(insval,MASK_BITREVWD,INS_BITREVWD))            || \
        (is_ins(insval,MASK_EXT,INS_EXT))                      || \
        (is_ins(insval,MASK_CPUCFG,INS_CPUCFG))                || \
        (is_ins(insval,MASK_ALSLW,INS_ALSLW))                  || \
        (is_ins(insval,MASK_ALSLD,INS_ALSLD))                  || \
        (is_ins(insval,MASK_BYTEPICK,INS_BYTEPICK))            || \
        (is_ins(insval,MASK_DIV_MOD,INS_DIV_MOD))              || \
        (is_ins(insval,MASK_BSTR_D,INS_BSTR_D))                || \
        (is_ins(insval,MASK_LDDIR,INS_LDDIR))                  || \
        (is_ins(insval,MASK_ARITH_IMM_2,INS_ARITH_IMM_2))      || \
        (is_ins(insval,MASK_MOVFR2GRS,INS_MOVFR2GRS))          || \
        (is_ins(insval,MASK_MOVFR2GRD,INS_MOVFR2GRD))          || \
        (is_ins(insval,MASK_MOVFRH2GRS,INS_MOVFRH2GRS))        || \
        (is_ins(insval,MASK_MOVFCSR2GR,INS_MOVFCSR2GR))        || \
        (is_ins(insval,MASK_MOVCF2GR,INS_MOVCF2GR)))

#define is_jump_ins(insval) (is_ins(insval,MASK_JUMP,INS_JUMP))

#define is_read_time_ins(insval) \
       ((is_ins(insval,MASK_RDTIMELW,INS_RDTIMELW))            || \
        (is_ins(insval,MASK_RDTIMEHW,INS_RDTIMEHW))            || \
        (is_ins(insval,MASK_RDTIMED,INS_RDTIMED)))

#define is_float_ins(insval) \
       ((is_ins(insval,MASK_FLOAT_ARITH,INS_FLOAT_ARITH))      || \
        (is_ins(insval,MASK_FLOAT_MUL,INS_FLOAT_MUL))          || \
        (is_ins(insval,MASK_FLDS,INS_FLDS))                    || \
        (is_ins(insval,MASK_FLDD,INS_FLDD))                    || \
        (is_ins(insval,MASK_FLDXS,INS_FLDXS))                  || \
        (is_ins(insval,MASK_FLDXD,INS_FLDXD)))

#define is_nop_ins(insval) \
       ((is_ins(insval,MASK_CACOP,INS_CACOP))                  || \
        (is_ins(insval,MASK_TLBCLR,INS_TLBCLR))                || \
        (is_ins(insval,MASK_TLBFLUSH,INS_TLBFLUSH))            || \
        (is_ins(insval,MASK_TLBWR,INS_TLBWR))                  || \
        (is_ins(insval,MASK_TLBFILL,INS_TLBFILL))              || \
        (is_ins(insval,MASK_INVTLB,INS_INVTLB))                || \
        (is_ins(insval,MASK_IDLE,INS_IDLE))                    || \
        (is_ins(insval,MASK_PRELD,INS_PRELD))                  || \
        (is_ins(insval,MASK_PRELDX,INS_PRELDX))                || \
        (is_ins(insval,MASK_DBAR,INS_DBAR))                    || \
        (is_ins(insval,MASK_IBAR,INS_IBAR))                    || \
        (is_ins(insval,MASK_FCMPCONDS,INS_FCMPCONDS))          || \
        (is_ins(insval,MASK_FCMPCONDD,INS_FCMPCONDD))          || \
        (is_ins(insval,MASK_SYSCALL,INS_SYSCALL)))


#define is_am_ins(insval)              ((is_ins(insval,MASK_SIGNED_AM,INS_SIGNED_AM)) || (is_ins(insval,MASK_UNSIGNED_AM,INS_UNSIGNED_AM)))

#define is_cond_load_ins(insval)       ((is_ins(insval,MASK_COND_FLD,INS_COND_FLD)) || (is_ins(insval,MASK_COND_LD,INS_COND_LD)))

#define is_cond_store_ins(insval)      ((is_ins(insval,MASK_COND_FST,INS_COND_FST)) || (is_ins(insval,MASK_COND_ST,INS_COND_ST)))

#define is_cf_ins(insval)              ((is_ins(insval,MASK_MOVFR2CF,INS_MOVFR2CF)) || (is_ins(insval,MASK_MOVGR2CF,INS_MOVGR2CF)))

#define is_stb_ins(insval)             (is_ins(insval,MASK_STB,INS_STB))
#define is_sth_ins(insval)             (is_ins(insval,MASK_STH,INS_STH))
#define is_stw_ins(insval)             (is_ins(insval,MASK_STW,INS_STW))
#define is_std_ins(insval)             (is_ins(insval,MASK_STD,INS_STD))
#define is_stptrw_ins(insval)          (is_ins(insval,MASK_STPTRW,INS_STPTRW))
#define is_stptrd_ins(insval)          (is_ins(insval,MASK_STPTRD,INS_STPTRD))
#define is_scw_ins(insval)             (is_ins(insval,MASK_SCW,INS_SCW))
#define is_scd_ins(insval)             (is_ins(insval,MASK_SCD,INS_SCD))
#define is_fsts_ins(insval)            (is_ins(insval,MASK_FSTS,INS_FSTS))
#define is_fstd_ins(insval)            (is_ins(insval,MASK_FSTD,INS_FSTD))
#define is_fstxs_ins(insval)                   (is_ins(insval,MASK_FSTXS,INS_FSTXS))
#define is_fstxd_ins(insval)                   (is_ins(insval,MASK_FSTXD,INS_FSTXD))
#define is_stxb_ins(insval)            (is_ins(insval,MASK_STXB,INS_STXB))
#define is_stxh_ins(insval)            (is_ins(insval,MASK_STXH,INS_STXH))
#define is_stxw_ins(insval)            (is_ins(insval,MASK_STXW,INS_STXW))
#define is_stxd_ins(insval)            (is_ins(insval,MASK_STXD,INS_STXD))
#define is_movgr2fcsr_ins(insval)      (is_ins(insval,MASK_MOVGR2FCSR,INS_MOVGR2FCSR))
#define is_jirl_ins(insval)            (is_ins(insval,MASK_JIRL,INS_JIRL))
#define is_bl_ins(insval)              (is_ins(insval,MASK_BL,INS_BL))
#define is_ldgt_ins(insval)            (is_ins(insval,MASK_LDGT,INS_LDGT))
#define is_ldle_ins(insval)            (is_ins(insval,MASK_LDLE,INS_LDLE))
#define is_fldgt_ins(insval)                   (is_ins(insval,MASK_FLDGT,INS_FLDGT))
#define is_fldle_ins(insval)                   (is_ins(insval,MASK_FLDLE,INS_FLDLE))
#define is_stgt_ins(insval)            (is_ins(insval,MASK_STGT,INS_STGT))
#define is_stle_ins(insval)            (is_ins(insval,MASK_STLE,INS_STLE))
#define is_fstgt_ins(insval)                   (is_ins(insval,MASK_FSTGT,INS_FSTGT))
#define is_fstle_ins(insval)                   (is_ins(insval,MASK_FSTLE,INS_FSTLE))

#define is_store_ins(insval) \
       ((is_stb_ins(insval))           || \
        (is_sth_ins(insval))           || \
        (is_stw_ins(insval))           || \
        (is_std_ins(insval))           || \
        (is_stptrw_ins(insval))        || \
        (is_stptrd_ins(insval))        || \
        (is_scw_ins(insval))           || \
        (is_scd_ins(insval))           || \
        (is_fsts_ins(insval))          || \
        (is_fstd_ins(insval))          || \
        (is_stxb_ins(insval))          || \
        (is_stxh_ins(insval))          || \
        (is_stxw_ins(insval))          || \
        (is_stxd_ins(insval)))



#endif /* ARCH_LOONGARCH_INSN_H */

