import React, { PureComponent } from 'react';
import { DisplayValue, FieldConfig } from '@grafana/data';
import { VizTextDisplayOptions } from '@grafana/schema';
import { Themeable } from '../../types';
export interface Props extends Themeable {
    height: number;
    field: FieldConfig;
    showThresholdMarkers: boolean;
    showThresholdLabels: boolean;
    width: number;
    value: DisplayValue;
    text?: VizTextDisplayOptions;
    onClick?: React.MouseEventHandler<HTMLElement>;
    className?: string;
}
export declare class Gauge extends PureComponent<Props> {
    canvasElement: any;
    static defaultProps: Partial<Props>;
    componentDidMount(): void;
    componentDidUpdate(): void;
    draw(): void;
    renderVisualization: () => JSX.Element;
    render(): JSX.Element;
}
