import * as api from '@opentelemetry/api';
import * as metrics from '@opentelemetry/api-metrics';
import { ObservableCallback } from '@opentelemetry/api-metrics';
import { InstrumentDescriptor } from './InstrumentDescriptor';
import { ObservableRegistry } from './state/ObservableRegistry';
import { AsyncWritableMetricStorage, WritableMetricStorage } from './state/WritableMetricStorage';
export declare class SyncInstrument {
    private _writableMetricStorage;
    protected _descriptor: InstrumentDescriptor;
    constructor(_writableMetricStorage: WritableMetricStorage, _descriptor: InstrumentDescriptor);
    protected _record(value: number, attributes?: metrics.MetricAttributes, context?: api.Context): void;
}
/**
 * The class implements {@link metrics.UpDownCounter} interface.
 */
export declare class UpDownCounterInstrument extends SyncInstrument implements metrics.UpDownCounter {
    /**
     * Increment value of counter by the input. Inputs may be negative.
     */
    add(value: number, attributes?: metrics.MetricAttributes, ctx?: api.Context): void;
}
/**
 * The class implements {@link metrics.Counter} interface.
 */
export declare class CounterInstrument extends SyncInstrument implements metrics.Counter {
    /**
     * Increment value of counter by the input. Inputs may not be negative.
     */
    add(value: number, attributes?: metrics.MetricAttributes, ctx?: api.Context): void;
}
/**
 * The class implements {@link metrics.Histogram} interface.
 */
export declare class HistogramInstrument extends SyncInstrument implements metrics.Histogram {
    /**
     * Records a measurement. Value of the measurement must not be negative.
     */
    record(value: number, attributes?: metrics.MetricAttributes, ctx?: api.Context): void;
}
export declare class ObservableInstrument implements metrics.Observable {
    private _observableRegistry;
    /** @internal */
    _metricStorages: AsyncWritableMetricStorage[];
    /** @internal */
    _descriptor: InstrumentDescriptor;
    constructor(descriptor: InstrumentDescriptor, metricStorages: AsyncWritableMetricStorage[], _observableRegistry: ObservableRegistry);
    /**
     * @see {metrics.Observable.addCallback}
     */
    addCallback(callback: ObservableCallback): void;
    /**
     * @see {metrics.Observable.removeCallback}
     */
    removeCallback(callback: ObservableCallback): void;
}
export declare class ObservableCounterInstrument extends ObservableInstrument implements metrics.ObservableCounter {
}
export declare class ObservableGaugeInstrument extends ObservableInstrument implements metrics.ObservableGauge {
}
export declare class ObservableUpDownCounterInstrument extends ObservableInstrument implements metrics.ObservableUpDownCounter {
}
export declare function isObservableInstrument(it: unknown): it is ObservableInstrument;
//# sourceMappingURL=Instruments.d.ts.map