/*
 * Decompiled with CFR 0.152.
 */
package netscape.ldap;

import java.io.Serializable;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.StringTokenizer;
import java.util.Vector;
import netscape.ldap.LDAPAttribute;
import netscape.ldap.LDAPConnection;
import netscape.ldap.LDAPException;
import netscape.ldap.LDAPModificationSet;
import netscape.ldap.LDAPSchema;

public abstract class LDAPSchemaElement
implements Serializable {
    static final long serialVersionUID = -3972153461950418863L;
    public static final int unknown = 0;
    public static final int cis = 1;
    public static final int binary = 2;
    public static final int telephone = 3;
    public static final int ces = 4;
    public static final int dn = 5;
    public static final int integer = 6;
    protected static final String cisString = "1.3.6.1.4.1.1466.115.121.1.15";
    protected static final String binaryString = "1.3.6.1.4.1.1466.115.121.1.5";
    protected static final String telephoneString = "1.3.6.1.4.1.1466.115.121.1.50";
    protected static final String cesString = "1.3.6.1.4.1.1466.115.121.1.26";
    protected static final String intString = "1.3.6.1.4.1.1466.115.121.1.27";
    protected static final String dnString = "1.3.6.1.4.1.1466.115.121.1.12";
    public static final String OBSOLETE = "OBSOLETE";
    public static final String SUPERIOR = "SUP";
    public static final String SYNTAX = "SYNTAX";
    protected String oid = null;
    protected String name = "";
    protected String description = "";
    protected String attrName = null;
    protected String rawValue = null;
    protected String[] aliases = null;
    protected Hashtable<String, Object> properties = null;
    protected static Hashtable<String, String> novalsTable = new Hashtable();

    protected LDAPSchemaElement() {
    }

    protected LDAPSchemaElement(String name, String oid, String description) {
        this(name, oid, description, null);
    }

    protected LDAPSchemaElement(String name, String oid, String description, String[] aliases) {
        if (oid == null) {
            throw new IllegalArgumentException("OID required");
        }
        this.name = name;
        this.oid = oid;
        this.description = description;
        if (aliases != null && aliases.length > 0) {
            this.aliases = aliases;
        }
    }

    public String getName() {
        return this.name;
    }

    public String getID() {
        return this.oid;
    }

    @Deprecated
    public String getOID() {
        return this.getID();
    }

    public String getDescription() {
        return this.description;
    }

    protected void update(LDAPConnection ld, int op, LDAPAttribute attr, String dn) throws LDAPException {
        LDAPAttribute[] attrs = new LDAPAttribute[]{attr};
        this.update(ld, op, attrs, dn);
    }

    protected void update(LDAPConnection ld, int op, LDAPAttribute[] attrs, String dn) throws LDAPException {
        LDAPModificationSet mods = new LDAPModificationSet();
        for (int i = 0; i < attrs.length; ++i) {
            mods.add(op, attrs[i]);
        }
        String entryName = LDAPSchema.getSchemaDN(ld, dn);
        ld.modify(entryName, mods);
    }

    protected void update(LDAPConnection ld, int op, String name, String dn) throws LDAPException {
        boolean quotingBug = !LDAPSchema.isAttributeSyntaxStandardsCompliant(ld);
        LDAPAttribute attr = new LDAPAttribute(name, this.getValue(quotingBug));
        this.update(ld, op, attr, dn);
    }

    public void add(LDAPConnection ld, String dn) throws LDAPException {
        this.update(ld, 0, this.attrName, dn);
    }

    public void add(LDAPConnection ld) throws LDAPException {
        this.add(ld, "");
    }

    public void modify(LDAPConnection ld, LDAPSchemaElement newValue, String dn) throws LDAPException {
        boolean quotingBug = !LDAPSchema.isAttributeSyntaxStandardsCompliant(ld);
        LDAPModificationSet mods = new LDAPModificationSet();
        mods.add(1, new LDAPAttribute(this.attrName, this.getValue(quotingBug)));
        mods.add(0, new LDAPAttribute(this.attrName, newValue.getValue(quotingBug)));
        String entryName = LDAPSchema.getSchemaDN(ld, dn);
        ld.modify(entryName, mods);
    }

    public void modify(LDAPConnection ld, LDAPSchemaElement newValue) throws LDAPException {
        this.modify(ld, newValue, "");
    }

    public void remove(LDAPConnection ld, String dn) throws LDAPException {
        this.update(ld, 1, this.attrName, dn);
    }

    public void remove(LDAPConnection ld) throws LDAPException {
        this.remove(ld, "");
    }

    public boolean isObsolete() {
        return this.properties == null ? false : this.properties.containsKey(OBSOLETE);
    }

    protected void parseValue(String raw) {
        String[] vals;
        if (this.properties == null) {
            this.properties = new Hashtable();
        }
        int l = raw.length();
        char[] ch = new char[l];
        raw.getChars(0, l, ch, 0);
        --l;
        while (ch[l] == ' ') {
            --l;
        }
        int start = 0;
        while (ch[start] == ' ') {
            ++start;
        }
        int ind = (start += 2) + 1;
        while (ch[ind] != ' ') {
            ++ind;
        }
        this.oid = new String(ch, start, ind - start);
        ++ind;
        while (ind < l) {
            String s;
            int last;
            while (ch[ind] == ' ') {
                ++ind;
            }
            for (last = ind + 1; last < l && ch[last] != ' '; ++last) {
            }
            if (last < l) {
                s = new String(ch, ind, last - ind);
                if (novalsTable.containsKey(s)) {
                    this.properties.put(s, "");
                    continue;
                }
            } else {
                s = "";
                ind = l;
                break;
            }
            for (ind = last; ind < l && ch[ind] == ' '; ++ind) {
            }
            if (ind >= l) break;
            boolean quoted = false;
            boolean list = false;
            if (ch[ind] == '\'') {
                quoted = true;
                ++ind;
                while (last < l && ch[last] != '\'') {
                    ++last;
                }
            } else if (ch[ind] == '(') {
                list = true;
                ++ind;
                while (last < l && ch[last] != ')') {
                    ++last;
                }
            } else {
                for (last = ind + 1; last < l && ch[last] != ' '; ++last) {
                }
            }
            if (ind < last && last <= l) {
                if (list) {
                    Vector<String> v = new Vector<String>();
                    if (ch[ind] == ' ') {
                        ++ind;
                    }
                    String delim = (val = new String(ch, ind, last - ind - 1)).indexOf(39) >= 0 ? "'" : " ";
                    StringTokenizer st = new StringTokenizer(val, delim);
                    while (st.hasMoreTokens()) {
                        String tok = st.nextToken().trim();
                        if (tok.length() <= 0 || tok.equals("$")) continue;
                        v.addElement(tok);
                    }
                    this.properties.put(s, v);
                } else {
                    val = new String(ch, ind, last - ind);
                    if (s.equals("NAME")) {
                        this.name = val;
                    } else if (s.equals("DESC")) {
                        this.description = val;
                    } else {
                        this.properties.put(s, val);
                    }
                    if (quoted) {
                        ++last;
                    }
                }
            }
            ind = last + 1;
        }
        if ((vals = this.getQualifier("NAME")) != null && vals.length > 0) {
            this.name = vals[0];
            if (vals.length > 1) {
                this.aliases = new String[vals.length - 1];
                System.arraycopy(vals, 1, this.aliases, 0, this.aliases.length);
            }
        }
    }

    public String getValue() {
        return this.getValue(false);
    }

    String getValue(boolean quotingBug) {
        return null;
    }

    String getValuePrefix() {
        String s = "( " + this.oid + " ";
        if (this.name != null && this.name.length() > 0) {
            s = s + "NAME ";
            if (this.aliases != null) {
                s = s + "( '" + this.name + "' ";
                for (int i = 0; i < this.aliases.length; ++i) {
                    s = s + "'" + this.aliases[i] + "' ";
                }
                s = s + ") ";
            } else {
                s = s + "'" + this.name + "' ";
            }
        }
        if (this.description != null) {
            s = s + "DESC '" + this.description + "' ";
        }
        if (this.isObsolete()) {
            s = s + "OBSOLETE ";
        }
        return s;
    }

    protected String getOptionalValues(String[] names) {
        Object s = "";
        for (int i = 0; i < names.length; ++i) {
            String[] vals = this.getQualifier(names[i]);
            if (vals == null || vals.length <= 0) continue;
            if (i > 0) {
                s = (String)s + " ";
            }
            s = (String)s + names[i] + " " + vals[0];
        }
        return s;
    }

    protected String getCustomValues() {
        Object s = "";
        Enumeration<String> en = this.properties.keys();
        while (en.hasMoreElements()) {
            String key = en.nextElement();
            if (!key.startsWith("X-")) continue;
            s = (String)s + this.getValue(key, true, false) + " ";
        }
        if (((String)s).length() > 0 && ((String)s).charAt(((String)s).length() - 1) == ' ') {
            s = ((String)s).substring(0, ((String)s).length() - 1);
        }
        return s;
    }

    String getValue(String key, boolean doQuote, boolean doDollar) {
        Object s = "";
        Object o = this.properties.get(key);
        if (o == null) {
            return s;
        }
        if (o instanceof String) {
            if (((String)o).length() > 0) {
                s = (String)s + key + " ";
                if (doQuote) {
                    s = (String)s + "'";
                }
                s = (String)s + (String)o;
                if (doQuote) {
                    s = (String)s + "'";
                }
            }
        } else {
            s = (String)s + key + " ( ";
            Vector v = (Vector)o;
            for (int i = 0; i < v.size(); ++i) {
                if (doQuote) {
                    s = (String)s + "'";
                }
                s = (String)s + (String)v.elementAt(i);
                if (doQuote) {
                    s = (String)s + "'";
                }
                s = (String)s + " ";
                if (!doDollar || i >= v.size() - 1) continue;
                s = (String)s + "$ ";
            }
            s = (String)s + ")";
        }
        return s;
    }

    String getValue(String key, boolean doQuote) {
        return this.getValue(key, doQuote, true);
    }

    public void setQualifier(String name, String value) {
        if (this.properties == null) {
            this.properties = new Hashtable();
        }
        if (value != null) {
            this.properties.put(name, value);
        } else {
            this.properties.remove(name);
        }
    }

    public void setQualifier(String name, String[] values) {
        if (values == null) {
            return;
        }
        if (this.properties == null) {
            this.properties = new Hashtable();
        }
        Vector<String> v = new Vector<String>();
        for (int i = 0; i < values.length; ++i) {
            v.addElement(values[i]);
        }
        this.properties.put(name, v);
    }

    public String[] getQualifier(String name) {
        if (this.properties == null) {
            return null;
        }
        Object o = this.properties.get(name);
        if (o == null) {
            return null;
        }
        if (o instanceof Vector) {
            Vector v = (Vector)o;
            Object[] vals = new String[v.size()];
            v.copyInto(vals);
            return vals;
        }
        String s = (String)o;
        if (s.length() < 1) {
            return new String[0];
        }
        return new String[]{s};
    }

    public Enumeration<String> getQualifierNames() {
        return this.properties.keys();
    }

    public String[] getAliases() {
        return this.aliases;
    }

    String getQualifierString(String[] ignore) {
        Hashtable<String, String> toIgnore = null;
        if (ignore != null) {
            toIgnore = new Hashtable<String, String>();
            for (int i = 0; i < ignore.length; ++i) {
                toIgnore.put(ignore[i], ignore[i]);
            }
        }
        Object s = "";
        Enumeration<String> en = this.getQualifierNames();
        while (en.hasMoreElements()) {
            String qualifier = en.nextElement();
            if (toIgnore != null && toIgnore.containsKey(qualifier)) continue;
            s = (String)s + "; " + qualifier;
            String[] vals = this.getQualifier(qualifier);
            if (vals == null) {
                s = (String)s + " ";
                continue;
            }
            s = (String)s + ": ";
            for (int i = 0; i < vals.length; ++i) {
                s = (String)s + vals[i] + " ";
            }
        }
        if (((String)s).length() > 0 && ((String)s).charAt(((String)s).length() - 1) == ' ') {
            s = ((String)s).substring(0, ((String)s).length() - 1);
        }
        return s;
    }

    String getAliasString() {
        if (this.aliases != null) {
            Object s = "; aliases:";
            for (int i = 0; i < this.aliases.length; ++i) {
                s = (String)s + " " + this.aliases[i];
            }
            return s;
        }
        return "";
    }
}

