/*
 * Decompiled with CFR 0.152.
 */
package com.netscape.cms.authentication;

import com.netscape.certsrv.authentication.AuthCredentials;
import com.netscape.certsrv.authentication.EInvalidCredentials;
import com.netscape.certsrv.authentication.EMissingCredential;
import com.netscape.certsrv.authentication.ISSLClientCertProvider;
import com.netscape.certsrv.base.EBaseException;
import com.netscape.certsrv.base.SessionContext;
import com.netscape.certsrv.profile.EProfileException;
import com.netscape.certsrv.property.IDescriptor;
import com.netscape.certsrv.usrgrp.CertUserLocator;
import com.netscape.certsrv.usrgrp.Certificates;
import com.netscape.certsrv.usrgrp.EUsrGrpException;
import com.netscape.cmscore.apps.CMS;
import com.netscape.cmscore.apps.EngineConfig;
import com.netscape.cmscore.base.ConfigStore;
import com.netscape.cmscore.request.Request;
import com.netscape.cmscore.usrgrp.ExactMatchCertUserLocator;
import com.netscape.cmscore.usrgrp.UGSubsystem;
import com.netscape.cmscore.usrgrp.User;
import java.security.cert.CertificateException;
import java.security.cert.X509Certificate;
import java.util.Enumeration;
import java.util.Locale;
import netscape.ldap.LDAPException;
import org.dogtagpki.server.authentication.AuthManager;
import org.dogtagpki.server.authentication.AuthManagerConfig;
import org.dogtagpki.server.authentication.AuthManagersConfig;
import org.dogtagpki.server.authentication.AuthToken;
import org.dogtagpki.server.authentication.AuthenticationConfig;
import org.mozilla.jss.netscape.security.x509.X509CertImpl;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class AgentCertAuthentication
extends AuthManager {
    public static Logger logger = LoggerFactory.getLogger(AgentCertAuthentication.class);
    public static final String CRED_CERT = "sslClientCert";
    protected String[] mRequiredCreds = new String[]{"sslClientCert"};
    private CertUserLocator mCULocator = null;

    @Override
    public void init(AuthenticationConfig authenticationConfig, String name, String implName, AuthManagerConfig config) throws EBaseException {
        this.authenticationConfig = authenticationConfig;
        this.mName = name;
        this.mImplName = implName;
        this.mConfig = config;
        this.mCULocator = new ExactMatchCertUserLocator();
        this.mCULocator.setCMSEngine(this.engine);
    }

    @Override
    public boolean isSSLClientRequired() {
        return true;
    }

    @Override
    public AuthToken authenticate(AuthCredentials authCred) throws EMissingCredential, EInvalidCredentials, EBaseException {
        logger.debug("AgentCertAuthentication: start");
        logger.debug("authenticator instance name is " + this.getName());
        EngineConfig sconfig = this.engine.getConfig();
        AuthenticationConfig authsConfig = sconfig.getAuthenticationConfig();
        AuthManagersConfig instancesConfig = authsConfig.getAuthManagersConfig();
        SessionContext context = SessionContext.getExistingContext();
        ISSLClientCertProvider provider = (ISSLClientCertProvider)context.get((Object)"sslClientCertProvider");
        if (provider == null) {
            logger.error("AgentCertAuthentication: No SSL Client Cert Provider Found");
            throw new EInvalidCredentials(CMS.getUserMessage("CMS_AUTHENTICATION_INVALID_CREDENTIAL", new String[0]));
        }
        logger.debug("AgentCertAuthenticator: got provider");
        logger.debug("AgentCertAuthenticator: retrieving client certificate");
        X509Certificate[] allCerts = provider.getClientCertificateChain();
        if (allCerts == null) {
            logger.error("AgentCertAuthentication: No SSL Client Certs Found");
            throw new EInvalidCredentials(CMS.getUserMessage("CMS_AUTHENTICATION_INVALID_CREDENTIAL", new String[0]));
        }
        logger.debug("AgentCertAuthenticator: got certificates");
        AuthToken authToken = new AuthToken(this);
        X509Certificate[] x509Certs = allCerts;
        X509CertImpl[] ci = new X509CertImpl[x509Certs.length];
        try {
            for (int i = 0; i < x509Certs.length; ++i) {
                ci[i] = new X509CertImpl(x509Certs[i].getEncoded());
            }
        }
        catch (CertificateException e) {
            logger.warn("Unable to parse certificate: " + e.getMessage(), (Throwable)e);
        }
        boolean checkRevocation = true;
        try {
            checkRevocation = this.mConfig.getBoolean("checkRevocation", true);
        }
        catch (EBaseException eBaseException) {
            // empty catch block
        }
        if (checkRevocation && this.engine.isRevoked((X509Certificate[])ci)) {
            logger.error("AgentCertAuthentication: certificate revoked");
            throw new EInvalidCredentials(CMS.getUserMessage("CMS_AUTHENTICATION_INVALID_CREDENTIAL", new String[0]));
        }
        User user = null;
        Certificates certs = new Certificates((X509Certificate[])ci);
        try {
            user = this.mCULocator.locateUser(certs);
        }
        catch (EUsrGrpException e) {
            throw new EInvalidCredentials(CMS.getUserMessage("CMS_AUTHENTICATION_INVALID_CREDENTIAL", new String[0]), (Exception)((Object)e));
        }
        catch (LDAPException e) {
            throw new EBaseException(CMS.getUserMessage("CMS_BASE_INTERNAL_ERROR", e.toString()));
        }
        if (user == null) {
            throw new EInvalidCredentials(CMS.getUserMessage("CMS_AUTHENTICATION_INVALID_CREDENTIAL", new String[0]));
        }
        String groupname = "";
        try {
            groupname = instancesConfig.getString(this.getName() + ".agentGroup", "");
        }
        catch (EBaseException eBaseException) {
            // empty catch block
        }
        if (!groupname.equals("")) {
            logger.debug("check if " + user.getUserID() + " is  in group " + groupname);
            UGSubsystem uggroup = this.engine.getUGSubsystem();
            if (!uggroup.isMemberOf(user, groupname)) {
                logger.error(user.getUserID() + " is not in this group " + groupname);
                throw new EInvalidCredentials(CMS.getUserMessage("CMS_AUTHORIZATION_ERROR", new String[0]));
            }
        }
        authToken.set("user", user.getUserDN());
        authToken.set("userdn", user.getUserDN());
        authToken.set("userid", user.getUserID());
        authToken.set("uid", user.getUserID());
        authToken.set("group", groupname);
        authToken.set(CRED_CERT, certs);
        logger.info("AgentCertAuthentication: authenticated " + user.getUserDN());
        return authToken;
    }

    @Override
    public String[] getRequiredCreds() {
        return this.mRequiredCreds;
    }

    @Override
    public void shutdown() {
    }

    @Override
    public void init(ConfigStore config) throws EProfileException {
    }

    @Override
    public String getName(Locale locale) {
        return CMS.getUserMessage(locale, "CMS_AUTHENTICATION_AGENT_NAME", new String[0]);
    }

    @Override
    public String getText(Locale locale) {
        return CMS.getUserMessage(locale, "CMS_AUTHENTICATION_AGENT_TEXT", new String[0]);
    }

    @Override
    public Enumeration<String> getValueNames() {
        return null;
    }

    @Override
    public boolean isValueWriteable(String name) {
        return false;
    }

    @Override
    public IDescriptor getValueDescriptor(Locale locale, String name) {
        return null;
    }

    @Override
    public void populate(AuthToken token, Request request) throws EProfileException {
    }
}

