/*
 * Decompiled with CFR 0.152.
 */
package com.netscape.cms.servlet.csadmin;

import com.netscape.certsrv.base.EBaseException;
import com.netscape.cms.servlet.base.CMSServlet;
import com.netscape.cms.servlet.common.CMSRequest;
import com.netscape.cms.servlet.common.CMSTemplate;
import com.netscape.cms.servlet.common.CMSTemplateParams;
import com.netscape.cms.servlet.common.ECMSGWException;
import com.netscape.cmscore.apps.CMS;
import com.netscape.cmscore.apps.CMSEngine;
import com.netscape.cmscore.apps.EngineConfig;
import com.netscape.cmscore.base.ArgBlock;
import java.io.IOException;
import java.io.OutputStream;
import java.util.Locale;
import javax.servlet.ServletConfig;
import javax.servlet.ServletException;
import javax.servlet.ServletOutputStream;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MainPageServlet
extends CMSServlet {
    public static Logger logger = LoggerFactory.getLogger(MainPageServlet.class);
    private static final long serialVersionUID = 2425301522251239666L;
    private String mFormPath = null;

    @Override
    public void init(ServletConfig sc) throws ServletException {
        super.init(sc);
        this.mTemplates.remove(CMSRequest.SUCCESS);
        this.mTemplates.remove(CMSRequest.ERROR);
    }

    @Override
    public void process(CMSRequest cmsReq) throws EBaseException {
        HttpServletRequest request = cmsReq.getHttpReq();
        HttpServletResponse response = cmsReq.getHttpResp();
        logger.debug("MainPageServlet process");
        ArgBlock header = new ArgBlock();
        ArgBlock ctx = new ArgBlock();
        CMSTemplateParams argSet = new CMSTemplateParams(header, ctx);
        CMSTemplate form = null;
        Locale[] locale = new Locale[1];
        if (this.mOutputTemplatePath != null) {
            this.mFormPath = this.mOutputTemplatePath;
        }
        try {
            form = this.getTemplate(this.mFormPath, request, locale);
        }
        catch (IOException e) {
            logger.warn("MainPageServlet process: cant locate the form: " + e.getMessage(), (Throwable)e);
        }
        this.process(argSet, header, ctx, request, response);
        try {
            ServletOutputStream out = response.getOutputStream();
            cmsReq.setStatus(CMSRequest.SUCCESS);
            response.setContentType("text/html");
            form.renderOutput((OutputStream)out, argSet);
        }
        catch (IOException e) {
            logger.error(CMS.getLogMessage("CMSGW_ERR_OUT_STREAM_TEMPLATE", e.toString()), (Throwable)e);
            throw new ECMSGWException(CMS.getUserMessage("CMS_GW_DISPLAY_TEMPLATE_ERROR", new String[0]), e);
        }
    }

    private void process(CMSTemplateParams argSet, ArgBlock header, ArgBlock ctx, HttpServletRequest req, HttpServletResponse resp) throws EBaseException {
        int num = 0;
        ArgBlock rarg = null;
        CMSEngine engine = this.getCMSEngine();
        EngineConfig cs = engine.getConfig();
        int state = 0;
        String host = "";
        String adminInterface = "";
        String eeInterface = "";
        String agentInterface = "";
        try {
            state = cs.getState();
            host = cs.getHostname();
            adminInterface = cs.getString("admin.interface.uri", "");
            eeInterface = cs.getString("ee.interface.uri", "");
            agentInterface = cs.getString("agent.interface.uri", "");
        }
        catch (Exception exception) {
            // empty catch block
        }
        if (state == 0) {
            rarg = new ArgBlock();
            rarg.addStringValue("type", "admin");
            rarg.addStringValue("prefix", "http");
            rarg.addIntegerValue("port", Integer.valueOf(engine.getEENonSSLPort()));
            rarg.addStringValue("host", host);
            rarg.addStringValue("uri", adminInterface);
            argSet.addRepeatRecord(rarg);
            ++num;
        } else if (state == 1) {
            if (!eeInterface.equals("")) {
                rarg = new ArgBlock();
                rarg.addStringValue("type", "ee");
                rarg.addStringValue("prefix", "https");
                rarg.addIntegerValue("port", Integer.valueOf(engine.getEESSLPort()));
                rarg.addStringValue("host", host);
                rarg.addStringValue("uri", eeInterface);
                argSet.addRepeatRecord(rarg);
                ++num;
            }
            if (!agentInterface.equals("")) {
                rarg = new ArgBlock();
                rarg.addStringValue("type", "agent");
                rarg.addStringValue("prefix", "https");
                rarg.addIntegerValue("port", Integer.valueOf(engine.getAgentPort()));
                rarg.addStringValue("host", host);
                rarg.addStringValue("uri", agentInterface);
                argSet.addRepeatRecord(rarg);
                ++num;
            }
        }
        header.addIntegerValue("totalRecordCount", num);
    }
}

