/*
 * Decompiled with CFR 0.152.
 */
package com.netscape.cmscore.dbs;

import com.netscape.certsrv.base.EBaseException;
import com.netscape.certsrv.dbs.DBAttrMapper;
import com.netscape.certsrv.dbs.DBVirtualList;
import com.netscape.certsrv.dbs.IDBObj;
import com.netscape.certsrv.dbs.ModificationSet;
import com.netscape.cmscore.dbs.DBAttribute;
import com.netscape.cmscore.dbs.DBObjectClasses;
import com.netscape.cmscore.dbs.DBRegistry;
import com.netscape.cmscore.dbs.DBSSession;
import com.netscape.cmscore.dbs.DBSearchResults;
import com.netscape.cmscore.dbs.DBSubsystem;
import com.netscape.cmscore.dbs.Database;
import com.netscape.cmscore.dbs.DateMapper;
import com.netscape.cmscore.dbs.StringMapper;
import com.netscape.cmsutil.ldap.LDAPUtil;
import java.lang.reflect.AccessibleObject;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.Enumeration;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class LDAPDatabase<E extends IDBObj>
extends Database<E> {
    public static Logger logger = LoggerFactory.getLogger(LDAPDatabase.class);
    public DBSubsystem dbSubsystem;
    public String baseDN;
    public Class<E> recordType;

    public LDAPDatabase(String name, DBSubsystem dbSubsystem, String baseDN, Class<E> recordType) throws EBaseException {
        super(name);
        this.dbSubsystem = dbSubsystem;
        this.baseDN = baseDN;
        this.recordType = recordType;
        this.register(recordType);
    }

    public DBAttrMapper createMapper(Class<?> attrType, DBAttribute dbAttribute) throws EBaseException {
        String attrName = dbAttribute.value();
        if (attrType == String.class) {
            return new StringMapper(attrName);
        }
        if (attrType == Date.class) {
            return new DateMapper(attrName);
        }
        throw new EBaseException("Unsupported attribute type: " + attrType);
    }

    public void register(Class<E> recordType) throws EBaseException {
        DBAttrMapper mapper;
        Class<?> attrType;
        Object name;
        DBAttribute dbAttribute;
        logger.debug("registering " + recordType.getName());
        DBRegistry dbRegistry = this.dbSubsystem.getRegistry();
        DBObjectClasses dbObjectClasses = recordType.getAnnotation(DBObjectClasses.class);
        if (dbObjectClasses == null) {
            throw new EBaseException("Missing object class mapping in " + recordType.getName());
        }
        dbRegistry.registerObjectClass(recordType.getName(), dbObjectClasses.value());
        for (Method method : recordType.getMethods()) {
            dbAttribute = method.getAnnotation(DBAttribute.class);
            if (dbAttribute == null || !((String)(name = method.getName())).matches("^set.+") && !((String)name).matches("^get.+")) continue;
            name = Character.toLowerCase(((String)name).charAt(3)) + ((String)name).substring(4);
            attrType = method.getReturnType();
            mapper = this.createMapper(attrType, dbAttribute);
            dbRegistry.registerAttribute((String)name, mapper);
        }
        for (AccessibleObject accessibleObject : recordType.getFields()) {
            dbAttribute = ((Field)accessibleObject).getAnnotation(DBAttribute.class);
            if (dbAttribute == null) continue;
            name = ((Field)accessibleObject).getName();
            attrType = ((Field)accessibleObject).getType();
            mapper = this.createMapper(attrType, dbAttribute);
            dbRegistry.registerAttribute((String)name, mapper);
        }
    }

    public abstract String createDN(String var1);

    public abstract String createFilter(String var1, Map<String, String> var2);

    public void createFilter(StringBuilder sb, Map<String, String> attributes) {
        if (attributes == null || attributes.isEmpty()) {
            return;
        }
        int components = 0;
        if (sb.length() > 0) {
            ++components;
        }
        components += attributes.size();
        for (Map.Entry<String, String> entry : attributes.entrySet()) {
            sb.append("(" + entry.getKey() + "=" + LDAPUtil.escapeFilter((Object)entry.getValue()) + ")");
        }
        if (components > 1) {
            sb.insert(0, "(&");
            sb.append(")");
        }
    }

    @Override
    public Collection<E> findRecords(String keyword) throws Exception {
        return this.findRecords(keyword, null);
    }

    public Collection<E> findRecords(String keyword, Map<String, String> attributes) throws Exception {
        logger.debug("LDAPDatabase: findRecords()");
        try (DBSSession session = this.dbSubsystem.createSession();){
            logger.debug("LDAPDatabase: LDAP search on " + this.baseDN);
            String ldapFilter = this.createFilter(keyword, attributes);
            logger.debug("LDAPDatabase: - filter " + ldapFilter);
            DBSearchResults results = session.search(this.baseDN, ldapFilter);
            ArrayList<IDBObj> list = new ArrayList<IDBObj>();
            while (results.hasMoreElements()) {
                IDBObj result = (IDBObj)results.nextElement();
                list.add(result);
            }
            ArrayList<IDBObj> arrayList = list;
            return arrayList;
        }
    }

    public DBVirtualList<E> findRecords(String keyword, Map<String, String> attributes, String[] sortKeys, int pageSize) throws Exception {
        logger.debug("LDAPDatabase: findRecords()");
        try (DBSSession session = this.dbSubsystem.createSession();){
            logger.debug("LDAPDatabase: LDAP VLV search on " + this.baseDN);
            String ldapFilter = this.createFilter(keyword, attributes);
            logger.debug("LDAPDatabase: - filter " + ldapFilter);
            logger.debug("LDAPDatabase: - sort keys:");
            if (sortKeys != null) {
                for (String key : sortKeys) {
                    logger.debug("LDAPDatabase:   - " + key);
                }
            }
            logger.debug("LDAPDatabase: - page size: " + pageSize);
            DBVirtualList dBVirtualList = session.createVirtualList(this.baseDN, ldapFilter, (String[])null, sortKeys, pageSize);
            return dBVirtualList;
        }
    }

    @Override
    public E getRecord(String id) throws Exception {
        logger.debug("LDAPDatabase: getRecord(\"" + id + "\")");
        try (DBSSession session = this.dbSubsystem.createSession();){
            String dn = this.createDN(id);
            logger.debug("LDAPDatabase: reading " + this.baseDN);
            IDBObj iDBObj = session.read(dn);
            return (E)iDBObj;
        }
    }

    @Override
    public void addRecord(String id, E record) throws Exception {
        logger.debug("LDAPDatabase: addRecord(\"" + id + "\")");
        try (DBSSession session = this.dbSubsystem.createSession();){
            String dn = this.createDN(id);
            logger.debug("LDAPDatabase: adding " + dn);
            session.add(dn, (IDBObj)record);
        }
    }

    @Override
    public void updateRecord(String id, E record) throws Exception {
        logger.debug("LDAPDatabase: updateRecord(\"" + id + "\")");
        try (DBSSession session = this.dbSubsystem.createSession();){
            String dn = this.createDN(id);
            logger.debug("LDAPDatabase: dn: " + dn);
            logger.debug("LDAPDatabase: changetype: modify");
            ModificationSet mods = new ModificationSet();
            Enumeration<String> names = record.getSerializableAttrNames();
            while (names.hasMoreElements()) {
                String name = names.nextElement();
                Object value = record.get(name);
                logger.debug("LDAPDatabase: replace: " + name);
                logger.debug("LDAPDatabase: " + name + ": " + value);
                logger.debug("LDAPDatabase: -");
                mods.add(name, 2, value);
            }
            session.modify(dn, mods);
            logger.debug("LDAPDatabase: modification completed");
        }
        catch (Exception e) {
            logger.error("LDAPDatabase: modification failed: " + e.getMessage(), (Throwable)e);
            throw e;
        }
    }

    @Override
    public void removeRecord(String id) throws Exception {
        logger.debug("LDAPDatabase: removeRecord(\"" + id + "\")");
        try (DBSSession session = this.dbSubsystem.createSession();){
            String dn = this.createDN(id);
            logger.debug("LDAPDatabase: removing " + dn);
            session.delete(dn);
        }
    }
}

