/*
 * Decompiled with CFR 0.152.
 */
package com.netscape.cmscore.dbs;

import com.netscape.cmscore.dbs.KeyRepository;
import com.netscape.cmscore.request.RequestRepository;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.TimeUnit;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class KeyStatusUpdateTask
implements Runnable {
    public static Logger logger = LoggerFactory.getLogger(KeyStatusUpdateTask.class);
    KeyRepository keyRepository;
    RequestRepository requestRepository;
    int interval;
    ScheduledExecutorService executorService;

    public KeyStatusUpdateTask(KeyRepository keyRepository, RequestRepository requestRepository, int interval) {
        this.keyRepository = keyRepository;
        this.requestRepository = requestRepository;
        this.interval = interval;
    }

    public void start() {
        this.executorService = Executors.newSingleThreadScheduledExecutor(new ThreadFactory(){

            @Override
            public Thread newThread(Runnable r) {
                return new Thread(r, "KeyStatusUpdateTask");
            }
        });
        this.executorService.scheduleWithFixedDelay(this, 0L, this.interval, TimeUnit.SECONDS);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void updateKeyStatus() throws Exception {
        KeyRepository keyRepository = this.keyRepository;
        synchronized (keyRepository) {
            logger.debug("About to start checkRanges");
            logger.debug("Starting key checkRanges");
            this.keyRepository.checkRanges();
            logger.debug("key checkRanges done");
            logger.debug("Starting request checkRanges");
            this.requestRepository.checkRanges();
            logger.debug("request checkRanges done");
        }
    }

    @Override
    public void run() {
        try {
            this.updateKeyStatus();
        }
        catch (Exception e) {
            logger.warn("KeyStatusUpdateTask: " + e.getMessage(), (Throwable)e);
        }
    }

    public void stop() {
        if (this.executorService != null) {
            this.executorService.shutdown();
        }
    }
}

