/*
 * Decompiled with CFR 0.152.
 */
package com.netscape.kra;

import com.netscape.certsrv.base.EBaseException;
import com.netscape.certsrv.base.SessionContext;
import com.netscape.certsrv.kra.EKRAException;
import com.netscape.certsrv.request.IService;
import com.netscape.certsrv.security.Credential;
import com.netscape.certsrv.security.IStorageKeyUnit;
import com.netscape.cmscore.apps.CMS;
import com.netscape.cmscore.dbs.KeyRecord;
import com.netscape.cmscore.dbs.KeyRepository;
import com.netscape.cmscore.request.Request;
import com.netscape.cmscore.security.JssSubsystem;
import com.netscape.cmscore.util.StatsSubsystem;
import com.netscape.cmsutil.crypto.CryptoUtil;
import com.netscape.kra.KeyRecoveryAuthority;
import java.io.ByteArrayOutputStream;
import java.io.CharConversionException;
import java.io.OutputStream;
import java.math.BigInteger;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.security.PublicKey;
import java.security.SecureRandom;
import java.security.cert.CertificateEncodingException;
import java.util.Hashtable;
import org.dogtagpki.server.authentication.AuthToken;
import org.dogtagpki.server.kra.KRAEngine;
import org.dogtagpki.server.kra.KRAEngineConfig;
import org.mozilla.jss.CryptoManager;
import org.mozilla.jss.asn1.ANY;
import org.mozilla.jss.asn1.ASN1Template;
import org.mozilla.jss.asn1.ASN1Util;
import org.mozilla.jss.asn1.ASN1Value;
import org.mozilla.jss.asn1.BMPString;
import org.mozilla.jss.asn1.OCTET_STRING;
import org.mozilla.jss.asn1.SEQUENCE;
import org.mozilla.jss.asn1.SET;
import org.mozilla.jss.crypto.Algorithm;
import org.mozilla.jss.crypto.CryptoToken;
import org.mozilla.jss.crypto.EncryptionAlgorithm;
import org.mozilla.jss.crypto.IVParameterSpec;
import org.mozilla.jss.crypto.KeyGenerator;
import org.mozilla.jss.crypto.KeyWrapAlgorithm;
import org.mozilla.jss.crypto.PBEAlgorithm;
import org.mozilla.jss.crypto.PrivateKey;
import org.mozilla.jss.crypto.SymmetricKey;
import org.mozilla.jss.crypto.X509Certificate;
import org.mozilla.jss.netscape.security.util.BigInt;
import org.mozilla.jss.netscape.security.util.DerInputStream;
import org.mozilla.jss.netscape.security.util.DerValue;
import org.mozilla.jss.netscape.security.x509.X509CertImpl;
import org.mozilla.jss.netscape.security.x509.X509Key;
import org.mozilla.jss.pkcs12.AuthenticatedSafes;
import org.mozilla.jss.pkcs12.CertBag;
import org.mozilla.jss.pkcs12.PFX;
import org.mozilla.jss.pkcs12.PasswordConverter;
import org.mozilla.jss.pkcs12.SafeBag;
import org.mozilla.jss.pkix.primitive.EncryptedPrivateKeyInfo;
import org.mozilla.jss.pkix.primitive.PrivateKeyInfo;
import org.mozilla.jss.util.Password;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class RecoveryService
implements IService {
    public static Logger logger = LoggerFactory.getLogger(RecoveryService.class);
    public static final String ATTR_NICKNAME = "nickname";
    public static final String ATTR_OWNER_NAME = "ownerName";
    public static final String ATTR_SERIALNO = "serialNumber";
    public static final String ATTR_PUBLIC_KEY_DATA = "publicKeyData";
    public static final String ATTR_PRIVATE_KEY_DATA = "privateKeyData";
    public static final String ATTR_TRANSPORT_CERT = "transportCert";
    public static final String ATTR_TRANSPORT_PWD = "transportPwd";
    public static final String ATTR_SIGNING_CERT = "signingCert";
    public static final String ATTR_PKCS12 = "pkcs12";
    public static final String ATTR_ENCRYPTION_CERTS = "encryptionCerts";
    public static final String ATTR_AGENT_CREDENTIALS = "agentCredentials";
    public static final String ATTR_USER_CERT = "cert";
    public static final String ATTR_DELIVERY = "delivery";
    private KeyRecoveryAuthority mKRA;
    private KeyRepository mStorage;
    private IStorageKeyUnit mStorageUnit = null;
    public static final String REQUEST_ISSED_CERT = "req_issued_cert";

    public RecoveryService(KeyRecoveryAuthority kra) {
        this.mKRA = kra;
        this.mStorage = this.mKRA.getKeyRepository();
        this.mStorageUnit = this.mKRA.getStorageKeyUnit();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean serviceRequest(Request request) throws EBaseException {
        CryptoManager cm = null;
        KRAEngineConfig config = null;
        String tokName = "";
        CryptoToken ct = null;
        Boolean allowEncDecrypt_recovery = false;
        boolean isSSKeygen = false;
        String serverKeygenP12Pass = null;
        KRAEngine engine = KRAEngine.getInstance();
        JssSubsystem jssSubsystem = engine.getJSSSubsystem();
        X509CertImpl transportCert = request.getExtDataInCert(ATTR_TRANSPORT_CERT);
        String transportCertNick = null;
        KeyWrapAlgorithm wrapAlg = KeyWrapAlgorithm.RSA;
        try {
            cm = CryptoManager.getInstance();
            config = engine.getConfig();
            tokName = config.getString("kra.storageUnit.hardware", "internal");
            boolean useOAEPKeyWrap = config.getUseOAEPKeyWrap();
            transportCertNick = config.getString("kra.cert.transport.nickname", "KRA transport certificate");
            logger.debug("RecoveryService: serviceRequest: KRA transport cert nickname: " + transportCertNick);
            logger.debug("RecoveryService: serviceRequest: token: " + tokName);
            ct = CryptoUtil.getCryptoToken((String)tokName);
            allowEncDecrypt_recovery = config.getBoolean("kra.allowEncDecrypt.recovery", false);
            String isSSKeygenStr = request.getExtDataInString("isServerSideKeygen");
            if (isSSKeygenStr != null && isSSKeygenStr.equalsIgnoreCase("true")) {
                SymmetricKey unwrappedSessionKey;
                logger.debug("RecoveryService: serviceRequest: isSSKengen=" + isSSKeygenStr);
                isSSKeygen = true;
                CryptoToken token = CryptoUtil.getKeyStorageToken((String)"internal");
                byte[] sessionWrappedPassphrase = request.getExtDataInByteArray("serverSideKeygenP12PasswdEnc");
                if (sessionWrappedPassphrase == null) {
                    throw new EBaseException(CMS.getUserMessage((String)"CMS_BASE_CERT_ERRORServer-Side Keygen Enroll Key Retrieval: sessionWrappedPassphrase not found in Request", (String[])new String[0]));
                }
                byte[] transWrappedSessionKey = request.getExtDataInByteArray("serverSideKeygenP12PasswdTransSession");
                if (transWrappedSessionKey == null) {
                    throw new EBaseException(CMS.getUserMessage((String)"CMS_BASE_CERT_ERRORServer-Side Keygen Enroll Key Retrieval: transWrappedSessionKey not found in Request", (String[])new String[0]));
                }
                X509Certificate transCert = cm.findCertByNickname(transportCertNick);
                PrivateKey transPrivateKey = cm.findPrivKeyByCert(transCert);
                if (transPrivateKey != null) {
                    logger.debug("RecoveryService: serviceRequest: found private key");
                }
                if (useOAEPKeyWrap) {
                    wrapAlg = KeyWrapAlgorithm.RSA_OAEP;
                }
                if ((unwrappedSessionKey = CryptoUtil.unwrap((CryptoToken)token, (SymmetricKey.Type)SymmetricKey.AES, (int)128, (SymmetricKey.Usage)SymmetricKey.Usage.UNWRAP, (PrivateKey)transPrivateKey, (byte[])transWrappedSessionKey, (KeyWrapAlgorithm)wrapAlg)) == null) {
                    logger.debug("RecoveryService: serviceRequest: unwrappedSessionKey null");
                    throw new EBaseException(CMS.getUserMessage((String)"CMS_BASE_CERT_ERRORServer-Side Keygen Enroll Key Retrieval: CryptoUtil.unwrap failed on unwrappedSessionKey", (String[])new String[0]));
                }
                EncryptionAlgorithm encryptAlgorithm = EncryptionAlgorithm.AES_128_CBC_PAD;
                byte[] iv = new byte[]{1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1};
                IVParameterSpec ivps = new IVParameterSpec(iv);
                byte[] passphrase = CryptoUtil.decryptUsingSymmetricKey((CryptoToken)token, (IVParameterSpec)ivps, (byte[])sessionWrappedPassphrase, (SymmetricKey)unwrappedSessionKey, (EncryptionAlgorithm)encryptAlgorithm);
                serverKeygenP12Pass = new String(passphrase, "UTF-8");
                CryptoUtil.obscureBytes((byte[])passphrase, (String)"random");
            }
        }
        catch (Exception e) {
            logger.error("RecoveryService exception: use internal token: " + e, (Throwable)e);
            ct = cm.getInternalCryptoToken();
        }
        finally {
            request.setExtData("serverSideKeygenP12PasswdTransSession", "");
            request.setExtData("serverSideKeygenP12PasswdEnc", "");
            request.deleteExtData("serverSideKeygenP12PasswdTransSession");
            request.deleteExtData("serverSideKeygenP12PasswdEnc");
        }
        if (ct == null) {
            throw new EBaseException(CMS.getUserMessage((String)"CMS_BASE_CERT_ERRORcannot get crypto token", (String[])new String[0]));
        }
        StatsSubsystem statsSub = (StatsSubsystem)engine.getSubsystem("stats");
        if (statsSub != null) {
            statsSub.startTiming("recovery", true);
        }
        logger.info("KRA services recovery request");
        Hashtable<String, Object> params = this.mKRA.getVolatileRequest(request.getRequestId());
        if (params == null) {
            if (isSSKeygen) {
                params = new Hashtable();
                params.put(ATTR_TRANSPORT_PWD, serverKeygenP12Pass);
            } else {
                return true;
            }
        }
        BigInteger serialno = request.getExtDataInBigInteger(ATTR_SERIALNO);
        logger.info("KRA reading key record; serialno=" + serialno.toString());
        if (statsSub != null) {
            statsSub.startTiming("get_key");
        }
        KeyRecord keyRecord = this.mStorage.readKeyRecord(serialno);
        if (statsSub != null) {
            statsSub.endTiming("get_key");
        }
        byte[] pubData = keyRecord.getPublicKeyData();
        X509CertImpl x509cert = request.getExtDataInCert(REQUEST_ISSED_CERT);
        if (x509cert == null && (x509cert = request.getExtDataInCert(ATTR_USER_CERT)) == null) {
            throw new EKRAException(CMS.getUserMessage((String)"CMS_KRA_INVALID_KEYRECORD", (String[])new String[0]));
        }
        byte[] inputPubData = x509cert.getPublicKey().getEncoded();
        if (inputPubData.length != pubData.length) {
            logger.error(CMS.getLogMessage((String)"CMSCORE_KRA_PUBLIC_KEY_LEN", (Object[])new Object[0]));
            throw new EKRAException(CMS.getUserMessage((String)"CMS_KRA_PUBLIC_KEY_NOT_MATCHED", (String[])new String[0]));
        }
        for (int i = 0; i < pubData.length; ++i) {
            if (pubData[i] == inputPubData[i]) continue;
            logger.error(CMS.getLogMessage((String)"CMSCORE_KRA_PUBLIC_KEY_LEN", (Object[])new Object[0]));
            throw new EKRAException(CMS.getUserMessage((String)"CMS_KRA_PUBLIC_KEY_NOT_MATCHED", (String[])new String[0]));
        }
        boolean isRSA = true;
        String keyAlg = x509cert.getPublicKey().getAlgorithm();
        if (keyAlg != null) {
            logger.debug("RecoveryService: publicKey alg =" + keyAlg);
            if (!keyAlg.equals("RSA")) {
                isRSA = false;
            }
        }
        byte[] privateKeyData = null;
        if (transportCert == null) {
            Boolean encrypted;
            if (statsSub != null) {
                statsSub.startTiming("recover_key");
            }
            if ((encrypted = keyRecord.isEncrypted()) == null) {
                encrypted = allowEncDecrypt_recovery;
            }
            PrivateKey privKey = null;
            if (encrypted.booleanValue()) {
                privateKeyData = this.recoverKey(params, keyRecord);
            } else {
                privKey = this.recoverKey(params, keyRecord, isRSA);
            }
            if (statsSub != null) {
                statsSub.endTiming("recover_key");
            }
            if (isRSA && encrypted.booleanValue()) {
                if (statsSub != null) {
                    statsSub.startTiming("verify_key");
                }
                if (!this.verifyKeyPair(pubData, privateKeyData)) {
                    jssSubsystem.obscureBytes(privateKeyData);
                    logger.error(CMS.getLogMessage((String)"CMSCORE_KRA_PUBLIC_NOT_FOUND", (Object[])new Object[0]));
                    throw new EKRAException(CMS.getUserMessage((String)"CMS_KRA_INVALID_PUBLIC_KEY", (String[])new String[0]));
                }
                if (statsSub != null) {
                    statsSub.endTiming("verify_key");
                }
            }
            if (statsSub != null) {
                statsSub.startTiming("create_p12");
            }
            try {
                if (encrypted.booleanValue()) {
                    this.createPFX(request, params, privateKeyData);
                } else {
                    this.createPFX(request, params, privKey, ct);
                }
            }
            catch (EBaseException e) {
                throw e;
            }
            finally {
                jssSubsystem.obscureBytes(privateKeyData);
            }
            if (statsSub != null) {
                statsSub.endTiming("create_p12");
            }
        } else {
            if (engine.getConfig().getBoolean("kra.keySplitting")) {
                Credential[] creds = (Credential[])params.get(ATTR_AGENT_CREDENTIALS);
                this.mKRA.getStorageKeyUnit().login(creds);
            }
            if (statsSub != null) {
                statsSub.startTiming("unwrap_key");
            }
            try {
                this.mKRA.getStorageKeyUnit().unwrap(keyRecord.getPrivateKeyData(), null, false, keyRecord.getWrappingParams(this.mKRA.getStorageKeyUnit().getOldWrappingParams()));
            }
            catch (Exception e) {
                throw new EBaseException("Failed to unwrap private key", (Throwable)e);
            }
            if (statsSub != null) {
                statsSub.endTiming("unwrap_key");
            }
            if (engine.getConfig().getBoolean("kra.keySplitting")) {
                this.mKRA.getStorageKeyUnit().logout();
            }
        }
        if (isSSKeygen) {
            logger.debug("RecoveryService: putting p12 in request");
            byte[] p12b = (byte[])params.get(ATTR_PKCS12);
            request.setExtData("req_issued_p12", p12b);
            boolean isArchival = request.getExtDataInBoolean("serverSideKeygenEnrollEnableArchival", true);
            if (isArchival) {
                logger.debug("RecoveryService: serviceRequest: Server-Side Keygen isArchival true, key record kept");
            } else {
                this.mStorage.deleteKeyRecord(serialno);
            }
            logger.debug("RecoveryService: serviceRequest: Server-Side Keygen isArchival false, key record not kept");
        }
        logger.info("key " + serialno + " recovered");
        String authMgr = "noAuthManager";
        Object initiative = "fromUser";
        SessionContext sContext = SessionContext.getContext();
        if (sContext != null) {
            String agentId = (String)sContext.get((Object)"userid");
            initiative = "fromAgent agentID: " + agentId;
            AuthToken authToken = (AuthToken)sContext.get((Object)"AuthToken");
            if (authToken != null) {
                authMgr = authToken.getInString("authMgrInstName");
            }
        }
        logger.info("{} reqID {} {} authenticated by {} is {} DN requested: {} {}", new Object[]{"recovery", request.getRequestId(), initiative, authMgr, "completed", x509cert.getSubjectName(), "serial number: 0x" + serialno.toString(16)});
        if (statsSub != null) {
            statsSub.endTiming("recovery");
        }
        return true;
    }

    public boolean verifyKeyPair(byte[] publicKeyData, byte[] privateKeyData) {
        try {
            DerValue publicKeyVal = new DerValue(publicKeyData);
            DerInputStream publicKeyIn = publicKeyVal.data;
            publicKeyIn.getSequence(0);
            DerValue publicKeyDer = new DerValue(publicKeyIn.getBitString());
            DerInputStream publicKeyDerIn = publicKeyDer.data;
            BigInt publicKeyModulus = publicKeyDerIn.getInteger();
            BigInt publicKeyExponent = publicKeyDerIn.getInteger();
            DerValue privateKeyVal = new DerValue(privateKeyData);
            if (privateKeyVal.tag != 48) {
                return false;
            }
            DerInputStream privateKeyIn = privateKeyVal.data;
            privateKeyIn.getInteger();
            privateKeyIn.getSequence(0);
            DerValue privateKeyDer = new DerValue(privateKeyIn.getOctetString());
            DerInputStream privateKeyDerIn = privateKeyDer.data;
            BigInt privateKeyVersion = privateKeyDerIn.getInteger();
            BigInt privateKeyModulus = privateKeyDerIn.getInteger();
            BigInt privateKeyExponent = privateKeyDerIn.getInteger();
            if (!publicKeyModulus.equals(privateKeyModulus)) {
                logger.debug("verifyKeyPair modulus mismatch publicKeyModulus=" + publicKeyModulus + " privateKeyModulus=" + privateKeyModulus);
                return false;
            }
            if (!publicKeyExponent.equals(privateKeyExponent)) {
                logger.debug("verifyKeyPair exponent mismatch publicKeyExponent=" + publicKeyExponent + " privateKeyExponent=" + privateKeyExponent);
                return false;
            }
            return true;
        }
        catch (Exception e) {
            logger.debug("verifyKeyPair error " + e);
            return false;
        }
    }

    public synchronized PrivateKey recoverKey(Hashtable<String, Object> request, KeyRecord keyRecord, boolean isRSA) throws EBaseException {
        logger.debug("RecoverService: recoverKey: key to recover is RSA? " + isRSA);
        KRAEngine engine = KRAEngine.getInstance();
        try {
            if (engine.getConfig().getBoolean("kra.keySplitting")) {
                Credential[] creds = (Credential[])request.get(ATTR_AGENT_CREDENTIALS);
                this.mStorageUnit.login(creds);
            }
            PublicKey pubkey = null;
            try {
                pubkey = X509Key.parsePublicKey((DerValue)new DerValue(keyRecord.getPublicKeyData()));
            }
            catch (Exception e) {
                logger.error("RecoverService: after parsePublicKey:" + e.toString(), (Throwable)e);
                throw new EKRAException(CMS.getUserMessage((String)"CMS_KRA_RECOVERY_FAILED_1", (String[])new String[]{"public key parsing failure"}));
            }
            PrivateKey privKey = null;
            try {
                privKey = this.mStorageUnit.unwrap(keyRecord.getPrivateKeyData(), pubkey, true, keyRecord.getWrappingParams(this.mKRA.getStorageKeyUnit().getOldWrappingParams()));
            }
            catch (Exception e) {
                logger.error(CMS.getLogMessage((String)"CMSCORE_KRA_PRIVATE_KEY_NOT_FOUND", (Object[])new Object[0]), (Throwable)e);
                throw new EKRAException(CMS.getUserMessage((String)"CMS_KRA_RECOVERY_FAILED_1", (String[])new String[]{"private key unwrapping failure"}), e);
            }
            if (engine.getConfigStore().getBoolean("kra.keySplitting")) {
                this.mStorageUnit.logout();
            }
            return privKey;
        }
        catch (Exception e) {
            logger.error("RecoverService: recoverKey() failed with allowEncDecrypt_recovery=false:" + e, (Throwable)e);
            throw new EKRAException(CMS.getUserMessage((String)"CMS_KRA_RECOVERY_FAILED_1", (String[])new String[]{"recoverKey() failed with allowEncDecrypt_recovery=false:" + e.toString()}));
        }
    }

    public void createPFX(Request request, Hashtable<String, Object> params, PrivateKey priKey, CryptoToken ct) throws EBaseException {
        logger.debug("RecoverService: createPFX() allowEncDecrypt_recovery=false");
        KRAEngine engine = KRAEngine.getInstance();
        JssSubsystem jssSubsystem = engine.getJSSSubsystem();
        String pwd = (String)params.get(ATTR_TRANSPORT_PWD);
        char[] pwdChar = pwd.toCharArray();
        Password pass = new Password(pwdChar);
        try {
            EncryptedPrivateKeyInfo key;
            X509CertImpl x509cert = request.getExtDataInCert(REQUEST_ISSED_CERT);
            if (x509cert == null && (x509cert = request.getExtDataInCert(ATTR_USER_CERT)) == null) {
                throw new EKRAException(CMS.getUserMessage((String)"CMS_KRA_PKCS12_FAILED_1", (String[])new String[]{"Missing Certificate"}));
            }
            logger.info("KRA adds certificate to P12");
            SEQUENCE encSafeContents = new SEQUENCE();
            OCTET_STRING cert = new OCTET_STRING(x509cert.getEncoded());
            String nickname = request.getExtDataInString(ATTR_NICKNAME);
            if (nickname == null) {
                nickname = x509cert.getSubjectDN().toString();
            }
            byte[] localKeyId = this.createLocalKeyId((java.security.cert.X509Certificate)x509cert);
            SET certAttrs = this.createBagAttrs(nickname, localKeyId);
            SafeBag certBag = new SafeBag(SafeBag.CERT_BAG, (ASN1Value)new CertBag(CertBag.X509_CERT_TYPE, (ASN1Value)cert), certAttrs);
            encSafeContents.addElement((ASN1Value)certBag);
            logger.info("KRA adds key to P12");
            SEQUENCE safeContents = new SEQUENCE();
            PasswordConverter passConverter = new PasswordConverter();
            boolean legacyP12 = engine.getConfig().getBoolean("kra.legacyPKCS12", true);
            if (legacyP12) {
                SecureRandom ran = jssSubsystem.getRandomNumberGenerator();
                byte[] salt = new byte[20];
                ran.nextBytes(salt);
                key = EncryptedPrivateKeyInfo.createPBE((PBEAlgorithm)PBEAlgorithm.PBE_SHA1_DES3_CBC, (Password)pass, (byte[])salt, (int)1, (KeyGenerator.CharToByteConverter)passConverter, (PrivateKey)priKey, (CryptoToken)ct);
                logger.debug("RecoverService: createPFX() EncryptedPrivateKeyInfo.createPBE() returned");
                if (key == null) {
                    logger.error("RecoverService: createPFX() key null");
                    throw new EBaseException("EncryptedPrivateKeyInfo.createPBE() failed");
                }
                logger.debug("RecoverService: createPFX() key not null");
            } else {
                String nonLegacyAlg = engine.getConfig().getString("kra.nonLegacyAlg", "AES/CBC/NoPadding");
                EncryptionAlgorithm encAlg = EncryptionAlgorithm.fromString((String)nonLegacyAlg);
                logger.debug("RecoverService: createPFX() selected enc alg: " + encAlg);
                if (encAlg == null || "AES/CBC/NoPadding".equals(encAlg.toString())) {
                    encAlg = EncryptionAlgorithm.AES_256_CBC;
                }
                byte[] epkiBytes = ct.getCryptoStore().getEncryptedPrivateKeyInfo(null, pass, (Algorithm)encAlg, 0, priKey);
                logger.debug("RecoverService: createPFX() getEncryptedPrivateKeyInfo() returned");
                if (epkiBytes == null) {
                    logger.error("RecoverService: createPFX() epkiBytes null");
                    throw new EBaseException("getEncryptedPrivateKeyInfo returned null");
                }
                logger.debug("RecoverService: createPFX() epkiBytes not null");
                key = new ANY(epkiBytes);
            }
            SET keyAttrs = this.createBagAttrs(x509cert.getSubjectDN().toString(), localKeyId);
            SafeBag keyBag = new SafeBag(SafeBag.PKCS8_SHROUDED_KEY_BAG, (ASN1Value)key, keyAttrs);
            safeContents.addElement((ASN1Value)keyBag);
            AuthenticatedSafes authSafes = new AuthenticatedSafes();
            authSafes.addSafeContents(safeContents);
            authSafes.addSafeContents(encSafeContents);
            PFX pfx = new PFX(authSafes);
            pfx.computeMacData(pass, null, 5);
            ByteArrayOutputStream fos = new ByteArrayOutputStream();
            pfx.encode((OutputStream)fos);
            params.put(ATTR_PKCS12, fos.toByteArray());
            logger.debug("RecoverService: createPFX() completed.");
        }
        catch (Exception e) {
            logger.error(CMS.getLogMessage((String)"CMSCORE_KRA_CONSTRUCT_P12", (Object[])new Object[]{e.toString()}), (Throwable)e);
            logger.error("RecoverService: createPFX() exception caught:" + e, (Throwable)e);
            throw new EKRAException(CMS.getUserMessage((String)"CMS_KRA_PKCS12_FAILED_1", (String[])new String[]{e.toString()}));
        }
        finally {
            pass.clear();
            jssSubsystem.obscureChars(pwdChar);
        }
        engine.getRequestRepository().updateRequest(request);
    }

    public synchronized byte[] recoverKey(Hashtable<String, Object> request, KeyRecord keyRecord) throws EBaseException {
        KRAEngine engine = KRAEngine.getInstance();
        if (engine.getConfig().getBoolean("kra.keySplitting")) {
            Credential[] creds = (Credential[])request.get(ATTR_AGENT_CREDENTIALS);
            this.mStorageUnit.login(creds);
        }
        logger.info("KRA decrypts internal private");
        try {
            byte[] privateKeyData = this.mStorageUnit.decryptInternalPrivate(keyRecord.getPrivateKeyData(), keyRecord.getWrappingParams(this.mKRA.getStorageKeyUnit().getOldWrappingParams()));
            if (engine.getConfig().getBoolean("kra.keySplitting")) {
                this.mStorageUnit.logout();
            }
            return privateKeyData;
        }
        catch (Exception e) {
            logger.error(CMS.getLogMessage((String)"CMSCORE_KRA_PRIVATE_KEY_NOT_FOUND", (Object[])new Object[0]), (Throwable)e);
            throw new EKRAException(CMS.getUserMessage((String)"CMS_KRA_RECOVERY_FAILED_1", (String[])new String[]{"no private key"}));
        }
    }

    public void createPFX(Request request, Hashtable<String, Object> params, byte[] priData) throws EBaseException {
        logger.debug("RecoverService: createPFX() allowEncDecrypt_recovery=true");
        KRAEngine engine = KRAEngine.getInstance();
        JssSubsystem jssSubsystem = engine.getJSSSubsystem();
        String pwd = (String)params.get(ATTR_TRANSPORT_PWD);
        char[] pwdChars = pwd.toCharArray();
        Password pass = new Password(pwdChars);
        try {
            X509CertImpl x509cert = request.getExtDataInCert(REQUEST_ISSED_CERT);
            if (x509cert == null && (x509cert = request.getExtDataInCert(ATTR_USER_CERT)) == null) {
                throw new EKRAException(CMS.getUserMessage((String)"CMS_KRA_PKCS12_FAILED_1", (String[])new String[]{"Missing Certificate"}));
            }
            logger.info("KRA adds certificate to P12");
            SEQUENCE encSafeContents = new SEQUENCE();
            OCTET_STRING cert = new OCTET_STRING(x509cert.getEncoded());
            String nickname = request.getExtDataInString(ATTR_NICKNAME);
            if (nickname == null) {
                nickname = x509cert.getSubjectDN().toString();
            }
            byte[] localKeyId = this.createLocalKeyId((java.security.cert.X509Certificate)x509cert);
            SET certAttrs = this.createBagAttrs(nickname, localKeyId);
            SafeBag certBag = new SafeBag(SafeBag.CERT_BAG, (ASN1Value)new CertBag(CertBag.X509_CERT_TYPE, (ASN1Value)cert), certAttrs);
            encSafeContents.addElement((ASN1Value)certBag);
            logger.info("KRA adds key to P12");
            SEQUENCE safeContents = new SEQUENCE();
            PrivateKeyInfo pki = (PrivateKeyInfo)ASN1Util.decode((ASN1Template)PrivateKeyInfo.getTemplate(), (byte[])priData);
            EncryptedPrivateKeyInfo epki = null;
            boolean legacyP12 = engine.getConfig().getBoolean("kra.legacyPKCS12", true);
            if (legacyP12) {
                byte[] salt = new byte[]{1, 1, 1, 1};
                epki = EncryptedPrivateKeyInfo.createPBE((PBEAlgorithm)PBEAlgorithm.PBE_SHA1_DES3_CBC, (Password)pass, (byte[])salt, (int)1, (KeyGenerator.CharToByteConverter)new PasswordConverter(), (PrivateKeyInfo)pki);
            } else {
                epki = EncryptedPrivateKeyInfo.createPBES2((int)16, (int)2000, (EncryptionAlgorithm)EncryptionAlgorithm.AES_128_CBC_PAD, (Password)pass, null, (PrivateKeyInfo)pki);
            }
            SET keyAttrs = this.createBagAttrs(x509cert.getSubjectDN().toString(), localKeyId);
            SafeBag keyBag = new SafeBag(SafeBag.PKCS8_SHROUDED_KEY_BAG, (ASN1Value)epki, keyAttrs);
            safeContents.addElement((ASN1Value)keyBag);
            AuthenticatedSafes authSafes = new AuthenticatedSafes();
            authSafes.addSafeContents(safeContents);
            authSafes.addSafeContents(encSafeContents);
            PFX pfx = new PFX(authSafes);
            pfx.computeMacData(pass, null, 5);
            ByteArrayOutputStream fos = new ByteArrayOutputStream();
            pfx.encode((OutputStream)fos);
            params.put(ATTR_PKCS12, fos.toByteArray());
        }
        catch (Exception e) {
            logger.error(CMS.getLogMessage((String)"CMSCORE_KRA_CONSTRUCT_P12", (Object[])new Object[]{e.toString()}), (Throwable)e);
            throw new EKRAException(CMS.getUserMessage((String)"CMS_KRA_PKCS12_FAILED_1", (String[])new String[]{e.toString()}));
        }
        finally {
            pass.clear();
            jssSubsystem.obscureChars(pwdChars);
        }
        engine.getRequestRepository().updateRequest(request);
    }

    public byte[] createLocalKeyId(java.security.cert.X509Certificate cert) throws EBaseException {
        try {
            byte[] certDer = cert.getEncoded();
            MessageDigest md = MessageDigest.getInstance("SHA");
            md.update(certDer);
            return md.digest();
        }
        catch (CertificateEncodingException e) {
            logger.error(CMS.getLogMessage((String)"CMSCORE_KRA_CREAT_KEY_ID", (Object[])new Object[]{e.toString()}), (Throwable)e);
            throw new EKRAException(CMS.getUserMessage((String)"CMS_KRA_KEYID_FAILED_1", (String[])new String[]{e.toString()}));
        }
        catch (NoSuchAlgorithmException e) {
            logger.error(CMS.getLogMessage((String)"CMSCORE_KRA_CREAT_KEY_ID", (Object[])new Object[]{e.toString()}), (Throwable)e);
            throw new EKRAException(CMS.getUserMessage((String)"CMS_KRA_KEYID_FAILED_1", (String[])new String[]{e.toString()}));
        }
    }

    public SET createBagAttrs(String nickName, byte[] localKeyId) throws EBaseException {
        try {
            SET attrs = new SET();
            SEQUENCE nickNameAttr = new SEQUENCE();
            nickNameAttr.addElement((ASN1Value)SafeBag.FRIENDLY_NAME);
            SET nickNameSet = new SET();
            nickNameSet.addElement((ASN1Value)new BMPString(nickName));
            nickNameAttr.addElement((ASN1Value)nickNameSet);
            attrs.addElement((ASN1Value)nickNameAttr);
            SEQUENCE localKeyAttr = new SEQUENCE();
            localKeyAttr.addElement((ASN1Value)SafeBag.LOCAL_KEY_ID);
            SET localKeySet = new SET();
            localKeySet.addElement((ASN1Value)new OCTET_STRING(localKeyId));
            localKeyAttr.addElement((ASN1Value)localKeySet);
            attrs.addElement((ASN1Value)localKeyAttr);
            return attrs;
        }
        catch (CharConversionException e) {
            logger.error(CMS.getLogMessage((String)"CMSCORE_KRA_CREAT_KEY_BAG", (Object[])new Object[]{e.toString()}), (Throwable)e);
            throw new EKRAException(CMS.getUserMessage((String)"CMS_KRA_KEYBAG_FAILED_1", (String[])new String[]{e.toString()}));
        }
    }
}

