/*
 * Decompiled with CFR 0.152.
 */
package com.netscape.cmstools.ca;

import com.netscape.certsrv.ca.CACertClient;
import com.netscape.certsrv.cert.CertData;
import com.netscape.certsrv.dbs.certdb.CertId;
import com.netscape.cmstools.ca.CACertCLI;
import com.netscape.cmstools.cli.MainCLI;
import java.io.FileOutputStream;
import java.io.PrintStream;
import org.apache.commons.cli.CommandLine;
import org.apache.commons.cli.Option;
import org.dogtagpki.cli.CLI;
import org.dogtagpki.cli.CommandCLI;
import org.mozilla.jss.netscape.security.util.Cert;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CACertExportCLI
extends CommandCLI {
    public static Logger logger = LoggerFactory.getLogger(CACertExportCLI.class);
    public CACertCLI certCLI;

    public CACertExportCLI(CACertCLI certCLI) {
        super("export", "Export certificate", (CLI)certCLI);
        this.certCLI = certCLI;
    }

    public void printHelp() {
        formatter.printHelp(this.getFullName() + " <Serial Number> [OPTIONS...]", this.options);
    }

    public void createOptions() {
        Option option = new Option(null, "output-format", true, "Output format: pem (default), der");
        option.setArgName("format");
        this.options.addOption(option);
        option = new Option(null, "output-file", true, "Output file");
        option.setArgName("file");
        this.options.addOption(option);
    }

    public void execute(CommandLine cmd) throws Exception {
        String[] cmdArgs = cmd.getArgs();
        if (cmdArgs.length < 1) {
            throw new Exception("Missing serial number");
        }
        CertId certID = new CertId(cmdArgs[0]);
        MainCLI mainCLI = (MainCLI)this.getRoot();
        mainCLI.init();
        CACertClient certClient = this.certCLI.getCertClient();
        CertData certData = certClient.getCert(certID);
        String outputFormat = cmd.getOptionValue("output-format", "pem");
        String cert = null;
        byte[] bytes = null;
        if ("pem".equalsIgnoreCase(outputFormat)) {
            cert = certData.getEncoded();
        } else if ("der".equalsIgnoreCase(outputFormat)) {
            bytes = Cert.parseCertificate((String)certData.getEncoded());
        } else {
            throw new Exception("Unsupported format: " + outputFormat);
        }
        String outputFile = cmd.getOptionValue("output-file");
        if (outputFile != null) {
            try (PrintStream out = new PrintStream(new FileOutputStream(outputFile));){
                if (cert != null) {
                    out.print(cert);
                }
                out.write(bytes);
            }
        } else if (cert != null) {
            System.out.print(cert);
        } else {
            System.out.write(bytes);
        }
    }
}

