/*
 * Decompiled with CFR 0.152.
 */
package org.dogtagpki.acme.scheduler;

import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.TimeUnit;
import org.dogtagpki.acme.scheduler.ACMESchedulerConfig;
import org.dogtagpki.acme.scheduler.ACMETask;
import org.dogtagpki.acme.scheduler.ACMETaskConfig;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ACMEScheduler {
    public static Logger logger = LoggerFactory.getLogger(ACMEScheduler.class);
    private ACMESchedulerConfig config;
    private ScheduledExecutorService executorService;

    public ACMESchedulerConfig getConfig() {
        return this.config;
    }

    public void setConfig(ACMESchedulerConfig config) {
        this.config = config;
    }

    public void init() throws Exception {
        logger.info("Initializing ACME scheduler");
        Integer threads = this.config.getThreads();
        if (threads == null) {
            threads = 1;
        }
        logger.info("- threads: " + threads);
        this.executorService = Executors.newScheduledThreadPool(threads);
        for (final String name : this.config.getTaskNames()) {
            logger.info("Initializing " + name + " task");
            ACMETaskConfig taskConfig = this.config.getTask(name);
            String className = taskConfig.getClassName();
            Class<?> taskClass = Class.forName(className);
            final ACMETask task = (ACMETask)taskClass.getDeclaredConstructor(new Class[0]).newInstance(new Object[0]);
            task.setConfig(taskConfig);
            task.init();
            Runnable runnable = new Runnable(){

                @Override
                public void run() {
                    try {
                        task.run();
                    }
                    catch (Exception e) {
                        logger.error("Unable to run " + name + " task: " + e.getMessage(), (Throwable)e);
                    }
                }
            };
            Integer initialDelay = taskConfig.getInitialDelay();
            if (initialDelay == null) {
                initialDelay = 0;
            }
            logger.info("- initial delay: " + initialDelay);
            Integer delay = taskConfig.getDelay();
            logger.info("- delay: " + delay);
            Integer interval = taskConfig.getInterval();
            logger.info("- interval: " + interval);
            TimeUnit unit = taskConfig.getUnit();
            if (unit == null) {
                unit = TimeUnit.MINUTES;
            }
            logger.info("- unit: " + unit);
            if (delay != null) {
                this.executorService.scheduleWithFixedDelay(runnable, initialDelay.intValue(), delay.intValue(), unit);
                continue;
            }
            if (interval != null) {
                this.executorService.scheduleAtFixedRate(runnable, initialDelay.intValue(), interval.intValue(), unit);
                continue;
            }
            this.executorService.schedule(runnable, (long)initialDelay.intValue(), unit);
        }
    }

    public void shutdown() throws Exception {
        logger.info("Shutting down ACME scheduler");
        this.executorService.shutdown();
    }
}

