/*
 * Decompiled with CFR 0.152.
 */
package net.jini.id;

import java.io.EOFException;
import java.io.IOException;
import java.io.InputStream;
import java.security.SecureRandom;
import net.jini.id.Uuid;

public final class UuidFactory {
    private static final Object lock = new Object();
    private static SecureRandom secureRandom;

    public static Uuid create(long bits0, long bits1) {
        return new Impl(bits0, bits1);
    }

    public static Uuid create(String s) {
        long node;
        long clock_seq_and_variant;
        long time_hi_and_version;
        long time_mid;
        long time_low;
        if (s.length() != 36 || s.charAt(8) != '-' || s.charAt(13) != '-' || s.charAt(18) != '-' || s.charAt(23) != '-') {
            throw new IllegalArgumentException("invalid string representation: \"" + s + "\"");
        }
        try {
            time_low = Long.parseLong(s.substring(0, 8), 16);
            time_mid = Long.parseLong(s.substring(9, 13), 16);
            time_hi_and_version = Long.parseLong(s.substring(14, 18), 16);
            clock_seq_and_variant = Long.parseLong(s.substring(19, 23), 16);
            node = Long.parseLong(s.substring(24, 36), 16);
        }
        catch (NumberFormatException e) {
            IllegalArgumentException iae = new IllegalArgumentException("invalid string representation: \"" + s + "\"");
            iae.initCause(e);
            throw iae;
        }
        if (time_low < 0L || time_mid < 0L || time_hi_and_version < 0L || clock_seq_and_variant < 0L || node < 0L) {
            throw new IllegalArgumentException("invalid string representation: \"" + s + "\"");
        }
        long bits0 = time_low << 32 | time_mid << 16 | time_hi_and_version;
        long bits1 = clock_seq_and_variant << 48 | node;
        return UuidFactory.create(bits0, bits1);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Uuid generate() {
        Object object = lock;
        synchronized (object) {
            if (secureRandom == null) {
                secureRandom = new SecureRandom();
            }
        }
        long bits0 = secureRandom.nextLong();
        long bits1 = secureRandom.nextLong();
        bits0 &= 0xFFFFFFFFFFFF0FFFL;
        bits1 &= 0x3FFFFFFFFFFFFFFFL;
        return UuidFactory.create(bits0 |= 0x4000L, bits1 |= Long.MIN_VALUE);
    }

    public static Uuid read(InputStream in) throws IOException {
        long bits0 = UuidFactory.readLong(in);
        long bits1 = UuidFactory.readLong(in);
        return UuidFactory.create(bits0, bits1);
    }

    private static long readLong(InputStream in) throws IOException {
        int b3;
        int b2;
        int b1;
        int b0 = in.read();
        if ((b0 | (b1 = in.read()) | (b2 = in.read()) | (b3 = in.read())) == -1) {
            throw new EOFException();
        }
        int upper = b0 << 24 | b1 << 16 | b2 << 8 | b3;
        b0 = in.read();
        if ((b0 | (b1 = in.read()) | (b2 = in.read()) | (b3 = in.read())) == -1) {
            throw new EOFException();
        }
        int lower = b0 << 24 | b1 << 16 | b2 << 8 | b3;
        return (long)upper << 32 | (long)lower & 0xFFFFFFFFL;
    }

    private UuidFactory() {
        throw new AssertionError();
    }

    private static class Impl
    extends Uuid {
        private static final long serialVersionUID = 1089722863511468966L;

        Impl(long bits0, long bits1) {
            super(bits0, bits1);
        }
    }
}

