/*
 * Decompiled with CFR 0.152.
 */
package com.infor.core.pool;

import com.infor.core.pool.ThreadWorker;
import com.infor.core.pool.WaitPool;

public class ThreadPool
extends ThreadGroup {
    private static final long WAIT_TIME = 100L;
    private WaitPool pool = null;
    private int capacity = 0;
    private volatile int nThreads = 0;
    private String idPrefix = "T";
    private Object threadCountLock = new Object();

    public ThreadPool(int capacity) {
        this(capacity, "ThreadPool");
    }

    public ThreadPool(int capacity, String name) {
        super(name);
        if (capacity <= 0) {
            throw new IndexOutOfBoundsException("ThreadPool: Cannot have a capacity <= 0");
        }
        this.pool = new WaitPool();
        this.capacity = capacity;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean createThread(Runnable newRunnable) {
        if (this.nThreads < this.capacity) {
            ThreadWorker tw;
            ThreadWorker threadWorker = tw = new ThreadWorker(this.pool, this, this.idPrefix + Integer.toString(this.nThreads), newRunnable);
            synchronized (threadWorker) {
                tw.start();
                try {
                    tw.wait(100L);
                }
                catch (InterruptedException ex) {
                    // empty catch block
                }
            }
            this.pool.recycle(tw);
            ++this.nThreads;
            return true;
        }
        return false;
    }

    public int getCapacity() {
        return this.capacity;
    }

    public int getIdleCount() {
        return this.pool.getSize();
    }

    public String getIDPrefix() {
        return this.idPrefix;
    }

    public int getThreadCount() {
        return this.nThreads;
    }

    public ThreadWorker getThreadWorker() {
        return (ThreadWorker)this.pool.getRecyclable();
    }

    public long getWaitTime() {
        return this.pool.getWaitTime();
    }

    public void requestStopAll() {
        Thread[] list = new Thread[this.capacity];
        int count = this.enumerate(list);
        for (int i = 0; i < count; ++i) {
            ((ThreadWorker)list[i]).destroy();
        }
    }

    public void setIDPrefix(String newIDPrefix) {
        this.idPrefix = newIDPrefix == null ? "T" : newIDPrefix;
    }

    public void setWaitTime(long waitTime) {
        this.pool.setWaitTime(waitTime);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void threadDeath() {
        --this.nThreads;
        if (this.nThreads == 0) {
            Object object = this.threadCountLock;
            synchronized (object) {
                this.threadCountLock.notifyAll();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void waitForAllThreadsToStop(long maxWait) throws InterruptedException {
        if (this.nThreads > 0) {
            Object object = this.threadCountLock;
            synchronized (object) {
                if (maxWait < 0L) {
                    this.threadCountLock.wait();
                } else {
                    if (maxWait == 0L) {
                        return;
                    }
                    this.threadCountLock.wait(maxWait);
                }
            }
        }
    }
}

