/*
 * Decompiled with CFR 0.152.
 */
package org.jquantlib.math;

import org.jquantlib.math.Constants;

public class ErrorFunction {
    private static final double tiny = Constants.QL_EPSILON;
    private static final double one = 1.0;
    private static final double erx = 0.8450629115104675;
    private static final double efx = 0.1283791670955126;
    private static final double efx8 = 1.0270333367641007;
    private static final double pp0 = 0.12837916709551256;
    private static final double pp1 = -0.3250421072470015;
    private static final double pp2 = -0.02848174957559851;
    private static final double pp3 = -0.005770270296489442;
    private static final double pp4 = -2.3763016656650163E-5;
    private static final double qq1 = 0.39791722395915535;
    private static final double qq2 = 0.0650222499887673;
    private static final double qq3 = 0.005081306281875766;
    private static final double qq4 = 1.3249473800432164E-4;
    private static final double qq5 = -3.960228278775368E-6;
    private static final double pa0 = -0.0023621185607526594;
    private static final double pa1 = 0.41485611868374833;
    private static final double pa2 = -0.3722078760357013;
    private static final double pa3 = 0.31834661990116175;
    private static final double pa4 = -0.11089469428239668;
    private static final double pa5 = 0.035478304325618236;
    private static final double pa6 = -0.002166375594868791;
    private static final double qa1 = 0.10642088040084423;
    private static final double qa2 = 0.540397917702171;
    private static final double qa3 = 0.07182865441419627;
    private static final double qa4 = 0.12617121980876164;
    private static final double qa5 = 0.01363708391202905;
    private static final double qa6 = 0.011984499846799107;
    private static final double ra0 = -0.009864944034847148;
    private static final double ra1 = -0.6938585727071818;
    private static final double ra2 = -10.558626225323291;
    private static final double ra3 = -62.375332450326006;
    private static final double ra4 = -162.39666946257347;
    private static final double ra5 = -184.60509290671104;
    private static final double ra6 = -81.2874355063066;
    private static final double ra7 = -9.814329344169145;
    private static final double sa1 = 19.651271667439257;
    private static final double sa2 = 137.65775414351904;
    private static final double sa3 = 434.56587747522923;
    private static final double sa4 = 645.3872717332679;
    private static final double sa5 = 429.00814002756783;
    private static final double sa6 = 108.63500554177944;
    private static final double sa7 = 6.570249770319282;
    private static final double sa8 = -0.0604244152148581;
    private static final double rb0 = -0.0098649429247001;
    private static final double rb1 = -0.799283237680523;
    private static final double rb2 = -17.757954917754752;
    private static final double rb3 = -160.63638485582192;
    private static final double rb4 = -637.5664433683896;
    private static final double rb5 = -1025.0951316110772;
    private static final double rb6 = -483.5191916086514;
    private static final double sb1 = 30.33806074348246;
    private static final double sb2 = 325.7925129965739;
    private static final double sb3 = 1536.729586084437;
    private static final double sb4 = 3199.8582195085955;
    private static final double sb5 = 2553.0504064331644;
    private static final double sb6 = 474.52854120695537;
    private static final double sb7 = -22.44095244658582;
    private static final double DBL_MIN = Double.MIN_NORMAL;

    public double evaluate(double x) {
        double S;
        double R;
        double ax = Math.abs(x);
        if (ax < 0.84375) {
            if (ax < 3.7252902984E-9) {
                if (ax < 3.5601181736115222E-307) {
                    return 0.125 * (8.0 * x + 1.0270333367641007 * x);
                }
                return x + 0.1283791670955126 * x;
            }
            double z = x * x;
            double r = 0.12837916709551256 + z * (-0.3250421072470015 + z * (-0.02848174957559851 + z * (-0.005770270296489442 + z * -2.3763016656650163E-5)));
            double s = 1.0 + z * (0.39791722395915535 + z * (0.0650222499887673 + z * (0.005081306281875766 + z * (1.3249473800432164E-4 + z * -3.960228278775368E-6))));
            double y = r / s;
            return x + x * y;
        }
        if (ax < 1.25) {
            double s = ax - 1.0;
            double P = -0.0023621185607526594 + s * (0.41485611868374833 + s * (-0.3722078760357013 + s * (0.31834661990116175 + s * (-0.11089469428239668 + s * (0.035478304325618236 + s * -0.002166375594868791)))));
            double Q = 1.0 + s * (0.10642088040084423 + s * (0.540397917702171 + s * (0.07182865441419627 + s * (0.12617121980876164 + s * (0.01363708391202905 + s * 0.011984499846799107)))));
            if (x >= 0.0) {
                return 0.8450629115104675 + P / Q;
            }
            return -0.8450629115104675 - P / Q;
        }
        if (ax >= 6.0) {
            if (x >= 0.0) {
                return 1.0 - tiny;
            }
            return tiny - 1.0;
        }
        double s = 1.0 / (ax * ax);
        if (ax < 2.85714285714285) {
            R = -0.009864944034847148 + s * (-0.6938585727071818 + s * (-10.558626225323291 + s * (-62.375332450326006 + s * (-162.39666946257347 + s * (-184.60509290671104 + s * (-81.2874355063066 + s * -9.814329344169145))))));
            S = 1.0 + s * (19.651271667439257 + s * (137.65775414351904 + s * (434.56587747522923 + s * (645.3872717332679 + s * (429.00814002756783 + s * (108.63500554177944 + s * (6.570249770319282 + s * -0.0604244152148581)))))));
        } else {
            R = -0.0098649429247001 + s * (-0.799283237680523 + s * (-17.757954917754752 + s * (-160.63638485582192 + s * (-637.5664433683896 + s * (-1025.0951316110772 + s * -483.5191916086514)))));
            S = 1.0 + s * (30.33806074348246 + s * (325.7925129965739 + s * (1536.729586084437 + s * (3199.8582195085955 + s * (2553.0504064331644 + s * (474.52854120695537 + s * -22.44095244658582))))));
        }
        double r = Math.exp(-ax * ax - 0.5625 + R / S);
        if (x >= 0.0) {
            return 1.0 - r / ax;
        }
        return r / ax - 1.0;
    }
}

