'\" t
.TH COREDUMPERPARAMETERS 3 "Mar 11, 2008"
.SH NAME
ClearCoreDumpParameters, SetCoreDumpLimited, SetCoreDumpCompressed, SetCoreDumpLimitedByPriority, SetCoreDumpNotes, SetCoreDumpCallback \- functions to initialize and set fields in a CoreDumpParameters structure.
.SH SYNOPSIS
.ad l
.PP
.B "#include \*(lqgoogle/coredumper.h\*(rq"
.HP 30
.BI void\~Clear\%Core\%Dump\%Parameters(struct\~CoreDump\%Parameters\ \:* params );
.HP 23
.BI int\~Set\%Core\%Dump\%Limited(\:struct\~Core\%Dump\%Parameters\ \:* params ,\ size_t\~ \:max_length );
.HP 33
.BI int\~Set\%Core\%Dump\%Limited\%By\%Priority(\:struct\~Core\%Dump\%Parameters\ \:* params ,\ size_t\ \: max_length );
.HP 26
.BI int\~Set\%Core\%Dump\%Compressed(\:struct\~Core\%Dump\%Parameters\ * \:params ,\ const\~struct\~Coredump\%Compressor\ \:* compressors\
    ,\ \:struct\~Coredumper\%Compressor\ \:** \
    selected_compressor );
.HP 21
.BI int\~Set\%Core\%Dump\%Notes(\:struct\~Core\%Dump\%Parameters\ \:* params ,\ \:struct\~Coredumper\%Note\~\:* notes ,\ \:int\~ \:note_count );
.HP 24
.BI int\~Set\%Core\%Dump\%Callback(\:struct\~Core\%Dump\%Parameters\ \:* params ,\ \:int\~(* callback_fn )(void*),\ \:void*\~ \:callback_arg );
.ad b
.SH DESCRIPTION
These functions must be used to set the attributes in a CoreDumpParameters
structure. Combinations of these functions may be used together. For instance
to produce a compressed core dump with additional notes you should call
\fBClearCoreDumpParameters\fP(), \fBSetCoreDumpCompressed\fP(), and
\fBSetCoreDumpNotes\fP().
.PP
The \fBClearCoreDumpParameters\fP() function clears the given
core dumper parameters structure to its default values.
.PP
The \fBSetCoreDumpLimited\fP() function sets the attributes in
.IR params
to produce core files of at most
.IR max_length
bytes when called with \fBWriteCoreDumpWith\fP(). This must not be used with
\fBSetCoreDumpLimitedByPriority\fP().
.PP
The \fBSetCoreDumpLimitedByPriority\fP() function sets the attributes in
.IR params
to produce core files of at most
.IR max_length
bytes when called with \fBWriteCoreDumpWith\fP(). This differs from normal
limiting by truncating the largest memory segments first as opposed to
truncating the whole core file. This must not be used with
\fBSetCoreDumpLimited\fP() or \fBSetCoreDumpCompressed\fP().
.PP
The \fBSetCoreDumpCompressed\fP() function sets the attributes in
.IR params
to produce a compressed core dump when called with \fBGetCoreDumpWith\fP() or
\fBWriteCoreDumpWith\fP(). Its arguments match the ones passed to
\fBGetCompressedCoreDump\fP().
.PP
The \fBSetCoreDumpNotes\fP() function sets the attributes in
.IR params
to add additional notes to core dumps when called with \fBGetCoreDumpWith\fP()
or \fBWriteCoreDumpWith\fP(). The notes are specified as an array of the
CoredumperNote structure:
.sp
.RS
.nf
struct CoredumperNote {
  const char *name;               // The vendor name
  unsigned int type;              // A vendor specific type
  unsigned int description_size;  // The size of the description field
  const void *description;        // The note data
};
.fi
.RE
.PP
The name, including a terminating null character, will be 4 byte aligned. The
type is a user chosen value. The description_size specifies the amount of bytes
to write from the description pointer in memory to the core dump note. The
description will be padded to be 4 byte aligned.
.PP
The \fBSetCoreDumpCallback\fP() function sets the attributes in
.IR params
to add a callback function that will be invoked after all threads in the
process have been suspended but before any actual core is dumped.  The
argument provided will be passed to the callback function and is otherwise
unused by the coredumper library.
.PP
If the callback function returns 0, then the core will continue to be dumped.
If the callback function returns non-0, then the core dump will be failed.
.PP
.SH RETURN VALUE
.PP
On success 0 will be returned. On error \-1 will be returned and
.I errno
will be set appropriately.
.SH ERRORS
The most common reason for an error is that incompatable parameters are combined.
.SH "SEE ALSO"
.BR GetCoreDump (3),
.BR GetCoreDumpWith (3),
.BR GetCompressedCoreDump(3),
.BR WriteCoreDump (3),
.BR WriteCoreDumpWith (3),
.BR WriteCoreDumpLimited (3),
.BR WriteCoreDumpLimitedByPriority (3),
and
.BR WriteCompressedCoreDump(3).
