import { DataFrame, FieldMatcher, Vector } from '../../types';
export declare function pickBestJoinField(data: DataFrame[]): FieldMatcher;
/**
 * @alpha
 */
export interface JoinOptions {
    /**
     * The input fields
     */
    frames: DataFrame[];
    /**
     * The field to join -- frames that do not have this field will be droppped
     */
    joinBy?: FieldMatcher;
    /**
     * Optionally filter the non-join fields
     */
    keep?: FieldMatcher;
    /**
     * @internal -- used when we need to keep a reference to the original frame/field index
     */
    keepOriginIndices?: boolean;
}
/**
 * @internal
 */
export declare function maybeSortFrame(frame: DataFrame, fieldIdx: number): DataFrame;
/**
 * This will return a single frame joined by the first matching field.  When a join field is not specified,
 * the default will use the first time field
 */
export declare function outerJoinDataFrames(options: JoinOptions): DataFrame | undefined;
export declare type TypedArray = Int8Array | Uint8Array | Int16Array | Uint16Array | Int32Array | Uint32Array | Uint8ClampedArray | Float32Array | Float64Array;
export declare type AlignedData = TypedArray[] | [xValues: number[] | TypedArray, ...yValues: Array<Array<number | null | undefined> | TypedArray>];
export declare function join(tables: AlignedData[], nullModes?: number[][]): number[][];
export declare function isLikelyAscendingVector(data: Vector, samples?: number): boolean;
