# *Percona XtraBackup* 2.4.5

Percona is glad to announce the release of *Percona XtraBackup* 2.4.5
on November 29th 2016. Downloads are available from our [download site](http://www.percona.com/downloads/XtraBackup/) and from [apt](../../installation/apt_repo.md#apt-repo) and [yum](../../installation/yum_repo.md#yum-repo) repositories.

This release is the GA (Generally Available) stable release in the 2.4
series.

## New features

* *Percona XtraBackup* now supports `SHA256` passwords. Using the `SHA256`
algorithm requires either SSL encrypted connection, or using public
key encryption for password exchange which is only available when both
client and server are linked with OpenSSL.

* *Percona XtraBackup* now supports [Command Options for Secure Connections](https://dev.mysql.com/doc/refman/5.6/en/secure-connection-options.html#option_general_ssl-ca).

* **NOTE:** Due to xbcrypt format changes, backups encrypted with this
*Percona XtraBackup* version will not be recoverable by older versions.

## Bugs Fixed

* *Percona XtraBackup* would crash while preparing the backup, during the
shutdown, when master thread was performing checkpoint and purge thread was
expecting that all other threads completed or were idle. Bug fixed
[PXB-483](https://jira.percona.com/browse/PXB-483).

* Safe slave backup algorithm performed too short delays between retries which
could cause backups to fail on a busy servers. Bug fixed [PXB-484](https://jira.percona.com/browse/PXB-484).

* *Percona XtraBackup* didn’t check the logblock checksums. Bug fixed
[PXB-485](https://jira.percona.com/browse/PXB-485).

* Fixed new compilation warnings with GCC 6. Bug fixed [PXB-487](https://jira.percona.com/browse/PXB-487).

* xbcrypt was not setting the Initialization Vector (IV) correctly (and thus
is was not using an IV). This was causing the same ciphertext to be generated
across different runs (for the same message/same key). The IV provides the
extra randomness to ensure that the same ciphertext is not generated across
runs. Bug fixed [PXB-490](https://jira.percona.com/browse/PXB-490).

* `target-dir` was no longer relative to current directory but to `datadir`
instead. Bug fixed [PXB-760](https://jira.percona.com/browse/PXB-760).

* Backup would still succeed even if *xtrabackup* would fail to write the
metadata. Bug fixed [PXB-763](https://jira.percona.com/browse/PXB-763).

* *xbcloud* now supports EMC ECS Swift API Authorization requests. Bugs fixed [PXB-769](https://jira.percona.com/browse/PXB-769) and [PXB-770](https://jira.percona.com/browse/PXB-770) (*Txomin Barturen*).

* Some older versions of *MySQL* did not bother to initialize page type
field for pages which are not index pages (see upstream [#76262](http://bugs.mysql.com/bug.php?id=76262) for
more information). Having this page type uninitialized could cause
*xtrabackup* to crash on prepare. Bug fixed [PXB-772](https://jira.percona.com/browse/PXB-772).

* *Percona XtraBackup* would fail to backup *MariaDB* 10.2 with the
`unsupported server version` error message. Bug fixed [PXB-1027](https://jira.percona.com/browse/PXB-1027).

* Fixed misleading error message about missing metadata. Bug fixed [PXB-752](https://jira.percona.com/browse/PXB-752).

* Backing up with an SSL user didn’t work correctly. Bug fixed [PXB-750](https://jira.percona.com/browse/PXB-750).

Other bugs fixed: [PXB-486](https://jira.percona.com/browse/PXB-486), [PXB-771](https://jira.percona.com/browse/PXB-771), [PXB-773](https://jira.percona.com/browse/PXB-773), and
[PXB-774](https://jira.percona.com/browse/PXB-774).
