/*
 * Decompiled with CFR 0.152.
 */
package org.dogtagpki.server.tps.config;

import com.netscape.certsrv.base.EBaseException;
import com.netscape.cmscore.dbs.CSCfgDatabase;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Map;
import org.dogtagpki.server.tps.config.ConfigDatabase;
import org.dogtagpki.server.tps.config.ConfigRecord;
import org.dogtagpki.server.tps.config.ConnectorRecord;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ConnectorDatabase
extends CSCfgDatabase<ConnectorRecord> {
    public static Logger logger = LoggerFactory.getLogger(ConnectorDatabase.class);
    public String prefix = "tps.connector";

    public ConnectorDatabase() {
        super("Connector", "Subsystem_Connections");
    }

    public ConnectorRecord createConnectorRecord(ConfigDatabase configDatabase, ConfigRecord configRecord, String connectorID) throws EBaseException {
        ConnectorRecord connectorRecord = new ConnectorRecord();
        connectorRecord.setID(connectorID);
        String status = this.getRecordStatus(connectorID);
        connectorRecord.setStatus(status);
        Map<String, String> properties = configDatabase.getProperties(configRecord, connectorID);
        connectorRecord.setProperties(properties);
        return connectorRecord;
    }

    public Collection<ConnectorRecord> findRecords(String filter) throws Exception {
        ArrayList<ConnectorRecord> result = new ArrayList<ConnectorRecord>();
        ConfigDatabase configDatabase = new ConfigDatabase();
        ConfigRecord configRecord = configDatabase.getRecord(this.substoreName);
        for (String connectorID : configRecord.getKeys()) {
            if (filter != null && !connectorID.contains(filter)) continue;
            ConnectorRecord connectorRecord = this.createConnectorRecord(configDatabase, configRecord, connectorID);
            result.add(connectorRecord);
        }
        return result;
    }

    public ConnectorRecord getRecord(String connectionID) throws Exception {
        ConfigDatabase configDatabase = new ConfigDatabase();
        ConfigRecord configRecord = configDatabase.getRecord(this.substoreName);
        return this.createConnectorRecord(configDatabase, configRecord, connectionID);
    }

    public void addRecord(String connectorID, ConnectorRecord connectorRecord) throws Exception {
        logger.debug("ConnectorDatabase.addRecord(\"" + connectorID + "\")");
        ConfigDatabase configDatabase = new ConfigDatabase();
        ConfigRecord configRecord = configDatabase.getRecord(this.substoreName);
        Map properties = connectorRecord.getProperties();
        configDatabase.validateProperties(configRecord, connectorID, properties);
        configRecord.addKey(connectorID);
        configDatabase.updateRecord(this.substoreName, configRecord);
        configDatabase.addProperties(configRecord, connectorID, properties);
        this.setRecordStatus(connectorID, connectorRecord.getStatus());
        configDatabase.commit();
    }

    public void updateRecord(String connectorID, ConnectorRecord connectorRecord) throws Exception {
        logger.debug("ConnectorDatabase.updateRecord(\"" + connectorID + "\")");
        ConfigDatabase configDatabase = new ConfigDatabase();
        ConfigRecord configRecord = configDatabase.getRecord(this.substoreName);
        Map properties = connectorRecord.getProperties();
        configDatabase.validateProperties(configRecord, connectorID, properties);
        configDatabase.removeProperties(configRecord, connectorID);
        configDatabase.addProperties(configRecord, connectorID, properties);
        this.setRecordStatus(connectorID, connectorRecord.getStatus());
        configDatabase.commit();
    }

    public void removeRecord(String connectorID) throws Exception {
        logger.debug("ConnectorDatabase.removeRecord(\"" + connectorID + "\")");
        ConfigDatabase configDatabase = new ConfigDatabase();
        ConfigRecord configRecord = configDatabase.getRecord(this.substoreName);
        configDatabase.removeProperties(configRecord, connectorID);
        configRecord.removeKey(connectorID);
        configDatabase.updateRecord(this.substoreName, configRecord);
        this.removeRecordStatus(connectorID);
        configDatabase.commit();
    }

    public String getNextID(String type) throws Exception {
        String id;
        ConfigDatabase configDatabase = new ConfigDatabase();
        ConfigRecord configRecord = configDatabase.getRecord(this.substoreName);
        Collection<String> keys = configRecord.getKeys();
        int n = 1;
        while (keys.contains(id = type + n)) {
            ++n;
        }
        return id;
    }
}

